/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.display;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.widget.TextView;
import com.xuexiang.xutil.display.ColorUtils;

public class DrawableUtils {
    private DrawableUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static GradientDrawable getSolidRectDrawable(int cornerRadius, int solidColor) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setCornerRadius((float)cornerRadius);
        gradientDrawable.setColor(solidColor);
        gradientDrawable.setGradientType(1);
        return gradientDrawable;
    }

    public static GradientDrawable getStrokeRectDrawable(int cornerRadius, int solidColor, int strokeColor, int strokeWidth) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setStroke(strokeWidth, strokeColor);
        gradientDrawable.setColor(solidColor);
        gradientDrawable.setCornerRadius((float)cornerRadius);
        gradientDrawable.setGradientType(1);
        return gradientDrawable;
    }

    public static StateListDrawable getStateListDrawable(Drawable pressedDrawable, Drawable normalDrawable) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842910, 16842919}, pressedDrawable);
        stateListDrawable.addState(new int[]{16842910}, normalDrawable);
        GradientDrawable gray = DrawableUtils.getSolidRectDrawable(10, -7829368);
        stateListDrawable.addState(new int[0], (Drawable)gray);
        return stateListDrawable;
    }

    public static StateListDrawable getDrawable(int cornerRadius, int pressedColor, int normalColor) {
        return DrawableUtils.getStateListDrawable((Drawable)DrawableUtils.getSolidRectDrawable(cornerRadius, pressedColor), (Drawable)DrawableUtils.getSolidRectDrawable(cornerRadius, normalColor));
    }

    public static StateListDrawable getStrokeSolidDrawable(int cornerRadiusPX, int strokeWidthPX, int subColor, int mainColor) {
        return DrawableUtils.getStateListDrawable((Drawable)DrawableUtils.getSolidRectDrawable(cornerRadiusPX, subColor), (Drawable)DrawableUtils.getStrokeRectDrawable(cornerRadiusPX, mainColor, subColor, strokeWidthPX));
    }

    public static StateListDrawable getSolidStrokeDrawable(int cornerRadiusPX, int strokeWidthPX, int subColor, int mainColor) {
        return DrawableUtils.getStateListDrawable((Drawable)DrawableUtils.getStrokeRectDrawable(cornerRadiusPX, subColor, mainColor, strokeWidthPX), (Drawable)DrawableUtils.getSolidRectDrawable(cornerRadiusPX, mainColor));
    }

    public static StateListDrawable getDrawable(int cornerRadius, int normalColor) {
        return DrawableUtils.getDrawable(cornerRadius, ColorUtils.darker((int)normalColor), normalColor);
    }

    public static StateListDrawable getDrawable(int cornerRadius) {
        return DrawableUtils.getDrawable(cornerRadius, ColorUtils.getRandomColor());
    }

    public static StateListDrawable getDrawable() {
        return DrawableUtils.getDrawable(10);
    }

    public static StateListDrawable getRandomColorDrawable(int cornerRadius) {
        return DrawableUtils.getDrawable(cornerRadius, ColorUtils.getRandomColor(), ColorUtils.getRandomColor());
    }

    public static StateListDrawable getRandomColorDrawable() {
        return DrawableUtils.getRandomColorDrawable(10);
    }

    public static StateListDrawable getStrokeRandomColorDrawable() {
        return DrawableUtils.getStrokeSolidDrawable(10, 4, ColorUtils.getRandomColor(), 0);
    }

    public static void setTextStrokeTheme(TextView textView, int strokeWidth, int cornerRadius, int color) {
        textView.setBackgroundDrawable((Drawable)DrawableUtils.getStrokeSolidDrawable(cornerRadius, strokeWidth, color, -1));
        textView.setTextColor(ColorUtils.getColorStateList((int)-1, (int)color));
        textView.getPaint().setFlags(32);
    }

    public static void setTextStrokeTheme(TextView textView, int strokeWidth, int cornerRadius) {
        DrawableUtils.setTextStrokeTheme(textView, strokeWidth, cornerRadius, ColorUtils.getRandomColor());
    }

    public static void setTextStrokeTheme(TextView textView) {
        DrawableUtils.setTextStrokeTheme(textView, 6, 10);
    }

    public static void setTextStrokeTheme(TextView textView, int color) {
        DrawableUtils.setTextStrokeTheme(textView, 6, 10, color);
    }

    public static void setTextSolidTheme(TextView textView, int strokeWidth, int cornerRadius, int color) {
        textView.setBackgroundDrawable((Drawable)DrawableUtils.getSolidStrokeDrawable(cornerRadius, strokeWidth, -1, color));
        textView.setTextColor(ColorUtils.getColorStateList((int)color, (int)-1));
        textView.getPaint().setFlags(32);
    }

    public static void setTextSolidTheme(TextView textView, int strokeWidth, int cornerRadius) {
        DrawableUtils.setTextSolidTheme(textView, strokeWidth, cornerRadius, ColorUtils.getRandomColor());
    }

    public static void setTextSolidTheme(TextView textView) {
        DrawableUtils.setTextSolidTheme(textView, 6, 10);
    }
}

