/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.data;

import android.graphics.PointF;

public final class GeometryUtils {
    private GeometryUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static float getDistanceBetween2Points(PointF p0, PointF p1) {
        float distance = (float)Math.sqrt(Math.pow(p0.y - p1.y, 2.0) + Math.pow(p0.x - p1.x, 2.0));
        return distance;
    }

    public static PointF getMiddlePoint(PointF p1, PointF p2) {
        return new PointF((p1.x + p2.x) / 2.0f, (p1.y + p2.y) / 2.0f);
    }

    public static PointF getPointByPercent(PointF p1, PointF p2, float percent) {
        return new PointF(GeometryUtils.evaluateValue(percent, Float.valueOf(p1.x), Float.valueOf(p2.x)), GeometryUtils.evaluateValue(percent, Float.valueOf(p1.y), Float.valueOf(p2.y)));
    }

    public static float evaluateValue(float fraction, Number start, Number end) {
        return start.floatValue() + (end.floatValue() - start.floatValue()) * fraction;
    }

    public static PointF[] getIntersectionPoints(PointF pMiddle, float radius, Double lineK) {
        PointF[] points = new PointF[2];
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        if (lineK != null) {
            float radian = (float)Math.atan(lineK);
            xOffset = (float)(Math.sin(radian) * (double)radius);
            yOffset = (float)(Math.cos(radian) * (double)radius);
        } else {
            xOffset = radius;
            yOffset = 0.0f;
        }
        points[0] = new PointF(pMiddle.x + xOffset, pMiddle.y - yOffset);
        points[1] = new PointF(pMiddle.x - xOffset, pMiddle.y + yOffset);
        return points;
    }
}

