/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.app.notify.builder;

import android.support.v4.app.NotificationCompat;
import com.xuexiang.xutil.app.notify.builder.BaseBuilder;
import java.util.ArrayList;
import java.util.List;

public class MailboxBuilder
extends BaseBuilder {
    private List<String> mMessages;

    public MailboxBuilder addMsg(String msg) {
        if (this.mMessages == null) {
            this.mMessages = new ArrayList<String>();
        }
        this.mMessages.add(msg);
        return this;
    }

    public MailboxBuilder setMessages(List<String> messages) {
        this.mMessages = messages;
        return this;
    }

    @Override
    protected void beforeBuild() {
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        if (this.mMessages != null && this.mMessages.size() > 0) {
            if (this.mMessages.size() > 1) {
                for (String msg : this.mMessages) {
                    inboxStyle.addLine((CharSequence)msg);
                }
                String text = "\u4f60\u6536\u5230\u4e86[" + this.mMessages.size() + "]\u6761\u4fe1\u606f";
                inboxStyle.setSummaryText((CharSequence)text);
                this.setStyle((NotificationCompat.Style)inboxStyle);
            } else if (this.mMessages.size() == 1) {
                this.setContentText(this.mMessages.get(0));
            }
        }
    }
}

