/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.app.notify.builder;

import android.app.PendingIntent;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import com.xuexiang.xutil.app.notify.builder.BaseBuilder;

public class CustomViewBuilder
extends BaseBuilder {
    private RemoteViews mContentView;
    private boolean mIsBigContentView;

    public CustomViewBuilder() {
    }

    public CustomViewBuilder(String packageName, int layoutId) {
        this.mContentView = new RemoteViews(packageName, layoutId);
    }

    public CustomViewBuilder setContentView(String packageName, int layoutId) {
        this.mContentView = new RemoteViews(packageName, layoutId);
        return this;
    }

    public CustomViewBuilder setContentView(RemoteViews contentView) {
        this.mContentView = contentView;
        return this;
    }

    public CustomViewBuilder setIsBigContentView(boolean isBigContentView) {
        this.mIsBigContentView = isBigContentView;
        return this;
    }

    public CustomViewBuilder setTextViewText(int viewId, CharSequence text) {
        if (this.mContentView != null) {
            this.mContentView.setTextViewText(viewId, text);
        }
        return this;
    }

    public CustomViewBuilder setImageViewResource(int viewId, int srcId) {
        if (this.mContentView != null) {
            this.mContentView.setImageViewResource(viewId, srcId);
        }
        return this;
    }

    public CustomViewBuilder setImageViewBitmap(int viewId, Bitmap bitmap) {
        if (this.mContentView != null) {
            this.mContentView.setImageViewBitmap(viewId, bitmap);
        }
        return this;
    }

    public CustomViewBuilder setOnClickPendingIntent(int viewId, PendingIntent pendingIntent) {
        if (this.mContentView != null) {
            this.mContentView.setOnClickPendingIntent(viewId, pendingIntent);
        }
        return this;
    }

    @Override
    protected void afterBuild() {
        if (this.mContentView != null) {
            if (this.mIsBigContentView) {
                this.getBuilder().setCustomBigContentView(this.mContentView);
            } else {
                this.getBuilder().setCustomContentView(this.mContentView);
            }
        }
    }
}

