/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.app.notify.builder;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.xuexiang.xutil.XUtil;
import com.xuexiang.xutil.app.notify.NotificationUtils;
import com.xuexiang.xutil.resource.ResUtils;
import java.util.ArrayList;
import java.util.List;

public class BaseBuilder {
    private static final String DEFAULT_CHANNEL_ID_PREFIX = "xutil_channel_id_";
    private static final String DEFAULT_CHANNEL_NAME_PREFIX = "xutil_channel_name_";
    private NotificationCompat.Builder mBuilder;
    private int mSmallIcon;
    protected CharSequence mContentTitle;
    protected CharSequence mContentText;
    protected CharSequence mSummaryText;
    private boolean mHeadUp;
    private PendingIntent mContentIntent;
    private PendingIntent mDeleteIntent;
    private PendingIntent mFullscreenIntent;
    private int mId;
    private String mChannelId;
    private String mChannelName;
    private int mBigIcon;
    private CharSequence mTicker = "\u60a8\u6709\u65b0\u7684\u6d88\u606f";
    private CharSequence mSubText;
    private long mWhen;
    private boolean mIsShowWhen = true;
    private List<BtnActionBean> mBtnActionBeans;
    private int mPriority = 0;
    private int mDefaults = 4;
    private boolean mIsSound = true;
    private boolean mIsVibrate = true;
    private boolean mLights = true;
    private Uri mSoundUri;
    private long[] mVibratePatten;
    private boolean mIsOnGoing = false;
    private boolean mIsForeGroundService = false;
    private int mVisibility = -1;
    private NotificationCompat.Style mStyle;
    private boolean mIsPolling = false;

    public <T extends BaseBuilder> T setBaseInfo(int icon, CharSequence contentTitle, CharSequence contentText) {
        this.mSmallIcon = icon;
        this.mContentTitle = contentTitle;
        this.mContentText = contentText;
        return (T)this;
    }

    public <T extends BaseBuilder> T setSmallIcon(int smallIcon) {
        this.mSmallIcon = smallIcon;
        return (T)this;
    }

    public <T extends BaseBuilder> T setContentTitle(CharSequence contentTitle) {
        this.mContentTitle = contentTitle;
        return (T)this;
    }

    public <T extends BaseBuilder> T setContentText(CharSequence contentText) {
        this.mContentText = contentText;
        return (T)this;
    }

    public <T extends BaseBuilder> T setSummaryText(CharSequence summaryText) {
        this.mSummaryText = summaryText;
        return (T)this;
    }

    public <T extends BaseBuilder> T setId(int id) {
        this.mId = id;
        return (T)this;
    }

    public <T extends BaseBuilder> T setChannelId(String channelId) {
        this.mChannelId = channelId;
        return (T)this;
    }

    public <T extends BaseBuilder> T setChannelName(String channelName) {
        this.mChannelName = channelName;
        return (T)this;
    }

    public <T extends BaseBuilder> T setPriority(int priority) {
        this.mPriority = priority;
        return (T)this;
    }

    public <T extends BaseBuilder> T setContentIntent(PendingIntent contentIntent) {
        this.mContentIntent = contentIntent;
        return (T)this;
    }

    public <T extends BaseBuilder> T setDeleteIntent(PendingIntent deleteIntent) {
        this.mDeleteIntent = deleteIntent;
        return (T)this;
    }

    public <T extends BaseBuilder> T setFullScreenIntent(PendingIntent fullscreenIntent) {
        this.mFullscreenIntent = fullscreenIntent;
        return (T)this;
    }

    public <T extends BaseBuilder> T setBigIcon(int bigIcon) {
        this.mBigIcon = bigIcon;
        return (T)this;
    }

    public <T extends BaseBuilder> T setHeadUp(boolean headUp) {
        this.mHeadUp = headUp;
        return (T)this;
    }

    public <T extends BaseBuilder> T setTicker(CharSequence ticker) {
        this.mTicker = ticker;
        return (T)this;
    }

    public <T extends BaseBuilder> T setSubtext(CharSequence subText) {
        this.mSubText = subText;
        return (T)this;
    }

    public <T extends BaseBuilder> T setWhen(long when) {
        this.mWhen = when;
        return (T)this;
    }

    public <T extends BaseBuilder> T setIsShowWhen(boolean isShowWhen) {
        this.mIsShowWhen = isShowWhen;
        return (T)this;
    }

    public <T extends BaseBuilder> T addAction(int icon, CharSequence text, PendingIntent pendingIntent) {
        if (this.mBtnActionBeans == null) {
            this.mBtnActionBeans = new ArrayList<BtnActionBean>();
        }
        if (this.mBtnActionBeans.size() > 5) {
            throw new RuntimeException("5 buttons at most!");
        }
        this.mBtnActionBeans.add(new BtnActionBean(icon, text, pendingIntent));
        return (T)this;
    }

    public <T extends BaseBuilder> T setDisplayForm(boolean sound, boolean vibrate, boolean lights) {
        this.mIsSound = sound;
        this.mIsVibrate = vibrate;
        this.mLights = lights;
        return (T)this;
    }

    public <T extends BaseBuilder> T setSoundUri(Uri soundUri) {
        this.mSoundUri = soundUri;
        return (T)this;
    }

    public <T extends BaseBuilder> T setVibratePatten(long[] vibratePatten) {
        this.mVibratePatten = vibratePatten;
        return (T)this;
    }

    public <T extends BaseBuilder> T setIsOnGoing(boolean isOnGoing) {
        this.mIsOnGoing = isOnGoing;
        return (T)this;
    }

    public <T extends BaseBuilder> T setForegroundService() {
        this.mIsForeGroundService = true;
        this.mIsOnGoing = true;
        return (T)this;
    }

    public <T extends BaseBuilder> T setVisibility(int visibility) {
        this.mVisibility = visibility;
        return (T)this;
    }

    public <T extends BaseBuilder> T setStyle(NotificationCompat.Style style) {
        this.mStyle = style;
        return (T)this;
    }

    public <T extends BaseBuilder> T setIsPolling(boolean isPolling) {
        this.mIsPolling = isPolling;
        return (T)this;
    }

    public void build() {
        this.beforeBuild();
        if (this.mChannelId == null) {
            this.mChannelId = DEFAULT_CHANNEL_ID_PREFIX + this.mId;
        }
        if (this.mChannelName == null) {
            this.mChannelName = DEFAULT_CHANNEL_NAME_PREFIX + this.mId;
        }
        this.mBuilder = new NotificationCompat.Builder(XUtil.getContext(), this.mChannelId);
        if (this.mSmallIcon > 0) {
            this.mBuilder.setSmallIcon(this.mSmallIcon);
        }
        if (this.mBigIcon > 0) {
            this.mBuilder.setLargeIcon(BitmapFactory.decodeResource((Resources)ResUtils.getResources(), (int)this.mBigIcon));
        }
        this.mBuilder.setTicker(this.mTicker);
        this.mBuilder.setContentTitle(this.mContentTitle);
        if (!TextUtils.isEmpty((CharSequence)this.mContentText)) {
            this.mBuilder.setContentText(this.mContentText);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSubText)) {
            this.mBuilder.setContentText(this.mSubText);
        }
        if (this.mWhen > 0L) {
            this.mBuilder.setWhen(this.mWhen);
        } else {
            this.mBuilder.setWhen(System.currentTimeMillis());
        }
        this.mBuilder.setShowWhen(this.mIsShowWhen);
        this.mBuilder.setContentIntent(this.mContentIntent);
        this.mBuilder.setDeleteIntent(this.mDeleteIntent);
        this.mBuilder.setFullScreenIntent(this.mFullscreenIntent, true);
        this.mBuilder.setAutoCancel(true);
        this.mBuilder.setOngoing(this.mIsOnGoing);
        this.mBuilder.setPriority(this.mPriority);
        if (this.mIsSound) {
            this.mDefaults |= 1;
            if (this.mSoundUri != null) {
                this.mBuilder.setSound(this.mSoundUri);
            }
        }
        if (this.mIsVibrate) {
            this.mDefaults |= 2;
            if (this.mVibratePatten != null) {
                this.mBuilder.setVibrate(this.mVibratePatten);
            }
        }
        if (this.mLights) {
            this.mDefaults |= 4;
        }
        this.mBuilder.setDefaults(this.mDefaults);
        if (this.mBtnActionBeans != null && this.mBtnActionBeans.size() > 0) {
            for (BtnActionBean bean : this.mBtnActionBeans) {
                this.mBuilder.addAction(bean.icon, bean.text, bean.pendingIntent);
            }
        }
        if (this.mHeadUp) {
            this.mBuilder.setPriority(2);
            this.mBuilder.setDefaults(-1);
        } else {
            this.mBuilder.setPriority(0);
            this.mBuilder.setDefaults(4);
        }
        this.mBuilder.setVisibility(this.mVisibility);
        if (this.mStyle != null) {
            this.mBuilder.setStyle(this.mStyle);
        }
        this.afterBuild();
    }

    protected void beforeBuild() {
    }

    protected void afterBuild() {
    }

    public void show() {
        this.build();
        Notification notification = this.mBuilder.build();
        if (this.mIsForeGroundService) {
            notification.flags = 64;
        }
        if (this.mIsPolling) {
            notification.flags |= 4;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(this.mChannelId, (CharSequence)this.mChannelName, 4);
            NotificationUtils.getManager().createNotificationChannel(channel);
        }
        NotificationUtils.notify(this.mId, notification);
    }

    public NotificationCompat.Builder getBuilder() {
        return this.mBuilder;
    }

    public static class BtnActionBean {
        public int icon;
        public CharSequence text;
        public PendingIntent pendingIntent;

        public BtnActionBean(int icon, CharSequence text, PendingIntent pendingIntent) {
            this.icon = icon;
            this.text = text;
            this.pendingIntent = pendingIntent;
        }
    }
}

