/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.app;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.xuexiang.xutil.app.ActivityUtils;
import com.xuexiang.xutil.app.PathUtils;
import com.xuexiang.xutil.file.FileUtils;
import com.xuexiang.xutil.tip.ToastUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SocialShareUtils {
    private SocialShareUtils() {
        throw new Error("Do not need instantiate!");
    }

    @NonNull
    private static ArrayList<Uri> getMediaUrisFromPaths(List<String> filePaths) {
        ArrayList<Uri> fileUris = new ArrayList<Uri>();
        for (String filePath : filePaths) {
            Uri uri = PathUtils.getMediaContentUri((File)FileUtils.getFileByPath((String)filePath));
            if (uri == null) continue;
            fileUris.add(uri);
        }
        return fileUris;
    }

    public static void shareMultiplePicture(Activity activity, String ... filePaths) {
        SocialShareUtils.shareMultiplePicture(activity, Arrays.asList(filePaths));
    }

    public static void shareMultiplePicture(Activity activity, List<String> filePaths) {
        if (!SocialShareUtils.shareMultiplePictureForResult(activity, filePaths)) {
            ToastUtils.toast((String)"\u672a\u627e\u5230\u53ef\u8fdb\u884c\u5206\u4eab\u7684\u5e94\u7528\uff01");
        }
    }

    public static void shareMultiplePictureToWeChatCircle(Activity activity, String description, String ... filePaths) {
        SocialShareUtils.shareMultiplePictureToWeChatCircle(activity, description, Arrays.asList(filePaths));
    }

    public static void shareMultiplePictureToWeChatCircle(Activity activity, String description, List<String> filePaths) {
        if (!SocialShareUtils.shareMultiplePictureToWeChatCircleForResult(activity, description, filePaths)) {
            ToastUtils.toast((String)"\u5f53\u524d\u8bbe\u5907\u672a\u5b89\u88c5\u5fae\u4fe1\uff0c\u65e0\u6cd5\u8fdb\u884c\u5fae\u4fe1\u5206\u4eab\uff01");
        }
    }

    public static void shareMultiplePictureToWeChatContacts(Activity activity, String description, String ... filePaths) {
        SocialShareUtils.shareMultiplePictureToWeChatContacts(activity, description, Arrays.asList(filePaths));
    }

    public static void shareMultiplePictureToWeChatContacts(Activity activity, String description, List<String> filePaths) {
        if (!SocialShareUtils.shareMultiplePictureToWeChatContactsForResult(activity, description, filePaths)) {
            ToastUtils.toast((String)"\u5f53\u524d\u8bbe\u5907\u672a\u5b89\u88c5\u5fae\u4fe1\uff0c\u65e0\u6cd5\u8fdb\u884c\u5fae\u4fe1\u5206\u4eab\uff01");
        }
    }

    public static boolean shareMultiplePictureForResult(Activity activity, String ... filePaths) {
        return SocialShareUtils.shareMultiplePictureForResult(activity, Arrays.asList(filePaths));
    }

    public static boolean shareMultiplePictureForResult(Activity activity, List<String> filePaths) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.SEND_MULTIPLE");
        intent.setType("image/*");
        intent.putParcelableArrayListExtra("android.intent.extra.STREAM", SocialShareUtils.getMediaUrisFromPaths(filePaths));
        return ActivityUtils.startActivity((Context)activity, (Intent)Intent.createChooser((Intent)intent, (CharSequence)"\u5206\u4eab\u5230"));
    }

    public static boolean shareMultiplePictureToWeChatCircleForResult(Activity activity, String description, String ... filePaths) {
        return SocialShareUtils.shareMultiplePictureToWeChatCircleForResult(activity, description, Arrays.asList(filePaths));
    }

    public static boolean shareMultiplePictureToWeChatCircleForResult(Activity activity, String description, List<String> filePaths) {
        Intent intent = new Intent();
        ComponentName comp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.tools.ShareToTimeLineUI");
        intent.setComponent(comp);
        intent.setAction("android.intent.action.SEND_MULTIPLE");
        intent.setType("image/*");
        intent.putParcelableArrayListExtra("android.intent.extra.STREAM", SocialShareUtils.getMediaUrisFromPaths(filePaths));
        intent.putExtra("Kdescription", description);
        return ActivityUtils.startActivity((Context)activity, (Intent)Intent.createChooser((Intent)intent, (CharSequence)"\u5206\u4eab\u5230"));
    }

    public static boolean shareMultiplePictureToWeChatContactsForResult(Activity activity, String description, String ... filePaths) {
        return SocialShareUtils.shareMultiplePictureToWeChatContactsForResult(activity, description, Arrays.asList(filePaths));
    }

    public static boolean shareMultiplePictureToWeChatContactsForResult(Activity activity, String description, List<String> filePaths) {
        Intent intent = new Intent();
        ComponentName comp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.tools.ShareImgUI");
        intent.setComponent(comp);
        intent.setAction("android.intent.action.SEND_MULTIPLE");
        intent.setType("image/*");
        intent.putParcelableArrayListExtra("android.intent.extra.STREAM", SocialShareUtils.getMediaUrisFromPaths(filePaths));
        intent.putExtra("Kdescription", description);
        return ActivityUtils.startActivity((Context)activity, (Intent)Intent.createChooser((Intent)intent, (CharSequence)"\u5206\u4eab\u5230"));
    }

    public static void sharePicture(Activity activity, Uri imgUri, ShareType shareType) {
        switch (shareType) {
            case DEFAULT: {
                SocialShareUtils.sharePicture(activity, imgUri);
                break;
            }
            case WE_CHAT_CIRCLE: {
                SocialShareUtils.sharePictureToWeChatCircle(activity, imgUri);
                break;
            }
            case WE_CHAT_CONTACTS: {
                SocialShareUtils.sharePictureToWeChatContacts(activity, imgUri);
                break;
            }
        }
    }

    public static void sharePictureToWeChatCircle(Activity activity, Uri imgUri) {
        ComponentName comp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.tools.ShareToTimeLineUI");
        SocialShareUtils.shareFile(activity, comp, imgUri, "image/*", "\u5206\u4eab\u56fe\u7247");
    }

    public static void sharePictureToWeChatContacts(Activity activity, Uri imgUri) {
        ComponentName comp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.tools.ShareImgUI");
        SocialShareUtils.shareFile(activity, comp, imgUri, "image/*", "\u5206\u4eab\u56fe\u7247");
    }

    public static void sharePicture(Activity activity, File picture) {
        SocialShareUtils.shareFile(activity, null, picture, "image/*", "\u5206\u4eab\u56fe\u7247");
    }

    public static void sharePicture(Activity activity, Uri pictureUri) {
        SocialShareUtils.shareFile(activity, null, pictureUri, "image/*", "\u5206\u4eab\u56fe\u7247");
    }

    public static boolean sharePictureForResult(Activity activity, Uri imgUri, ShareType shareType) {
        switch (shareType) {
            case DEFAULT: {
                return SocialShareUtils.sharePictureForResult(activity, imgUri);
            }
            case WE_CHAT_CIRCLE: {
                return SocialShareUtils.sharePictureToWeChatCircleForResult(activity, imgUri);
            }
            case WE_CHAT_CONTACTS: {
                return SocialShareUtils.sharePictureToWeChatContactsForResult(activity, imgUri);
            }
        }
        return false;
    }

    public static boolean sharePictureToWeChatCircleForResult(Activity activity, Uri imgUri) {
        ComponentName comp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.tools.ShareToTimeLineUI");
        return SocialShareUtils.shareFileForResult(activity, comp, imgUri, "image/*", "\u5206\u4eab\u56fe\u7247");
    }

    public static boolean sharePictureToWeChatContactsForResult(Activity activity, Uri imgUri) {
        ComponentName comp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.tools.ShareImgUI");
        return SocialShareUtils.shareFileForResult(activity, comp, imgUri, "image/*", "\u5206\u4eab\u56fe\u7247");
    }

    public static boolean sharePictureForResult(Activity activity, File picture) {
        return SocialShareUtils.shareFileForResult(activity, null, picture, "image/*", "\u5206\u4eab\u56fe\u7247");
    }

    public static boolean sharePictureForResult(Activity activity, Uri pictureUri) {
        return SocialShareUtils.shareFileForResult(activity, null, pictureUri, "image/*", "\u5206\u4eab\u56fe\u7247");
    }

    public static void shareVideo(Activity activity, Uri videoUri, ShareType shareType) {
        switch (shareType) {
            case DEFAULT: {
                SocialShareUtils.shareVideo(activity, videoUri);
                break;
            }
            case WE_CHAT_CIRCLE: {
                ToastUtils.toast((String)"\u5fae\u4fe1\u670b\u53cb\u5708\u53ea\u652f\u6301\u5206\u4eab\u56fe\u7247\uff01");
                break;
            }
            case WE_CHAT_CONTACTS: {
                SocialShareUtils.shareVideoToWeChatContacts(activity, videoUri);
                break;
            }
        }
    }

    public static void shareVideoToWeChatContacts(Activity activity, Uri videoUri) {
        ComponentName comp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.tools.ShareImgUI");
        SocialShareUtils.shareFile(activity, comp, videoUri, "video/*", "\u5206\u4eab\u89c6\u9891");
    }

    public static void shareVideo(Activity activity, File videoFile) {
        SocialShareUtils.shareFile(activity, null, videoFile, "video/*", "\u5206\u4eab\u89c6\u9891");
    }

    public static void shareVideo(Activity activity, Uri videoUri) {
        SocialShareUtils.shareFile(activity, null, videoUri, "video/*", "\u5206\u4eab\u89c6\u9891");
    }

    public static boolean shareVideoForResult(Activity activity, Uri videoUri, ShareType shareType) {
        switch (shareType) {
            case DEFAULT: {
                return SocialShareUtils.shareVideoForResult(activity, videoUri);
            }
            case WE_CHAT_CIRCLE: {
                break;
            }
            case WE_CHAT_CONTACTS: {
                return SocialShareUtils.shareVideoToWeChatContactsForResult(activity, videoUri);
            }
        }
        return false;
    }

    public static boolean shareVideoToWeChatContactsForResult(Activity activity, Uri videoUri) {
        ComponentName comp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.tools.ShareImgUI");
        return SocialShareUtils.shareFileForResult(activity, comp, videoUri, "video/*", "\u5206\u4eab\u89c6\u9891");
    }

    public static boolean shareVideoForResult(Activity activity, File videoFile) {
        return SocialShareUtils.shareFileForResult(activity, null, videoFile, "video/*", "\u5206\u4eab\u89c6\u9891");
    }

    public static boolean shareVideoForResult(Activity activity, Uri videoUri) {
        return SocialShareUtils.shareFileForResult(activity, null, videoUri, "video/*", "\u5206\u4eab\u89c6\u9891");
    }

    public static void shareFile(Activity activity, Uri fileUri, ShareType shareType) {
        switch (shareType) {
            case DEFAULT: {
                SocialShareUtils.shareFile(activity, fileUri);
                break;
            }
            case WE_CHAT_CIRCLE: {
                ToastUtils.toast((String)"\u5fae\u4fe1\u670b\u53cb\u5708\u53ea\u652f\u6301\u5206\u4eab\u56fe\u7247\uff01");
                break;
            }
            case WE_CHAT_CONTACTS: {
                SocialShareUtils.shareFileToWeChatContacts(activity, fileUri);
                break;
            }
        }
    }

    public static void shareFileToWeChatContacts(Activity activity, Uri fileUri) {
        ComponentName comp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.tools.ShareImgUI");
        SocialShareUtils.shareFile(activity, comp, fileUri, "*/*", "\u5206\u4eab\u6587\u4ef6");
    }

    public static void shareFile(Activity activity, Uri fileUri) {
        SocialShareUtils.shareFile(activity, null, fileUri, "*/*", "\u5206\u4eab\u6587\u4ef6");
    }

    public static void shareFile(Activity activity, ComponentName componentName, @NonNull File fileToShare, String mimeTypeForFile, String subjectTextToShare) {
        SocialShareUtils.shareFile(activity, componentName, PathUtils.getUriForFile((File)fileToShare), mimeTypeForFile, subjectTextToShare);
    }

    public static void shareFile(Activity activity, ComponentName componentName, Uri fileUri, @NonNull String mimeTypeForFile, @NonNull String subjectTextToShare) {
        if (!SocialShareUtils.shareFileForResult(activity, componentName, fileUri, mimeTypeForFile, subjectTextToShare)) {
            ToastUtils.toast((String)"\u672a\u627e\u5230\u53ef\u8fdb\u884c\u5206\u4eab\u7684\u5e94\u7528\uff01");
        }
    }

    public static boolean shareFileForResult(Activity activity, Uri fileUri, ShareType shareType) {
        switch (shareType) {
            case DEFAULT: {
                return SocialShareUtils.shareFileForResult(activity, fileUri);
            }
            case WE_CHAT_CIRCLE: {
                break;
            }
            case WE_CHAT_CONTACTS: {
                return SocialShareUtils.shareFileToWeChatContactsForResult(activity, fileUri);
            }
        }
        return false;
    }

    public static boolean shareFileToWeChatContactsForResult(Activity activity, Uri fileUri) {
        ComponentName comp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.tools.ShareImgUI");
        return SocialShareUtils.shareFileForResult(activity, comp, fileUri, "*/*", "\u5206\u4eab\u6587\u4ef6");
    }

    public static boolean shareFileForResult(Activity activity, Uri fileUri) {
        return SocialShareUtils.shareFileForResult(activity, null, fileUri, "*/*", "\u5206\u4eab\u6587\u4ef6");
    }

    public static boolean shareFileForResult(Activity activity, ComponentName componentName, @NonNull File fileToShare, String mimeTypeForFile, String subjectTextToShare) {
        return SocialShareUtils.shareFileForResult(activity, componentName, PathUtils.getUriForFile((File)fileToShare), mimeTypeForFile, subjectTextToShare);
    }

    public static boolean shareFileForResult(Activity activity, ComponentName componentName, Uri fileUri, @NonNull String mimeTypeForFile, @NonNull String subjectTextToShare) {
        Intent intent = new Intent();
        if (componentName != null) {
            intent.setComponent(componentName);
        }
        intent.setAction("android.intent.action.SEND");
        intent.setType(mimeTypeForFile);
        intent.putExtra("android.intent.extra.SUBJECT", subjectTextToShare);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)fileUri);
        return ActivityUtils.startActivity((Context)activity, (Intent)Intent.createChooser((Intent)intent, (CharSequence)"\u5206\u4eab\u5230"));
    }

    public static enum ShareType {
        DEFAULT,
        WE_CHAT_CONTACTS,
        WE_CHAT_CIRCLE;

    }
}

