/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.RequiresPermission;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import com.xuexiang.xutil.app.IntentUtils;
import com.xuexiang.xutil.common.ShellUtils;
import com.xuexiang.xutil.common.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.util.List;

public final class PackageUtils {
    private static final int APP_INSTALL_AUTO = 0;
    private static final int APP_INSTALL_INTERNAL = 1;
    private static final int APP_INSTALL_EXTERNAL = 2;
    public static final int REQUEST_CODE_INSTALL_APP = 999;
    public static final int DELETE_SUCCEEDED = 1;
    public static final int DELETE_FAILED_INTERNAL_ERROR = -1;
    public static final int DELETE_FAILED_DEVICE_POLICY_MANAGER = -2;
    public static final int DELETE_FAILED_INVALID_PACKAGE = -3;
    public static final int DELETE_FAILED_PERMISSION_DENIED = -4;

    private PackageUtils() {
        throw new Error("Do not need instantiate!");
    }

    public static boolean install(Context context, File apkFile) throws IOException {
        return PackageUtils.install(context, apkFile.getCanonicalPath());
    }

    public static boolean install(Context context, String filePath) {
        if (PackageUtils.isSystemApplication(context) || ShellUtils.checkRootPermission()) {
            return PackageUtils.installAppSilent(context, filePath);
        }
        return PackageUtils.installNormal(context, filePath);
    }

    @RequiresPermission(value="android.permission.INSTALL_PACKAGES")
    public static boolean installAppSilent(Context context, String filePath) {
        if (Build.VERSION.SDK_INT < 24) {
            return PackageUtils.installAppSilentBelow24(context, filePath);
        }
        return PackageUtils.installAppSilentAbove24(context.getPackageName(), filePath);
    }

    @RequiresPermission(value="android.permission.INSTALL_PACKAGES")
    private static boolean installAppSilentBelow24(Context context, String filePath) {
        File file = PackageUtils.getFileByPath(filePath);
        if (!PackageUtils.isFileExists(file)) {
            return false;
        }
        String pmParams = " -r " + PackageUtils.getInstallLocationParams();
        StringBuilder command = new StringBuilder().append("LD_LIBRARY_PATH=/vendor/lib:/system/lib pm install ").append(pmParams).append(" ").append(filePath.replace(" ", "\\ "));
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand((String)command.toString(), (!PackageUtils.isSystemApplication(context) ? 1 : 0) != 0, (boolean)true);
        return commandResult.successMsg != null && (commandResult.successMsg.contains("Success") || commandResult.successMsg.contains("success"));
    }

    @RequiresPermission(value="android.permission.INSTALL_PACKAGES")
    private static boolean installAppSilentAbove24(String packageName, String filePath) {
        File file = PackageUtils.getFileByPath(filePath);
        if (!PackageUtils.isFileExists(file)) {
            return false;
        }
        boolean isRoot = PackageUtils.isDeviceRooted();
        String command = "pm install -i " + packageName + " --user 0 " + filePath;
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand((String)command, (boolean)isRoot);
        return commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success");
    }

    private static boolean installNormal(Context context, String filePath) {
        File file = PackageUtils.getFileByPath(filePath);
        return PackageUtils.isFileExists(file) && PackageUtils.installNormal(context, file);
    }

    private static boolean installNormal(Context context, File appFile) {
        try {
            Intent intent = PackageUtils.getInstallAppIntent(context, appFile);
            if (context.getPackageManager().queryIntentActivities(intent, 0).size() > 0) {
                if (context instanceof Activity) {
                    ((Activity)context).startActivityForResult(intent, 999);
                } else {
                    context.startActivity(intent);
                }
                return true;
            }
        }
        catch (Exception e) {
            Logger.e((String)"\u4f7f\u7528\u7cfb\u7edf\u7684\u610f\u56fe\u8fdb\u884capk\u5b89\u88c5\u5931\u8d25\uff01", (Throwable)e);
        }
        return false;
    }

    public static Intent getInstallAppIntent(Context context, File appFile) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            if (Build.VERSION.SDK_INT >= 24) {
                intent.setFlags(65);
                Uri fileUri = FileProvider.getUriForFile((Context)context, (String)(context.getApplicationContext().getPackageName() + ".updateFileProvider"), (File)appFile);
                intent.setDataAndType(fileUri, "application/vnd.android.package-archive");
            } else {
                intent.setDataAndType(Uri.fromFile((File)appFile), "application/vnd.android.package-archive");
            }
            return intent;
        }
        catch (Exception e) {
            Logger.e((String)"\u83b7\u53d6\u5b89\u88c5\u7684\u610f\u56fe\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    private static File getFileByPath(String filePath) {
        return PackageUtils.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    private static boolean isDeviceRooted() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    public static int uninstall(Context context, String packageName) {
        if (PackageUtils.isSystemApplication(context) || ShellUtils.checkRootPermission()) {
            return PackageUtils.uninstallSilent(context, packageName);
        }
        return PackageUtils.uninstallNormal(context, packageName) ? 1 : -3;
    }

    public static boolean uninstallNormal(Context context, String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return false;
        }
        Intent i = new Intent("android.intent.action.DELETE", Uri.parse((String)new StringBuilder(32).append("package:").append(packageName).toString()));
        i.addFlags(0x10000000);
        context.startActivity(i);
        return true;
    }

    public static int uninstallSilent(Context context, String packageName) {
        return PackageUtils.uninstallSilent(context, packageName, true);
    }

    public static int uninstallSilent(Context context, String packageName, boolean isKeepData) {
        if (packageName == null || packageName.length() == 0) {
            return -3;
        }
        StringBuilder command = new StringBuilder().append("LD_LIBRARY_PATH=/vendor/lib:/system/lib pm uninstall").append(isKeepData ? " -k " : " ").append(packageName.replace(" ", "\\ "));
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand((String)command.toString(), (!PackageUtils.isSystemApplication(context) ? 1 : 0) != 0, (boolean)true);
        if (commandResult.successMsg != null && (commandResult.successMsg.contains("Success") || commandResult.successMsg.contains("success"))) {
            return 1;
        }
        Logger.e((String)("uninstallSilent successMsg:" + commandResult.successMsg + ", ErrorMsg:" + commandResult.errorMsg));
        if (commandResult.errorMsg == null) {
            return -1;
        }
        if (commandResult.errorMsg.contains("Permission denied")) {
            return -4;
        }
        return -1;
    }

    public static boolean isSystemApplication(Context context) {
        return context != null && PackageUtils.isSystemApplication(context, context.getPackageName());
    }

    public static boolean isSystemApplication(Context context, String packageName) {
        return context != null && PackageUtils.isSystemApplication(context.getPackageManager(), packageName);
    }

    public static boolean isSystemApplication(PackageManager packageManager, String packageName) {
        if (packageManager == null || packageName == null || packageName.length() == 0) {
            return false;
        }
        try {
            ApplicationInfo app = packageManager.getApplicationInfo(packageName, 0);
            return app != null && (app.flags & 1) > 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getAppVersionCode(Context context) {
        PackageManager pm;
        if (context != null && (pm = context.getPackageManager()) != null) {
            try {
                PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
                if (pi != null) {
                    return pi.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    private static int getInstallLocation() {
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand((String)"LD_LIBRARY_PATH=/vendor/lib:/system/lib pm get-install-location", (boolean)false, (boolean)true);
        if (commandResult.result == 0 && commandResult.successMsg != null && commandResult.successMsg.length() > 0) {
            try {
                int location = Integer.parseInt(commandResult.successMsg.substring(0, 1));
                switch (location) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                Logger.e((String)"pm get-install-location error");
            }
        }
        return 0;
    }

    private static String getInstallLocationParams() {
        int location = PackageUtils.getInstallLocation();
        switch (location) {
            case 1: {
                return "-f";
            }
            case 2: {
                return "-s";
            }
        }
        return "";
    }

    @SuppressLint(value={"InlinedApi"})
    public static void startInstalledAppDetails(Context context, String packageName) {
        Intent intent = new Intent();
        int sdkVersion = Build.VERSION.SDK_INT;
        if (Build.VERSION.SDK_INT >= 9) {
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts((String)"package", (String)packageName, null));
        } else {
            intent.setAction("android.intent.action.VIEW");
            intent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            intent.putExtra(sdkVersion == 8 ? "pkg" : "com.android.settings.ApplicationPkgName", packageName);
        }
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static boolean checkAPP(Context context, String packageName) {
        if (packageName == null || "".equals(packageName)) {
            return false;
        }
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(packageName, 8192);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static void installApk(Context context, String filePath) {
        File apkFile = new File(filePath);
        if (!apkFile.exists()) {
            return;
        }
        Intent i = new Intent("android.intent.action.VIEW");
        i.setDataAndType(Uri.parse((String)("file://" + apkFile.toString())), "application/vnd.android.package-archive");
        context.startActivity(i);
    }

    public static void openApp(Context context) {
        context.startActivity(IntentUtils.getLaunchAppIntent((String)context.getPackageName()));
    }

    public static void openApp(Context context, ApplicationInfo appInfo) {
        PackageUtils.openApp(context, appInfo.packageName);
    }

    public static boolean openApp(Context context, String packageName) {
        Intent intent = PackageUtils.getAppOpenIntentByPackageName(context, packageName, true);
        if (intent != null) {
            context.startActivity(intent);
            return true;
        }
        return false;
    }

    public static boolean switchApp(Context context, String packageName) {
        Context pkgContext = PackageUtils.getPackageContext(context, packageName);
        Intent intent = PackageUtils.getAppOpenIntentByPackageName(context, packageName, false);
        if (pkgContext != null && intent != null) {
            pkgContext.startActivity(intent);
            return true;
        }
        return false;
    }

    private static Intent getAppOpenIntentByPackageName(Context context, String packageName, boolean isReopen) {
        String mainAct = null;
        PackageManager pkgMag = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        if (!isReopen) {
            intent.setFlags(0x10200000);
        }
        List list = pkgMag.queryIntentActivities(intent, 1);
        for (int i = 0; i < list.size(); ++i) {
            ResolveInfo info = (ResolveInfo)list.get(i);
            if (!info.activityInfo.packageName.equals(packageName)) continue;
            mainAct = info.activityInfo.name;
            break;
        }
        if (TextUtils.isEmpty(mainAct)) {
            return null;
        }
        intent.setComponent(new ComponentName(packageName, mainAct));
        return intent;
    }

    private static Context getPackageContext(Context context, String packageName) {
        Context pkgContext = null;
        if (context.getPackageName().equals(packageName)) {
            pkgContext = context;
        } else {
            try {
                pkgContext = context.createPackageContext(packageName, 3);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return pkgContext;
    }
}

