/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.service;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.xuexiang.xupdate.R;
import com.xuexiang.xupdate.XUpdate;
import com.xuexiang.xupdate._XUpdate;
import com.xuexiang.xupdate.entity.DownloadEntity;
import com.xuexiang.xupdate.entity.UpdateEntity;
import com.xuexiang.xupdate.logs.UpdateLog;
import com.xuexiang.xupdate.proxy.IUpdateHttpService;
import com.xuexiang.xupdate.service.OnFileDownloadListener;
import com.xuexiang.xupdate.utils.ApkInstallUtils;
import com.xuexiang.xupdate.utils.FileUtils;
import com.xuexiang.xupdate.utils.UpdateUtils;
import java.io.File;

public class DownloadService
extends Service {
    private static final int DOWNLOAD_NOTIFY_ID = 1000;
    private static boolean mIsRunning = false;
    private static final String CHANNEL_ID = "xupdate_channel_id";
    private static final CharSequence CHANNEL_NAME = "xupdate_channel_name";
    private NotificationManager mNotificationManager;
    private NotificationCompat.Builder mBuilder;

    public static void bindService(ServiceConnection connection) {
        Intent intent = new Intent(XUpdate.getContext(), DownloadService.class);
        XUpdate.getContext().startService(intent);
        XUpdate.getContext().bindService(intent, connection, 1);
        mIsRunning = true;
    }

    private void stop(String contentText) {
        if (this.mBuilder != null) {
            this.mBuilder.setContentTitle((CharSequence)UpdateUtils.getAppName((Context)this)).setContentText((CharSequence)contentText);
            Notification notification = this.mBuilder.build();
            notification.flags = 16;
            this.mNotificationManager.notify(1000, notification);
        }
        this.close();
    }

    private void close() {
        mIsRunning = false;
        this.stopSelf();
    }

    public static boolean isRunning() {
        return mIsRunning;
    }

    public void onCreate() {
        super.onCreate();
        this.mNotificationManager = (NotificationManager)this.getSystemService("notification");
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        mIsRunning = true;
        return new DownloadBinder();
    }

    public boolean onUnbind(Intent intent) {
        mIsRunning = false;
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        this.mNotificationManager = null;
        this.mBuilder = null;
        super.onDestroy();
    }

    private void setUpNotification(@NonNull DownloadEntity downloadEntity) {
        if (!downloadEntity.isShowNotification()) {
            return;
        }
        this.initNotification();
    }

    private void initNotification() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, CHANNEL_NAME, 4);
            channel.enableVibration(false);
            channel.enableLights(false);
            this.mNotificationManager.createNotificationChannel(channel);
        }
        this.mBuilder = this.getNotificationBuilder();
        this.mNotificationManager.notify(1000, this.mBuilder.build());
    }

    private NotificationCompat.Builder getNotificationBuilder() {
        return new NotificationCompat.Builder((Context)this, CHANNEL_ID).setContentTitle((CharSequence)this.getString(R.string.xupdate_start_download)).setContentText((CharSequence)this.getString(R.string.xupdate_connecting_service)).setSmallIcon(R.drawable.xupdate_icon_app_update).setLargeIcon(UpdateUtils.drawable2Bitmap(UpdateUtils.getAppIcon((Context)this))).setOngoing(true).setAutoCancel(true).setWhen(System.currentTimeMillis());
    }

    private void startDownload(@NonNull UpdateEntity updateEntity, @NonNull FileDownloadCallBack fileDownloadCallBack) {
        String apkUrl = updateEntity.getDownloadUrl();
        if (TextUtils.isEmpty((CharSequence)apkUrl)) {
            String contentText = this.getString(R.string.xupdate_tip_download_url_error);
            this.stop(contentText);
            return;
        }
        String apkName = UpdateUtils.getApkNameByDownloadUrl(apkUrl);
        File apkCacheDir = FileUtils.getFileByPath(updateEntity.getApkCacheDir());
        if (apkCacheDir == null) {
            apkCacheDir = UpdateUtils.getDefaultDiskCacheDir();
        }
        try {
            if (!FileUtils.isFileExists(apkCacheDir)) {
                apkCacheDir.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String target = apkCacheDir + File.separator + updateEntity.getVersionName();
        UpdateLog.d("\u5f00\u59cb\u4e0b\u8f7d\u66f4\u65b0\u6587\u4ef6, \u4e0b\u8f7d\u5730\u5740:" + apkUrl + ", \u4fdd\u5b58\u8def\u5f84:" + target + ", \u6587\u4ef6\u540d:" + apkName);
        updateEntity.getIUpdateHttpService().download(apkUrl, target, apkName, fileDownloadCallBack);
    }

    private void showDownloadCompleteNotification(File file) {
        Intent installAppIntent = ApkInstallUtils.getInstallAppIntent(file);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)installAppIntent, (int)0x8000000);
        if (this.mBuilder == null) {
            this.mBuilder = this.getNotificationBuilder();
        }
        this.mBuilder.setContentIntent(contentIntent).setContentTitle((CharSequence)UpdateUtils.getAppName((Context)this)).setContentText((CharSequence)this.getString(R.string.xupdate_download_complete)).setProgress(0, 0, false).setDefaults(-1);
        Notification notification = this.mBuilder.build();
        notification.flags = 16;
        this.mNotificationManager.notify(1000, notification);
    }

    private class FileDownloadCallBack
    implements IUpdateHttpService.DownloadCallback {
        private final DownloadEntity mDownloadEntity;
        private OnFileDownloadListener mOnFileDownloadListener;
        private boolean mIsAutoInstall;
        private int mOldRate = 0;
        private boolean mIsCancel;

        FileDownloadCallBack(@Nullable UpdateEntity updateEntity, OnFileDownloadListener listener) {
            this.mDownloadEntity = updateEntity.getDownLoadEntity();
            this.mIsAutoInstall = updateEntity.isAutoInstall();
            this.mOnFileDownloadListener = listener;
        }

        @Override
        public void onStart() {
            if (this.mIsCancel) {
                return;
            }
            DownloadService.this.mNotificationManager.cancel(1000);
            DownloadService.this.mBuilder = null;
            DownloadService.this.setUpNotification(this.mDownloadEntity);
            if (this.mOnFileDownloadListener != null) {
                this.mOnFileDownloadListener.onStart();
            }
        }

        @Override
        public void onProgress(float progress, long total) {
            if (this.mIsCancel) {
                return;
            }
            int rate = Math.round(progress * 100.0f);
            if (this.mOldRate != rate) {
                if (this.mOnFileDownloadListener != null) {
                    this.mOnFileDownloadListener.onProgress(progress, total);
                }
                if (DownloadService.this.mBuilder != null) {
                    DownloadService.this.mBuilder.setContentTitle((CharSequence)(DownloadService.this.getString(R.string.xupdate_lab_downloading) + UpdateUtils.getAppName((Context)DownloadService.this))).setContentText((CharSequence)(rate + "%")).setProgress(100, rate, false).setWhen(System.currentTimeMillis());
                    Notification notification = DownloadService.this.mBuilder.build();
                    notification.flags = 24;
                    DownloadService.this.mNotificationManager.notify(1000, notification);
                }
                this.mOldRate = rate;
            }
        }

        @Override
        public void onSuccess(File file) {
            if (this.mIsCancel) {
                return;
            }
            if (this.mOnFileDownloadListener != null && !this.mOnFileDownloadListener.onCompleted(file)) {
                DownloadService.this.close();
                return;
            }
            UpdateLog.d("\u66f4\u65b0\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210, \u6587\u4ef6\u8def\u5f84:" + file.getAbsolutePath());
            try {
                if (UpdateUtils.isAppOnForeground((Context)DownloadService.this)) {
                    DownloadService.this.mNotificationManager.cancel(1000);
                    if (this.mIsAutoInstall) {
                        _XUpdate.startInstallApk((Context)DownloadService.this, file, this.mDownloadEntity);
                    } else {
                        DownloadService.this.showDownloadCompleteNotification(file);
                    }
                } else {
                    DownloadService.this.showDownloadCompleteNotification(file);
                }
                DownloadService.this.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                DownloadService.this.close();
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.mIsCancel) {
                return;
            }
            _XUpdate.onUpdateError(4000, throwable.getMessage());
            if (this.mOnFileDownloadListener != null) {
                this.mOnFileDownloadListener.onError(throwable);
            }
            try {
                DownloadService.this.mNotificationManager.cancel(1000);
                DownloadService.this.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void onCancel() {
            this.mOnFileDownloadListener = null;
            this.mIsCancel = true;
        }
    }

    public class DownloadBinder
    extends Binder {
        private FileDownloadCallBack mFileDownloadCallBack;
        private UpdateEntity mUpdateEntity;

        public void start(@NonNull UpdateEntity updateEntity, @Nullable OnFileDownloadListener downloadListener) {
            this.mUpdateEntity = updateEntity;
            this.mFileDownloadCallBack = new FileDownloadCallBack(updateEntity, downloadListener);
            DownloadService.this.startDownload(updateEntity, this.mFileDownloadCallBack);
        }

        public void stop(String msg) {
            if (this.mFileDownloadCallBack != null) {
                this.mFileDownloadCallBack.onCancel();
            }
            this.mUpdateEntity.getIUpdateHttpService().cancelDownload(this.mUpdateEntity.getDownloadUrl());
            DownloadService.this.stop(msg);
        }

        public void showNotification() {
            if (DownloadService.this.mBuilder == null && DownloadService.isRunning()) {
                DownloadService.this.initNotification();
            }
        }
    }
}

