/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.proxy.impl;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xuexiang.xupdate.XUpdate;
import com.xuexiang.xupdate.entity.UpdateEntity;
import com.xuexiang.xupdate.proxy.IUpdateDownloader;
import com.xuexiang.xupdate.service.DownloadService;
import com.xuexiang.xupdate.service.OnFileDownloadListener;

public class DefaultUpdateDownloader
implements IUpdateDownloader {
    private DownloadService.DownloadBinder mDownloadBinder;
    private ServiceConnection mServiceConnection;
    private boolean mIsBound;

    @Override
    public void startDownload(final @NonNull UpdateEntity updateEntity, final @Nullable OnFileDownloadListener downloadListener) {
        this.mServiceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                DefaultUpdateDownloader.this.mIsBound = true;
                DefaultUpdateDownloader.this.startDownload((DownloadService.DownloadBinder)service, updateEntity, downloadListener);
            }

            public void onServiceDisconnected(ComponentName name) {
                DefaultUpdateDownloader.this.mIsBound = false;
            }
        };
        DownloadService.bindService(this.mServiceConnection);
    }

    private void startDownload(DownloadService.DownloadBinder binder, @NonNull UpdateEntity updateEntity, @Nullable OnFileDownloadListener downloadListener) {
        this.mDownloadBinder = binder;
        this.mDownloadBinder.start(updateEntity, downloadListener);
    }

    @Override
    public void cancelDownload() {
        if (this.mDownloadBinder != null) {
            this.mDownloadBinder.stop("\u53d6\u6d88\u4e0b\u8f7d");
        }
        if (this.mIsBound && this.mServiceConnection != null) {
            XUpdate.getContext().unbindService(this.mServiceConnection);
            this.mIsBound = false;
        }
    }

    @Override
    public void backgroundDownload() {
        if (this.mDownloadBinder != null) {
            this.mDownloadBinder.showNotification();
        }
    }
}

