/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xupdate.widget;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xupdate.R;
import com.xuexiang.xupdate._XUpdate;
import com.xuexiang.xupdate.entity.PromptEntity;
import com.xuexiang.xupdate.entity.UpdateEntity;
import com.xuexiang.xupdate.proxy.IUpdateProxy;
import com.xuexiang.xupdate.service.OnFileDownloadListener;
import com.xuexiang.xupdate.utils.ColorUtils;
import com.xuexiang.xupdate.utils.DrawableUtils;
import com.xuexiang.xupdate.utils.UpdateUtils;
import com.xuexiang.xupdate.widget.NumberProgressBar;
import java.io.File;

public class UpdateDialogFragment
extends DialogFragment
implements View.OnClickListener {
    public static final String KEY_UPDATE_ENTITY = "key_update_entity";
    public static final String KEY_UPDATE_PROMPT_ENTITY = "key_update_prompt_entity";
    public static final int REQUEST_CODE_REQUEST_PERMISSIONS = 111;
    private static IUpdateProxy sTmpProxy;
    private ImageView mIvTop;
    private TextView mTvTitle;
    private TextView mTvUpdateInfo;
    private Button mBtnUpdate;
    private Button mBtnBackgroundUpdate;
    private TextView mTvIgnore;
    private NumberProgressBar mNumberProgressBar;
    private LinearLayout mLlClose;
    private ImageView mIvClose;
    private UpdateEntity mUpdateEntity;
    private IUpdateProxy mIUpdateProxy;
    private PromptEntity mPromptEntity;
    private OnFileDownloadListener mOnFileDownloadListener = new OnFileDownloadListener(){

        @Override
        public void onStart() {
            if (!UpdateDialogFragment.this.isRemoving()) {
                UpdateDialogFragment.this.mNumberProgressBar.setVisibility(0);
                UpdateDialogFragment.this.mNumberProgressBar.setProgress(0);
                UpdateDialogFragment.this.mBtnUpdate.setVisibility(8);
                if (UpdateDialogFragment.this.mPromptEntity.isSupportBackgroundUpdate()) {
                    UpdateDialogFragment.this.mBtnBackgroundUpdate.setVisibility(0);
                } else {
                    UpdateDialogFragment.this.mBtnBackgroundUpdate.setVisibility(8);
                }
            }
        }

        @Override
        public void onProgress(float progress, long total) {
            if (!UpdateDialogFragment.this.isRemoving()) {
                UpdateDialogFragment.this.mNumberProgressBar.setProgress(Math.round(progress * 100.0f));
                UpdateDialogFragment.this.mNumberProgressBar.setMax(100);
            }
        }

        @Override
        public boolean onCompleted(File file) {
            if (!UpdateDialogFragment.this.isRemoving()) {
                UpdateDialogFragment.this.mBtnBackgroundUpdate.setVisibility(8);
                if (UpdateDialogFragment.this.mUpdateEntity.isForce()) {
                    UpdateDialogFragment.this.showInstallButton(file);
                } else {
                    UpdateDialogFragment.this.dismissAllowingStateLoss();
                }
            }
            return true;
        }

        @Override
        public void onError(Throwable throwable) {
            if (!UpdateDialogFragment.this.isRemoving()) {
                UpdateDialogFragment.this.dismissAllowingStateLoss();
            }
        }
    };

    public static UpdateDialogFragment newInstance(@NonNull UpdateEntity updateEntity, @NonNull IUpdateProxy updateProxy, @NonNull PromptEntity promptEntity) {
        UpdateDialogFragment fragment = new UpdateDialogFragment();
        Bundle args = new Bundle();
        args.putParcelable(KEY_UPDATE_ENTITY, (Parcelable)updateEntity);
        args.putParcelable(KEY_UPDATE_PROMPT_ENTITY, (Parcelable)promptEntity);
        fragment.setIUpdateProxy(updateProxy).setArguments(args);
        return fragment;
    }

    public UpdateDialogFragment setIUpdateProxy(IUpdateProxy updateProxy) {
        this.mIUpdateProxy = updateProxy;
        return this;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        _XUpdate.setIsShowUpdatePrompter(true);
        this.setStyle(1, R.style.XUpdate_Fragment_Dialog);
    }

    public void onStart() {
        super.onStart();
        this.initDialog();
    }

    private void initDialog() {
        this.getDialog().setCanceledOnTouchOutside(false);
        this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                return keyCode == 4 && UpdateDialogFragment.this.mUpdateEntity != null && UpdateDialogFragment.this.mUpdateEntity.isForce();
            }
        });
        Window window = this.getDialog().getWindow();
        if (window != null) {
            window.setGravity(17);
            WindowManager.LayoutParams lp = window.getAttributes();
            DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
            if (this.mPromptEntity.getWidthRatio() > 0.0f && this.mPromptEntity.getWidthRatio() < 1.0f) {
                lp.width = (int)((float)displayMetrics.widthPixels * this.mPromptEntity.getWidthRatio());
            }
            if (this.mPromptEntity.getHeightRatio() > 0.0f && this.mPromptEntity.getHeightRatio() < 1.0f) {
                lp.height = (int)((float)displayMetrics.heightPixels * this.mPromptEntity.getHeightRatio());
            }
            window.setAttributes(lp);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.xupdate_dialog_app, container);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    private void initView(View view) {
        this.mIvTop = (ImageView)view.findViewById(R.id.iv_top);
        this.mTvTitle = (TextView)view.findViewById(R.id.tv_title);
        this.mTvUpdateInfo = (TextView)view.findViewById(R.id.tv_update_info);
        this.mBtnUpdate = (Button)view.findViewById(R.id.btn_update);
        this.mBtnBackgroundUpdate = (Button)view.findViewById(R.id.btn_background_update);
        this.mTvIgnore = (TextView)view.findViewById(R.id.tv_ignore);
        this.mNumberProgressBar = (NumberProgressBar)view.findViewById(R.id.npb_progress);
        this.mLlClose = (LinearLayout)view.findViewById(R.id.ll_close);
        this.mIvClose = (ImageView)view.findViewById(R.id.iv_close);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (sTmpProxy != null) {
            this.mIUpdateProxy = sTmpProxy;
            sTmpProxy = null;
        }
        this.initData();
    }

    private void initData() {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mPromptEntity = (PromptEntity)bundle.getParcelable(KEY_UPDATE_PROMPT_ENTITY);
            if (this.mPromptEntity == null) {
                this.mPromptEntity = new PromptEntity();
            }
            this.initTheme(this.mPromptEntity.getThemeColor(), this.mPromptEntity.getTopResId());
            this.mUpdateEntity = (UpdateEntity)bundle.getParcelable(KEY_UPDATE_ENTITY);
            if (this.mUpdateEntity != null) {
                this.initUpdateInfo(this.mUpdateEntity);
                this.initListeners();
            }
        }
    }

    private void initUpdateInfo(UpdateEntity updateEntity) {
        String newVersion = updateEntity.getVersionName();
        String updateInfo = UpdateUtils.getDisplayUpdateInfo(this.getContext(), updateEntity);
        this.mTvUpdateInfo.setText((CharSequence)updateInfo);
        this.mTvTitle.setText((CharSequence)String.format(this.getString(R.string.xupdate_lab_ready_update), newVersion));
        if (UpdateUtils.isApkDownloaded(this.mUpdateEntity)) {
            this.showInstallButton(UpdateUtils.getApkFileByUpdateEntity(this.mUpdateEntity));
        }
        if (updateEntity.isForce()) {
            this.mLlClose.setVisibility(8);
        } else if (updateEntity.isIgnorable()) {
            this.mTvIgnore.setVisibility(0);
        }
    }

    private void initTheme(@ColorInt int themeColor, @DrawableRes int topResId) {
        if (themeColor == -1) {
            themeColor = ColorUtils.getColor(this.getContext(), R.color.xupdate_default_theme_color);
        }
        if (topResId == -1) {
            topResId = R.drawable.xupdate_bg_app_top;
        }
        this.setDialogTheme(themeColor, topResId);
    }

    private void setDialogTheme(int color2, int topResId) {
        this.mIvTop.setImageResource(topResId);
        this.mBtnUpdate.setBackgroundDrawable((Drawable)DrawableUtils.getDrawable(UpdateUtils.dip2px(4, (Context)this.getActivity()), color2));
        this.mBtnBackgroundUpdate.setBackgroundDrawable((Drawable)DrawableUtils.getDrawable(UpdateUtils.dip2px(4, (Context)this.getActivity()), color2));
        this.mNumberProgressBar.setProgressTextColor(color2);
        this.mNumberProgressBar.setReachedBarColor(color2);
        this.mBtnUpdate.setTextColor(ColorUtils.isColorDark(color2) ? -1 : -16777216);
    }

    private void initListeners() {
        this.mBtnUpdate.setOnClickListener((View.OnClickListener)this);
        this.mBtnBackgroundUpdate.setOnClickListener((View.OnClickListener)this);
        this.mIvClose.setOnClickListener((View.OnClickListener)this);
        this.mTvIgnore.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.btn_update) {
            int flag = ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            if (flag != 0) {
                this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 111);
            } else {
                this.installApp();
            }
        } else if (i == R.id.btn_background_update) {
            if (this.mIUpdateProxy != null) {
                this.mIUpdateProxy.backgroundDownload();
            }
            this.dismiss();
        } else if (i == R.id.iv_close) {
            if (this.mIUpdateProxy != null) {
                this.mIUpdateProxy.cancelDownload();
            }
            this.dismiss();
        } else if (i == R.id.tv_ignore) {
            UpdateUtils.saveIgnoreVersion((Context)this.getActivity(), this.mUpdateEntity.getVersionName());
            this.dismiss();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 111) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.installApp();
            } else {
                _XUpdate.onUpdateError(4001);
                this.dismiss();
            }
        }
    }

    private void installApp() {
        if (UpdateUtils.isApkDownloaded(this.mUpdateEntity)) {
            this.onInstallApk();
            if (!this.mUpdateEntity.isForce()) {
                this.dismiss();
            } else {
                this.showInstallButton(UpdateUtils.getApkFileByUpdateEntity(this.mUpdateEntity));
            }
        } else {
            if (this.mIUpdateProxy != null) {
                this.mIUpdateProxy.startDownload(this.mUpdateEntity, this.mOnFileDownloadListener);
            }
            if (this.mUpdateEntity.isIgnorable()) {
                this.mTvIgnore.setVisibility(8);
            }
        }
    }

    private void showInstallButton(final File apkFile) {
        this.mNumberProgressBar.setVisibility(8);
        this.mBtnUpdate.setText(R.string.xupdate_lab_install);
        this.mBtnUpdate.setVisibility(0);
        this.mBtnUpdate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UpdateDialogFragment.this.onInstallApk(apkFile);
            }
        });
    }

    private void onInstallApk() {
        _XUpdate.startInstallApk(this.getContext(), UpdateUtils.getApkFileByUpdateEntity(this.mUpdateEntity), this.mUpdateEntity.getDownLoadEntity());
    }

    private void onInstallApk(File apkFile) {
        _XUpdate.startInstallApk(this.getContext(), apkFile, this.mUpdateEntity.getDownLoadEntity());
    }

    public void show(FragmentManager manager, String tag) {
        if (Build.VERSION.SDK_INT > 16 && manager.isDestroyed()) {
            return;
        }
        try {
            super.show(manager, tag);
        }
        catch (Exception e) {
            _XUpdate.onUpdateError(3000, e.getMessage());
        }
    }

    public void show(FragmentManager manager) {
        this.show(manager, "update_dialog");
    }

    public void onDestroyView() {
        _XUpdate.setIsShowUpdatePrompter(false);
        super.onDestroyView();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        sTmpProxy = this.mIUpdateProxy;
    }
}

