/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.toast;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.CheckResult;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.toast.Utils;

@SuppressLint(value={"InflateParams"})
public class XToast {
    private static Toast lastToast = null;
    public static final int LENGTH_SHORT = 0;
    public static final int LENGTH_LONG = 1;

    private XToast() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @StringRes int message) {
        return XToast.normal(context, context.getString(message), 0, null, false);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message) {
        return XToast.normal(context, message, 0, null, false);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @StringRes int message, Drawable icon) {
        return XToast.normal(context, context.getString(message), 0, icon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, Drawable icon) {
        return XToast.normal(context, message, 0, icon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @StringRes int message, int duration) {
        return XToast.normal(context, context.getString(message), duration, null, false);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return XToast.normal(context, message, duration, null, false);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @StringRes int message, int duration, Drawable icon) {
        return XToast.normal(context, context.getString(message), duration, icon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, int duration, Drawable icon) {
        return XToast.normal(context, message, duration, icon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @StringRes int message, int duration, Drawable icon, boolean withIcon) {
        return XToast.custom(context, context.getString(message), icon, Utils.getColor(context, R.color.toast_normal_tint_color), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull CharSequence message, int duration, Drawable icon, boolean withIcon) {
        return XToast.custom(context, message, icon, Utils.getColor(context, R.color.toast_normal_tint_color), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @StringRes int message) {
        return XToast.warning(context, context.getString(message), 0, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull CharSequence message) {
        return XToast.warning(context, message, 0, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @StringRes int message, int duration) {
        return XToast.warning(context, context.getString(message), duration, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return XToast.warning(context, message, duration, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @StringRes int message, int duration, boolean withIcon) {
        return XToast.custom(context, context.getString(message), Utils.getDrawable(context, R.drawable.xtoast_ic_error_outline_white_24dp), Utils.getColor(context, R.color.toast_warning_color), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return XToast.custom(context, message, Utils.getDrawable(context, R.drawable.xtoast_ic_error_outline_white_24dp), Utils.getColor(context, R.color.toast_warning_color), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @StringRes int message) {
        return XToast.info(context, context.getString(message), 0, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull CharSequence message) {
        return XToast.info(context, message, 0, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @StringRes int message, int duration) {
        return XToast.info(context, context.getString(message), duration, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return XToast.info(context, message, duration, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @StringRes int message, int duration, boolean withIcon) {
        return XToast.custom(context, context.getString(message), Utils.getDrawable(context, R.drawable.xtoast_ic_info_outline_white_24dp), Utils.getColor(context, R.color.toast_info_color), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return XToast.custom(context, message, Utils.getDrawable(context, R.drawable.xtoast_ic_info_outline_white_24dp), Utils.getColor(context, R.color.toast_info_color), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @StringRes int message) {
        return XToast.success(context, context.getString(message), 0, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull CharSequence message) {
        return XToast.success(context, message, 0, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @StringRes int message, int duration) {
        return XToast.success(context, context.getString(message), duration, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return XToast.success(context, message, duration, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @StringRes int message, int duration, boolean withIcon) {
        return XToast.custom(context, context.getString(message), Utils.getDrawable(context, R.drawable.xtoast_ic_check_white_24dp), Utils.getColor(context, R.color.toast_success_color), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return XToast.custom(context, message, Utils.getDrawable(context, R.drawable.xtoast_ic_check_white_24dp), Utils.getColor(context, R.color.toast_success_color), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @StringRes int message) {
        return XToast.error(context, context.getString(message), 0, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull CharSequence message) {
        return XToast.error(context, message, 0, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @StringRes int message, int duration) {
        return XToast.error(context, context.getString(message), duration, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return XToast.error(context, message, duration, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @StringRes int message, int duration, boolean withIcon) {
        return XToast.custom(context, context.getString(message), Utils.getDrawable(context, R.drawable.xtoast_ic_clear_white_24dp), Utils.getColor(context, R.color.toast_error_color), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull CharSequence message, int duration, boolean withIcon) {
        return XToast.custom(context, message, Utils.getDrawable(context, R.drawable.xtoast_ic_clear_white_24dp), Utils.getColor(context, R.color.toast_error_color), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, true);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @StringRes int message, Drawable icon, int duration, boolean withIcon) {
        return XToast.custom(context, context.getString(message), icon, -1, Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, false);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull CharSequence message, Drawable icon, int duration, boolean withIcon) {
        return XToast.custom(context, message, icon, -1, Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, false);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @StringRes int message, @DrawableRes int iconRes, @ColorRes int tintColorRes, int duration, boolean withIcon, boolean shouldTint) {
        return XToast.custom(context, context.getString(message), Utils.getDrawable(context, iconRes), Utils.getColor(context, tintColorRes), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, shouldTint);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull CharSequence message, @DrawableRes int iconRes, @ColorRes int tintColorRes, int duration, boolean withIcon, boolean shouldTint) {
        return XToast.custom(context, message, Utils.getDrawable(context, iconRes), Utils.getColor(context, tintColorRes), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, shouldTint);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @StringRes int message, Drawable icon, @ColorRes int tintColorRes, int duration, boolean withIcon, boolean shouldTint) {
        return XToast.custom(context, context.getString(message), icon, Utils.getColor(context, tintColorRes), Utils.getColor(context, R.color.toast_default_text_color), duration, withIcon, shouldTint);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @StringRes int message, Drawable icon, @ColorRes int tintColorRes, @ColorRes int textColorRes, int duration, boolean withIcon, boolean shouldTint) {
        return XToast.custom(context, context.getString(message), icon, Utils.getColor(context, tintColorRes), Utils.getColor(context, textColorRes), duration, withIcon, shouldTint);
    }

    @SuppressLint(value={"ShowToast"})
    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull CharSequence message, Drawable icon, @ColorInt int tintColor, @ColorInt int textColor, int duration, boolean withIcon, boolean shouldTint) {
        final Toast currentToast = Toast.makeText((Context)context, (CharSequence)"", (int)duration);
        View toastLayout = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(R.layout.xui_layout_xtoast, null);
        ImageView toastIcon = (ImageView)toastLayout.findViewById(R.id.toast_icon);
        TextView toastTextView = (TextView)toastLayout.findViewById(R.id.toast_text);
        Drawable drawableFrame = shouldTint ? Utils.tint9PatchDrawableFrame(context, tintColor) : Utils.getDrawable(context, R.drawable.xtoast_frame);
        Utils.setBackground(toastLayout, drawableFrame);
        if (withIcon) {
            if (icon == null) {
                throw new IllegalArgumentException("Avoid passing 'icon' as null if 'withIcon' is set to true");
            }
            if (Config.get().isRTL && Build.VERSION.SDK_INT >= 17) {
                toastLayout.setLayoutDirection(1);
            }
            Utils.setBackground((View)toastIcon, Config.get().tintIcon ? Utils.tintIcon(icon, textColor) : icon);
        } else {
            toastIcon.setVisibility(8);
        }
        toastTextView.setText(message);
        toastTextView.setTextColor(textColor);
        toastTextView.setTypeface(Config.get().typeface, 0);
        if (Config.get().textSize != -1) {
            toastTextView.setTextSize(2, (float)Config.get().textSize);
        }
        if (Config.get().alpha != -1) {
            toastLayout.getBackground().setAlpha(Config.get().alpha);
        }
        currentToast.setView(toastLayout);
        if (Config.get().gravity != -1) {
            currentToast.setGravity(Config.get().gravity, Config.get().xOffset, Config.get().yOffset);
        }
        if (!Config.get().allowQueue) {
            if (lastToast != null) {
                lastToast.cancel();
            }
            lastToast = currentToast;
            currentToast.getView().addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                }

                public void onViewDetachedFromWindow(View v) {
                    v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    if (currentToast == lastToast) {
                        lastToast = null;
                    }
                }
            });
        }
        return currentToast;
    }

    public static class Config {
        private static volatile Config sInstance = null;
        private static final Typeface LOADED_TOAST_TYPEFACE = Typeface.create((String)"sans-serif-condensed", (int)0);
        private Typeface typeface = LOADED_TOAST_TYPEFACE;
        private int textSize = -1;
        private boolean tintIcon = true;
        private boolean allowQueue = true;
        private int alpha = -1;
        private int gravity = -1;
        private int xOffset = 0;
        private int yOffset = 0;
        private boolean isRTL = false;

        private Config() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Config get() {
            if (sInstance != null) return sInstance;
            Class<Config> clazz = Config.class;
            synchronized (Config.class) {
                if (sInstance != null) return sInstance;
                sInstance = new Config();
                // ** MonitorExit[var0] (shouldn't be in output)
                return sInstance;
            }
        }

        public void reset() {
            this.typeface = LOADED_TOAST_TYPEFACE;
            this.textSize = -1;
            this.tintIcon = true;
            this.allowQueue = true;
            this.alpha = -1;
            this.gravity = -1;
            this.xOffset = 0;
            this.yOffset = 0;
            this.isRTL = false;
        }

        @CheckResult
        public Config setToastTypeface(Typeface typeface) {
            if (typeface != null) {
                this.typeface = typeface;
            }
            return this;
        }

        @CheckResult
        public Config setTextSize(int sizeInSp) {
            this.textSize = sizeInSp;
            return this;
        }

        @CheckResult
        public Config tintIcon(boolean tintIcon) {
            this.tintIcon = tintIcon;
            return this;
        }

        public Config setAlpha(@IntRange(from=0L, to=255L) int alpha) {
            this.alpha = alpha;
            return this;
        }

        @CheckResult
        public Config allowQueue(boolean allowQueue) {
            this.allowQueue = allowQueue;
            return this;
        }

        public Config setGravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Config setGravity(int gravity, int xOffset, int yOffset) {
            this.gravity = gravity;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            return this;
        }

        public Config resetGravity() {
            this.gravity = -1;
            this.xOffset = 0;
            this.yOffset = 0;
            return this;
        }

        public Config setXOffset(int xOffset) {
            this.xOffset = xOffset;
            return this;
        }

        public Config setYOffset(int yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        public Config setRTL(boolean isRTL) {
            this.isRTL = isRTL;
            return this;
        }
    }
}

