/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.supertextview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.text.method.PasswordTransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Switch;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.edittext.ClearEditText;
import com.xuexiang.xui.widget.edittext.PasswordEditText;
import com.xuexiang.xui.widget.textview.supertextview.BaseTextView;
import io.github.inflationx.calligraphy3.HasTypeface;

public class SuperTextView
extends RelativeLayout
implements HasTypeface {
    private Context mContext;
    private BaseTextView mLeftView;
    private BaseTextView mCenterView;
    private BaseTextView mRightView;
    private RelativeLayout.LayoutParams mLeftBaseViewParams;
    private RelativeLayout.LayoutParams mCenterBaseViewParams;
    private RelativeLayout.LayoutParams mRightBaseViewParams;
    private ImageView mLeftIconIV;
    private ImageView mRightIconIV;
    private RelativeLayout.LayoutParams mLeftImgParams;
    private RelativeLayout.LayoutParams mRightImgParams;
    private Drawable mLeftIconRes;
    private int mLeftIconWidth;
    private int mLeftIconHeight;
    private int mLeftIconMarginLeft;
    private ColorStateList mLeftIconTint;
    private int mLeftIconPadding;
    private Drawable mRightIconRes;
    private int mRightIconWidth;
    private int mRightIconHeight;
    private int mRightIconMarginRight;
    private ColorStateList mRightIconTint;
    private int mRightIconPadding;
    private int mDefaultTextColor;
    private int mDefaultTextSize;
    private int mDefaultMaxEms;
    private int mDefaultMargin;
    private String mLeftTextString;
    private String mLeftTopTextString;
    private String mLeftBottomTextString;
    private String mRightTextString;
    private String mRightTopTextString;
    private String mRightBottomTextString;
    private String mCenterTextString;
    private String mCenterTopTextString;
    private String mCenterBottomTextString;
    private int mLeftTextColor;
    private int mLeftTopTextColor;
    private int mLeftBottomTextColor;
    private int mCenterTextColor;
    private int mCenterTopTextColor;
    private int mCenterBottomTextColor;
    private int mRightTextColor;
    private int mRightTopTextColor;
    private int mRightBottomTextColor;
    private int mLeftTextSize;
    private int mLeftTopTextSize;
    private int mLeftBottomTextSize;
    private int mRightTextSize;
    private int mRightTopTextSize;
    private int mRightBottomTextSize;
    private int mCenterTextSize;
    private int mCenterTopTextSize;
    private int mCenterBottomTextSize;
    private int mLeftTopLines;
    private int mLeftLines;
    private int mLeftBottomLines;
    private int mCenterTopLines;
    private int mCenterLines;
    private int mCenterBottomLines;
    private int mRightTopLines;
    private int mRightLines;
    private int mRightBottomLines;
    private int mLeftTopMaxEms;
    private int mLeftMaxEms;
    private int mLeftBottomMaxEms;
    private int mCenterTopMaxEms;
    private int mCenterMaxEms;
    private int mCenterBottomMaxEms;
    private int mRightTopMaxEms;
    private int mRightMaxEms;
    private int mRightBottomMaxEms;
    private boolean mLeftTopTextBold;
    private boolean mLeftTextBold;
    private boolean mLeftBottomTextBold;
    private boolean mCenterTopTextBold;
    private boolean mCenterTextBold;
    private boolean mCenterBottomTextBold;
    private boolean mRightTopTextBold;
    private boolean mRightTextBold;
    private boolean mRightBottomTextBold;
    private Drawable mLeftTextBackground;
    private Drawable mCenterTextBackground;
    private Drawable mRightTextBackground;
    private Drawable mLeftTvDrawableLeft;
    private Drawable mLeftTvDrawableRight;
    private Drawable mCenterTvDrawableLeft;
    private Drawable mCenterTvDrawableRight;
    private Drawable mRightTvDrawableLeft;
    private Drawable mRightTvDrawableRight;
    private int mLeftTvDrawableWidth;
    private int mLeftTvDrawableHeight;
    private int mCenterTvDrawableWidth;
    private int mCenterTvDrawableHeight;
    private int mRightTvDrawableWidth;
    private int mRightTvDrawableHeight;
    private int mTextViewDrawablePadding;
    private static final int GRAVITY_LEFT_CENTER = 0;
    private static final int GRAVITY_CENTER = 1;
    private static final int GRAVITY_RIGHT_CENTER = 2;
    private static final int DEFAULT_GRAVITY = 1;
    private int mLeftGravity;
    private int mCenterGravity;
    private int mRightGravity;
    private int mLeftViewWidth;
    private View mTopDividerLineView;
    private View mBottomDividerLineView;
    private RelativeLayout.LayoutParams mTopDividerLineParams;
    private RelativeLayout.LayoutParams mBottomDividerLineParams;
    private int mTopDividerLineMarginLR;
    private int mTopDividerLineMarginLeft;
    private int mTopDividerLineMarginRight;
    private int mBottomDividerLineMarginLR;
    private int mBottomDividerLineMarginLeft;
    private int mBottomDividerLineMarginRight;
    private int mDividerLineType;
    private int mDividerLineColor;
    private int mDividerLineHeight;
    private static final int NONE = 0;
    private static final int TOP = 1;
    private static final int BOTTOM = 2;
    private static final int BOTH = 3;
    private static final int DEFAULT_DIVIDER = 2;
    private int mLeftViewMarginLeft;
    private int mLeftViewMarginRight;
    private int mCenterViewMarginLeft;
    private int mCenterViewMarginRight;
    private int mRightViewMarginLeft;
    private int mRightViewMarginRight;
    private boolean mUseRipple;
    private Drawable mBackgroundDrawable;
    private OnSuperTextViewClickListener mSuperTextViewClickListener;
    private OnLeftTopTvClickListener mLeftTopTvClickListener;
    private OnLeftTvClickListener mLeftTvClickListener;
    private OnLeftBottomTvClickListener mLeftBottomTvClickListener;
    private OnCenterTopTvClickListener mCenterTopTvClickListener;
    private OnCenterTvClickListener mCenterTvClickListener;
    private OnCenterBottomTvClickListener mCenterBottomTvClickListener;
    private OnRightTopTvClickListener mRightTopTvClickListener;
    private OnRightTvClickListener mRightTvClickListener;
    private OnRightBottomTvClickListener mRightBottomTvClickListener;
    private CompoundButton.OnCheckedChangeListener mSwitchCheckedChangeListener;
    private CompoundButton.OnCheckedChangeListener mCheckBoxCheckedChangeListener;
    private OnLeftImageViewClickListener mLeftImageViewClickListener;
    private OnRightImageViewClickListener mRightImageViewClickListener;
    private boolean mEnableEdit = false;
    private EditText mCenterEditText;
    private int mEditTextWidth = -1;
    private static final int TYPE_NONE = 0;
    private static final int TYPE_CLEAR = 1;
    private static final int TYPE_PASSWORD = 2;
    private int mEditTextButtonType = 1;
    private Drawable mEditBackground;
    private String mEditTextHint;
    private String mEditTextString;
    private int mEditTextInputType;
    private boolean mIsAsteriskStyle;
    private static final int TYPE_CHECKBOX = 0;
    private static final int TYPE_SWITCH = 1;
    private int mRightViewType;
    private CheckBox mRightCheckBox;
    private Drawable mRightCheckBoxBg;
    private int mRightCheckBoxMarginRight;
    private boolean mIsChecked;
    private int mCenterSpaceHeight;
    private Switch mRightSwitch;
    private int mRightSwitchMarginRight;
    private boolean mSwitchIsChecked;
    private String mSwitchTextOff;
    private String mSwitchTextOn;
    private int mSwitchMinWidth;
    private int mSwitchPadding;
    private int mThumbTextPadding;
    private Drawable mSwitchThumbResource;
    private Drawable mSwitchTrackResource;
    private int mDefaultShapeColor;
    private int mSelectorPressedColor;
    private int mSelectorNormalColor;
    private int mSolidColor;
    private float mCornersRadius;
    private float mCornersTopLeftRadius;
    private float mCornersTopRightRadius;
    private float mCornersBottomLeftRadius;
    private float mCornersBottomRightRadius;
    private int mStrokeWidth;
    private int mStrokeColor;
    private float mStrokeDashWidth;
    private float mStrokeDashGap;
    private boolean mUseShape;
    private GradientDrawable mGradientDrawable;

    public SuperTextView(Context context) {
        super(context);
        this.initAttrs(context, null);
    }

    public SuperTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public SuperTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        this.mContext = context;
        this.mDefaultTextColor = ThemeUtils.resolveColor(context, R.attr.stv_color_common_text, ContextCompat.getColor((Context)context, (int)R.color.stv_color_common_text));
        this.mDefaultTextSize = ThemeUtils.resolveDimension(context, R.attr.stv_text_size, ResUtils.getDimensionPixelSize(context, R.dimen.default_stv_text_size));
        this.mDefaultMaxEms = ThemeUtils.resolveInt(context, R.attr.stv_max_ems, 20);
        this.mDefaultMargin = ThemeUtils.resolveDimension(context, R.attr.stv_margin, ResUtils.getDimensionPixelSize(context, R.dimen.default_stv_margin));
        this.mDefaultShapeColor = ThemeUtils.resolveColor(context, R.attr.stv_color_shape, ContextCompat.getColor((Context)context, (int)R.color.xui_config_color_white));
        this.getAttr(attrs);
        this.initView();
    }

    private void getAttr(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.SuperTextView);
        this.mLeftTextString = typedArray.getString(R.styleable.SuperTextView_sLeftTextString);
        this.mLeftTopTextString = typedArray.getString(R.styleable.SuperTextView_sLeftTopTextString);
        this.mLeftBottomTextString = typedArray.getString(R.styleable.SuperTextView_sLeftBottomTextString);
        this.mCenterTextString = typedArray.getString(R.styleable.SuperTextView_sCenterTextString);
        this.mCenterTopTextString = typedArray.getString(R.styleable.SuperTextView_sCenterTopTextString);
        this.mCenterBottomTextString = typedArray.getString(R.styleable.SuperTextView_sCenterBottomTextString);
        this.mRightTextString = typedArray.getString(R.styleable.SuperTextView_sRightTextString);
        this.mRightTopTextString = typedArray.getString(R.styleable.SuperTextView_sRightTopTextString);
        this.mRightBottomTextString = typedArray.getString(R.styleable.SuperTextView_sRightBottomTextString);
        this.mLeftTextColor = typedArray.getColor(R.styleable.SuperTextView_sLeftTextColor, this.mDefaultTextColor);
        this.mLeftTopTextColor = typedArray.getColor(R.styleable.SuperTextView_sLeftTopTextColor, this.mDefaultTextColor);
        this.mLeftBottomTextColor = typedArray.getColor(R.styleable.SuperTextView_sLeftBottomTextColor, this.mDefaultTextColor);
        this.mCenterTextColor = typedArray.getColor(R.styleable.SuperTextView_sCenterTextColor, this.mDefaultTextColor);
        this.mCenterTopTextColor = typedArray.getColor(R.styleable.SuperTextView_sCenterTopTextColor, this.mDefaultTextColor);
        this.mCenterBottomTextColor = typedArray.getColor(R.styleable.SuperTextView_sCenterBottomTextColor, this.mDefaultTextColor);
        this.mRightTextColor = typedArray.getColor(R.styleable.SuperTextView_sRightTextColor, this.mDefaultTextColor);
        this.mRightTopTextColor = typedArray.getColor(R.styleable.SuperTextView_sRightTopTextColor, this.mDefaultTextColor);
        this.mRightBottomTextColor = typedArray.getColor(R.styleable.SuperTextView_sRightBottomTextColor, this.mDefaultTextColor);
        this.mLeftTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTextSize, this.mDefaultTextSize);
        this.mLeftTopTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTopTextSize, this.mDefaultTextSize);
        this.mLeftBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftBottomTextSize, this.mDefaultTextSize);
        this.mCenterTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterTextSize, this.mDefaultTextSize);
        this.mCenterTopTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterTopTextSize, this.mDefaultTextSize);
        this.mCenterBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterBottomTextSize, this.mDefaultTextSize);
        this.mRightTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTextSize, this.mDefaultTextSize);
        this.mRightTopTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTopTextSize, this.mDefaultTextSize);
        this.mRightBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightBottomTextSize, this.mDefaultTextSize);
        this.mLeftTopLines = typedArray.getInt(R.styleable.SuperTextView_sLeftTopLines, 1);
        this.mLeftLines = typedArray.getInt(R.styleable.SuperTextView_sLeftLines, 1);
        this.mLeftBottomLines = typedArray.getInt(R.styleable.SuperTextView_sLeftBottomLines, 1);
        this.mCenterTopLines = typedArray.getInt(R.styleable.SuperTextView_sCenterTopLines, 1);
        this.mCenterLines = typedArray.getInt(R.styleable.SuperTextView_sCenterLines, 1);
        this.mCenterBottomLines = typedArray.getInt(R.styleable.SuperTextView_sCenterBottomLines, 1);
        this.mRightTopLines = typedArray.getInt(R.styleable.SuperTextView_sRightTopLines, 1);
        this.mRightLines = typedArray.getInt(R.styleable.SuperTextView_sRightLines, 1);
        this.mRightBottomLines = typedArray.getInt(R.styleable.SuperTextView_sRightBottomLines, 1);
        this.mLeftTopMaxEms = typedArray.getInt(R.styleable.SuperTextView_sLeftTopMaxEms, this.mDefaultMaxEms);
        this.mLeftMaxEms = typedArray.getInt(R.styleable.SuperTextView_sLeftMaxEms, this.mDefaultMaxEms);
        this.mLeftBottomMaxEms = typedArray.getInt(R.styleable.SuperTextView_sLeftBottomMaxEms, this.mDefaultMaxEms);
        this.mCenterTopMaxEms = typedArray.getInt(R.styleable.SuperTextView_sCenterTopMaxEms, this.mDefaultMaxEms);
        this.mCenterMaxEms = typedArray.getInt(R.styleable.SuperTextView_sCenterMaxEms, this.mDefaultMaxEms);
        this.mCenterBottomMaxEms = typedArray.getInt(R.styleable.SuperTextView_sCenterBottomMaxEms, this.mDefaultMaxEms);
        this.mRightTopMaxEms = typedArray.getInt(R.styleable.SuperTextView_sRightTopMaxEms, this.mDefaultMaxEms);
        this.mRightMaxEms = typedArray.getInt(R.styleable.SuperTextView_sRightMaxEms, this.mDefaultMaxEms);
        this.mRightBottomMaxEms = typedArray.getInt(R.styleable.SuperTextView_sRightBottomMaxEms, this.mDefaultMaxEms);
        this.mLeftGravity = typedArray.getInt(R.styleable.SuperTextView_sLeftViewGravity, 1);
        this.mCenterGravity = typedArray.getInt(R.styleable.SuperTextView_sCenterViewGravity, 1);
        this.mRightGravity = typedArray.getInt(R.styleable.SuperTextView_sRightViewGravity, 1);
        this.mLeftTvDrawableLeft = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sLeftTvDrawableLeft);
        this.mLeftTvDrawableRight = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sLeftTvDrawableRight);
        this.mCenterTvDrawableLeft = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sCenterTvDrawableLeft);
        this.mCenterTvDrawableRight = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sCenterTvDrawableRight);
        this.mRightTvDrawableLeft = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sRightTvDrawableLeft);
        this.mRightTvDrawableRight = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sRightTvDrawableRight);
        this.mTextViewDrawablePadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTextViewDrawablePadding, this.mDefaultMargin);
        this.mLeftTvDrawableWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTvDrawableWidth, -1);
        this.mLeftTvDrawableHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTvDrawableHeight, -1);
        this.mCenterTvDrawableWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterTvDrawableWidth, -1);
        this.mCenterTvDrawableHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterTvDrawableHeight, -1);
        this.mRightTvDrawableWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTvDrawableWidth, -1);
        this.mRightTvDrawableHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTvDrawableHeight, -1);
        this.mLeftViewWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftViewWidth, 0);
        this.mTopDividerLineMarginLR = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTopDividerLineMarginLR, 0);
        this.mTopDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTopDividerLineMarginLeft, 0);
        this.mTopDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTopDividerLineMarginRight, 0);
        this.mBottomDividerLineMarginLR = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBottomDividerLineMarginLR, 0);
        this.mBottomDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBottomDividerLineMarginLeft, 0);
        this.mBottomDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBottomDividerLineMarginRight, 0);
        this.mDividerLineType = typedArray.getInt(R.styleable.SuperTextView_sDividerLineType, 2);
        this.mDividerLineColor = typedArray.getColor(R.styleable.SuperTextView_sDividerLineColor, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_separator_light));
        this.mDividerLineHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sDividerLineHeight, DensityUtils.dp2px(this.mContext, 0.5f));
        this.mLeftViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftViewMarginLeft, this.mDefaultMargin);
        this.mLeftViewMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftViewMarginRight, this.mDefaultMargin);
        this.mCenterViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterViewMarginLeft, 0);
        this.mCenterViewMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterViewMarginRight, 0);
        this.mRightViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightViewMarginLeft, this.mDefaultMargin);
        this.mRightViewMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightViewMarginRight, this.mDefaultMargin);
        this.mLeftIconRes = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sLeftIconRes);
        this.mLeftIconWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconWidth, 0);
        this.mLeftIconHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconHeight, 0);
        this.mLeftIconMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconMarginLeft, this.mDefaultMargin);
        this.mLeftIconTint = ResUtils.getColorStateListAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sLeftIconTint);
        this.mLeftIconPadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconPadding, 0);
        this.mRightIconRes = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sRightIconRes);
        this.mRightIconWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconWidth, 0);
        this.mRightIconHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconHeight, 0);
        this.mRightIconMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconMarginRight, this.mDefaultMargin);
        this.mRightIconTint = ResUtils.getColorStateListAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sLeftIconTint);
        this.mRightIconPadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconPadding, 0);
        this.mLeftTopTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sLeftTopTextIsBold, false);
        this.mLeftTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sLeftTextIsBold, false);
        this.mLeftBottomTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sLeftBottomTextIsBold, false);
        this.mCenterTopTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sCenterTopTextIsBold, false);
        this.mCenterTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sCenterTextIsBold, false);
        this.mCenterBottomTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sCenterBottomTextIsBold, false);
        this.mRightTopTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sRightTopTextIsBold, false);
        this.mRightTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sRightTextIsBold, false);
        this.mRightBottomTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sRightBottomTextIsBold, false);
        this.mLeftTextBackground = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sLeftTextBackground);
        this.mCenterTextBackground = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sCenterTextBackground);
        this.mRightTextBackground = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sRightTextBackground);
        this.mEnableEdit = typedArray.getBoolean(R.styleable.SuperTextView_sEnableEdit, this.mEnableEdit);
        this.mEditBackground = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sEditBackGround);
        this.mEditTextWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sEditTextWidth, this.mEditTextWidth);
        this.mEditTextString = typedArray.getString(R.styleable.SuperTextView_sEditTextString);
        this.mEditTextHint = typedArray.getString(R.styleable.SuperTextView_sEditTextHint);
        this.mEditTextInputType = typedArray.getInt(R.styleable.SuperTextView_android_inputType, -1);
        this.mEditTextButtonType = typedArray.getInt(R.styleable.SuperTextView_sEditTextButtonType, this.mEditTextButtonType);
        this.mIsAsteriskStyle = typedArray.getBoolean(R.styleable.SuperTextView_sEditTextIsAsteriskStyle, this.mIsAsteriskStyle);
        this.mUseRipple = typedArray.getBoolean(R.styleable.SuperTextView_sUseRipple, true);
        this.mBackgroundDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sBackgroundDrawableRes);
        this.mRightViewType = typedArray.getInt(R.styleable.SuperTextView_sRightViewType, -1);
        this.mIsChecked = typedArray.getBoolean(R.styleable.SuperTextView_sIsChecked, false);
        this.mRightCheckBoxMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightCheckBoxMarginRight, this.mDefaultMargin);
        this.mRightCheckBoxBg = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sRightCheckBoxRes);
        this.mRightSwitchMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightSwitchMarginRight, this.mDefaultMargin);
        this.mSwitchIsChecked = typedArray.getBoolean(R.styleable.SuperTextView_sSwitchIsChecked, false);
        this.mSwitchTextOff = typedArray.getString(R.styleable.SuperTextView_sTextOff);
        this.mSwitchTextOn = typedArray.getString(R.styleable.SuperTextView_sTextOn);
        this.mSwitchMinWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sSwitchMinWidth, 0);
        this.mSwitchPadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sSwitchPadding, 0);
        this.mThumbTextPadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sThumbTextPadding, 0);
        this.mSwitchThumbResource = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sThumbResource);
        this.mSwitchTrackResource = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.SuperTextView_sTrackResource);
        this.mCenterSpaceHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterSpaceHeight, DensityUtils.dp2px(this.mContext, 5.0f));
        this.mSelectorPressedColor = typedArray.getColor(R.styleable.SuperTextView_sShapeSelectorPressedColor, this.mDefaultShapeColor);
        this.mSelectorNormalColor = typedArray.getColor(R.styleable.SuperTextView_sShapeSelectorNormalColor, this.mDefaultShapeColor);
        this.mSolidColor = typedArray.getColor(R.styleable.SuperTextView_sShapeSolidColor, this.mDefaultShapeColor);
        this.mCornersRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersRadius, 0);
        this.mCornersTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersTopLeftRadius, 0);
        this.mCornersTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersTopRightRadius, 0);
        this.mCornersBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersBottomLeftRadius, 0);
        this.mCornersBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersBottomRightRadius, 0);
        this.mStrokeWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeStrokeWidth, 0);
        this.mStrokeDashWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeStrokeDashWidth, 0);
        this.mStrokeDashGap = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeStrokeDashGap, 0);
        this.mStrokeColor = typedArray.getColor(R.styleable.SuperTextView_sShapeStrokeColor, this.mDefaultShapeColor);
        this.mUseShape = typedArray.getBoolean(R.styleable.SuperTextView_sUseShape, false);
        typedArray.recycle();
    }

    private RelativeLayout.LayoutParams getParams(RelativeLayout.LayoutParams params) {
        if (params == null) {
            params = new RelativeLayout.LayoutParams(-2, -2);
        }
        return params;
    }

    private void initView() {
        this.initSuperTextView();
        this.initLeftIcon();
        this.initExtraView();
        this.initRightIcon();
        this.initLeftTextView();
        this.initCenterTextView();
        this.initRightTextView();
        this.initDividerLineView();
    }

    private void initSuperTextView() {
        if (this.mUseRipple) {
            this.setBackgroundResource(R.drawable.stv_btn_selector_white);
            this.setClickable(true);
        }
        if (this.mBackgroundDrawable != null) {
            this.setBackgroundDrawable(this.mBackgroundDrawable);
        }
        if (this.mUseShape) {
            if (Build.VERSION.SDK_INT < 16) {
                this.setBackgroundDrawable((Drawable)this.getSelector());
            } else {
                this.setBackground((Drawable)this.getSelector());
            }
        }
    }

    private void initLeftIcon() {
        if (this.mLeftIconIV == null) {
            this.mLeftIconIV = new AppCompatImageView(this.mContext);
        }
        this.mLeftImgParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mLeftImgParams.addRule(20, -1);
        this.mLeftImgParams.addRule(15, -1);
        if (this.mLeftIconHeight != 0 && this.mLeftIconWidth != 0) {
            this.mLeftImgParams.width = this.mLeftIconWidth;
            this.mLeftImgParams.height = this.mLeftIconHeight;
        }
        this.mLeftIconIV.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mLeftIconIV.setId(R.id.sLeftImgId);
        this.mLeftIconIV.setLayoutParams((ViewGroup.LayoutParams)this.mLeftImgParams);
        this.mLeftIconIV.setPadding(this.mLeftIconPadding, this.mLeftIconPadding, this.mLeftIconPadding, this.mLeftIconPadding);
        if (this.mLeftIconRes != null) {
            this.mLeftImgParams.setMargins(this.mLeftIconMarginLeft, 0, 0, 0);
            this.mLeftImgParams.setMarginStart(this.mLeftIconMarginLeft);
            this.mLeftIconIV.setImageDrawable(this.mLeftIconRes);
        }
        if (this.mLeftIconTint != null && Build.VERSION.SDK_INT >= 21) {
            this.mLeftIconIV.setImageTintList(this.mLeftIconTint);
        }
        this.addView((View)this.mLeftIconIV);
    }

    private void initRightIcon() {
        if (this.mRightIconIV == null) {
            this.mRightIconIV = new AppCompatImageView(this.mContext);
        }
        this.mRightImgParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mRightImgParams.addRule(15, -1);
        switch (this.mRightViewType) {
            case 0: {
                this.mRightImgParams.addRule(16, R.id.sRightCheckBoxId);
                break;
            }
            case 1: {
                this.mRightImgParams.addRule(16, R.id.sRightSwitchId);
                break;
            }
            default: {
                this.mRightImgParams.addRule(21, -1);
            }
        }
        if (this.mRightIconHeight != 0 && this.mRightIconWidth != 0) {
            this.mRightImgParams.width = this.mRightIconWidth;
            this.mRightImgParams.height = this.mRightIconHeight;
        }
        this.mRightIconIV.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mRightIconIV.setId(R.id.sRightImgId);
        this.mRightIconIV.setLayoutParams((ViewGroup.LayoutParams)this.mRightImgParams);
        this.mRightIconIV.setPadding(this.mRightIconPadding, this.mRightIconPadding, this.mRightIconPadding, this.mRightIconPadding);
        if (this.mRightIconRes != null) {
            this.mRightImgParams.setMargins(0, 0, this.mRightIconMarginRight, 0);
            this.mRightImgParams.setMarginEnd(this.mRightIconMarginRight);
            this.mRightIconIV.setImageDrawable(this.mRightIconRes);
        }
        if (this.mRightIconTint != null && Build.VERSION.SDK_INT >= 21) {
            this.mRightIconIV.setImageTintList(this.mRightIconTint);
        }
        this.addView((View)this.mRightIconIV);
    }

    private void initLeftTextView() {
        if (this.mLeftView == null) {
            this.mLeftView = this.initBaseView(R.id.sLeftViewId);
        }
        this.mLeftBaseViewParams = this.getParams(this.mLeftBaseViewParams);
        this.mLeftBaseViewParams.addRule(17, R.id.sLeftImgId);
        this.mLeftBaseViewParams.addRule(15, -1);
        if (this.mLeftViewWidth != 0) {
            this.mLeftBaseViewParams.width = this.mLeftViewWidth;
        }
        this.mLeftBaseViewParams.setMargins(this.mLeftViewMarginLeft, 0, this.mLeftViewMarginRight, 0);
        this.mLeftView.setLayoutParams((ViewGroup.LayoutParams)this.mLeftBaseViewParams);
        this.mLeftView.setCenterSpaceHeight(this.mCenterSpaceHeight);
        this.setDefaultColor(this.mLeftView, this.mLeftTopTextColor, this.mLeftTextColor, this.mLeftBottomTextColor);
        this.setDefaultSize(this.mLeftView, this.mLeftTopTextSize, this.mLeftTextSize, this.mLeftBottomTextSize);
        this.setDefaultLines(this.mLeftView, this.mLeftTopLines, this.mLeftLines, this.mLeftBottomLines);
        this.setDefaultMaxEms(this.mLeftView, this.mLeftTopMaxEms, this.mLeftMaxEms, this.mLeftBottomMaxEms);
        this.setDefaultTextIsBold(this.mLeftView, this.mLeftTopTextBold, this.mLeftTextBold, this.mLeftBottomTextBold);
        this.setDefaultGravity(this.mLeftView, this.mLeftGravity);
        this.setDefaultDrawable(this.mLeftView.getCenterTextView(), this.mLeftTvDrawableLeft, this.mLeftTvDrawableRight, this.mTextViewDrawablePadding, this.mLeftTvDrawableWidth, this.mLeftTvDrawableHeight);
        this.setDefaultBackground(this.mLeftView.getCenterTextView(), this.mLeftTextBackground);
        this.setDefaultString(this.mLeftView, this.mLeftTopTextString, this.mLeftTextString, this.mLeftBottomTextString);
        this.addView((View)this.mLeftView);
    }

    private void initCenterTextView() {
        if (this.mEnableEdit) {
            if (this.mCenterEditText == null) {
                if (this.mEditTextButtonType == 0) {
                    this.mCenterEditText = new AppCompatEditText(this.mContext);
                } else if (this.mEditTextButtonType == 1) {
                    this.mCenterEditText = new ClearEditText(this.mContext);
                } else if (this.mEditTextButtonType == 2) {
                    this.mCenterEditText = new PasswordEditText(this.mContext);
                    ((PasswordEditText)this.mCenterEditText).setIsAsteriskStyle(this.mIsAsteriskStyle);
                }
            }
            RelativeLayout.LayoutParams mCenterEditTextParams = new RelativeLayout.LayoutParams(this.mEditTextWidth, -2);
            mCenterEditTextParams.addRule(13, -1);
            mCenterEditTextParams.addRule(15, -1);
            if (this.mCenterGravity != 1) {
                mCenterEditTextParams.addRule(17, R.id.sLeftViewId);
                mCenterEditTextParams.addRule(16, R.id.sRightViewId);
            }
            mCenterEditTextParams.setMargins(this.mCenterViewMarginLeft, 0, this.mCenterViewMarginRight, 0);
            mCenterEditTextParams.setMarginStart(this.mCenterViewMarginLeft);
            mCenterEditTextParams.setMarginEnd(this.mCenterViewMarginRight);
            this.mCenterEditText.setId(R.id.sCenterEditTextId);
            this.mCenterEditText.setLayoutParams((ViewGroup.LayoutParams)mCenterEditTextParams);
            if (this.mEditBackground != null) {
                this.mCenterEditText.setBackground(this.mEditBackground);
            } else {
                this.mCenterEditText.setBackgroundColor(ResUtils.getColor(this.getContext(), R.color.xui_config_color_transparent));
            }
            this.mCenterEditText.setTextColor(this.mCenterTextColor);
            this.mCenterEditText.setTextSize(0, (float)this.mCenterTextSize);
            this.mCenterEditText.setMaxLines(this.mCenterLines);
            this.mCenterEditText.setText((CharSequence)this.mEditTextString);
            this.mCenterEditText.setHint((CharSequence)this.mEditTextHint);
            if (this.mEditTextInputType != -1) {
                this.mCenterEditText.setInputType(this.mEditTextInputType);
            }
            this.addView((View)this.mCenterEditText);
        } else {
            if (this.mCenterView == null) {
                this.mCenterView = this.initBaseView(R.id.sCenterViewId);
            }
            this.mCenterBaseViewParams = this.getParams(this.mCenterBaseViewParams);
            this.mCenterBaseViewParams.addRule(13, -1);
            this.mCenterBaseViewParams.addRule(15, -1);
            if (this.mCenterGravity != 1) {
                this.mCenterBaseViewParams.addRule(17, R.id.sLeftViewId);
                this.mCenterBaseViewParams.addRule(16, R.id.sRightViewId);
            }
            this.mCenterBaseViewParams.setMargins(this.mCenterViewMarginLeft, 0, this.mCenterViewMarginRight, 0);
            this.mCenterBaseViewParams.setMarginStart(this.mCenterViewMarginLeft);
            this.mCenterBaseViewParams.setMarginEnd(this.mCenterViewMarginRight);
            this.mCenterView.setLayoutParams((ViewGroup.LayoutParams)this.mCenterBaseViewParams);
            this.mCenterView.setCenterSpaceHeight(this.mCenterSpaceHeight);
            this.setDefaultColor(this.mCenterView, this.mCenterTopTextColor, this.mCenterTextColor, this.mCenterBottomTextColor);
            this.setDefaultSize(this.mCenterView, this.mCenterTopTextSize, this.mCenterTextSize, this.mCenterBottomTextSize);
            this.setDefaultLines(this.mCenterView, this.mCenterTopLines, this.mCenterLines, this.mCenterBottomLines);
            this.setDefaultMaxEms(this.mCenterView, this.mCenterTopMaxEms, this.mCenterMaxEms, this.mCenterBottomMaxEms);
            this.setDefaultTextIsBold(this.mCenterView, this.mCenterTopTextBold, this.mCenterTextBold, this.mCenterBottomTextBold);
            this.setDefaultGravity(this.mCenterView, this.mCenterGravity);
            this.setDefaultDrawable(this.mCenterView.getCenterTextView(), this.mCenterTvDrawableLeft, this.mCenterTvDrawableRight, this.mTextViewDrawablePadding, this.mCenterTvDrawableWidth, this.mCenterTvDrawableHeight);
            this.setDefaultBackground(this.mCenterView.getCenterTextView(), this.mCenterTextBackground);
            this.setDefaultString(this.mCenterView, this.mCenterTopTextString, this.mCenterTextString, this.mCenterBottomTextString);
            this.addView((View)this.mCenterView);
        }
    }

    private void initRightTextView() {
        if (this.mRightView == null) {
            this.mRightView = this.initBaseView(R.id.sRightViewId);
        }
        this.mRightBaseViewParams = this.getParams(this.mRightBaseViewParams);
        this.mRightBaseViewParams.addRule(15, -1);
        this.mRightBaseViewParams.addRule(16, R.id.sRightImgId);
        this.mRightBaseViewParams.setMargins(this.mRightViewMarginLeft, 0, this.mRightViewMarginRight, 0);
        this.mRightBaseViewParams.setMarginStart(this.mRightViewMarginLeft);
        this.mRightBaseViewParams.setMarginEnd(this.mRightViewMarginRight);
        this.mRightView.setLayoutParams((ViewGroup.LayoutParams)this.mRightBaseViewParams);
        this.mRightView.setCenterSpaceHeight(this.mCenterSpaceHeight);
        this.setDefaultColor(this.mRightView, this.mRightTopTextColor, this.mRightTextColor, this.mRightBottomTextColor);
        this.setDefaultSize(this.mRightView, this.mRightTopTextSize, this.mRightTextSize, this.mRightBottomTextSize);
        this.setDefaultLines(this.mRightView, this.mRightTopLines, this.mRightLines, this.mRightBottomLines);
        this.setDefaultMaxEms(this.mRightView, this.mRightTopMaxEms, this.mRightMaxEms, this.mRightBottomMaxEms);
        this.setDefaultTextIsBold(this.mRightView, this.mRightTopTextBold, this.mRightTextBold, this.mRightBottomTextBold);
        this.setDefaultGravity(this.mRightView, this.mRightGravity);
        this.setDefaultDrawable(this.mRightView.getCenterTextView(), this.mRightTvDrawableLeft, this.mRightTvDrawableRight, this.mTextViewDrawablePadding, this.mRightTvDrawableWidth, this.mRightTvDrawableHeight);
        this.setDefaultBackground(this.mRightView.getCenterTextView(), this.mRightTextBackground);
        this.setDefaultString(this.mRightView, this.mRightTopTextString, this.mRightTextString, this.mRightBottomTextString);
        this.addView((View)this.mRightView);
    }

    private void initExtraView() {
        switch (this.mRightViewType) {
            case 0: {
                this.initRightCheckBox();
                break;
            }
            case 1: {
                this.initRightSwitch();
                break;
            }
        }
    }

    private void initRightCheckBox() {
        if (this.mRightCheckBox == null) {
            this.mRightCheckBox = new CheckBox(this.mContext);
        }
        RelativeLayout.LayoutParams mRightCheckBoxParams = new RelativeLayout.LayoutParams(-2, -2);
        mRightCheckBoxParams.addRule(21, -1);
        mRightCheckBoxParams.addRule(15, -1);
        mRightCheckBoxParams.setMargins(0, 0, this.mRightCheckBoxMarginRight, 0);
        mRightCheckBoxParams.setMarginEnd(this.mRightCheckBoxMarginRight);
        this.mRightCheckBox.setId(R.id.sRightCheckBoxId);
        this.mRightCheckBox.setLayoutParams((ViewGroup.LayoutParams)mRightCheckBoxParams);
        if (this.mRightCheckBoxBg != null) {
            this.mRightCheckBox.setGravity(13);
            this.mRightCheckBox.setButtonDrawable(this.mRightCheckBoxBg);
        }
        this.mRightCheckBox.setChecked(this.mIsChecked);
        this.mRightCheckBox.setOnCheckedChangeListener(this.mCheckBoxCheckedChangeListener);
        this.addView((View)this.mRightCheckBox);
    }

    private void initRightSwitch() {
        if (this.mRightSwitch == null) {
            this.mRightSwitch = new Switch(this.mContext);
        }
        RelativeLayout.LayoutParams mRightSwitchParams = new RelativeLayout.LayoutParams(-2, -2);
        mRightSwitchParams.addRule(21, -1);
        mRightSwitchParams.addRule(15, -1);
        mRightSwitchParams.setMargins(0, 0, this.mRightSwitchMarginRight, 0);
        mRightSwitchParams.setMarginEnd(this.mRightSwitchMarginRight);
        this.mRightSwitch.setId(R.id.sRightSwitchId);
        this.mRightSwitch.setLayoutParams((ViewGroup.LayoutParams)mRightSwitchParams);
        this.mRightSwitch.setChecked(this.mSwitchIsChecked);
        if (!TextUtils.isEmpty((CharSequence)this.mSwitchTextOff)) {
            this.mRightSwitch.setTextOff((CharSequence)this.mSwitchTextOff);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSwitchTextOn)) {
            this.mRightSwitch.setTextOn((CharSequence)this.mSwitchTextOn);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            if (this.mSwitchMinWidth != 0) {
                this.mRightSwitch.setSwitchMinWidth(this.mSwitchMinWidth);
            }
            if (this.mSwitchPadding != 0) {
                this.mRightSwitch.setSwitchPadding(this.mSwitchPadding);
            }
            if (this.mSwitchThumbResource != null) {
                this.mRightSwitch.setThumbDrawable(this.mSwitchThumbResource);
            }
            if (this.mSwitchThumbResource != null) {
                this.mRightSwitch.setTrackDrawable(this.mSwitchTrackResource);
            }
            if (this.mThumbTextPadding != 0) {
                this.mRightSwitch.setThumbTextPadding(this.mThumbTextPadding);
            }
        }
        this.mRightSwitch.setOnCheckedChangeListener(this.mSwitchCheckedChangeListener);
        this.addView((View)this.mRightSwitch);
    }

    private BaseTextView initBaseView(int id2) {
        BaseTextView baseTextView = new BaseTextView(this.mContext);
        baseTextView.setId(id2);
        return baseTextView;
    }

    private void setDefaultString(BaseTextView baseTextView, String topTextString, String leftTextString, String bottomTextString) {
        if (baseTextView != null) {
            baseTextView.setTopTextString(topTextString);
            baseTextView.setCenterTextString(leftTextString);
            baseTextView.setBottomTextString(bottomTextString);
        }
    }

    private void setDefaultColor(BaseTextView baseTextView, int topTextColor, int textColor, int bottomTextColor) {
        if (baseTextView != null) {
            baseTextView.getTopTextView().setTextColor(topTextColor);
            baseTextView.getCenterTextView().setTextColor(textColor);
            baseTextView.getBottomTextView().setTextColor(bottomTextColor);
        }
    }

    private void setDefaultSize(BaseTextView baseTextView, int topTextSize, int leftTextSize, int bottomTextSize) {
        if (baseTextView != null) {
            baseTextView.getTopTextView().setTextSize(0, (float)topTextSize);
            baseTextView.getCenterTextView().setTextSize(0, (float)leftTextSize);
            baseTextView.getBottomTextView().setTextSize(0, (float)bottomTextSize);
        }
    }

    private void setDefaultMaxEms(BaseTextView baseTextView, int topMaxEms, int centerMaxEms, int bottomMaxEms) {
        if (baseTextView != null) {
            baseTextView.setMaxEms(topMaxEms, centerMaxEms, bottomMaxEms);
        }
    }

    private void setDefaultLines(BaseTextView baseTextView, int leftTopLines, int leftLines, int bottomLines) {
        if (baseTextView != null) {
            baseTextView.getTopTextView().setMaxLines(leftTopLines);
            baseTextView.getCenterTextView().setMaxLines(leftLines);
            baseTextView.getBottomTextView().setMaxLines(bottomLines);
        }
    }

    private void setDefaultGravity(BaseTextView baseTextView, int gravity) {
        if (baseTextView != null) {
            this.setGravity(baseTextView, gravity);
        }
    }

    private void setGravity(BaseTextView baseTextView, int gravity) {
        switch (gravity) {
            case 0: {
                baseTextView.setGravity(8388627);
                break;
            }
            case 1: {
                baseTextView.setGravity(17);
                break;
            }
            case 2: {
                baseTextView.setGravity(8388629);
                break;
            }
        }
    }

    public void setDefaultDrawable(TextView textView, Drawable drawableLeft, Drawable drawableRight, int drawablePadding, int drawableWidth, int drawableHeight) {
        if (drawableLeft != null || drawableRight != null) {
            textView.setVisibility(0);
        }
        if (drawableWidth != -1 && drawableHeight != -1) {
            if (drawableLeft != null) {
                drawableLeft.setBounds(0, 0, drawableWidth, drawableHeight);
            }
            if (drawableRight != null) {
                drawableRight.setBounds(0, 0, drawableWidth, drawableHeight);
            }
            textView.setCompoundDrawables(drawableLeft, null, drawableRight, null);
        } else {
            textView.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, null, drawableRight, null);
        }
        textView.setCompoundDrawablePadding(drawablePadding);
    }

    private void setDefaultBackground(TextView textView, Drawable background) {
        if (background != null) {
            textView.setVisibility(0);
            if (Build.VERSION.SDK_INT < 16) {
                textView.setBackgroundDrawable(background);
            } else {
                textView.setBackground(background);
            }
        }
    }

    private void initDividerLineView() {
        if (!this.mUseShape) {
            switch (this.mDividerLineType) {
                case 0: {
                    break;
                }
                case 1: {
                    this.setTopDividerLineView();
                    break;
                }
                case 2: {
                    this.setBottomDividerLineView();
                    break;
                }
                case 3: {
                    this.setTopDividerLineView();
                    this.setBottomDividerLineView();
                    break;
                }
            }
        }
    }

    private void setTopDividerLineView() {
        if (this.mTopDividerLineMarginLR != 0) {
            this.initTopDividerLineView(this.mTopDividerLineMarginLR, this.mTopDividerLineMarginLR);
        } else {
            this.initTopDividerLineView(this.mTopDividerLineMarginLeft, this.mTopDividerLineMarginRight);
        }
    }

    private void setBottomDividerLineView() {
        if (this.mBottomDividerLineMarginLR != 0) {
            this.initBottomDividerLineView(this.mBottomDividerLineMarginLR, this.mBottomDividerLineMarginLR);
        } else {
            this.initBottomDividerLineView(this.mBottomDividerLineMarginLeft, this.mBottomDividerLineMarginRight);
        }
    }

    private void initTopDividerLineView(int marginStart, int marginEnd) {
        if (this.mTopDividerLineView == null) {
            if (this.mTopDividerLineParams == null) {
                this.mTopDividerLineParams = new RelativeLayout.LayoutParams(-1, this.mDividerLineHeight);
            }
            this.mTopDividerLineParams.addRule(10, -1);
            this.mTopDividerLineParams.setMarginStart(marginStart);
            this.mTopDividerLineParams.setMarginEnd(marginEnd);
            this.mTopDividerLineView = new View(this.mContext);
            this.mTopDividerLineView.setLayoutParams((ViewGroup.LayoutParams)this.mTopDividerLineParams);
            this.mTopDividerLineView.setBackgroundColor(this.mDividerLineColor);
        }
        this.addView(this.mTopDividerLineView);
    }

    private void initBottomDividerLineView(int marginStart, int marginEnd) {
        if (this.mBottomDividerLineView == null) {
            if (this.mBottomDividerLineParams == null) {
                this.mBottomDividerLineParams = new RelativeLayout.LayoutParams(-1, this.mDividerLineHeight);
            }
            this.mBottomDividerLineParams.addRule(12, -1);
            this.mBottomDividerLineParams.setMarginStart(marginStart);
            this.mBottomDividerLineParams.setMarginEnd(marginEnd);
            this.mBottomDividerLineView = new View(this.mContext);
            this.mBottomDividerLineView.setLayoutParams((ViewGroup.LayoutParams)this.mBottomDividerLineParams);
            this.mBottomDividerLineView.setBackgroundColor(this.mDividerLineColor);
        }
        this.addView(this.mBottomDividerLineView);
    }

    private void setDefaultLeftViewClickListener(final BaseTextView baseTextView) {
        if (baseTextView != null) {
            if (this.mLeftTopTvClickListener != null) {
                baseTextView.getTopTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.mLeftTopTvClickListener.onClick(baseTextView.getTopTextView());
                    }
                });
            }
            if (this.mLeftTvClickListener != null) {
                baseTextView.getCenterTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.mLeftTvClickListener.onClick(baseTextView.getCenterTextView());
                    }
                });
            }
            if (this.mLeftBottomTvClickListener != null) {
                baseTextView.getBottomTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.mLeftBottomTvClickListener.onClick(baseTextView.getBottomTextView());
                    }
                });
            }
        }
    }

    private void setDefaultCenterViewClickListener(final BaseTextView baseTextView) {
        if (baseTextView != null) {
            if (this.mCenterTopTvClickListener != null) {
                baseTextView.getTopTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.mCenterTopTvClickListener.onClick(baseTextView.getTopTextView());
                    }
                });
            }
            if (this.mCenterTvClickListener != null) {
                baseTextView.getCenterTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.mCenterTvClickListener.onClick(baseTextView.getCenterTextView());
                    }
                });
            }
            if (this.mCenterBottomTvClickListener != null) {
                baseTextView.getBottomTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.mCenterBottomTvClickListener.onClick(baseTextView.getBottomTextView());
                    }
                });
            }
        }
    }

    private void setDefaultRightViewClickListener(final BaseTextView baseTextView) {
        if (baseTextView != null) {
            if (this.mRightTopTvClickListener != null) {
                baseTextView.getTopTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.mRightTopTvClickListener.onClick(baseTextView.getTopTextView());
                    }
                });
            }
            if (this.mRightTvClickListener != null) {
                baseTextView.getCenterTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.mRightTvClickListener.onClick(baseTextView.getCenterTextView());
                    }
                });
            }
            if (this.mRightBottomTvClickListener != null) {
                baseTextView.getBottomTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.mRightBottomTvClickListener.onClick(baseTextView.getBottomTextView());
                    }
                });
            }
        }
    }

    private void setDefaultTextIsBold(BaseTextView baseTextView, boolean topTextBold, boolean centerTextBold, boolean bottomTextBold) {
        if (baseTextView != null) {
            baseTextView.getTopTextView().getPaint().setFakeBoldText(topTextBold);
            baseTextView.getCenterTextView().getPaint().setFakeBoldText(centerTextBold);
            baseTextView.getBottomTextView().getPaint().setFakeBoldText(bottomTextBold);
        }
    }

    public SuperTextView setLeftTopString(CharSequence string2) {
        if (this.mLeftView != null) {
            this.mLeftView.setTopTextString(string2);
        }
        return this;
    }

    public SuperTextView setLeftString(CharSequence string2) {
        if (this.mLeftView != null) {
            this.mLeftView.setCenterTextString(string2);
        }
        return this;
    }

    public SuperTextView setLeftBottomString(CharSequence string2) {
        if (this.mLeftView != null) {
            this.mLeftView.setBottomTextString(string2);
        }
        return this;
    }

    public SuperTextView setCenterTopString(CharSequence string2) {
        if (this.mCenterView != null) {
            this.mCenterView.setTopTextString(string2);
        }
        return this;
    }

    public SuperTextView setCenterString(CharSequence string2) {
        if (this.mCenterView != null) {
            this.mCenterView.setCenterTextString(string2);
        }
        return this;
    }

    public SuperTextView setCenterEditString(CharSequence string2) {
        if (this.mCenterEditText != null) {
            this.mCenterEditText.setText(string2);
        }
        return this;
    }

    public SuperTextView setCenterBottomString(CharSequence string2) {
        if (this.mCenterView != null) {
            this.mCenterView.setBottomTextString(string2);
        }
        return this;
    }

    public SuperTextView setRightTopString(CharSequence string2) {
        if (this.mRightView != null) {
            this.mRightView.setTopTextString(string2);
        }
        return this;
    }

    public SuperTextView setRightString(CharSequence string2) {
        if (this.mRightView != null) {
            this.mRightView.setCenterTextString(string2);
        }
        return this;
    }

    public SuperTextView setRightBottomString(CharSequence string2) {
        if (this.mRightView != null) {
            this.mRightView.setBottomTextString(string2);
        }
        return this;
    }

    public SuperTextView setLeftTopTextColor(int color2) {
        if (this.mLeftView != null) {
            this.mLeftView.getTopTextView().setTextColor(color2);
        }
        return this;
    }

    public SuperTextView setLeftTextColor(int color2) {
        if (this.mLeftView != null) {
            this.mLeftView.getCenterTextView().setTextColor(color2);
        }
        return this;
    }

    public SuperTextView setLeftBottomTextColor(int color2) {
        if (this.mLeftView != null) {
            this.mLeftView.getBottomTextView().setTextColor(color2);
        }
        return this;
    }

    public SuperTextView setCenterTopTextColor(int color2) {
        if (this.mCenterView != null) {
            this.mCenterView.getTopTextView().setTextColor(color2);
        }
        return this;
    }

    public SuperTextView setCenterTextColor(int color2) {
        if (this.mCenterView != null) {
            this.mCenterView.getCenterTextView().setTextColor(color2);
        }
        return this;
    }

    public SuperTextView setCenterBottomTextColor(int color2) {
        if (this.mCenterView != null) {
            this.mCenterView.getBottomTextView().setTextColor(color2);
        }
        return this;
    }

    public SuperTextView setRightTopTextColor(int color2) {
        if (this.mRightView != null) {
            this.mRightView.getTopTextView().setTextColor(color2);
        }
        return this;
    }

    public SuperTextView setRightTextColor(int color2) {
        if (this.mRightView != null) {
            this.mRightView.getCenterTextView().setTextColor(color2);
        }
        return this;
    }

    public SuperTextView setRightBottomTextColor(int color2) {
        if (this.mRightView != null) {
            this.mRightView.getBottomTextView().setTextColor(color2);
        }
        return this;
    }

    public String getLeftTopString() {
        return this.mLeftView != null ? this.mLeftView.getTopTextView().getText().toString().trim() : "";
    }

    public String getLeftString() {
        return this.mLeftView != null ? this.mLeftView.getCenterTextView().getText().toString().trim() : "";
    }

    public String getLeftBottomString() {
        return this.mLeftView != null ? this.mLeftView.getBottomTextView().getText().toString().trim() : "";
    }

    public String getCenterTopString() {
        return this.mCenterView != null ? this.mCenterView.getTopTextView().getText().toString().trim() : "";
    }

    public String getCenterString() {
        return this.mCenterView != null ? this.mCenterView.getCenterTextView().getText().toString().trim() : "";
    }

    public String getCenterBottomString() {
        return this.mCenterView != null ? this.mCenterView.getBottomTextView().getText().toString().trim() : "";
    }

    public String getRightTopString() {
        return this.mRightView != null ? this.mRightView.getTopTextView().getText().toString().trim() : "";
    }

    public String getRightString() {
        return this.mRightView != null ? this.mRightView.getCenterTextView().getText().toString().trim() : "";
    }

    public String getRightBottomString() {
        return this.mRightView != null ? this.mRightView.getBottomTextView().getText().toString().trim() : "";
    }

    public ImageView getLeftIconIV() {
        this.mLeftImgParams.setMargins(this.mLeftIconMarginLeft, 0, 0, 0);
        this.mLeftImgParams.setMarginStart(this.mLeftIconMarginLeft);
        return this.mLeftIconIV;
    }

    public ImageView getRightIconIV() {
        this.mRightImgParams.setMargins(0, 0, this.mRightIconMarginRight, 0);
        this.mLeftImgParams.setMarginEnd(this.mRightIconMarginRight);
        return this.mRightIconIV;
    }

    public SuperTextView setCheckBoxChecked(boolean isChecked) {
        this.setCheckBoxChecked(isChecked, true);
        return this;
    }

    public SuperTextView setCheckBoxChecked(boolean isChecked, boolean isSilent) {
        this.mIsChecked = isChecked;
        if (this.mRightCheckBox != null) {
            if (isSilent) {
                this.mRightCheckBox.setOnCheckedChangeListener(null);
                this.mRightCheckBox.setChecked(isChecked);
                this.mRightCheckBox.setOnCheckedChangeListener(this.mCheckBoxCheckedChangeListener);
            } else {
                this.mRightCheckBox.setChecked(isChecked);
            }
        }
        return this;
    }

    public SuperTextView setCheckBoxBackground(Drawable drawable2) {
        this.mRightCheckBoxBg = drawable2;
        if (this.mRightCheckBox != null) {
            this.mRightCheckBox.setBackgroundDrawable(drawable2);
        }
        return this;
    }

    public boolean getCheckBoxIsChecked() {
        boolean isChecked = false;
        if (this.mRightCheckBox != null) {
            isChecked = this.mRightCheckBox.isChecked();
        }
        return isChecked;
    }

    public SuperTextView setSwitchIsChecked(boolean isChecked) {
        this.setSwitchIsChecked(isChecked, true);
        return this;
    }

    public SuperTextView setSwitchIsChecked(boolean isChecked, boolean isSilent) {
        this.mSwitchIsChecked = isChecked;
        if (this.mRightSwitch != null) {
            if (isSilent) {
                this.mRightSwitch.setOnCheckedChangeListener(null);
                this.mRightSwitch.setChecked(isChecked);
                this.mRightSwitch.setOnCheckedChangeListener(this.mSwitchCheckedChangeListener);
            } else {
                this.mRightSwitch.setChecked(isChecked);
            }
        }
        return this;
    }

    public boolean getSwitchIsChecked() {
        boolean isChecked = false;
        if (this.mRightSwitch != null) {
            isChecked = this.mRightSwitch.isChecked();
        }
        return isChecked;
    }

    public SuperTextView setLeftTvDrawableLeft(Drawable drawableLeft) {
        this.setDefaultDrawable(this.mLeftView.getCenterTextView(), drawableLeft, null, this.mTextViewDrawablePadding, this.mLeftTvDrawableWidth, this.mLeftTvDrawableHeight);
        return this;
    }

    public SuperTextView setLeftTvDrawableRight(Drawable drawableRight) {
        this.setDefaultDrawable(this.mLeftView.getCenterTextView(), null, drawableRight, this.mTextViewDrawablePadding, this.mLeftTvDrawableWidth, this.mLeftTvDrawableHeight);
        return this;
    }

    public SuperTextView setCenterTvDrawableLeft(Drawable drawableLeft) {
        this.setDefaultDrawable(this.mCenterView.getCenterTextView(), drawableLeft, null, this.mTextViewDrawablePadding, this.mCenterTvDrawableWidth, this.mCenterTvDrawableHeight);
        return this;
    }

    public SuperTextView setCenterTvDrawableRight(Drawable drawableRight) {
        this.setDefaultDrawable(this.mCenterView.getCenterTextView(), null, drawableRight, this.mTextViewDrawablePadding, this.mCenterTvDrawableWidth, this.mCenterTvDrawableHeight);
        return this;
    }

    public SuperTextView setRightTvDrawableLeft(Drawable drawableLeft) {
        this.setDefaultDrawable(this.mRightView.getCenterTextView(), drawableLeft, null, this.mTextViewDrawablePadding, this.mRightTvDrawableWidth, this.mRightTvDrawableHeight);
        return this;
    }

    public SuperTextView setRightTvDrawableRight(Drawable drawableRight) {
        this.setDefaultDrawable(this.mRightView.getCenterTextView(), null, drawableRight, this.mTextViewDrawablePadding, this.mRightTvDrawableWidth, this.mRightTvDrawableHeight);
        return this;
    }

    public SuperTextView setLeftIcon(Drawable leftIcon) {
        if (this.mLeftIconIV != null) {
            this.mLeftImgParams.setMargins(this.mLeftIconMarginLeft, 0, 0, 0);
            this.mLeftImgParams.setMarginStart(this.mLeftIconMarginLeft);
            this.mLeftIconIV.setImageDrawable(leftIcon);
        }
        return this;
    }

    public SuperTextView setLeftIcon(int resId) {
        if (this.mLeftIconIV != null) {
            this.mLeftImgParams.setMargins(this.mLeftIconMarginLeft, 0, 0, 0);
            this.mLeftImgParams.setMarginStart(this.mLeftIconMarginLeft);
            this.mLeftIconIV.setImageResource(resId);
        }
        return this;
    }

    public SuperTextView setRightIcon(Drawable rightIcon) {
        if (this.mRightIconIV != null) {
            this.mRightImgParams.setMargins(0, 0, this.mRightIconMarginRight, 0);
            this.mRightImgParams.setMarginEnd(this.mRightIconMarginRight);
            this.mRightIconIV.setImageDrawable(rightIcon);
        }
        return this;
    }

    public SuperTextView setRightIcon(int resId) {
        if (this.mRightIconIV != null) {
            this.mRightImgParams.setMargins(0, 0, this.mRightIconMarginRight, 0);
            this.mRightImgParams.setMarginEnd(this.mRightIconMarginRight);
            this.mRightIconIV.setImageResource(resId);
        }
        return this;
    }

    public SuperTextView setSBackground(Drawable drawable2) {
        if (drawable2 != null) {
            this.setBackgroundDrawable(drawable2);
        }
        return this;
    }

    public TextView getLeftTopTextView() {
        TextView textView = null;
        if (this.mLeftView != null) {
            textView = this.mLeftView.getTopTextView();
        }
        return textView;
    }

    public TextView getLeftTextView() {
        TextView textView = null;
        if (this.mLeftView != null) {
            textView = this.mLeftView.getCenterTextView();
        }
        return textView;
    }

    public TextView getLeftBottomTextView() {
        TextView textView = null;
        if (this.mLeftView != null) {
            textView = this.mLeftView.getBottomTextView();
        }
        return textView;
    }

    public TextView getCenterTopTextView() {
        TextView textView = null;
        if (this.mCenterView != null) {
            textView = this.mCenterView.getTopTextView();
        }
        return textView;
    }

    public TextView getCenterTextView() {
        TextView textView = null;
        if (this.mCenterView != null) {
            textView = this.mCenterView.getCenterTextView();
        }
        return textView;
    }

    @Nullable
    public EditText getCenterEditText() {
        return this.mCenterEditText;
    }

    public String getCenterEditValue() {
        if (this.mCenterEditText != null) {
            return this.mCenterEditText.getText().toString();
        }
        return "";
    }

    public SuperTextView setPasswordTransformationMethod(PasswordTransformationMethod transformationMethod) {
        if (this.mCenterEditText != null && this.mCenterEditText instanceof PasswordEditText) {
            ((PasswordEditText)this.mCenterEditText).setPasswordTransformationMethod(transformationMethod);
        }
        return this;
    }

    public boolean isEditEmpty() {
        if (this.mCenterEditText != null) {
            return TextUtils.isEmpty((CharSequence)this.mCenterEditText.getText().toString());
        }
        return true;
    }

    public boolean isEditNotEmpty() {
        if (this.mCenterEditText != null) {
            return !TextUtils.isEmpty((CharSequence)this.mCenterEditText.getText().toString());
        }
        return false;
    }

    public TextView getCenterBottomTextView() {
        TextView textView = null;
        if (this.mCenterView != null) {
            textView = this.mCenterView.getBottomTextView();
        }
        return textView;
    }

    public TextView getRightTopTextView() {
        TextView textView = null;
        if (this.mRightView != null) {
            textView = this.mRightView.getTopTextView();
        }
        return textView;
    }

    public TextView getRightTextView() {
        TextView textView = null;
        if (this.mRightView != null) {
            textView = this.mRightView.getCenterTextView();
        }
        return textView;
    }

    public TextView getRightBottomTextView() {
        TextView textView = null;
        if (this.mRightView != null) {
            textView = this.mRightView.getBottomTextView();
        }
        return textView;
    }

    public SuperTextView setLeftTextGravity(int gravity) {
        this.setTextGravity(this.mLeftView, gravity);
        return this;
    }

    public SuperTextView setCenterTextGravity(int gravity) {
        this.setTextGravity(this.mCenterView, gravity);
        return this;
    }

    public SuperTextView setRightTextGravity(int gravity) {
        this.setTextGravity(this.mRightView, gravity);
        return this;
    }

    private void setTextGravity(BaseTextView baseTextView, int gravity) {
        if (baseTextView != null) {
            baseTextView.getCenterTextView().setGravity(gravity);
        }
    }

    public SuperTextView setTopDividerLineVisibility(int visibility) {
        if (this.mTopDividerLineView == null) {
            this.setTopDividerLineView();
        }
        this.mTopDividerLineView.setVisibility(visibility);
        return this;
    }

    public SuperTextView setBottomDividerLineVisibility(int visibility) {
        if (this.mBottomDividerLineView == null) {
            this.setBottomDividerLineView();
        }
        this.mBottomDividerLineView.setVisibility(visibility);
        return this;
    }

    public SuperTextView setOnSuperTextViewClickListener(OnSuperTextViewClickListener onSuperTextViewClickListener) {
        this.mSuperTextViewClickListener = onSuperTextViewClickListener;
        if (this.mSuperTextViewClickListener != null) {
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SuperTextView.this.mSuperTextViewClickListener.onClick(SuperTextView.this);
                }
            });
        }
        return this;
    }

    public SuperTextView setLeftTopTvClickListener(OnLeftTopTvClickListener leftTopTvClickListener) {
        this.mLeftTopTvClickListener = leftTopTvClickListener;
        this.setDefaultLeftViewClickListener(this.mLeftView);
        return this;
    }

    public SuperTextView setLeftTvClickListener(OnLeftTvClickListener leftTvClickListener) {
        this.mLeftTvClickListener = leftTvClickListener;
        this.setDefaultLeftViewClickListener(this.mLeftView);
        return this;
    }

    public SuperTextView setLeftBottomTvClickListener(OnLeftBottomTvClickListener leftBottomTvClickListener) {
        this.mLeftBottomTvClickListener = leftBottomTvClickListener;
        this.setDefaultLeftViewClickListener(this.mLeftView);
        return this;
    }

    public SuperTextView setCenterTopTvClickListener(OnCenterTopTvClickListener centerTopTvClickListener) {
        this.mCenterTopTvClickListener = centerTopTvClickListener;
        this.setDefaultCenterViewClickListener(this.mCenterView);
        return this;
    }

    public SuperTextView setCenterEditTextClickListener(View.OnClickListener clickListener) {
        if (this.mCenterEditText != null) {
            this.mCenterEditText.setOnClickListener(clickListener);
        }
        return this;
    }

    public SuperTextView setCenterEditTextFocusChangeListener(View.OnFocusChangeListener focusChangeListener) {
        if (this.mCenterEditText != null && this.mEditTextButtonType == 0) {
            this.mCenterEditText.setOnFocusChangeListener(focusChangeListener);
        }
        return this;
    }

    public SuperTextView setCenterTvClickListener(OnCenterTvClickListener centerTvClickListener) {
        this.mCenterTvClickListener = centerTvClickListener;
        this.setDefaultCenterViewClickListener(this.mCenterView);
        return this;
    }

    public SuperTextView setCenterBottomTvClickListener(OnCenterBottomTvClickListener centerBottomTvClickListener) {
        this.mCenterBottomTvClickListener = centerBottomTvClickListener;
        this.setDefaultCenterViewClickListener(this.mCenterView);
        return this;
    }

    public SuperTextView setRightTopTvClickListener(OnRightTopTvClickListener rightTopTvClickListener) {
        this.mRightTopTvClickListener = rightTopTvClickListener;
        this.setDefaultRightViewClickListener(this.mRightView);
        return this;
    }

    public SuperTextView setRightTvClickListener(OnRightTvClickListener rightTvClickListener) {
        this.mRightTvClickListener = rightTvClickListener;
        this.setDefaultRightViewClickListener(this.mRightView);
        return this;
    }

    public SuperTextView setRightBottomTvClickListener(OnRightBottomTvClickListener rightBottomTvClickListener) {
        this.mRightBottomTvClickListener = rightBottomTvClickListener;
        this.setDefaultRightViewClickListener(this.mRightView);
        return this;
    }

    public SuperTextView setLeftImageViewClickListener(OnLeftImageViewClickListener listener) {
        this.mLeftImageViewClickListener = listener;
        if (this.mLeftIconIV != null) {
            this.mLeftIconIV.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SuperTextView.this.mLeftImageViewClickListener.onClick(SuperTextView.this.mLeftIconIV);
                }
            });
        }
        return this;
    }

    public SuperTextView setRightImageViewClickListener(OnRightImageViewClickListener listener) {
        this.mRightImageViewClickListener = listener;
        if (this.mRightIconIV != null) {
            this.mRightIconIV.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SuperTextView.this.mRightImageViewClickListener.onClick(SuperTextView.this.mRightIconIV);
                }
            });
        }
        return this;
    }

    public SuperTextView setSwitchCheckedChangeListener(CompoundButton.OnCheckedChangeListener switchCheckedChangeListener) {
        this.mSwitchCheckedChangeListener = switchCheckedChangeListener;
        if (this.mRightSwitch != null) {
            this.mRightSwitch.setOnCheckedChangeListener(this.mSwitchCheckedChangeListener);
        }
        return this;
    }

    public SuperTextView setCheckBoxCheckedChangeListener(CompoundButton.OnCheckedChangeListener checkBoxCheckedChangeListener) {
        this.mCheckBoxCheckedChangeListener = checkBoxCheckedChangeListener;
        if (this.mRightCheckBox != null) {
            this.mRightCheckBox.setOnCheckedChangeListener(this.mCheckBoxCheckedChangeListener);
        }
        return this;
    }

    public void setTypeface(Typeface typeface) {
        if (this.mLeftView != null) {
            this.mLeftView.setTypeface(typeface);
        }
        if (this.mCenterView != null) {
            this.mCenterView.setTypeface(typeface);
        }
        if (this.mCenterEditText != null) {
            this.mCenterEditText.setTypeface(typeface);
        }
        if (this.mRightView != null) {
            this.mRightView.setTypeface(typeface);
        }
        if (this.mCenterView != null) {
            this.mCenterView.setTypeface(typeface);
        }
    }

    public StateListDrawable getSelector() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919, 16842910}, (Drawable)this.getDrawable(16842919));
        stateListDrawable.addState(new int[0], (Drawable)this.getDrawable(16842910));
        return stateListDrawable;
    }

    public GradientDrawable getDrawable(int state) {
        this.mGradientDrawable = new GradientDrawable();
        this.mGradientDrawable.setShape(0);
        switch (state) {
            case 16842919: {
                this.mGradientDrawable.setColor(this.mSelectorPressedColor);
                break;
            }
            case 16842910: {
                this.mGradientDrawable.setColor(this.mSelectorNormalColor);
                break;
            }
            default: {
                this.mGradientDrawable.setColor(this.mSolidColor);
            }
        }
        this.setBorder();
        this.setRadius();
        return this.mGradientDrawable;
    }

    private void setBorder() {
        this.mGradientDrawable.setStroke(this.mStrokeWidth, this.mStrokeColor, this.mStrokeDashWidth, this.mStrokeDashGap);
    }

    private void setRadius() {
        if (this.mCornersRadius != 0.0f) {
            this.mGradientDrawable.setCornerRadius(this.mCornersRadius);
        } else {
            this.mGradientDrawable.setCornerRadii(new float[]{this.mCornersTopLeftRadius, this.mCornersTopLeftRadius, this.mCornersTopRightRadius, this.mCornersTopRightRadius, this.mCornersBottomRightRadius, this.mCornersBottomRightRadius, this.mCornersBottomLeftRadius, this.mCornersBottomLeftRadius});
        }
    }

    public SuperTextView setShapeSelectorPressedColor(int color2) {
        this.mSelectorPressedColor = color2;
        return this;
    }

    public SuperTextView setShapeSelectorNormalColor(int color2) {
        this.mSelectorNormalColor = color2;
        return this;
    }

    public SuperTextView setShapeSolidColor(int color2) {
        this.mSolidColor = color2;
        return this;
    }

    public SuperTextView setShapeStrokeWidth(int strokeWidth) {
        this.mStrokeWidth = DensityUtils.dp2px(this.mContext, strokeWidth);
        return this;
    }

    public SuperTextView setShapeStrokeColor(int strokeColor) {
        this.mStrokeColor = strokeColor;
        return this;
    }

    public SuperTextView setShapeSrokeDashWidth(float strokeDashWidth) {
        this.mStrokeDashWidth = DensityUtils.dp2px(this.mContext, strokeDashWidth);
        return this;
    }

    public SuperTextView setShapeStrokeDashGap(float strokeDashGap) {
        this.mStrokeDashGap = DensityUtils.dp2px(this.mContext, strokeDashGap);
        return this;
    }

    public SuperTextView setShapeCornersRadius(float radius) {
        this.mCornersRadius = DensityUtils.dp2px(this.mContext, radius);
        return this;
    }

    public SuperTextView setShapeCornersTopLeftRadius(float radius) {
        this.mCornersTopLeftRadius = DensityUtils.dp2px(this.mContext, radius);
        return this;
    }

    public SuperTextView setShapeCornersTopRightRadius(float radius) {
        this.mCornersTopRightRadius = DensityUtils.dp2px(this.mContext, radius);
        return this;
    }

    public SuperTextView setShapeCornersBottomLeftRadius(float radius) {
        this.mCornersBottomLeftRadius = DensityUtils.dp2px(this.mContext, radius);
        return this;
    }

    public SuperTextView setShapeCornersBottomRightRadius(float radius) {
        this.mCornersBottomRightRadius = DensityUtils.dp2px(this.mContext, radius);
        return this;
    }

    public SuperTextView useShape() {
        if (Build.VERSION.SDK_INT < 16) {
            this.setBackgroundDrawable((Drawable)this.getSelector());
        } else {
            this.setBackground((Drawable)this.getSelector());
        }
        return this;
    }

    public static interface OnRightImageViewClickListener {
        public void onClick(ImageView var1);
    }

    public static interface OnLeftImageViewClickListener {
        public void onClick(ImageView var1);
    }

    public static interface OnRightBottomTvClickListener {
        public void onClick(TextView var1);
    }

    public static interface OnRightTvClickListener {
        public void onClick(TextView var1);
    }

    public static interface OnRightTopTvClickListener {
        public void onClick(TextView var1);
    }

    public static interface OnCenterBottomTvClickListener {
        public void onClick(TextView var1);
    }

    public static interface OnCenterTvClickListener {
        public void onClick(TextView var1);
    }

    public static interface OnCenterTopTvClickListener {
        public void onClick(TextView var1);
    }

    public static interface OnLeftBottomTvClickListener {
        public void onClick(TextView var1);
    }

    public static interface OnLeftTvClickListener {
        public void onClick(TextView var1);
    }

    public static interface OnLeftTopTvClickListener {
        public void onClick(TextView var1);
    }

    public static interface OnSuperTextViewClickListener {
        public void onClick(SuperTextView var1);
    }
}

