/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.supertextview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import io.github.inflationx.calligraphy3.HasTypeface;

public class CommonTextView
extends RelativeLayout
implements HasTypeface {
    private Context mContext;
    private int mDefaultTextColor;
    private int mDefaultTextSize;
    private int mDefaultPadding;
    private int mBackgroundColor = -1;
    private Drawable mLeft_drawableLeft;
    private Drawable mLeft_drawableTop;
    private Drawable mLeft_drawableRight;
    private Drawable mLeft_drawableBottom;
    private Drawable mCenter_drawableLeft;
    private Drawable mCenter_drawableTop;
    private Drawable mCenter_drawableRight;
    private Drawable mCenter_drawableBottom;
    private Drawable mRight_drawableLeft;
    private Drawable mRight_drawableTop;
    private Drawable mRight_drawableRight;
    private Drawable mRight_drawableBottom;
    private Drawable mLeft_IV_drawable;
    private CharSequence mLeftTextString;
    private CharSequence mLeftTopTextString;
    private CharSequence mLeftBottomTextString;
    private CharSequence mRightTextString;
    private CharSequence mRightTopTextString;
    private CharSequence mRightBottomTextString;
    private CharSequence mCenterTextString;
    private CharSequence mCenterTopTextString;
    private CharSequence mCenterBottomTextString;
    private int mLeftTextSize;
    private int mLeftTopTextSize;
    private int mLeftBottomTextSize;
    private int mRightTextSize;
    private int mRightTopTextSize;
    private int mRightBottomTextSize;
    private int mCenterTextSize;
    private int mCenterTopTextSize;
    private int mCenterBottomTextSize;
    private int mLeftTextColor;
    private int mLeftTopTextColor;
    private int mLeftBottomTextColor;
    private int mCenterTextColor;
    private int mCenterTopTextColor;
    private int mCenterBottomTextColor;
    private int mRightTextColor;
    private int mRightTopTextColor;
    private int mRightBottomTextColor;
    private int mLeftIconDrawablePadding;
    private int mCenterIconDrawablePadding;
    private int mRightIconDrawablePadding;
    private int mLeftViewPaddingLeft;
    private int mLeftViewPaddingRight;
    private int mCenterViewPaddingLeft;
    private int mCenterViewPaddingRight;
    private int mRightViewPaddingLeft;
    private int mRightViewPaddingRight;
    private int mTopDividerLineMarginLR;
    private int mTopDividerLineMarginLeft;
    private int mTopDividerLineMarginRight;
    private int mBottomDividerLineMarginLR;
    private int mBottomDividerLineMarginLeft;
    private int mBottomDividerLineMarginRight;
    private int mBothDividerLineMarginLeft;
    private int mBothDividerLineMarginRight;
    private int mCenterSpaceHeight;
    private int mLeftImageViewMarginLeft;
    private int mDividerLineType;
    private int mDividerLineColor;
    private int mDividerLineHeight;
    private int mLeftTextViewLineSpacingExtra;
    private int mCenterTextViewLineSpacingExtra;
    private int mRightTextViewLineSpacingExtra;
    private static final int NONE = 0;
    private static final int TOP = 1;
    private static final int BOTTOM = 2;
    private static final int BOTH = 3;
    private static final int DEFAULT = 2;
    private boolean mIsUseRipple;
    private boolean mSetSingleLine = true;
    private int mSetMaxEms = 10;
    private int mSetLines = 1;
    private static final int GRAVITY_LEFT_CENTER = 0;
    private static final int GRAVITY_CENTER = 1;
    private static final int GRAVITY_RIGHT_CENTER = 2;
    private static final int DEFAULT_GRAVITY = 1;
    private int mLeftTextViewGravity;
    private int mCenterTextViewGravity;
    private int mRightTextViewGravity;
    private TextView mLeftTextView;
    private TextView mCenterTextView;
    private TextView mRightTextView;
    private TextView mLeftTopTextView;
    private TextView mCenterTopTextView;
    private TextView mRightTopTextView;
    private TextView mLeftBottomTextView;
    private TextView mCenterBottomTextView;
    private TextView mRightBottomTextView;
    private ImageView mLeftImageView;
    private View mTopLineView;
    private View mBottomLineView;
    private View mCenterBaseLineView;
    private boolean mLeftViewIsClickable;
    private boolean mCenterViewIsClickable;
    private boolean mRightViewIsClickable;
    private RelativeLayout.LayoutParams mLeftTVParams;
    private RelativeLayout.LayoutParams mCenterTVParams;
    private RelativeLayout.LayoutParams mRightTVParams;
    private RelativeLayout.LayoutParams mTopLineParams;
    private RelativeLayout.LayoutParams mBottomLineParams;
    private RelativeLayout.LayoutParams mLeftTopTVParams;
    private RelativeLayout.LayoutParams mCenterTopTVParams;
    private RelativeLayout.LayoutParams mRightTopTVParams;
    private RelativeLayout.LayoutParams mLeftBottomTVParams;
    private RelativeLayout.LayoutParams mCenterBottomTVParams;
    private RelativeLayout.LayoutParams mRightBottomTVParams;
    private RelativeLayout.LayoutParams mCenterBaseLineParams;
    private OnCommonTextViewClickListener mOnCommonTextViewClickListener;
    private Drawable mBackground_drawable;
    private boolean mIsCenterAlignLeft;
    private int mCenterViewMarginLeft;

    public CommonTextView(Context context) {
        super(context);
        this.initAttrs(context, null);
    }

    public CommonTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public CommonTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        this.mContext = context;
        this.mDefaultTextColor = ThemeUtils.resolveColor(context, R.attr.stv_color_common_text, ResUtils.getColor(context, R.color.stv_color_common_text));
        this.mDefaultTextSize = ThemeUtils.resolveDimension(context, R.attr.stv_text_size, ResUtils.getDimensionPixelSize(context, R.dimen.default_stv_text_size));
        this.mDefaultPadding = ThemeUtils.resolveDimension(context, R.attr.stv_margin, ResUtils.getDimensionPixelSize(context, R.dimen.default_stv_margin));
        this.mCenterSpaceHeight = this.dip2px(context, 5.0f);
        this.getAttr(attrs);
        this.init();
    }

    private void getAttr(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.CommonTextView);
        this.mLeft_drawableLeft = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cLeftIconResForDrawableLeft);
        this.mLeft_drawableTop = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cLeftIconResForDrawableTop);
        this.mLeft_drawableRight = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cLeftIconResForDrawableRight);
        this.mLeft_drawableBottom = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cLeftIconResForDrawableBottom);
        this.mCenter_drawableLeft = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cCenterIconResForDrawableLeft);
        this.mCenter_drawableTop = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cCenterIconResForDrawableTop);
        this.mCenter_drawableRight = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cCenterIconResForDrawableRight);
        this.mCenter_drawableBottom = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cCenterIconResForDrawableBottom);
        this.mRight_drawableLeft = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cRightIconResForDrawableLeft);
        this.mRight_drawableTop = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cRightIconResForDrawableTop);
        this.mRight_drawableRight = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cRightIconResForDrawableRight);
        this.mRight_drawableBottom = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cRightIconResForDrawableBottom);
        this.mLeft_IV_drawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cLeftImageViewDrawableRes);
        this.mLeftTextString = typedArray.getString(R.styleable.CommonTextView_cLeftTextString);
        this.mLeftTopTextString = typedArray.getString(R.styleable.CommonTextView_cLeftTopTextString);
        this.mLeftBottomTextString = typedArray.getString(R.styleable.CommonTextView_cLeftBottomTextString);
        this.mCenterTextString = typedArray.getString(R.styleable.CommonTextView_cCenterTextString);
        this.mCenterTopTextString = typedArray.getString(R.styleable.CommonTextView_cCenterTopTextString);
        this.mCenterBottomTextString = typedArray.getString(R.styleable.CommonTextView_cCenterBottomTextString);
        this.mRightTextString = typedArray.getString(R.styleable.CommonTextView_cRightTextString);
        this.mRightTopTextString = typedArray.getString(R.styleable.CommonTextView_cRightTopTextString);
        this.mRightBottomTextString = typedArray.getString(R.styleable.CommonTextView_cRightBottomTextString);
        this.mLeftTextColor = typedArray.getColor(R.styleable.CommonTextView_cLeftTextColor, this.mDefaultTextColor);
        this.mLeftTopTextColor = typedArray.getColor(R.styleable.CommonTextView_cLeftTopTextColor, this.mDefaultTextColor);
        this.mLeftBottomTextColor = typedArray.getColor(R.styleable.CommonTextView_cLeftBottomTextColor, this.mDefaultTextColor);
        this.mCenterTextColor = typedArray.getColor(R.styleable.CommonTextView_cCenterTextColor, this.mDefaultTextColor);
        this.mCenterTopTextColor = typedArray.getColor(R.styleable.CommonTextView_cCenterTopTextColor, this.mDefaultTextColor);
        this.mCenterBottomTextColor = typedArray.getColor(R.styleable.CommonTextView_cCenterBottomTextColor, this.mDefaultTextColor);
        this.mRightTextColor = typedArray.getColor(R.styleable.CommonTextView_cRightTextColor, this.mDefaultTextColor);
        this.mRightTopTextColor = typedArray.getColor(R.styleable.CommonTextView_cRightTopTextColor, this.mDefaultTextColor);
        this.mRightBottomTextColor = typedArray.getColor(R.styleable.CommonTextView_cRightBottomTextColor, this.mDefaultTextColor);
        this.mLeftTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftTextSize, this.mDefaultTextSize);
        this.mLeftTopTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftTopTextSize, this.mDefaultTextSize);
        this.mLeftBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftBottomTextSize, this.mDefaultTextSize);
        this.mCenterTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterTextSize, this.mDefaultTextSize);
        this.mCenterTopTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterTopTextSize, this.mDefaultTextSize);
        this.mCenterBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterBottomTextSize, this.mDefaultTextSize);
        this.mRightTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightTextSize, this.mDefaultTextSize);
        this.mRightTopTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightTopTextSize, this.mDefaultTextSize);
        this.mRightBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightBottomTextSize, this.mDefaultTextSize);
        this.mLeftIconDrawablePadding = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftIconDrawablePadding, this.mDefaultPadding);
        this.mCenterIconDrawablePadding = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterIconDrawablePadding, this.mDefaultPadding);
        this.mRightIconDrawablePadding = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightIconDrawablePadding, this.mDefaultPadding);
        this.mLeftViewPaddingLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftViewPaddingLeft, this.mDefaultPadding);
        this.mLeftViewPaddingRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftViewPaddingRight, this.mDefaultPadding);
        this.mCenterViewPaddingLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterViewPaddingLeft, this.mDefaultPadding);
        this.mCenterViewPaddingRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterViewPaddingRight, this.mDefaultPadding);
        this.mRightViewPaddingLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightViewPaddingLeft, this.mDefaultPadding);
        this.mRightViewPaddingRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightViewPaddingRight, this.mDefaultPadding);
        this.mBothDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cBothDividerLineMarginLeft, 0);
        this.mBothDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cBothDividerLineMarginRight, 0);
        this.mTopDividerLineMarginLR = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cTopDividerLineMarginLR, 0);
        this.mTopDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cTopDividerLineMarginLeft, 0);
        this.mTopDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cTopDividerLineMarginRight, 0);
        this.mBottomDividerLineMarginLR = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cBottomDividerLineMarginLR, 0);
        this.mBottomDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cBottomDividerLineMarginLeft, 0);
        this.mBottomDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cBottomDividerLineMarginRight, 0);
        this.mLeftImageViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftImageViewMarginLeft, this.mDefaultPadding);
        this.mCenterSpaceHeight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterSpaceHeight, this.mCenterSpaceHeight);
        this.mLeftTextViewLineSpacingExtra = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftTextViewLineSpacingExtra, 0);
        this.mCenterTextViewLineSpacingExtra = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterTextViewLineSpacingExtra, 0);
        this.mRightTextViewLineSpacingExtra = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightTextViewLineSpacingExtra, 0);
        this.mDividerLineType = typedArray.getInt(R.styleable.CommonTextView_cShowDividerLineType, 2);
        this.mDividerLineColor = typedArray.getColor(R.styleable.CommonTextView_cDividerLineColor, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_separator_light));
        this.mDividerLineHeight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cDividerLineHeight, this.dip2px(this.mContext, 0.5f));
        this.mIsUseRipple = typedArray.getBoolean(R.styleable.CommonTextView_cUseRipple, false);
        this.mBackgroundColor = typedArray.getColor(R.styleable.CommonTextView_cBackgroundColor, this.mBackgroundColor);
        this.mSetSingleLine = typedArray.getBoolean(R.styleable.CommonTextView_cSetSingleLine, true);
        this.mSetMaxEms = typedArray.getInt(R.styleable.CommonTextView_cSetMaxEms, this.mSetMaxEms);
        this.mSetLines = typedArray.getInt(R.styleable.CommonTextView_cSetLines, 1);
        this.mLeftTextViewGravity = typedArray.getInt(R.styleable.CommonTextView_cLeftTextViewGravity, 1);
        this.mCenterTextViewGravity = typedArray.getInt(R.styleable.CommonTextView_cCenterTextViewGravity, 1);
        this.mRightTextViewGravity = typedArray.getInt(R.styleable.CommonTextView_cRightTextViewGravity, 1);
        this.mLeftViewIsClickable = typedArray.getBoolean(R.styleable.CommonTextView_cLeftViewIsClickable, false);
        this.mCenterViewIsClickable = typedArray.getBoolean(R.styleable.CommonTextView_cCenterViewIsClickable, false);
        this.mRightViewIsClickable = typedArray.getBoolean(R.styleable.CommonTextView_cRightViewIsClickable, false);
        this.mBackground_drawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.CommonTextView_cBackgroundDrawableRes);
        this.mIsCenterAlignLeft = typedArray.getBoolean(R.styleable.CommonTextView_cIsCenterAlignLeft, false);
        this.mCenterViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterViewMarginLeft, this.dip2px(this.mContext, 200.0f));
        typedArray.recycle();
    }

    private void init() {
        this.initCommonTextView();
        this.initLineView();
        this.initCenterBaseLine();
        if (this.mLeft_IV_drawable != null) {
            this.initLeftImageView();
        }
        if (this.mLeftTextString != null || this.mLeft_drawableLeft != null || this.mLeft_drawableRight != null) {
            this.initLeftText();
        }
        if (this.mCenterTextString != null) {
            this.initCenterText();
        }
        if (this.mRightTextString != null || this.mRight_drawableLeft != null || this.mRight_drawableRight != null) {
            this.initRightText();
        }
        if (this.mLeftTopTextString != null) {
            this.initLeftTopText();
        }
        if (this.mLeftBottomTextString != null) {
            this.initLeftBottomText();
        }
        if (this.mCenterTopTextString != null) {
            this.initCenterTopText();
        }
        if (this.mCenterBottomTextString != null) {
            this.initCenterBottomText();
        }
        if (this.mRightTopTextString != null) {
            this.initRightTopText();
        }
        if (this.mRightBottomTextString != null) {
            this.initRightBottomText();
        }
    }

    private void initCommonTextView() {
        this.setBackgroundColor(this.mBackgroundColor);
        if (this.mIsUseRipple) {
            this.setBackgroundResource(R.drawable.stv_btn_selector_white);
        }
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CommonTextView.this.mOnCommonTextViewClickListener != null) {
                    CommonTextView.this.mOnCommonTextViewClickListener.onCommonTextViewClick();
                }
            }
        });
        if (this.mBackground_drawable != null) {
            this.setBackgroundDrawable(this.mBackground_drawable);
        }
    }

    private void initCenterBaseLine() {
        if (this.mCenterBaseLineView == null) {
            if (this.mCenterBaseLineParams == null) {
                this.mCenterBaseLineParams = new RelativeLayout.LayoutParams(-1, this.mCenterSpaceHeight);
                this.mCenterBaseLineParams.addRule(15, -1);
            }
            this.mCenterBaseLineView = new View(this.mContext);
            this.mCenterBaseLineView.setId(R.id.cCenterBaseLineId);
            this.mCenterBaseLineView.setLayoutParams((ViewGroup.LayoutParams)this.mCenterBaseLineParams);
        }
        this.addView(this.mCenterBaseLineView);
    }

    private void initLineView() {
        switch (this.mDividerLineType) {
            case 0: {
                break;
            }
            case 1: {
                this.setTopLineMargin();
                break;
            }
            case 2: {
                this.setBottomLineMargin();
                break;
            }
            case 3: {
                this.setTopLineMargin();
                this.setBottomLineMargin();
                break;
            }
        }
    }

    private void setTopLineMargin() {
        if (this.mTopDividerLineMarginLR != 0) {
            this.initTopLineView(this.mTopDividerLineMarginLR, this.mTopDividerLineMarginLR);
        } else if (this.mBothDividerLineMarginLeft != 0 | this.mBothDividerLineMarginRight != 0) {
            this.initTopLineView(this.mBothDividerLineMarginLeft, this.mBothDividerLineMarginRight);
        } else {
            this.initTopLineView(this.mTopDividerLineMarginLeft, this.mTopDividerLineMarginRight);
        }
    }

    private void setBottomLineMargin() {
        if (this.mBottomDividerLineMarginLR != 0) {
            this.initBottomLineView(this.mBottomDividerLineMarginLR, this.mBottomDividerLineMarginLR);
        } else if (this.mBothDividerLineMarginRight != 0 | this.mBothDividerLineMarginRight != 0) {
            this.initBottomLineView(this.mBothDividerLineMarginLeft, this.mBothDividerLineMarginRight);
        } else {
            this.initBottomLineView(this.mBottomDividerLineMarginLeft, this.mBottomDividerLineMarginRight);
        }
    }

    private void initTopLineView(int marginStart, int marginEnd) {
        if (this.mTopLineView == null) {
            if (this.mTopLineParams == null) {
                this.mTopLineParams = new RelativeLayout.LayoutParams(-1, this.mDividerLineHeight);
            }
            this.mTopLineParams.addRule(10, -1);
            this.mTopLineParams.setMarginStart(marginStart);
            this.mTopLineParams.setMarginEnd(marginEnd);
            this.mTopLineView = new View(this.mContext);
            this.mTopLineView.setLayoutParams((ViewGroup.LayoutParams)this.mTopLineParams);
            this.mTopLineView.setBackgroundColor(this.mDividerLineColor);
        }
        this.addView(this.mTopLineView);
    }

    private void initBottomLineView(int marginStart, int marginEnd) {
        if (this.mBottomLineView == null) {
            if (this.mBottomLineParams == null) {
                this.mBottomLineParams = new RelativeLayout.LayoutParams(-1, this.mDividerLineHeight);
            }
            this.mBottomLineParams.addRule(12, -1);
            this.mBottomLineParams.setMarginStart(marginStart);
            this.mBottomLineParams.setMarginEnd(marginEnd);
            this.mBottomLineView = new View(this.mContext);
            this.mBottomLineView.setLayoutParams((ViewGroup.LayoutParams)this.mBottomLineParams);
            this.mBottomLineView.setBackgroundColor(this.mDividerLineColor);
        }
        this.addView(this.mBottomLineView);
    }

    private void initLeftImageView() {
        this.mLeftImageView = new ImageView(this.mContext);
        RelativeLayout.LayoutParams leftIVParams = new RelativeLayout.LayoutParams(-2, -2);
        leftIVParams.addRule(9, -1);
        leftIVParams.addRule(15, -1);
        leftIVParams.setMargins(this.mLeftImageViewMarginLeft, 0, 0, 0);
        this.mLeftImageView.setScaleType(ImageView.ScaleType.CENTER);
        this.mLeftImageView.setId(R.id.cLeftImageViewId);
        this.mLeftImageView.setLayoutParams((ViewGroup.LayoutParams)leftIVParams);
        if (this.mLeft_IV_drawable != null) {
            this.mLeftImageView.setImageDrawable(this.mLeft_IV_drawable);
        }
        this.addView((View)this.mLeftImageView);
    }

    private void initLeftText() {
        if (this.mLeftTextView == null) {
            if (this.mLeftTVParams == null) {
                this.mLeftTVParams = this.getParams(this.mLeftTVParams);
            }
            this.mLeftTVParams.addRule(15, -1);
            this.mLeftTVParams.addRule(1, R.id.cLeftImageViewId);
            this.mLeftTVParams.setMargins(this.mLeftViewPaddingLeft, 0, this.mLeftViewPaddingRight, 0);
            this.mLeftTextView = this.initText(this.mLeftTextView, this.mLeftTVParams, R.id.cLeftTextId, this.mLeftTextColor, this.mLeftTextSize);
            this.mLeftTextView.setText(this.mLeftTextString);
            this.mLeftTextView.setLineSpacing((float)this.mLeftTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.mLeftTextView, this.mLeftTextViewGravity);
            if (this.mLeftViewIsClickable) {
                this.mLeftTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (CommonTextView.this.mOnCommonTextViewClickListener != null) {
                            CommonTextView.this.mOnCommonTextViewClickListener.onLeftViewClick();
                        }
                    }
                });
            }
        }
        this.setDrawable(this.mLeftTextView, this.mLeft_drawableLeft, this.mLeft_drawableTop, this.mLeft_drawableRight, this.mLeft_drawableBottom, this.mLeftIconDrawablePadding);
    }

    private void initLeftTopText() {
        if (this.mLeftTopTextView == null) {
            if (this.mLeftTopTVParams == null) {
                this.mLeftTopTVParams = this.getParams(this.mLeftTopTVParams);
            }
            this.mLeftTopTVParams.addRule(15, -1);
            this.mLeftTopTVParams.addRule(2, R.id.cCenterBaseLineId);
            this.mLeftTopTVParams.addRule(1, R.id.cLeftImageViewId);
            this.mLeftTopTVParams.setMargins(this.mLeftViewPaddingLeft, 0, this.mLeftViewPaddingRight, 0);
            this.mLeftTopTextView = this.initText(this.mLeftTopTextView, this.mLeftTopTVParams, R.id.cLeftTopTextId, this.mLeftTopTextColor, this.mLeftTopTextSize);
            this.mLeftTopTextView.setText(this.mLeftTopTextString);
            this.setTextViewGravity(this.mLeftTopTextView, this.mLeftTextViewGravity);
        }
    }

    private void initLeftBottomText() {
        if (this.mLeftBottomTextView == null) {
            if (this.mLeftBottomTVParams == null) {
                this.mLeftBottomTVParams = this.getParams(this.mLeftBottomTVParams);
            }
            this.mLeftBottomTVParams.addRule(15, -1);
            this.mLeftBottomTVParams.addRule(3, R.id.cCenterBaseLineId);
            this.mLeftBottomTVParams.addRule(1, R.id.cLeftImageViewId);
            this.mLeftBottomTVParams.setMargins(this.mLeftViewPaddingLeft, 0, this.mLeftViewPaddingRight, 0);
            this.mLeftBottomTextView = this.initText(this.mLeftBottomTextView, this.mLeftBottomTVParams, R.id.cLeftBottomTextId, this.mLeftBottomTextColor, this.mLeftBottomTextSize);
            this.mLeftBottomTextView.setText(this.mLeftBottomTextString);
            this.setTextViewGravity(this.mLeftBottomTextView, this.mLeftTextViewGravity);
        }
    }

    private void initCenterText() {
        if (this.mCenterTextView == null) {
            if (this.mCenterTVParams == null) {
                this.mCenterTVParams = this.mIsCenterAlignLeft ? new RelativeLayout.LayoutParams(-1, -2) : this.getParams(this.mCenterTVParams);
            }
            this.mCenterTVParams.addRule(15, -1);
            this.mCenterTVParams.addRule(13, -1);
            if (this.mIsCenterAlignLeft) {
                this.mCenterTextView = this.initText(this.mCenterTextView, this.mCenterTVParams, R.id.cCenterTextId, this.mCenterTextColor, this.mCenterTextSize);
                this.mCenterTVParams.setMargins(this.mCenterViewMarginLeft, 0, this.mCenterViewPaddingRight, 0);
                this.setTextViewGravity(this.mCenterTextView, 0);
            } else {
                this.mCenterTextView = this.initText(this.mCenterTextView, this.mCenterTVParams, R.id.cCenterTextId, this.mCenterTextColor, this.mCenterTextSize);
                this.mCenterTVParams.setMargins(this.mCenterViewPaddingLeft, 0, this.mCenterViewPaddingRight, 0);
                this.setTextViewGravity(this.mCenterTextView, this.mCenterTextViewGravity);
            }
            this.mCenterTextView.setText(this.mCenterTextString);
            this.mCenterTextView.setLineSpacing((float)this.mCenterTextViewLineSpacingExtra, 1.0f);
            if (this.mCenterViewIsClickable) {
                this.mCenterTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (CommonTextView.this.mOnCommonTextViewClickListener != null) {
                            CommonTextView.this.mOnCommonTextViewClickListener.onCenterViewClick();
                        }
                    }
                });
            }
        }
        this.setDrawable(this.mCenterTextView, this.mCenter_drawableLeft, this.mCenter_drawableTop, this.mCenter_drawableRight, this.mCenter_drawableBottom, this.mCenterIconDrawablePadding);
    }

    private void initCenterTopText() {
        if (this.mCenterTopTextView == null) {
            if (this.mCenterTopTVParams == null) {
                this.mCenterTopTVParams = this.getParams(this.mCenterTopTVParams);
            }
            this.mCenterTopTVParams.addRule(15, -1);
            this.mCenterTopTVParams.addRule(13, -1);
            this.mCenterTopTVParams.addRule(2, R.id.cCenterBaseLineId);
            this.mCenterTopTVParams.setMargins(this.mCenterViewPaddingLeft, 0, this.mCenterViewPaddingRight, 0);
            this.mCenterTopTextView = this.initText(this.mCenterTopTextView, this.mCenterTopTVParams, R.id.cCenterTopTextId, this.mCenterTopTextColor, this.mCenterTopTextSize);
            this.mCenterTopTextView.setText(this.mCenterTopTextString);
            this.mCenterTopTextView.setLineSpacing((float)this.mCenterTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.mCenterTopTextView, this.mCenterTextViewGravity);
        }
    }

    private void initCenterBottomText() {
        if (this.mCenterBottomTextView == null) {
            if (this.mCenterBottomTVParams == null) {
                this.mCenterBottomTVParams = this.getParams(this.mCenterBottomTVParams);
            }
            this.mCenterBottomTVParams.addRule(15, -1);
            this.mCenterBottomTVParams.addRule(13, -1);
            this.mCenterBottomTVParams.addRule(3, R.id.cCenterBaseLineId);
            this.mCenterBottomTVParams.setMargins(this.mCenterViewPaddingLeft, 0, this.mCenterViewPaddingRight, 0);
            this.mCenterBottomTextView = this.initText(this.mCenterBottomTextView, this.mCenterBottomTVParams, R.id.cCenterBottomTextId, this.mCenterBottomTextColor, this.mCenterBottomTextSize);
            this.mCenterBottomTextView.setText(this.mCenterBottomTextString);
            this.mCenterBottomTextView.setLineSpacing((float)this.mCenterTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.mCenterBottomTextView, this.mCenterTextViewGravity);
        }
    }

    private void initRightText() {
        if (this.mRightTextView == null) {
            if (this.mRightTVParams == null) {
                this.mRightTVParams = this.getParams(this.mRightTVParams);
            }
            this.mRightTVParams.addRule(15, -1);
            this.mRightTVParams.addRule(11, -1);
            this.mRightTVParams.addRule(0, R.id.cRightImageViewId);
            this.mRightTVParams.setMargins(this.mRightViewPaddingLeft, 0, this.mRightViewPaddingRight, 0);
            this.mRightTextView = this.initText(this.mRightTextView, this.mRightTVParams, R.id.cRightTextId, this.mRightTextColor, this.mRightTextSize);
            this.mRightTextView.setText(this.mRightTextString);
            this.mRightTextView.setLineSpacing((float)this.mRightTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.mRightTextView, this.mRightTextViewGravity);
            if (this.mRightViewIsClickable) {
                this.mRightTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (CommonTextView.this.mOnCommonTextViewClickListener != null) {
                            CommonTextView.this.mOnCommonTextViewClickListener.onRightViewClick();
                        }
                    }
                });
            }
        }
        this.setDrawable(this.mRightTextView, this.mRight_drawableLeft, this.mRight_drawableTop, this.mRight_drawableRight, this.mRight_drawableBottom, this.mRightIconDrawablePadding);
    }

    private void initRightTopText() {
        if (this.mRightTopTextView == null) {
            if (this.mRightTopTVParams == null) {
                this.mRightTopTVParams = this.getParams(this.mRightTopTVParams);
            }
            this.mRightTopTVParams.addRule(15, -1);
            this.mRightTopTVParams.addRule(11, -1);
            this.mRightTopTVParams.addRule(2, R.id.cCenterBaseLineId);
            this.mRightTopTVParams.addRule(0, R.id.cRightImageViewId);
            this.mRightTopTVParams.setMargins(this.mRightViewPaddingLeft, 0, this.mRightViewPaddingRight, 0);
            this.mRightTopTextView = this.initText(this.mRightTopTextView, this.mRightTopTVParams, R.id.cRightTopTextId, this.mRightTopTextColor, this.mRightTopTextSize);
            this.mRightTopTextView.setText(this.mRightTopTextString);
            this.mRightTopTextView.setLineSpacing((float)this.mRightTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.mRightTopTextView, this.mRightTextViewGravity);
        }
    }

    private void initRightBottomText() {
        if (this.mRightBottomTextView == null) {
            if (this.mRightBottomTVParams == null) {
                this.mRightBottomTVParams = this.getParams(this.mRightBottomTVParams);
            }
            this.mRightBottomTVParams.addRule(15, -1);
            this.mRightBottomTVParams.addRule(11, -1);
            this.mRightBottomTVParams.addRule(3, R.id.cCenterBaseLineId);
            this.mRightBottomTVParams.addRule(0, R.id.cRightImageViewId);
            this.mRightBottomTVParams.setMargins(this.mRightViewPaddingLeft, 0, this.mRightViewPaddingRight, 0);
            this.mRightBottomTextView = this.initText(this.mRightBottomTextView, this.mRightBottomTVParams, R.id.cRightBottomTextId, this.mRightBottomTextColor, this.mRightBottomTextSize);
            this.mRightBottomTextView.setText(this.mRightBottomTextString);
            this.mRightBottomTextView.setLineSpacing((float)this.mRightTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.mRightBottomTextView, this.mRightTextViewGravity);
        }
    }

    public RelativeLayout.LayoutParams getParams(RelativeLayout.LayoutParams params) {
        if (params == null) {
            params = new RelativeLayout.LayoutParams(-2, -2);
        }
        return params;
    }

    public TextView initText(TextView textView, RelativeLayout.LayoutParams layoutParams, int id2, int textColor, int textSize) {
        if (textView == null) {
            textView = new TextView(this.mContext);
            textView.setId(id2);
            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            textView.setTextColor(textColor);
            textView.setTextSize(0, (float)textSize);
            textView.setLines(this.mSetLines);
            textView.setSingleLine(this.mSetSingleLine);
            textView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.mSetMaxEms)});
            this.addView((View)textView);
        }
        return textView;
    }

    private void setTextViewGravity(TextView textView, int gravity_type) {
        switch (gravity_type) {
            case 0: {
                textView.setGravity(19);
                break;
            }
            case 1: {
                textView.setGravity(17);
                break;
            }
            case 2: {
                textView.setGravity(21);
                break;
            }
        }
    }

    public void setDrawable(TextView textView, Drawable drawableLeft, Drawable drawableTop, Drawable drawableRight, Drawable drawableBottom, int drawablePadding) {
        textView.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
        textView.setCompoundDrawablePadding(drawablePadding);
    }

    public CommonTextView setLeftTextString(CharSequence string2) {
        if (this.mLeftTextView == null) {
            this.initLeftText();
        }
        this.mLeftTextView.setText(string2);
        return this;
    }

    public CommonTextView setLeftTopTextString(CharSequence string2) {
        if (this.mLeftTopTextView == null) {
            this.initLeftTopText();
        }
        this.mLeftTopTextView.setText(string2);
        return this;
    }

    public CommonTextView setLeftBottomTextString(CharSequence string2) {
        if (this.mLeftBottomTextView == null) {
            this.initLeftBottomText();
        }
        this.mLeftBottomTextView.setText(string2);
        return this;
    }

    public CommonTextView setLeftTextSize(float size) {
        if (this.mLeftTextView == null) {
            this.initLeftText();
        }
        this.mLeftTextView.setTextSize(size);
        return this;
    }

    public CommonTextView setLeftTextColor(int color2) {
        if (this.mLeftTextView == null) {
            this.initLeftText();
        }
        this.mLeftTextView.setTextColor(color2);
        return this;
    }

    public CommonTextView setCenterTextString(CharSequence string2) {
        if (this.mCenterTextView == null) {
            this.initCenterText();
        }
        this.mCenterTextView.setText(string2);
        return this;
    }

    public CommonTextView setCenterTopTextString(CharSequence string2) {
        if (this.mCenterTopTextView == null) {
            this.initCenterTopText();
        }
        this.mCenterTopTextView.setText(string2);
        return this;
    }

    public CommonTextView setCenterBottomTextString(CharSequence string2) {
        if (this.mCenterBottomTextView == null) {
            this.initCenterBottomText();
        }
        this.mCenterBottomTextView.setText(string2);
        return this;
    }

    public CommonTextView setCenterTextSize(float size) {
        if (this.mCenterTextView == null) {
            this.initCenterText();
        }
        this.mCenterTextView.setTextSize(size);
        return this;
    }

    public CommonTextView setCenterTextColor(int color2) {
        if (this.mCenterTextView == null) {
            this.initCenterText();
        }
        this.mCenterTextView.setTextColor(color2);
        return this;
    }

    public CommonTextView setRightTextString(CharSequence string2) {
        if (this.mRightTextView == null) {
            this.initRightText();
        }
        this.mRightTextView.setText(string2);
        return this;
    }

    public CommonTextView setRightTopTextString(CharSequence string2) {
        if (this.mRightTopTextView == null) {
            this.initRightTopText();
        }
        this.mRightTopTextView.setText(string2);
        return this;
    }

    public CommonTextView setRightBottomTextString(CharSequence string2) {
        if (this.mRightBottomTextView == null) {
            this.initRightBottomText();
        }
        this.mRightBottomTextView.setText(string2);
        return this;
    }

    public CommonTextView setRightTextSize(float size) {
        if (this.mRightTextView == null) {
            this.initRightText();
        }
        this.mRightTextView.setTextSize(size);
        return this;
    }

    public CommonTextView setRightTextColor(int color2) {
        if (this.mRightTextView == null) {
            this.initRightText();
        }
        this.mRightTextView.setTextColor(color2);
        return this;
    }

    public CommonTextView setLeftDrawableLeft(Drawable drawableLeft) {
        if (drawableLeft != null) {
            drawableLeft.setBounds(0, 0, drawableLeft.getMinimumWidth(), drawableLeft.getMinimumHeight());
        }
        if (this.mLeftTextView == null) {
            this.initLeftText();
        }
        this.mLeftTextView.setCompoundDrawables(drawableLeft, null, null, null);
        return this;
    }

    public CommonTextView setLeftDrawableTop(Drawable drawableTop) {
        if (drawableTop != null) {
            drawableTop.setBounds(0, 0, drawableTop.getMinimumWidth(), drawableTop.getMinimumHeight());
        }
        if (this.mLeftTextView == null) {
            this.initLeftText();
        }
        this.mLeftTextView.setCompoundDrawables(null, drawableTop, null, null);
        return this;
    }

    public CommonTextView setLeftDrawableRight(Drawable drawableRight) {
        if (drawableRight != null) {
            drawableRight.setBounds(0, 0, drawableRight.getMinimumWidth(), drawableRight.getMinimumHeight());
        }
        if (this.mLeftTextView == null) {
            this.initLeftText();
        }
        this.mLeftTextView.setCompoundDrawables(null, null, drawableRight, null);
        return this;
    }

    public CommonTextView setLeftDrawableBottom(Drawable drawableBottom) {
        if (drawableBottom != null) {
            drawableBottom.setBounds(0, 0, drawableBottom.getMinimumWidth(), drawableBottom.getMinimumHeight());
        }
        if (this.mLeftTextView == null) {
            this.initLeftText();
        }
        this.mLeftTextView.setCompoundDrawables(null, null, null, drawableBottom);
        return this;
    }

    public CommonTextView setCenterDrawableLeft(Drawable drawableLeft) {
        if (drawableLeft != null) {
            drawableLeft.setBounds(0, 0, drawableLeft.getMinimumWidth(), drawableLeft.getMinimumHeight());
        }
        if (this.mCenterTextView == null) {
            this.initCenterText();
        }
        this.mCenterTextView.setCompoundDrawables(drawableLeft, null, null, null);
        return this;
    }

    public CommonTextView setCenterDrawableTop(Drawable drawableTop) {
        if (drawableTop != null) {
            drawableTop.setBounds(0, 0, drawableTop.getMinimumWidth(), drawableTop.getMinimumHeight());
        }
        if (this.mCenterTextView == null) {
            this.initCenterText();
        }
        this.mCenterTextView.setCompoundDrawables(null, drawableTop, null, null);
        return this;
    }

    public CommonTextView setCenterDrawableRight(Drawable drawableRight) {
        if (drawableRight != null) {
            drawableRight.setBounds(0, 0, drawableRight.getMinimumWidth(), drawableRight.getMinimumHeight());
        }
        if (this.mCenterTextView == null) {
            this.initCenterText();
        }
        this.mCenterTextView.setCompoundDrawables(null, null, drawableRight, null);
        return this;
    }

    public CommonTextView setCenterDrawableBottom(Drawable drawableBottom) {
        if (drawableBottom != null) {
            drawableBottom.setBounds(0, 0, drawableBottom.getMinimumWidth(), drawableBottom.getMinimumHeight());
        }
        if (this.mCenterTextView == null) {
            this.initCenterText();
        }
        this.mCenterTextView.setCompoundDrawables(null, null, null, drawableBottom);
        return this;
    }

    public CommonTextView setRightDrawableLeft(Drawable drawableLeft) {
        if (drawableLeft != null) {
            drawableLeft.setBounds(0, 0, drawableLeft.getMinimumWidth(), drawableLeft.getMinimumHeight());
        }
        if (this.mRightTextView == null) {
            this.initRightText();
        }
        this.mRightTextView.setCompoundDrawables(drawableLeft, null, null, null);
        return this;
    }

    public CommonTextView setRightDrawableTop(Drawable drawableTop) {
        if (drawableTop != null) {
            drawableTop.setBounds(0, 0, drawableTop.getMinimumWidth(), drawableTop.getMinimumHeight());
        }
        if (this.mRightTextView == null) {
            this.initRightText();
        }
        this.mRightTextView.setCompoundDrawables(null, drawableTop, null, null);
        return this;
    }

    public CommonTextView setRightDrawableRight(Drawable drawableRight) {
        if (drawableRight != null) {
            drawableRight.setBounds(0, 0, drawableRight.getMinimumWidth(), drawableRight.getMinimumHeight());
        }
        if (this.mRightTextView == null) {
            this.initRightText();
        }
        this.mRightTextView.setCompoundDrawables(null, null, drawableRight, null);
        return this;
    }

    public CommonTextView setRightDrawableBottom(Drawable drawableBottom) {
        if (drawableBottom != null) {
            drawableBottom.setBounds(0, 0, drawableBottom.getMinimumWidth(), drawableBottom.getMinimumHeight());
        }
        if (this.mRightTextView == null) {
            this.initRightText();
        }
        this.mRightTextView.setCompoundDrawables(null, null, null, drawableBottom);
        return this;
    }

    public ImageView getLeftImageView() {
        if (this.mLeftImageView == null) {
            this.initLeftImageView();
        }
        return this.mLeftImageView;
    }

    public CharSequence getLeftTextString() {
        return this.mLeftTextView != null ? this.mLeftTextView.getText() : "";
    }

    public CharSequence getLeftTopTextString() {
        return this.mLeftTopTextView != null ? this.mLeftTopTextView.getText() : "";
    }

    public CharSequence getLeftBottomTextString() {
        return this.mLeftBottomTextView != null ? this.mLeftBottomTextView.getText() : "";
    }

    public CharSequence getCenterTextString() {
        return this.mCenterTextView != null ? this.mCenterTextView.getText() : "";
    }

    public CharSequence getCenterTopTextString() {
        return this.mCenterTopTextView != null ? this.mCenterTopTextView.getText() : "";
    }

    public CharSequence getCenterBottomTextString() {
        return this.mCenterBottomTextView != null ? this.mCenterBottomTextView.getText() : "";
    }

    public CharSequence getRightTextString() {
        return this.mRightTextView != null ? this.mRightTextView.getText() : "";
    }

    public CharSequence getRightTopTextString() {
        return this.mRightTopTextView != null ? this.mRightTopTextView.getText() : "";
    }

    public CharSequence getRightBottomTextString() {
        return this.mRightBottomTextView != null ? this.mRightBottomTextView.getText() : "";
    }

    public void setTypeface(Typeface typeface) {
        if (this.mLeftTextView != null) {
            this.mLeftTextView.setTypeface(typeface);
        }
        if (this.mCenterTextView != null) {
            this.mCenterTextView.setTypeface(typeface);
        }
        if (this.mRightTextView != null) {
            this.mRightTextView.setTypeface(typeface);
        }
        if (this.mLeftTopTextView != null) {
            this.mLeftTopTextView.setTypeface(typeface);
        }
        if (this.mCenterTopTextView != null) {
            this.mCenterTopTextView.setTypeface(typeface);
        }
        if (this.mRightTopTextView != null) {
            this.mRightTopTextView.setTypeface(typeface);
        }
        if (this.mLeftBottomTextView != null) {
            this.mLeftBottomTextView.setTypeface(typeface);
        }
        if (this.mCenterBottomTextView != null) {
            this.mCenterBottomTextView.setTypeface(typeface);
        }
        if (this.mRightBottomTextView != null) {
            this.mRightBottomTextView.setTypeface(typeface);
        }
    }

    public CommonTextView setOnCommonTextViewClickListener(OnCommonTextViewClickListener listener) {
        this.mOnCommonTextViewClickListener = listener;
        return this;
    }

    public CommonTextView setLeftViewIsClickable(boolean isClickable) {
        if (isClickable && this.mLeftTextView != null) {
            this.mLeftTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonTextView.this.mOnCommonTextViewClickListener != null) {
                        CommonTextView.this.mOnCommonTextViewClickListener.onLeftViewClick();
                    }
                }
            });
        }
        return this;
    }

    public CommonTextView setCenterViewIsClickable(boolean isClickable) {
        if (isClickable && this.mCenterTextView != null) {
            this.mCenterTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonTextView.this.mOnCommonTextViewClickListener != null) {
                        CommonTextView.this.mOnCommonTextViewClickListener.onCenterViewClick();
                    }
                }
            });
        }
        return this;
    }

    public CommonTextView setRightViewIsClickable(boolean isClickable) {
        if (isClickable && this.mRightTextView != null) {
            this.mRightTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonTextView.this.mOnCommonTextViewClickListener != null) {
                        CommonTextView.this.mOnCommonTextViewClickListener.onRightViewClick();
                    }
                }
            });
        }
        return this;
    }

    public int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public int sp2px(Context context, float spValue) {
        float scale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * scale + 0.5f);
    }

    public static class OnCommonTextViewClickListener {
        public void onCommonTextViewClick() {
        }

        public void onLeftViewClick() {
        }

        public void onCenterViewClick() {
        }

        public void onRightViewClick() {
        }
    }
}

