/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.marqueen;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ViewFlipper;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.textview.marqueen.MarqueeFactory;
import java.util.List;

public class MarqueeView
extends ViewFlipper {
    private int mInterval = 2500;
    private int mAnimDuration = 500;
    private Animation mAnimIn;
    private Animation mAnimOut;
    private int mAnimInRes = R.anim.marquee_bottom_in;
    private int mAnimOutRes = R.anim.marquee_top_out;

    public MarqueeView(Context context) {
        super(context);
        this.init(null);
    }

    public MarqueeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.MarqueeView, 0, 0);
        this.mInterval = a.getInt(R.styleable.MarqueeView_mq_interval, this.mInterval);
        this.mAnimInRes = a.getResourceId(R.styleable.MarqueeView_mq_animIn, this.mAnimInRes);
        this.mAnimOutRes = a.getResourceId(R.styleable.MarqueeView_mq_animOut, this.mAnimOutRes);
        this.mAnimDuration = a.getInt(R.styleable.MarqueeView_mq_animDuration, this.mAnimDuration);
        a.recycle();
        this.setFlipInterval(this.mInterval);
        this.mAnimIn = AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.mAnimInRes);
        this.mAnimIn.setDuration((long)this.mAnimDuration);
        this.setInAnimation(this.mAnimIn);
        this.mAnimOut = AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.mAnimOutRes);
        this.mAnimOut.setDuration((long)this.mAnimDuration);
        this.setOutAnimation(this.mAnimOut);
    }

    public void setMarqueeFactory(MarqueeFactory factory) {
        factory.setAttachedToMarqueeView(this);
        this.removeAllViews();
        List mViews = factory.getMarqueeViews();
        if (mViews != null) {
            for (int i = 0; i < mViews.size(); ++i) {
                this.addView((View)mViews.get(i));
            }
        }
    }

    public void setInterval(int interval) {
        this.mInterval = interval;
        this.setFlipInterval(interval);
    }

    public void setAnimDuration(int animDuration) {
        this.mAnimDuration = animDuration;
        this.mAnimIn.setDuration((long)animDuration);
        this.setInAnimation(this.mAnimIn);
        this.mAnimOut.setDuration((long)animDuration);
        this.setOutAnimation(this.mAnimOut);
    }

    public void setAnimInAndOut(Animation animIn, Animation animOut) {
        this.mAnimIn = animIn;
        this.mAnimOut = animOut;
        this.setInAnimation(animIn);
        this.setOutAnimation(animOut);
    }

    public void setAnimInAndOut(int animInId, int animOutID) {
        this.mAnimIn = AnimationUtils.loadAnimation((Context)this.getContext(), (int)animInId);
        this.mAnimOut = AnimationUtils.loadAnimation((Context)this.getContext(), (int)animOutID);
        this.mAnimIn.setDuration((long)this.mAnimDuration);
        this.mAnimOut.setDuration((long)this.mAnimDuration);
        this.setInAnimation(this.mAnimIn);
        this.setOutAnimation(this.mAnimOut);
    }

    public Animation getAnimIn() {
        return this.mAnimIn;
    }

    public Animation getAnimOut() {
        return this.mAnimOut;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopFlipping();
    }
}

