/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.marqueen;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.util.Date;

public class DisplayEntity {
    private static final String TIME_PLACE_HOLDER = "$";
    private String mID;
    private final String mMessage;
    private long mTime;
    private int mEffectiveInternal;

    public DisplayEntity(String message) {
        this.mMessage = message;
    }

    public DisplayEntity(String ID, String message, long time, int effectiveInternal) {
        this.mID = ID;
        this.mMessage = message;
        this.mTime = time;
        this.mEffectiveInternal = effectiveInternal;
    }

    public String getID() {
        return this.mID;
    }

    public DisplayEntity setID(String ID) {
        this.mID = ID;
        return this;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public long getTime() {
        return this.mTime;
    }

    public DisplayEntity setTime(long time) {
        this.mTime = time;
        return this;
    }

    public int getEffectiveInternal() {
        return this.mEffectiveInternal;
    }

    public DisplayEntity setEffectiveInternal(int effectiveInternal) {
        this.mEffectiveInternal = effectiveInternal;
        return this;
    }

    @NonNull
    public String toString() {
        return this.updateMessage();
    }

    private String updateMessage() {
        if (this.isValid() && this.mTime != 0L && this.mMessage.contains(TIME_PLACE_HOLDER)) {
            String internal = String.valueOf(this.calculateNumberOfMinutes(this.mTime));
            return this.mMessage.replace(TIME_PLACE_HOLDER, internal);
        }
        return this.mMessage;
    }

    public int calculateNumberOfMinutes(long date) {
        return (int)((this.getCurrentDate().getTime() - date) / 60000L);
    }

    public Date getCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    public boolean isValid() {
        return !TextUtils.isEmpty((CharSequence)this.mMessage);
    }
}

