/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.badge;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.widget.textview.badge.Badge;
import com.xuexiang.xui.widget.textview.badge.BadgeAnimator;
import com.xuexiang.xui.widget.textview.badge.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class BadgeView
extends View
implements Badge {
    public static final int DEFAULT_COLOR_BACKGROUND = -1552832;
    public static final int DEFAULT_COLOR_BADGE_TEXT = -1;
    public static final int DEFAULT_TEXT_SIZE = 11;
    public static final int DEFAULT_BADGE_PADDING = 5;
    public static final int DEFAULT_GRAVITY_OFFSET = 1;
    protected int mColorBackground;
    protected int mColorBackgroundBorder;
    protected int mColorBadgeText;
    protected Drawable mDrawableBackground;
    protected Bitmap mBitmapClip;
    protected boolean mDrawableBackgroundClip;
    protected float mBackgroundBorderWidth;
    protected float mBadgeTextSize;
    protected float mBadgePadding;
    protected int mBadgeNumber;
    protected String mBadgeText;
    protected boolean mDraggable;
    protected boolean mDragging;
    protected boolean mExact;
    protected boolean mShowShadow;
    protected int mBadgeGravity;
    protected float mGravityOffsetX;
    protected float mGravityOffsetY;
    protected float mDefaultRadius;
    protected float mFinalDragDistance;
    protected int mDragQuadrant;
    protected boolean mDragOutOfRange;
    protected RectF mBadgeTextRect;
    protected RectF mBadgeBackgroundRect;
    protected Path mDragPath;
    protected Paint.FontMetrics mBadgeTextFontMetrics;
    protected PointF mBadgeCenter;
    protected PointF mDragCenter;
    protected PointF mRowBadgeCenter;
    protected PointF mControlPoint;
    protected List<PointF> mInnerTangentPoints;
    protected View mTargetView;
    protected int mWidth;
    protected int mHeight;
    protected TextPaint mBadgeTextPaint;
    protected Paint mBadgeBackgroundPaint;
    protected Paint mBadgeBackgroundBorderPaint;
    protected BadgeAnimator mAnimator;
    protected Badge.OnDragStateChangedListener mDragStateChangedListener;
    protected ViewGroup mActivityRoot;

    public BadgeView(Context context) {
        this(context, null);
    }

    private BadgeView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private BadgeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setLayerType(1, null);
        this.mBadgeTextRect = new RectF();
        this.mBadgeBackgroundRect = new RectF();
        this.mDragPath = new Path();
        this.mBadgeCenter = new PointF();
        this.mDragCenter = new PointF();
        this.mRowBadgeCenter = new PointF();
        this.mControlPoint = new PointF();
        this.mInnerTangentPoints = new ArrayList<PointF>();
        this.mBadgeTextPaint = new TextPaint();
        this.mBadgeTextPaint.setAntiAlias(true);
        this.mBadgeTextPaint.setSubpixelText(true);
        this.mBadgeTextPaint.setFakeBoldText(true);
        this.mBadgeTextPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        this.mBadgeBackgroundPaint = new Paint();
        this.mBadgeBackgroundPaint.setAntiAlias(true);
        this.mBadgeBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mBadgeBackgroundBorderPaint = new Paint();
        this.mBadgeBackgroundBorderPaint.setAntiAlias(true);
        this.mBadgeBackgroundBorderPaint.setStyle(Paint.Style.STROKE);
        this.mColorBackground = -1552832;
        this.mColorBadgeText = -1;
        this.mBadgeTextSize = DensityUtils.sp2px(this.getContext(), 11.0f);
        this.mBadgePadding = DensityUtils.dp2px(this.getContext(), 5.0f);
        this.mBadgeNumber = 0;
        this.mBadgeGravity = 8388661;
        this.mGravityOffsetX = DensityUtils.dp2px(this.getContext(), 1.0f);
        this.mGravityOffsetY = DensityUtils.dp2px(this.getContext(), 1.0f);
        this.mFinalDragDistance = DensityUtils.dp2px(this.getContext(), 90.0f);
        this.mShowShadow = true;
        this.mDrawableBackgroundClip = false;
        if (Build.VERSION.SDK_INT >= 21) {
            this.setTranslationZ(1000.0f);
        }
    }

    @Override
    public Badge bindTarget(View targetView) {
        ViewParent targetParent;
        if (targetView == null) {
            throw new IllegalStateException("targetView can not be null");
        }
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        if ((targetParent = targetView.getParent()) instanceof ViewGroup) {
            this.mTargetView = targetView;
            if (targetParent instanceof BadgeContainer) {
                ((BadgeContainer)targetParent).addView(this);
            } else {
                ViewGroup targetContainer = (ViewGroup)targetParent;
                int index = targetContainer.indexOfChild(targetView);
                ViewGroup.LayoutParams targetParams = targetView.getLayoutParams();
                targetContainer.removeView(targetView);
                BadgeContainer badgeContainer = new BadgeContainer(this.getContext());
                if (targetContainer instanceof RelativeLayout) {
                    badgeContainer.setId(targetView.getId());
                }
                targetContainer.addView((View)badgeContainer, index, targetParams);
                badgeContainer.addView(targetView);
                badgeContainer.addView(this);
            }
        } else {
            throw new IllegalStateException("targetView must have a parent");
        }
        return this;
    }

    @Override
    public View getTargetView() {
        return this.mTargetView;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mActivityRoot == null) {
            this.findViewRoot(this.mTargetView);
        }
    }

    private void findViewRoot(View view) {
        this.mActivityRoot = (ViewGroup)view.getRootView();
        if (this.mActivityRoot == null) {
            this.findActivityRoot(view);
        }
    }

    private void findActivityRoot(View view) {
        if (view.getParent() != null && view.getParent() instanceof View) {
            this.findActivityRoot((View)view.getParent());
        } else if (view instanceof ViewGroup) {
            this.mActivityRoot = (ViewGroup)view;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: 
            case 5: {
                float x = event.getX();
                float y = event.getY();
                if (!this.mDraggable || event.getPointerId(event.getActionIndex()) != 0 || !(x > this.mBadgeBackgroundRect.left) || !(x < this.mBadgeBackgroundRect.right) || !(y > this.mBadgeBackgroundRect.top) || !(y < this.mBadgeBackgroundRect.bottom) || this.mBadgeText == null) break;
                this.initRowBadgeCenter();
                this.mDragging = true;
                this.updateListener(1);
                this.mDefaultRadius = DensityUtils.dp2px(this.getContext(), 7.0f);
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.screenFromWindow(true);
                this.mDragCenter.x = event.getRawX();
                this.mDragCenter.y = event.getRawY();
                break;
            }
            case 2: {
                if (!this.mDragging) break;
                this.mDragCenter.x = event.getRawX();
                this.mDragCenter.y = event.getRawY();
                this.invalidate();
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                if (event.getPointerId(event.getActionIndex()) != 0 || !this.mDragging) break;
                this.mDragging = false;
                this.onPointerUp();
                break;
            }
        }
        return this.mDragging || super.onTouchEvent(event);
    }

    private void onPointerUp() {
        if (this.mDragOutOfRange) {
            this.animateHide(this.mDragCenter);
            this.updateListener(5);
        } else {
            this.reset();
            this.updateListener(4);
        }
    }

    protected Bitmap createBadgeBitmap() {
        Bitmap bitmap = Bitmap.createBitmap((int)((int)this.mBadgeBackgroundRect.width() + DensityUtils.dp2px(this.getContext(), 3.0f)), (int)((int)this.mBadgeBackgroundRect.height() + DensityUtils.dp2px(this.getContext(), 3.0f)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        this.drawBadge(canvas, new PointF((float)canvas.getWidth() / 2.0f, (float)canvas.getHeight() / 2.0f), this.getBadgeCircleRadius());
        return bitmap;
    }

    protected void screenFromWindow(boolean screen) {
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        if (screen) {
            this.mActivityRoot.addView((View)this, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        } else {
            this.bindTarget(this.mTargetView);
        }
    }

    private void showShadowImpl(boolean showShadow) {
        int x = DensityUtils.dp2px(this.getContext(), 1.0f);
        int y = DensityUtils.dp2px(this.getContext(), 1.5f);
        switch (this.mDragQuadrant) {
            case 1: {
                x = DensityUtils.dp2px(this.getContext(), 1.0f);
                y = DensityUtils.dp2px(this.getContext(), -1.5f);
                break;
            }
            case 2: {
                x = DensityUtils.dp2px(this.getContext(), -1.0f);
                y = DensityUtils.dp2px(this.getContext(), -1.5f);
                break;
            }
            case 3: {
                x = DensityUtils.dp2px(this.getContext(), -1.0f);
                y = DensityUtils.dp2px(this.getContext(), 1.5f);
                break;
            }
            case 4: {
                x = DensityUtils.dp2px(this.getContext(), 1.0f);
                y = DensityUtils.dp2px(this.getContext(), 1.5f);
                break;
            }
        }
        this.mBadgeBackgroundPaint.setShadowLayer(showShadow ? (float)DensityUtils.dp2px(this.getContext(), 2.0f) : 0.0f, (float)x, (float)y, 0x33000000);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            this.mAnimator.draw(canvas);
            return;
        }
        if (this.mBadgeText != null) {
            this.initPaints();
            float badgeRadius = this.getBadgeCircleRadius();
            float startCircleRadius = this.mDefaultRadius * (1.0f - MathUtils.getPointDistance(this.mRowBadgeCenter, this.mDragCenter) / this.mFinalDragDistance);
            if (this.mDraggable && this.mDragging) {
                this.mDragQuadrant = MathUtils.getQuadrant(this.mDragCenter, this.mRowBadgeCenter);
                this.showShadowImpl(this.mShowShadow);
                this.mDragOutOfRange = startCircleRadius < (float)DensityUtils.dp2px(this.getContext(), 1.5f);
                if (this.mDragOutOfRange) {
                    this.updateListener(3);
                    this.drawBadge(canvas, this.mDragCenter, badgeRadius);
                } else {
                    this.updateListener(2);
                    this.drawDragging(canvas, startCircleRadius, badgeRadius);
                    this.drawBadge(canvas, this.mDragCenter, badgeRadius);
                }
            } else {
                this.findBadgeCenter();
                this.drawBadge(canvas, this.mBadgeCenter, badgeRadius);
            }
        }
    }

    private void initPaints() {
        this.showShadowImpl(this.mShowShadow);
        this.mBadgeBackgroundPaint.setColor(this.mColorBackground);
        this.mBadgeBackgroundBorderPaint.setColor(this.mColorBackgroundBorder);
        this.mBadgeBackgroundBorderPaint.setStrokeWidth(this.mBackgroundBorderWidth);
        this.mBadgeTextPaint.setColor(this.mColorBadgeText);
        this.mBadgeTextPaint.setTextAlign(Paint.Align.CENTER);
    }

    private void drawDragging(Canvas canvas, float startRadius, float badgeRadius) {
        float dy = this.mDragCenter.y - this.mRowBadgeCenter.y;
        float dx = this.mDragCenter.x - this.mRowBadgeCenter.x;
        this.mInnerTangentPoints.clear();
        if (dx != 0.0f) {
            double k1 = dy / dx;
            double k2 = -1.0 / k1;
            MathUtils.getInnerTangentPoints(this.mDragCenter, badgeRadius, k2, this.mInnerTangentPoints);
            MathUtils.getInnerTangentPoints(this.mRowBadgeCenter, startRadius, k2, this.mInnerTangentPoints);
        } else {
            MathUtils.getInnerTangentPoints(this.mDragCenter, badgeRadius, 0.0, this.mInnerTangentPoints);
            MathUtils.getInnerTangentPoints(this.mRowBadgeCenter, startRadius, 0.0, this.mInnerTangentPoints);
        }
        this.mDragPath.reset();
        this.mDragPath.addCircle(this.mRowBadgeCenter.x, this.mRowBadgeCenter.y, startRadius, this.mDragQuadrant == 1 || this.mDragQuadrant == 2 ? Path.Direction.CCW : Path.Direction.CW);
        this.mControlPoint.x = (this.mRowBadgeCenter.x + this.mDragCenter.x) / 2.0f;
        this.mControlPoint.y = (this.mRowBadgeCenter.y + this.mDragCenter.y) / 2.0f;
        this.mDragPath.moveTo(this.mInnerTangentPoints.get((int)2).x, this.mInnerTangentPoints.get((int)2).y);
        this.mDragPath.quadTo(this.mControlPoint.x, this.mControlPoint.y, this.mInnerTangentPoints.get((int)0).x, this.mInnerTangentPoints.get((int)0).y);
        this.mDragPath.lineTo(this.mInnerTangentPoints.get((int)1).x, this.mInnerTangentPoints.get((int)1).y);
        this.mDragPath.quadTo(this.mControlPoint.x, this.mControlPoint.y, this.mInnerTangentPoints.get((int)3).x, this.mInnerTangentPoints.get((int)3).y);
        this.mDragPath.lineTo(this.mInnerTangentPoints.get((int)2).x, this.mInnerTangentPoints.get((int)2).y);
        this.mDragPath.close();
        canvas.drawPath(this.mDragPath, this.mBadgeBackgroundPaint);
        if (this.mColorBackgroundBorder != 0 && this.mBackgroundBorderWidth > 0.0f) {
            float startY;
            float startX;
            this.mDragPath.reset();
            this.mDragPath.moveTo(this.mInnerTangentPoints.get((int)2).x, this.mInnerTangentPoints.get((int)2).y);
            this.mDragPath.quadTo(this.mControlPoint.x, this.mControlPoint.y, this.mInnerTangentPoints.get((int)0).x, this.mInnerTangentPoints.get((int)0).y);
            this.mDragPath.moveTo(this.mInnerTangentPoints.get((int)1).x, this.mInnerTangentPoints.get((int)1).y);
            this.mDragPath.quadTo(this.mControlPoint.x, this.mControlPoint.y, this.mInnerTangentPoints.get((int)3).x, this.mInnerTangentPoints.get((int)3).y);
            if (this.mDragQuadrant == 1 || this.mDragQuadrant == 2) {
                startX = this.mInnerTangentPoints.get((int)2).x - this.mRowBadgeCenter.x;
                startY = this.mRowBadgeCenter.y - this.mInnerTangentPoints.get((int)2).y;
            } else {
                startX = this.mInnerTangentPoints.get((int)3).x - this.mRowBadgeCenter.x;
                startY = this.mRowBadgeCenter.y - this.mInnerTangentPoints.get((int)3).y;
            }
            float startAngle = 360.0f - (float)MathUtils.radianToAngle(MathUtils.getTanRadian(Math.atan(startY / startX), this.mDragQuadrant - 1 == 0 ? 4 : this.mDragQuadrant - 1));
            if (Build.VERSION.SDK_INT >= 21) {
                this.mDragPath.addArc(this.mRowBadgeCenter.x - startRadius, this.mRowBadgeCenter.y - startRadius, this.mRowBadgeCenter.x + startRadius, this.mRowBadgeCenter.y + startRadius, startAngle, 180.0f);
            } else {
                this.mDragPath.addArc(new RectF(this.mRowBadgeCenter.x - startRadius, this.mRowBadgeCenter.y - startRadius, this.mRowBadgeCenter.x + startRadius, this.mRowBadgeCenter.y + startRadius), startAngle, 180.0f);
            }
            canvas.drawPath(this.mDragPath, this.mBadgeBackgroundBorderPaint);
        }
    }

    private void drawBadge(Canvas canvas, PointF center, float radius) {
        if (center.x == -1000.0f && center.y == -1000.0f) {
            return;
        }
        if (this.mBadgeText.isEmpty() || this.mBadgeText.length() == 1) {
            this.mBadgeBackgroundRect.left = center.x - (float)((int)radius);
            this.mBadgeBackgroundRect.top = center.y - (float)((int)radius);
            this.mBadgeBackgroundRect.right = center.x + (float)((int)radius);
            this.mBadgeBackgroundRect.bottom = center.y + (float)((int)radius);
            if (this.mDrawableBackground != null) {
                this.drawBadgeBackground(canvas);
            } else {
                canvas.drawCircle(center.x, center.y, radius, this.mBadgeBackgroundPaint);
                if (this.mColorBackgroundBorder != 0 && this.mBackgroundBorderWidth > 0.0f) {
                    canvas.drawCircle(center.x, center.y, radius, this.mBadgeBackgroundBorderPaint);
                }
            }
        } else {
            this.mBadgeBackgroundRect.left = center.x - (this.mBadgeTextRect.width() / 2.0f + this.mBadgePadding);
            this.mBadgeBackgroundRect.top = center.y - (this.mBadgeTextRect.height() / 2.0f + this.mBadgePadding * 0.5f);
            this.mBadgeBackgroundRect.right = center.x + (this.mBadgeTextRect.width() / 2.0f + this.mBadgePadding);
            this.mBadgeBackgroundRect.bottom = center.y + (this.mBadgeTextRect.height() / 2.0f + this.mBadgePadding * 0.5f);
            radius = this.mBadgeBackgroundRect.height() / 2.0f;
            if (this.mDrawableBackground != null) {
                this.drawBadgeBackground(canvas);
            } else {
                canvas.drawRoundRect(this.mBadgeBackgroundRect, radius, radius, this.mBadgeBackgroundPaint);
                if (this.mColorBackgroundBorder != 0 && this.mBackgroundBorderWidth > 0.0f) {
                    canvas.drawRoundRect(this.mBadgeBackgroundRect, radius, radius, this.mBadgeBackgroundBorderPaint);
                }
            }
        }
        if (!this.mBadgeText.isEmpty()) {
            canvas.drawText(this.mBadgeText, center.x, (this.mBadgeBackgroundRect.bottom + this.mBadgeBackgroundRect.top - this.mBadgeTextFontMetrics.bottom - this.mBadgeTextFontMetrics.top) / 2.0f, (Paint)this.mBadgeTextPaint);
        }
    }

    private void drawBadgeBackground(Canvas canvas) {
        this.mBadgeBackgroundPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        int left = (int)this.mBadgeBackgroundRect.left;
        int top = (int)this.mBadgeBackgroundRect.top;
        int right = (int)this.mBadgeBackgroundRect.right;
        int bottom = (int)this.mBadgeBackgroundRect.bottom;
        if (this.mDrawableBackgroundClip) {
            right = left + this.mBitmapClip.getWidth();
            bottom = top + this.mBitmapClip.getHeight();
            canvas.saveLayer((float)left, (float)top, (float)right, (float)bottom, null, 31);
        }
        this.mDrawableBackground.setBounds(left, top, right, bottom);
        this.mDrawableBackground.draw(canvas);
        if (this.mDrawableBackgroundClip) {
            this.mBadgeBackgroundPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
            canvas.drawBitmap(this.mBitmapClip, (float)left, (float)top, this.mBadgeBackgroundPaint);
            canvas.restore();
            this.mBadgeBackgroundPaint.setXfermode(null);
            if (this.mBadgeText.isEmpty() || this.mBadgeText.length() == 1) {
                canvas.drawCircle(this.mBadgeBackgroundRect.centerX(), this.mBadgeBackgroundRect.centerY(), this.mBadgeBackgroundRect.width() / 2.0f, this.mBadgeBackgroundBorderPaint);
            } else {
                canvas.drawRoundRect(this.mBadgeBackgroundRect, this.mBadgeBackgroundRect.height() / 2.0f, this.mBadgeBackgroundRect.height() / 2.0f, this.mBadgeBackgroundBorderPaint);
            }
        } else {
            canvas.drawRect(this.mBadgeBackgroundRect, this.mBadgeBackgroundBorderPaint);
        }
    }

    private void createClipLayer() {
        if (this.mBadgeText == null) {
            return;
        }
        if (!this.mDrawableBackgroundClip) {
            return;
        }
        if (this.mBitmapClip != null && !this.mBitmapClip.isRecycled()) {
            this.mBitmapClip.recycle();
        }
        float radius = this.getBadgeCircleRadius();
        if (this.mBadgeText.isEmpty() || this.mBadgeText.length() == 1) {
            this.mBitmapClip = Bitmap.createBitmap((int)((int)radius * 2), (int)((int)radius * 2), (Bitmap.Config)Bitmap.Config.ARGB_4444);
            Canvas srcCanvas = new Canvas(this.mBitmapClip);
            srcCanvas.drawCircle((float)srcCanvas.getWidth() / 2.0f, (float)srcCanvas.getHeight() / 2.0f, (float)srcCanvas.getWidth() / 2.0f, this.mBadgeBackgroundPaint);
        } else {
            this.mBitmapClip = Bitmap.createBitmap((int)((int)(this.mBadgeTextRect.width() + this.mBadgePadding * 2.0f)), (int)((int)(this.mBadgeTextRect.height() + this.mBadgePadding)), (Bitmap.Config)Bitmap.Config.ARGB_4444);
            Canvas srcCanvas = new Canvas(this.mBitmapClip);
            if (Build.VERSION.SDK_INT >= 21) {
                srcCanvas.drawRoundRect(0.0f, 0.0f, (float)srcCanvas.getWidth(), (float)srcCanvas.getHeight(), (float)srcCanvas.getHeight() / 2.0f, (float)srcCanvas.getHeight() / 2.0f, this.mBadgeBackgroundPaint);
            } else {
                srcCanvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)srcCanvas.getWidth(), (float)srcCanvas.getHeight()), (float)srcCanvas.getHeight() / 2.0f, (float)srcCanvas.getHeight() / 2.0f, this.mBadgeBackgroundPaint);
            }
        }
    }

    private float getBadgeCircleRadius() {
        if (this.mBadgeText.isEmpty()) {
            return this.mBadgePadding;
        }
        if (this.mBadgeText.length() == 1) {
            return this.mBadgeTextRect.height() > this.mBadgeTextRect.width() ? this.mBadgeTextRect.height() / 2.0f + this.mBadgePadding * 0.5f : this.mBadgeTextRect.width() / 2.0f + this.mBadgePadding * 0.5f;
        }
        return this.mBadgeBackgroundRect.height() / 2.0f;
    }

    private void findBadgeCenter() {
        float rectWidth = Math.max(this.mBadgeTextRect.height(), this.mBadgeTextRect.width());
        switch (this.mBadgeGravity) {
            case 0x800033: {
                this.mBadgeCenter.x = this.mGravityOffsetX + this.mBadgePadding + rectWidth / 2.0f;
                this.mBadgeCenter.y = this.mGravityOffsetY + this.mBadgePadding + this.mBadgeTextRect.height() / 2.0f;
                break;
            }
            case 8388691: {
                this.mBadgeCenter.x = this.mGravityOffsetX + this.mBadgePadding + rectWidth / 2.0f;
                this.mBadgeCenter.y = (float)this.mHeight - (this.mGravityOffsetY + this.mBadgePadding + this.mBadgeTextRect.height() / 2.0f);
                break;
            }
            case 8388661: {
                this.mBadgeCenter.x = (float)this.mWidth - (this.mGravityOffsetX + this.mBadgePadding + rectWidth / 2.0f);
                this.mBadgeCenter.y = this.mGravityOffsetY + this.mBadgePadding + this.mBadgeTextRect.height() / 2.0f;
                break;
            }
            case 0x800055: {
                this.mBadgeCenter.x = (float)this.mWidth - (this.mGravityOffsetX + this.mBadgePadding + rectWidth / 2.0f);
                this.mBadgeCenter.y = (float)this.mHeight - (this.mGravityOffsetY + this.mBadgePadding + this.mBadgeTextRect.height() / 2.0f);
                break;
            }
            case 17: {
                this.mBadgeCenter.x = (float)this.mWidth / 2.0f;
                this.mBadgeCenter.y = (float)this.mHeight / 2.0f;
                break;
            }
            case 49: {
                this.mBadgeCenter.x = (float)this.mWidth / 2.0f;
                this.mBadgeCenter.y = this.mGravityOffsetY + this.mBadgePadding + this.mBadgeTextRect.height() / 2.0f;
                break;
            }
            case 81: {
                this.mBadgeCenter.x = (float)this.mWidth / 2.0f;
                this.mBadgeCenter.y = (float)this.mHeight - (this.mGravityOffsetY + this.mBadgePadding + this.mBadgeTextRect.height() / 2.0f);
                break;
            }
            case 8388627: {
                this.mBadgeCenter.x = this.mGravityOffsetX + this.mBadgePadding + rectWidth / 2.0f;
                this.mBadgeCenter.y = (float)this.mHeight / 2.0f;
                break;
            }
            case 8388629: {
                this.mBadgeCenter.x = (float)this.mWidth - (this.mGravityOffsetX + this.mBadgePadding + rectWidth / 2.0f);
                this.mBadgeCenter.y = (float)this.mHeight / 2.0f;
                break;
            }
        }
        this.initRowBadgeCenter();
    }

    private void measureText() {
        this.mBadgeTextRect.left = 0.0f;
        this.mBadgeTextRect.top = 0.0f;
        if (TextUtils.isEmpty((CharSequence)this.mBadgeText)) {
            this.mBadgeTextRect.right = 0.0f;
            this.mBadgeTextRect.bottom = 0.0f;
        } else {
            this.mBadgeTextPaint.setTextSize(this.mBadgeTextSize);
            this.mBadgeTextRect.right = this.mBadgeTextPaint.measureText(this.mBadgeText);
            this.mBadgeTextFontMetrics = this.mBadgeTextPaint.getFontMetrics();
            this.mBadgeTextRect.bottom = this.mBadgeTextFontMetrics.descent - this.mBadgeTextFontMetrics.ascent;
        }
        this.createClipLayer();
    }

    private void initRowBadgeCenter() {
        int[] screenPoint = new int[2];
        this.getLocationOnScreen(screenPoint);
        this.mRowBadgeCenter.x = this.mBadgeCenter.x + (float)screenPoint[0];
        this.mRowBadgeCenter.y = this.mBadgeCenter.y + (float)screenPoint[1];
    }

    protected void animateHide(PointF center) {
        if (this.mBadgeText == null) {
            return;
        }
        if (this.mAnimator == null || !this.mAnimator.isRunning()) {
            this.screenFromWindow(true);
            this.mAnimator = new BadgeAnimator(this.createBadgeBitmap(), center, this);
            this.mAnimator.start();
            this.setBadgeNumber(0);
        }
    }

    public void reset() {
        this.mDragCenter.x = -1000.0f;
        this.mDragCenter.y = -1000.0f;
        this.mDragQuadrant = 4;
        this.screenFromWindow(false);
        this.getParent().requestDisallowInterceptTouchEvent(false);
        this.invalidate();
    }

    @Override
    public void hide(boolean animate) {
        if (animate && this.mActivityRoot != null) {
            this.initRowBadgeCenter();
            this.animateHide(this.mRowBadgeCenter);
        } else {
            this.setBadgeNumber(0);
        }
    }

    @Override
    public Badge setBadgeNumber(int badgeNumber) {
        this.mBadgeNumber = badgeNumber;
        this.mBadgeText = this.mBadgeNumber < 0 ? "" : (this.mBadgeNumber > 99 ? (this.mExact ? String.valueOf(this.mBadgeNumber) : "99+") : (this.mBadgeNumber > 0 ? String.valueOf(this.mBadgeNumber) : null));
        this.measureText();
        this.invalidate();
        return this;
    }

    @Override
    public int getBadgeNumber() {
        return this.mBadgeNumber;
    }

    @Override
    public Badge setBadgeText(String badgeText) {
        this.mBadgeText = badgeText;
        this.mBadgeNumber = 1;
        this.measureText();
        this.invalidate();
        return this;
    }

    @Override
    public String getBadgeText() {
        return this.mBadgeText;
    }

    @Override
    public Badge setExactMode(boolean isExact) {
        this.mExact = isExact;
        if (this.mBadgeNumber > 99) {
            this.setBadgeNumber(this.mBadgeNumber);
        }
        return this;
    }

    @Override
    public boolean isExactMode() {
        return this.mExact;
    }

    @Override
    public Badge setShowShadow(boolean showShadow) {
        this.mShowShadow = showShadow;
        this.invalidate();
        return this;
    }

    @Override
    public boolean isShowShadow() {
        return this.mShowShadow;
    }

    @Override
    public Badge setBadgeBackgroundColor(int color2) {
        this.mColorBackground = color2;
        if (this.mColorBackground == 0) {
            this.mBadgeTextPaint.setXfermode(null);
        } else {
            this.mBadgeTextPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        }
        this.invalidate();
        return this;
    }

    @Override
    public Badge stroke(int color2, float width, boolean isDpValue) {
        this.mColorBackgroundBorder = color2;
        this.mBackgroundBorderWidth = isDpValue ? (float)DensityUtils.dp2px(this.getContext(), width) : width;
        this.invalidate();
        return this;
    }

    @Override
    public int getBadgeBackgroundColor() {
        return this.mColorBackground;
    }

    @Override
    public Badge setBadgeBackground(Drawable drawable2) {
        return this.setBadgeBackground(drawable2, false);
    }

    @Override
    public Badge setBadgeBackground(Drawable drawable2, boolean clip) {
        this.mDrawableBackgroundClip = clip;
        this.mDrawableBackground = drawable2;
        this.createClipLayer();
        this.invalidate();
        return this;
    }

    @Override
    public Drawable getBadgeBackground() {
        return this.mDrawableBackground;
    }

    @Override
    public Badge setBadgeTextColor(int color2) {
        this.mColorBadgeText = color2;
        this.invalidate();
        return this;
    }

    @Override
    public int getBadgeTextColor() {
        return this.mColorBadgeText;
    }

    @Override
    public Badge setBadgeTextSize(float size, boolean isSpValue) {
        this.mBadgeTextSize = isSpValue ? (float)DensityUtils.dp2px(this.getContext(), size) : size;
        this.measureText();
        this.invalidate();
        return this;
    }

    @Override
    public float getBadgeTextSize(boolean isSpValue) {
        return isSpValue ? (float)DensityUtils.px2dp(this.getContext(), this.mBadgeTextSize) : this.mBadgeTextSize;
    }

    @Override
    public Badge setBadgePadding(float padding, boolean isDpValue) {
        this.mBadgePadding = isDpValue ? (float)DensityUtils.dp2px(this.getContext(), padding) : padding;
        this.createClipLayer();
        this.invalidate();
        return this;
    }

    @Override
    public float getBadgePadding(boolean isDpValue) {
        return isDpValue ? (float)DensityUtils.px2dp(this.getContext(), this.mBadgePadding) : this.mBadgePadding;
    }

    @Override
    public boolean isDraggable() {
        return this.mDraggable;
    }

    @Override
    public Badge setBadgeGravity(int gravity) {
        if (gravity != 0x800033 && gravity != 8388661 && gravity != 8388691 && gravity != 0x800055 && gravity != 17 && gravity != 49 && gravity != 81 && gravity != 8388627 && gravity != 8388629) {
            throw new IllegalStateException("only support Gravity.START | Gravity.TOP , Gravity.END | Gravity.TOP , Gravity.START | Gravity.BOTTOM , Gravity.END | Gravity.BOTTOM , Gravity.CENTER , Gravity.CENTER | Gravity.TOP , Gravity.CENTER | Gravity.BOTTOM ,Gravity.CENTER | Gravity.START , Gravity.CENTER | Gravity.END");
        }
        this.mBadgeGravity = gravity;
        this.invalidate();
        return this;
    }

    @Override
    public int getBadgeGravity() {
        return this.mBadgeGravity;
    }

    @Override
    public Badge setGravityOffset(float offset, boolean isDpValue) {
        return this.setGravityOffset(offset, offset, isDpValue);
    }

    @Override
    public Badge setGravityOffset(float offsetX, float offsetY, boolean isDpValue) {
        this.mGravityOffsetX = isDpValue ? (float)DensityUtils.dp2px(this.getContext(), offsetX) : offsetX;
        this.mGravityOffsetY = isDpValue ? (float)DensityUtils.dp2px(this.getContext(), offsetY) : offsetY;
        this.invalidate();
        return this;
    }

    @Override
    public float getGravityOffsetX(boolean isDpValue) {
        return isDpValue ? (float)DensityUtils.px2dp(this.getContext(), this.mGravityOffsetX) : this.mGravityOffsetX;
    }

    @Override
    public float getGravityOffsetY(boolean isDpValue) {
        return isDpValue ? (float)DensityUtils.px2dp(this.getContext(), this.mGravityOffsetY) : this.mGravityOffsetY;
    }

    private void updateListener(int state) {
        if (this.mDragStateChangedListener != null) {
            this.mDragStateChangedListener.onDragStateChanged(state, this, this.mTargetView);
        }
    }

    @Override
    public Badge setOnDragStateChangedListener(Badge.OnDragStateChangedListener l) {
        this.mDraggable = l != null;
        this.mDragStateChangedListener = l;
        return this;
    }

    @Override
    public PointF getDragCenter() {
        if (this.mDraggable && this.mDragging) {
            return this.mDragCenter;
        }
        return null;
    }

    private static class BadgeContainer
    extends ViewGroup {
        protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
            if (!(this.getParent() instanceof RelativeLayout)) {
                super.dispatchRestoreInstanceState(container);
            }
        }

        public BadgeContainer(Context context) {
            super(context);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                child.layout(0, 0, child.getMeasuredWidth(), child.getMeasuredHeight());
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            View targetView = null;
            View badgeView = null;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (!(child instanceof BadgeView)) {
                    targetView = child;
                    continue;
                }
                badgeView = child;
            }
            if (targetView == null) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            } else {
                targetView.measure(widthMeasureSpec, heightMeasureSpec);
                if (badgeView != null) {
                    badgeView.measure(View.MeasureSpec.makeMeasureSpec((int)targetView.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)targetView.getMeasuredHeight(), (int)0x40000000));
                }
                this.setMeasuredDimension(targetView.getMeasuredWidth(), targetView.getMeasuredHeight());
            }
        }
    }
}

