/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.badge;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import com.xuexiang.xui.widget.textview.badge.BadgeView;
import java.lang.ref.WeakReference;
import java.util.Random;

public class BadgeAnimator
extends ValueAnimator {
    private BitmapFragment[][] mFragments;
    private WeakReference<BadgeView> mWeakBadge;

    public BadgeAnimator(Bitmap badgeBitmap, PointF center, BadgeView badge) {
        this.mWeakBadge = new WeakReference<BadgeView>(badge);
        this.setFloatValues(new float[]{0.0f, 1.0f});
        this.setDuration(500L);
        this.mFragments = this.getFragments(badgeBitmap, center);
        this.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BadgeView badgeView = (BadgeView)BadgeAnimator.this.mWeakBadge.get();
                if (badgeView == null || !badgeView.isShown()) {
                    BadgeAnimator.this.cancel();
                } else {
                    badgeView.invalidate();
                }
            }
        });
        this.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BadgeView badgeView = (BadgeView)BadgeAnimator.this.mWeakBadge.get();
                if (badgeView != null) {
                    badgeView.reset();
                }
            }
        });
    }

    public void draw(Canvas canvas) {
        BitmapFragment[][] bitmapFragmentArray = this.mFragments;
        int n = bitmapFragmentArray.length;
        for (int i = 0; i < n; ++i) {
            BitmapFragment[] mFragment;
            for (BitmapFragment bf : mFragment = bitmapFragmentArray[i]) {
                float value = Float.parseFloat(this.getAnimatedValue().toString());
                bf.update(value, canvas);
            }
        }
    }

    private BitmapFragment[][] getFragments(Bitmap badgeBitmap, PointF center) {
        int width = badgeBitmap.getWidth();
        int height = badgeBitmap.getHeight();
        float fragmentSize = (float)Math.min(width, height) / 6.0f;
        float startX = center.x - (float)badgeBitmap.getWidth() / 2.0f;
        float startY = center.y - (float)badgeBitmap.getHeight() / 2.0f;
        BitmapFragment[][] fragments = new BitmapFragment[(int)((float)height / fragmentSize)][(int)((float)width / fragmentSize)];
        for (int i = 0; i < fragments.length; ++i) {
            for (int j = 0; j < fragments[i].length; ++j) {
                BitmapFragment bf = new BitmapFragment();
                bf.color = badgeBitmap.getPixel((int)((float)j * fragmentSize), (int)((float)i * fragmentSize));
                bf.x = startX + (float)j * fragmentSize;
                bf.y = startY + (float)i * fragmentSize;
                bf.size = fragmentSize;
                bf.maxSize = Math.max(width, height);
                fragments[i][j] = bf;
            }
        }
        badgeBitmap.recycle();
        return fragments;
    }

    private static class BitmapFragment {
        Random random;
        float x;
        float y;
        float size;
        int color;
        int maxSize;
        Paint paint = new Paint();

        public BitmapFragment() {
            this.paint.setAntiAlias(true);
            this.paint.setStyle(Paint.Style.FILL);
            this.random = new Random();
        }

        public void update(float value, Canvas canvas) {
            this.paint.setColor(this.color);
            this.x += 0.1f * (float)this.random.nextInt(this.maxSize) * (this.random.nextFloat() - 0.5f);
            this.y += 0.1f * (float)this.random.nextInt(this.maxSize) * (this.random.nextFloat() - 0.5f);
            canvas.drawCircle(this.x, this.y, this.size - value * this.size, this.paint);
        }
    }
}

