/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ThemeUtils;

public class ReadMoreTextView
extends AppCompatTextView {
    private static final int TRIM_MODE_LINES = 0;
    private static final int TRIM_MODE_LENGTH = 1;
    private static final int DEFAULT_TRIM_LENGTH = 240;
    private static final int DEFAULT_TRIM_LINES = 2;
    private static final int INVALID_END_INDEX = -1;
    private static final boolean DEFAULT_SHOW_TRIM_EXPANDED_TEXT = true;
    private CharSequence text;
    private TextView.BufferType bufferType;
    private boolean readMore = true;
    private CharSequence trimCollapsedText;
    private CharSequence trimExpandedText;
    private CharSequence ellipsizeText;
    private ReadMoreClickableSpan viewMoreSpan;
    private int colorClickableText;
    private boolean showTrimExpandedText;
    private int trimMode;
    private int trimLength;
    private int trimLines;
    private int lineEndIndex;

    public ReadMoreTextView(Context context) {
        this(context, null);
    }

    public ReadMoreTextView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.ReadMoreTextViewStyle);
    }

    public ReadMoreTextView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ReadMoreTextView, defStyleAttr, 0);
        this.trimLength = typedArray.getInt(R.styleable.ReadMoreTextView_rmtv_trimLength, 240);
        this.trimCollapsedText = typedArray.getString(R.styleable.ReadMoreTextView_rmtv_trimCollapsedText);
        this.trimExpandedText = typedArray.getString(R.styleable.ReadMoreTextView_rmtv_trimExpandedText);
        this.ellipsizeText = typedArray.getString(R.styleable.ReadMoreTextView_rmtv_ellipsize);
        if (TextUtils.isEmpty((CharSequence)this.trimCollapsedText)) {
            this.trimCollapsedText = context.getString(R.string.xui_rmtv_show_more);
        }
        if (TextUtils.isEmpty((CharSequence)this.trimExpandedText)) {
            this.trimExpandedText = context.getString(R.string.xui_rmtv_show_less);
        }
        if (TextUtils.isEmpty((CharSequence)this.ellipsizeText)) {
            this.ellipsizeText = context.getString(R.string.xui_rmtv_ellipsize);
        }
        this.trimLines = typedArray.getInt(R.styleable.ReadMoreTextView_rmtv_trimLines, 2);
        this.colorClickableText = typedArray.getColor(R.styleable.ReadMoreTextView_rmtv_colorClickableText, ThemeUtils.resolveColor(context, R.attr.colorAccent));
        this.showTrimExpandedText = typedArray.getBoolean(R.styleable.ReadMoreTextView_rmtv_showTrimExpandedText, true);
        this.trimMode = typedArray.getInt(R.styleable.ReadMoreTextView_rmtv_trimMode, 0);
        typedArray.recycle();
        this.viewMoreSpan = new ReadMoreClickableSpan();
        this.onGlobalLayoutLineEndIndex();
        this.setText();
    }

    private void setText() {
        super.setText(this.getDisplayableText(), this.bufferType);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setHighlightColor(0);
    }

    private CharSequence getDisplayableText() {
        return this.getTrimmedText(this.text);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.text = text;
        this.bufferType = type;
        this.setText();
    }

    private CharSequence getTrimmedText(CharSequence text) {
        if (this.trimMode == 1 && text != null && text.length() > this.trimLength) {
            if (this.readMore) {
                return this.updateCollapsedText();
            }
            return this.updateExpandedText();
        }
        if (this.trimMode == 0 && text != null && this.lineEndIndex > 0) {
            if (this.readMore) {
                if (this.getLayout().getLineCount() > this.trimLines) {
                    return this.updateCollapsedText();
                }
            } else {
                return this.updateExpandedText();
            }
        }
        return text;
    }

    private CharSequence updateCollapsedText() {
        int trimEndIndex = this.text.length();
        switch (this.trimMode) {
            case 0: {
                trimEndIndex = this.lineEndIndex - (this.ellipsizeText.length() + this.trimCollapsedText.length() + 1);
                if (trimEndIndex >= 0) break;
                trimEndIndex = this.trimLength + 1;
                break;
            }
            case 1: {
                trimEndIndex = this.trimLength + 1;
                break;
            }
        }
        SpannableStringBuilder s = new SpannableStringBuilder(this.text, 0, trimEndIndex).append(this.ellipsizeText).append(this.trimCollapsedText);
        return this.addClickableSpan(s, this.trimCollapsedText);
    }

    private CharSequence updateExpandedText() {
        if (this.showTrimExpandedText) {
            SpannableStringBuilder s = new SpannableStringBuilder(this.text, 0, this.text.length()).append(this.trimExpandedText);
            return this.addClickableSpan(s, this.trimExpandedText);
        }
        return this.text;
    }

    private CharSequence addClickableSpan(SpannableStringBuilder s, CharSequence trimText) {
        s.setSpan((Object)this.viewMoreSpan, s.length() - trimText.length(), s.length(), 33);
        return s;
    }

    public void setTrimLength(int trimLength) {
        this.trimLength = trimLength;
        this.setText();
    }

    public void setColorClickableText(int colorClickableText) {
        this.colorClickableText = colorClickableText;
    }

    public void setTrimCollapsedText(CharSequence trimCollapsedText) {
        this.trimCollapsedText = trimCollapsedText;
    }

    public void setTrimExpandedText(CharSequence trimExpandedText) {
        this.trimExpandedText = trimExpandedText;
    }

    public void setTrimMode(int trimMode) {
        this.trimMode = trimMode;
    }

    public void setTrimLines(int trimLines) {
        this.trimLines = trimLines;
    }

    private void onGlobalLayoutLineEndIndex() {
        if (this.trimMode == 0) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    ViewTreeObserver obs = ReadMoreTextView.this.getViewTreeObserver();
                    obs.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    ReadMoreTextView.this.refreshLineEndIndex();
                    ReadMoreTextView.this.setText();
                }
            });
        }
    }

    private void refreshLineEndIndex() {
        try {
            this.lineEndIndex = this.trimLines == 0 ? this.getLayout().getLineEnd(0) : (this.trimLines > 0 && this.getLineCount() >= this.trimLines ? this.getLayout().getLineEnd(this.trimLines - 1) : -1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ReadMoreClickableSpan
    extends ClickableSpan {
        private ReadMoreClickableSpan() {
        }

        public void onClick(@NonNull View widget) {
            ReadMoreTextView.this.readMore = !ReadMoreTextView.this.readMore;
            ReadMoreTextView.this.setText();
        }

        public void updateDrawState(TextPaint ds) {
            ds.setColor(ReadMoreTextView.this.colorClickableText);
        }
    }
}

