/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.textview.marqueen.DisplayEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MarqueeTextView
extends AppCompatTextView {
    private static final int REDRAW_TEXT = 1;
    private int mBaseline;
    private boolean mStopMarquee;
    private List<DisplayEntity> mDisplayList = new ArrayList<DisplayEntity>();
    private int mCurrentIndex = 0;
    private DisplayEntity mShowDisplayEntity;
    private float mDisplayTextWidth;
    private float mCurrentPosition;
    private int mScrollWidth;
    private int mSpeed = 3;
    private boolean mIsRolling = false;
    private boolean mIsAutoFit;
    private boolean mIsAutoDisplay;
    private OnMarqueeListener mOnMarqueeListener;
    private final Object mLock = new Object();
    private final Handler mHandler = new Handler(new Handler.Callback(){

        public boolean handleMessage(@NonNull Message message) {
            if (message.what == 1) {
                if (MarqueeTextView.this.mCurrentPosition < -MarqueeTextView.this.mDisplayTextWidth) {
                    MarqueeTextView.this.rollNextDisplay();
                } else {
                    MarqueeTextView.this.mCurrentPosition = MarqueeTextView.this.mCurrentPosition - (float)MarqueeTextView.this.mSpeed;
                    MarqueeTextView.this.reDraw(30);
                }
            }
            return true;
        }
    });

    public MarqueeTextView(@NonNull Context context) {
        this(context, null);
    }

    public MarqueeTextView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.MarqueeTextViewStyle);
    }

    public MarqueeTextView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MarqueeTextView, defStyleAttr, 0);
        this.mIsAutoFit = typedArray.getBoolean(R.styleable.MarqueeTextView_mtv_isAutoFit, false);
        this.mIsAutoDisplay = typedArray.getBoolean(R.styleable.MarqueeTextView_mtv_isAutoDisplay, false);
        int entriesId = typedArray.getResourceId(R.styleable.MarqueeTextView_mtv_entries, 0);
        typedArray.recycle();
        List<String> initData = ResUtils.getStringList(context, entriesId);
        this.startSimpleRoll(initData);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mIsAutoFit) {
            this.measureView();
        }
    }

    public MarqueeTextView measureView() {
        this.mCurrentPosition = this.getWidth();
        this.mScrollWidth = this.getWidth();
        this.mBaseline = this.calculateBaseLine();
        return this;
    }

    public MarqueeTextView startRoll(List<DisplayEntity> list) {
        return this.setDisplayList(list).startRoll();
    }

    public MarqueeTextView startSimpleRoll(List<String> list) {
        return this.setDisplaySimpleList(list).startRoll();
    }

    public MarqueeTextView setDisplayList(List<DisplayEntity> list) {
        if (list != null && list.size() > 0) {
            this.mDisplayList.clear();
            this.mDisplayList.addAll(list);
        }
        return this;
    }

    public MarqueeTextView setDisplaySimpleList(List<String> list) {
        if (list != null && list.size() > 0) {
            this.mDisplayList.clear();
            for (String message : list) {
                if (TextUtils.isEmpty((CharSequence)message)) continue;
                this.mDisplayList.add(new DisplayEntity(message));
            }
        }
        return this;
    }

    public boolean addDisplayString(String displayString) {
        return this.addDisplayEntity(new DisplayEntity(displayString));
    }

    public boolean addDisplayEntity(DisplayEntity displayEntity) {
        boolean result = false;
        if (displayEntity != null && displayEntity.isValid()) {
            if (this.mDisplayList == null) {
                this.mDisplayList = new ArrayList<DisplayEntity>();
            }
            result = this.addEntity(displayEntity);
            if (!this.mIsRolling) {
                this.startRoll();
            }
        }
        return result;
    }

    private boolean addEntity(DisplayEntity displayEntity) {
        if (TextUtils.isEmpty((CharSequence)displayEntity.getID())) {
            return this.mDisplayList.add(displayEntity);
        }
        boolean result = false;
        boolean isFindSameID = false;
        for (int i = 0; i < this.mDisplayList.size(); ++i) {
            if (!displayEntity.getID().equals(this.mDisplayList.get(i).getID())) continue;
            this.mDisplayList.set(i, displayEntity);
            isFindSameID = true;
            result = true;
            break;
        }
        if (!isFindSameID) {
            result = this.mDisplayList.add(displayEntity);
        }
        return result;
    }

    public MarqueeTextView startRoll() {
        this.initRoll();
        return this;
    }

    public boolean removeDisplayString(String displayString) {
        return this.removeDisplayEntity(new DisplayEntity(displayString));
    }

    public boolean removeDisplayEntity(DisplayEntity displayEntity) {
        if (displayEntity != null && displayEntity.isValid()) {
            if (this.isRollingDisplayEntity(displayEntity)) {
                if (this.mCurrentIndex <= this.mDisplayList.size() - 1) {
                    this.mDisplayList.remove(this.mCurrentIndex);
                    this.rollDisplayByIndex(this.mCurrentIndex);
                    return true;
                }
                this.rollDisplayByIndex(this.mCurrentIndex);
                return false;
            }
            return this.removeByDisplayEntity(displayEntity);
        }
        return false;
    }

    private boolean isRollingDisplayEntity(DisplayEntity displayEntity) {
        if (!this.mIsRolling || this.mShowDisplayEntity == null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)displayEntity.getID())) {
            return displayEntity.getMessage().equals(this.mShowDisplayEntity.getMessage());
        }
        return displayEntity.getID().equals(this.mShowDisplayEntity.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeByDisplayEntity(DisplayEntity displayEntity) {
        if (this.getDisplaySize() > 0) {
            Iterator<DisplayEntity> it = this.mDisplayList.iterator();
            Object object = this.mLock;
            synchronized (object) {
                while (it.hasNext()) {
                    DisplayEntity matchEntity = it.next();
                    if (TextUtils.isEmpty((CharSequence)displayEntity.getID())) {
                        if (!displayEntity.getMessage().equals(matchEntity.getMessage())) continue;
                        it.remove();
                        return true;
                    }
                    if (!displayEntity.getID().equals(matchEntity.getID())) continue;
                    it.remove();
                    return true;
                }
            }
        }
        return false;
    }

    private void updateDisplayText(DisplayEntity displayEntity) {
        if (displayEntity != null) {
            if (this.mOnMarqueeListener != null) {
                DisplayEntity temp = this.mOnMarqueeListener.onStartMarquee(displayEntity, this.mCurrentIndex);
                if (temp != null && temp.isValid()) {
                    displayEntity = temp;
                    this.mDisplayList.set(this.mCurrentIndex, displayEntity);
                } else {
                    if (this.mCurrentIndex <= this.mDisplayList.size() - 1) {
                        this.mDisplayList.remove(this.mCurrentIndex);
                    }
                    this.rollDisplayByIndex(this.mCurrentIndex);
                    return;
                }
            }
            this.showDisplayEntity(displayEntity);
        } else {
            this.rollNextDisplay();
        }
    }

    private void showDisplayEntity(DisplayEntity displayEntity) {
        this.mShowDisplayEntity = displayEntity;
        this.mDisplayTextWidth = this.getPaint().measureText(this.mShowDisplayEntity.toString());
        this.mCurrentPosition = this.mScrollWidth;
        if (this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        }
        if (!this.mStopMarquee) {
            this.mHandler.sendEmptyMessageDelayed(1, 500L);
        } else {
            this.mIsRolling = false;
        }
    }

    protected void onAttachedToWindow() {
        this.mStopMarquee = false;
        if (!this.isShowDisplayEntityValid()) {
            this.mIsRolling = false;
        }
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        this.mStopMarquee = true;
        this.mIsRolling = false;
        if (this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        }
        super.onDetachedFromWindow();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isShowDisplayEntityValid()) {
            this.mBaseline = this.calculateBaseLine();
            canvas.drawText(this.mShowDisplayEntity.toString(), this.mCurrentPosition, (float)this.mBaseline, (Paint)this.getPaint());
            this.mIsRolling = true;
        }
    }

    private boolean isShowDisplayEntityValid() {
        return this.mShowDisplayEntity != null && this.mShowDisplayEntity.isValid();
    }

    private int calculateBaseLine() {
        Paint.FontMetricsInt fontMetrics = this.getPaint().getFontMetricsInt();
        return (this.getHeight() - fontMetrics.bottom - fontMetrics.top) / 2;
    }

    private void rollNextDisplay() {
        ++this.mCurrentIndex;
        this.rollDisplayByIndex(this.mCurrentIndex);
    }

    private void rollDisplayByIndex(int index) {
        if (index <= this.mDisplayList.size() - 1) {
            this.updateDisplayText(this.getDisplayItem(index));
        } else {
            this.handleRollFinished();
        }
    }

    private void handleRollFinished() {
        if (this.mOnMarqueeListener == null || this.onMarqueeFinished()) {
            this.initRoll();
        } else {
            this.mIsRolling = false;
        }
    }

    private boolean onMarqueeFinished() {
        List<DisplayEntity> tmp = this.mOnMarqueeListener.onMarqueeFinished(this.mDisplayList);
        if (tmp != null) {
            this.mDisplayList = tmp;
            return true;
        }
        return false;
    }

    private void initRoll() {
        if (this.mDisplayList != null && this.mDisplayList.size() > 0) {
            if (this.mIsAutoDisplay) {
                this.setVisibility(0);
            }
            this.mCurrentIndex = 0;
            this.updateDisplayText(this.getDisplayItem(this.mCurrentIndex));
        } else {
            if (this.mIsAutoDisplay) {
                this.setVisibility(8);
            }
            this.mIsRolling = false;
        }
    }

    private void reDraw(int delayMillis) {
        this.invalidate();
        if (!this.mStopMarquee && this.mHandler != null) {
            this.mHandler.sendEmptyMessageDelayed(1, (long)delayMillis);
        } else {
            this.mIsRolling = false;
        }
    }

    public MarqueeTextView setViewWidth(int viewWidth) {
        this.mCurrentPosition = viewWidth;
        this.mScrollWidth = viewWidth;
        return this;
    }

    public float getCurrentPosition() {
        return this.mCurrentPosition;
    }

    public MarqueeTextView setCurrentPosition(float coordinateX) {
        this.mCurrentPosition = coordinateX;
        return this;
    }

    public int getScrollWidth() {
        return this.mScrollWidth;
    }

    public MarqueeTextView setScrollWidth(int scrollWidth) {
        this.mScrollWidth = scrollWidth;
        return this;
    }

    public int getSpeed() {
        return this.mSpeed;
    }

    public MarqueeTextView setSpeed(int speed) {
        this.mSpeed = speed;
        return this;
    }

    public boolean isRolling() {
        return this.mIsRolling;
    }

    public int getCurrentIndex() {
        return this.mCurrentIndex;
    }

    public DisplayEntity getShowDisplayEntity() {
        return this.mShowDisplayEntity;
    }

    public List<DisplayEntity> getDisplayList() {
        return this.mDisplayList;
    }

    public int getDisplaySize() {
        return this.mDisplayList != null ? this.mDisplayList.size() : 0;
    }

    public boolean hasDisplayMessage() {
        return this.getDisplaySize() > 0;
    }

    public DisplayEntity getDisplayItem(int index) {
        if (this.mDisplayList != null && index >= 0 && index <= this.mDisplayList.size() - 1) {
            return this.mDisplayList.get(index);
        }
        return null;
    }

    public void clear() {
        this.mIsRolling = false;
        if (this.mDisplayList != null && this.mDisplayList.size() > 0) {
            this.mDisplayList.clear();
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        if (this.mIsAutoDisplay) {
            this.setVisibility(8);
        }
    }

    public MarqueeTextView setOnMarqueeListener(OnMarqueeListener listener) {
        this.mOnMarqueeListener = listener;
        return this;
    }

    public static interface OnMarqueeListener {
        public DisplayEntity onStartMarquee(DisplayEntity var1, int var2);

        public List<DisplayEntity> onMarqueeFinished(List<DisplayEntity> var1);
    }
}

