/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview;

import android.content.Context;
import android.os.Looper;
import android.text.Layout;
import android.text.SpannableString;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;

public class LoggerTextView
extends AppCompatTextView {
    private ILogFormatter mLogFormatter = new DefaultLogFormatter();
    private ILogDecorator mLogDecorator = new DefaultLogDecorator();

    public LoggerTextView(Context context) {
        this(context, null);
    }

    public LoggerTextView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.LoggerTextViewStyle);
    }

    public LoggerTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
    }

    public LoggerTextView setLogFormatter(@NonNull ILogFormatter logFormatter) {
        this.mLogFormatter = logFormatter;
        return this;
    }

    public LoggerTextView setLogDecorator(@NonNull ILogDecorator logDecorator) {
        this.mLogDecorator = logDecorator;
        return this;
    }

    public void logNormal(String logContent) {
        this.addLog(logContent, LogType.NORMAL);
    }

    public void logSuccess(String logContent) {
        this.addLog(logContent, LogType.SUCCESS);
    }

    public void logError(String logContent) {
        this.addLog(logContent, LogType.ERROR);
    }

    public void logWarning(String logContent) {
        this.addLog(logContent, LogType.WARNING);
    }

    public void logCustom(String logContent) {
        this.addLog(logContent, LogType.CUSTOM);
    }

    public void addLog(String logContent, LogType logType) {
        SpannableString spannableString = this.getLogDecorator().decorate(this.getContext(), this.getLogFormatter().format(logContent, logType), logType);
        this.appendLogInMainThread(spannableString);
    }

    private void appendLogInMainThread(final SpannableString spannableString) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.appendLog(spannableString);
        } else {
            this.post(new Runnable(){

                @Override
                public void run() {
                    LoggerTextView.this.appendLog(spannableString);
                }
            });
        }
    }

    public ILogDecorator getLogDecorator() {
        if (this.mLogDecorator == null) {
            this.mLogDecorator = new DefaultLogDecorator();
        }
        return this.mLogDecorator;
    }

    public ILogFormatter getLogFormatter() {
        if (this.mLogFormatter == null) {
            this.mLogFormatter = new DefaultLogFormatter();
        }
        return this.mLogFormatter;
    }

    private void appendLog(SpannableString spannableString) {
        this.append((CharSequence)spannableString);
        this.append("\r\n");
        this.scrollToEnd();
    }

    private void scrollToEnd() {
        int offset = this.getTextRealHeight();
        if (offset > this.getHeight()) {
            this.scrollTo(0, offset - this.getHeight());
        }
    }

    private int getTextRealHeight() {
        Layout layout2 = this.getLayout();
        return (layout2 != null ? layout2.getLineTop(this.getLineCount()) : 0) + this.getCompoundPaddingTop() + this.getCompoundPaddingBottom();
    }

    public void clearLog() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.setText("");
            this.scrollTo(0, 0);
        } else {
            this.post(new Runnable(){

                @Override
                public void run() {
                    LoggerTextView.this.setText("");
                    LoggerTextView.this.scrollTo(0, 0);
                }
            });
        }
    }

    public static enum LogType {
        NORMAL,
        SUCCESS,
        ERROR,
        WARNING,
        CUSTOM;

    }

    public static interface ILogDecorator {
        public SpannableString decorate(Context var1, String var2, LogType var3);
    }

    public static class DefaultLogDecorator
    implements ILogDecorator {
        @Override
        public SpannableString decorate(@NonNull Context context, String logContent, LogType logType) {
            SpannableString spannableString = new SpannableString((CharSequence)logContent);
            switch (logType) {
                case ERROR: {
                    spannableString.setSpan((Object)new ForegroundColorSpan(ResUtils.getColor(context, R.color.xui_config_color_error)), 0, logContent.length(), 33);
                    break;
                }
                case SUCCESS: {
                    spannableString.setSpan((Object)new ForegroundColorSpan(ResUtils.getColor(context, R.color.xui_config_color_success)), 0, logContent.length(), 33);
                    break;
                }
                case WARNING: {
                    spannableString.setSpan((Object)new ForegroundColorSpan(ResUtils.getColor(context, R.color.xui_config_color_waring)), 0, logContent.length(), 33);
                    break;
                }
            }
            return spannableString;
        }
    }

    public static interface ILogFormatter {
        public String format(String var1, LogType var2);
    }

    public static class DefaultLogFormatter
    implements ILogFormatter {
        @Override
        public String format(String logContent, LogType logType) {
            return logContent;
        }
    }
}

