/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;

public class ExpandableTextView
extends LinearLayout
implements View.OnClickListener {
    private static final int MAX_COLLAPSED_LINES = 8;
    private static final int DEFAULT_ANIM_DURATION = 300;
    private static final float DEFAULT_ANIM_ALPHA_START = 0.7f;
    protected TextView mTv;
    protected ImageButton mButton;
    private boolean mRelayout;
    private boolean mCollapsed = true;
    private int mCollapsedHeight;
    private int mTextHeightWithMaxLines;
    private int mMaxCollapsedLines;
    private int mMarginBetweenTxtAndBottom;
    private Drawable mExpandDrawable;
    private Drawable mCollapseDrawable;
    private int mAnimationDuration;
    private float mAnimAlphaStart;
    private boolean mAnimating;
    private OnExpandStateChangeListener mListener;
    private SparseBooleanArray mCollapsedStatus;
    private int mPosition;

    public ExpandableTextView(Context context) {
        super(context);
        this.init(null);
    }

    public ExpandableTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    @TargetApi(value=11)
    public ExpandableTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    public void setOrientation(int orientation) {
        if (0 == orientation) {
            throw new IllegalArgumentException("ExpandableTextView only supports Vertical Orientation.");
        }
        super.setOrientation(orientation);
    }

    public void onClick(View view) {
        if (this.mButton.getVisibility() != 0) {
            return;
        }
        this.mCollapsed = !this.mCollapsed;
        this.mButton.setImageDrawable(this.mCollapsed ? this.mExpandDrawable : this.mCollapseDrawable);
        if (this.mCollapsedStatus != null) {
            this.mCollapsedStatus.put(this.mPosition, this.mCollapsed);
        }
        this.mAnimating = true;
        ExpandCollapseAnimation animation = this.mCollapsed ? new ExpandCollapseAnimation((View)this, this.getHeight(), this.mCollapsedHeight) : new ExpandCollapseAnimation((View)this, this.getHeight(), this.getHeight() + this.mTextHeightWithMaxLines - this.mTv.getHeight());
        animation.setFillAfter(true);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                ExpandableTextView.applyAlphaAnimation((View)ExpandableTextView.this.mTv, ExpandableTextView.this.mAnimAlphaStart);
            }

            public void onAnimationEnd(Animation animation) {
                ExpandableTextView.this.clearAnimation();
                ExpandableTextView.this.mAnimating = false;
                if (ExpandableTextView.this.mListener != null) {
                    ExpandableTextView.this.mListener.onExpandStateChanged(ExpandableTextView.this.mTv, !ExpandableTextView.this.mCollapsed);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.clearAnimation();
        this.startAnimation(animation);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mAnimating;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.findViews();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.mRelayout || this.getVisibility() == 8) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        this.mRelayout = false;
        this.mButton.setVisibility(8);
        this.mTv.setMaxLines(Integer.MAX_VALUE);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mTv.getLineCount() <= this.mMaxCollapsedLines) {
            return;
        }
        this.mTextHeightWithMaxLines = ExpandableTextView.getRealTextViewHeight(this.mTv);
        if (this.mCollapsed) {
            this.mTv.setMaxLines(this.mMaxCollapsedLines);
        }
        this.mButton.setVisibility(0);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mCollapsed) {
            this.mTv.post(new Runnable(){

                @Override
                public void run() {
                    ExpandableTextView.this.mMarginBetweenTxtAndBottom = ExpandableTextView.this.getHeight() - ExpandableTextView.this.mTv.getHeight();
                }
            });
            this.mCollapsedHeight = this.getMeasuredHeight();
        }
    }

    public void setOnExpandStateChangeListener(@Nullable OnExpandStateChangeListener listener) {
        this.mListener = listener;
    }

    public void setText(@Nullable CharSequence text) {
        this.mRelayout = true;
        this.mTv.setText(text);
        this.setVisibility(TextUtils.isEmpty((CharSequence)text) ? 8 : 0);
    }

    public void setText(@Nullable CharSequence text, @NonNull SparseBooleanArray collapsedStatus, int position) {
        this.mCollapsedStatus = collapsedStatus;
        this.mPosition = position;
        boolean isCollapsed = collapsedStatus.get(position, true);
        this.clearAnimation();
        this.mCollapsed = isCollapsed;
        this.mButton.setImageDrawable(this.mCollapsed ? this.mExpandDrawable : this.mCollapseDrawable);
        this.setText(text);
        this.getLayoutParams().height = -2;
        this.requestLayout();
    }

    @Nullable
    public CharSequence getText() {
        if (this.mTv == null) {
            return "";
        }
        return this.mTv.getText();
    }

    private void init(AttributeSet attrs) {
        this.initAttr(attrs);
        this.setOrientation(1);
        this.setVisibility(8);
    }

    private void initAttr(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ExpandableTextView);
        this.mMaxCollapsedLines = typedArray.getInt(R.styleable.ExpandableTextView_etv_maxCollapsedLines, 8);
        this.mAnimationDuration = typedArray.getInt(R.styleable.ExpandableTextView_etv_animDuration, 300);
        this.mAnimAlphaStart = typedArray.getFloat(R.styleable.ExpandableTextView_etv_animAlphaStart, 0.7f);
        this.mExpandDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.ExpandableTextView_etv_expandDrawable);
        this.mCollapseDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.ExpandableTextView_etv_collapseDrawable);
        if (this.mExpandDrawable == null) {
            this.mExpandDrawable = ExpandableTextView.getDrawable(this.getContext(), R.drawable.xui_ic_expand_more_black_12dp);
        }
        if (this.mCollapseDrawable == null) {
            this.mCollapseDrawable = ExpandableTextView.getDrawable(this.getContext(), R.drawable.xui_ic_expand_less_black_12dp);
        }
        typedArray.recycle();
    }

    private void findViews() {
        this.mTv = (TextView)this.findViewById(R.id.expandable_text);
        this.mTv.setOnClickListener((View.OnClickListener)this);
        this.mButton = (ImageButton)this.findViewById(R.id.expand_collapse);
        this.mButton.setImageDrawable(this.mCollapsed ? this.mExpandDrawable : this.mCollapseDrawable);
        this.mButton.setOnClickListener((View.OnClickListener)this);
    }

    private static boolean isPostHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    private static boolean isPostLolipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @TargetApi(value=11)
    private static void applyAlphaAnimation(View view, float alpha) {
        if (ExpandableTextView.isPostHoneycomb()) {
            view.setAlpha(alpha);
        } else {
            AlphaAnimation alphaAnimation = new AlphaAnimation(alpha, alpha);
            alphaAnimation.setDuration(0L);
            alphaAnimation.setFillAfter(true);
            view.startAnimation((Animation)alphaAnimation);
        }
    }

    @TargetApi(value=21)
    private static Drawable getDrawable(@NonNull Context context, @DrawableRes int resId) {
        Resources resources = context.getResources();
        if (ExpandableTextView.isPostLolipop()) {
            return resources.getDrawable(resId, context.getTheme());
        }
        return resources.getDrawable(resId);
    }

    private static int getRealTextViewHeight(@NonNull TextView textView) {
        Layout layout2 = textView.getLayout();
        int textHeight = layout2 != null ? layout2.getLineTop(textView.getLineCount()) : 0;
        int padding = textView.getCompoundPaddingTop() + textView.getCompoundPaddingBottom();
        return textHeight + padding;
    }

    public static interface OnExpandStateChangeListener {
        public void onExpandStateChanged(TextView var1, boolean var2);
    }

    class ExpandCollapseAnimation
    extends Animation {
        private final View mTargetView;
        private final int mStartHeight;
        private final int mEndHeight;

        public ExpandCollapseAnimation(View view, int startHeight, int endHeight) {
            this.mTargetView = view;
            this.mStartHeight = startHeight;
            this.mEndHeight = endHeight;
            this.setDuration(ExpandableTextView.this.mAnimationDuration);
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            int newHeight = (int)((float)(this.mEndHeight - this.mStartHeight) * interpolatedTime + (float)this.mStartHeight);
            ExpandableTextView.this.mTv.setMaxHeight(newHeight - ExpandableTextView.this.mMarginBetweenTxtAndBottom);
            if (Float.compare(ExpandableTextView.this.mAnimAlphaStart, 1.0f) != 0) {
                ExpandableTextView.applyAlphaAnimation((View)ExpandableTextView.this.mTv, ExpandableTextView.this.mAnimAlphaStart + interpolatedTime * (1.0f - ExpandableTextView.this.mAnimAlphaStart));
            }
            this.mTargetView.getLayoutParams().height = newHeight;
            this.mTargetView.requestLayout();
        }

        public void initialize(int width, int height, int parentWidth, int parentHeight) {
            super.initialize(width, height, parentWidth, parentHeight);
        }

        public boolean willChangeBounds() {
            return true;
        }
    }
}

