/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.tabbar;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.tabbar.vertical.ITabView;
import com.xuexiang.xui.widget.tabbar.vertical.TabAdapter;
import com.xuexiang.xui.widget.tabbar.vertical.TabFragmentManager;
import com.xuexiang.xui.widget.tabbar.vertical.TabView;
import com.xuexiang.xui.widget.tabbar.vertical.XTabView;
import java.util.ArrayList;
import java.util.List;

public class VerticalTabLayout
extends ScrollView {
    private TabStrip mTabStrip;
    private int mColorIndicator;
    private TabView mSelectedTab;
    private int mTabMargin;
    private int mIndicatorWidth;
    private int mIndicatorGravity;
    private float mIndicatorCorners;
    private int mTabMode;
    private int mTabHeight;
    public static int TAB_MODE_FIXED = 10;
    public static int TAB_MODE_SCROLLABLE = 11;
    private ViewPager mViewPager;
    private PagerAdapter mPagerAdapter;
    private TabAdapter mTabAdapter;
    private List<OnTabSelectedListener> mTabSelectedListeners = new ArrayList<OnTabSelectedListener>();
    private OnTabPageChangeListener mTabPageChangeListener;
    private DataSetObserver mPagerAdapterObserver;
    private TabFragmentManager mTabFragmentManager;
    private float mLastPositionOffset;

    public VerticalTabLayout(Context context) {
        this(context, null);
    }

    public VerticalTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VerticalTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.VerticalTabLayout);
        this.mColorIndicator = typedArray.getColor(R.styleable.VerticalTabLayout_vtl_indicator_color, ThemeUtils.getMainThemeColor(context));
        this.mIndicatorWidth = (int)typedArray.getDimension(R.styleable.VerticalTabLayout_vtl_indicator_width, (float)DensityUtils.dp2px(context, 3.0f));
        this.mIndicatorCorners = typedArray.getDimension(R.styleable.VerticalTabLayout_vtl_indicator_corners, 0.0f);
        this.mIndicatorGravity = typedArray.getInteger(R.styleable.VerticalTabLayout_vtl_indicator_gravity, 3);
        if (this.mIndicatorGravity == 3) {
            this.mIndicatorGravity = 3;
        } else if (this.mIndicatorGravity == 5) {
            this.mIndicatorGravity = 5;
        } else if (this.mIndicatorGravity == 119) {
            this.mIndicatorGravity = 119;
        }
        this.mTabMargin = (int)typedArray.getDimension(R.styleable.VerticalTabLayout_vtl_tab_margin, 0.0f);
        this.mTabMode = typedArray.getInteger(R.styleable.VerticalTabLayout_vtl_tab_mode, TAB_MODE_FIXED);
        this.mTabHeight = (int)typedArray.getDimension(R.styleable.VerticalTabLayout_vtl_tab_height, -2.0f);
        typedArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() > 0) {
            this.removeAllViews();
        }
        this.initTabStrip();
    }

    private void initTabStrip() {
        this.mTabStrip = new TabStrip(this.getContext());
        this.addView((View)this.mTabStrip, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void removeAllTabs() {
        this.mTabStrip.removeAllViews();
        this.mSelectedTab = null;
    }

    public TabView getTabAt(int position) {
        return (TabView)this.mTabStrip.getChildAt(position);
    }

    public int getTabCount() {
        return this.mTabStrip.getChildCount();
    }

    public int getSelectedTabPosition() {
        return this.getPositionByTabView(this.mSelectedTab);
    }

    public int getPositionByTabView(TabView view) {
        int index = this.mTabStrip.indexOfChild((View)view);
        return index == -1 ? 0 : index;
    }

    private void addTabWithMode(TabView tabView) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        this.initTabWithMode(params);
        this.mTabStrip.addView((View)tabView, (ViewGroup.LayoutParams)params);
        if (this.mTabStrip.indexOfChild((View)tabView) == 0) {
            tabView.setChecked(true);
            params = (LinearLayout.LayoutParams)tabView.getLayoutParams();
            params.setMargins(0, 0, 0, 0);
            tabView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mSelectedTab = tabView;
            this.mTabStrip.post(new Runnable(){

                @Override
                public void run() {
                    VerticalTabLayout.this.mTabStrip.moveIndicator(0.0f);
                }
            });
        }
    }

    private void initTabWithMode(LinearLayout.LayoutParams params) {
        if (this.mTabMode == TAB_MODE_FIXED) {
            params.height = 0;
            params.weight = 1.0f;
            params.setMargins(0, 0, 0, 0);
            this.setFillViewport(true);
        } else if (this.mTabMode == TAB_MODE_SCROLLABLE) {
            params.height = this.mTabHeight;
            params.weight = 0.0f;
            params.setMargins(0, this.mTabMargin, 0, 0);
            this.setFillViewport(false);
        }
    }

    private void scrollToTab(int position) {
        int target;
        TabView tabView = this.getTabAt(position);
        int y = this.getScrollY();
        int tabTop = tabView.getTop() + tabView.getHeight() / 2 - y;
        if (tabTop > (target = this.getHeight() / 2)) {
            this.smoothScrollBy(0, tabTop - target);
        } else if (tabTop < target) {
            this.smoothScrollBy(0, tabTop - target);
        }
    }

    private void scrollByTab(int position, float positionOffset) {
        TabView tabView = this.getTabAt(position);
        int y = this.getScrollY();
        int tabTop = tabView.getTop() + tabView.getHeight() / 2 - y;
        int target = this.getHeight() / 2;
        int nextScrollY = tabView.getHeight() + this.mTabMargin;
        if (positionOffset > 0.0f) {
            float percent = positionOffset - this.mLastPositionOffset;
            if (tabTop > target) {
                this.smoothScrollBy(0, (int)((float)nextScrollY * percent));
            }
        }
        this.mLastPositionOffset = positionOffset;
    }

    public void addTab(TabView tabView) {
        if (tabView == null) {
            throw new IllegalStateException("tabView can't be null");
        }
        this.addTabWithMode(tabView);
        tabView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int position = VerticalTabLayout.this.mTabStrip.indexOfChild(view);
                VerticalTabLayout.this.setTabSelected(position);
            }
        });
    }

    public void setTabSelected(int position) {
        this.setTabSelected(position, true, true);
    }

    private void setTabSelected(final int position, final boolean updateIndicator, final boolean callListener) {
        this.post(new Runnable(){

            @Override
            public void run() {
                VerticalTabLayout.this.setTabSelectedImpl(position, updateIndicator, callListener);
            }
        });
    }

    private void setTabSelectedImpl(int position, boolean updateIndicator, boolean callListener) {
        TabView view = this.getTabAt(position);
        TabView unselectedTab = null;
        boolean newTabSelected = view != this.mSelectedTab;
        if (newTabSelected) {
            if (this.mSelectedTab != null) {
                this.mSelectedTab.setChecked(false);
                unselectedTab = this.mSelectedTab;
            }
            view.setChecked(true);
            if (updateIndicator) {
                this.mTabStrip.moveIndicatorWithAnimator(position);
            }
            this.scrollToTab(position);
            this.mSelectedTab = view;
        }
        if (callListener) {
            for (int i = 0; i < this.mTabSelectedListeners.size(); ++i) {
                OnTabSelectedListener listener = this.mTabSelectedListeners.get(i);
                if (listener == null) continue;
                if (newTabSelected) {
                    listener.onTabSelected(view, position);
                    if (unselectedTab == null) continue;
                    listener.onTabUnselected(unselectedTab, this.getPositionByTabView(unselectedTab));
                    continue;
                }
                listener.onTabReselected(view, position);
            }
        }
    }

    public void setTabBadge(int tabPosition, int badgeNum) {
        this.getTabAt(tabPosition).getBadgeView().setBadgeNumber(badgeNum);
    }

    public void setTabBadge(int tabPosition, String badgeText) {
        this.getTabAt(tabPosition).getBadgeView().setBadgeText(badgeText);
    }

    public void setTabMode(int mode) {
        if (mode != TAB_MODE_FIXED && mode != TAB_MODE_SCROLLABLE) {
            throw new IllegalStateException("only support TAB_MODE_FIXED or TAB_MODE_SCROLLABLE");
        }
        if (mode == this.mTabMode) {
            return;
        }
        this.mTabMode = mode;
        for (int i = 0; i < this.mTabStrip.getChildCount(); ++i) {
            View view = this.mTabStrip.getChildAt(i);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
            this.initTabWithMode(params);
            if (i == 0) {
                params.setMargins(0, 0, 0, 0);
            }
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mTabStrip.invalidate();
        this.mTabStrip.post(new Runnable(){

            @Override
            public void run() {
                VerticalTabLayout.this.mTabStrip.updateIndicator();
            }
        });
    }

    public void setTabMargin(int margin) {
        if (margin == this.mTabMargin) {
            return;
        }
        this.mTabMargin = margin;
        if (this.mTabMode == TAB_MODE_FIXED) {
            return;
        }
        for (int i = 0; i < this.mTabStrip.getChildCount(); ++i) {
            View view = this.mTabStrip.getChildAt(i);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
            params.setMargins(0, i == 0 ? 0 : this.mTabMargin, 0, 0);
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mTabStrip.invalidate();
        this.mTabStrip.post(new Runnable(){

            @Override
            public void run() {
                VerticalTabLayout.this.mTabStrip.updateIndicator();
            }
        });
    }

    public void setTabHeight(int height) {
        if (height == this.mTabHeight) {
            return;
        }
        this.mTabHeight = height;
        if (this.mTabMode == TAB_MODE_FIXED) {
            return;
        }
        for (int i = 0; i < this.mTabStrip.getChildCount(); ++i) {
            View view = this.mTabStrip.getChildAt(i);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
            params.height = this.mTabHeight;
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mTabStrip.invalidate();
        this.mTabStrip.post(new Runnable(){

            @Override
            public void run() {
                VerticalTabLayout.this.mTabStrip.updateIndicator();
            }
        });
    }

    public void setIndicatorColor(int color2) {
        this.mColorIndicator = color2;
        this.mTabStrip.invalidate();
    }

    public void setIndicatorWidth(int width) {
        this.mIndicatorWidth = width;
        this.mTabStrip.setIndicatorGravity();
    }

    public void setIndicatorCorners(int corners) {
        this.mIndicatorCorners = corners;
        this.mTabStrip.invalidate();
    }

    public void setIndicatorGravity(int gravity) {
        if (gravity != 3 && gravity != 5 && 119 != gravity) {
            throw new IllegalStateException("only support Gravity.LEFT, Gravity.RIGHT, Gravity.FILL");
        }
        this.mIndicatorGravity = gravity;
        this.mTabStrip.setIndicatorGravity();
    }

    public void addOnTabSelectedListener(OnTabSelectedListener listener) {
        if (listener != null) {
            this.mTabSelectedListeners.add(listener);
        }
    }

    public void removeOnTabSelectedListener(OnTabSelectedListener listener) {
        if (listener != null) {
            this.mTabSelectedListeners.remove(listener);
        }
    }

    public void setTabAdapter(TabAdapter adapter) {
        this.removeAllTabs();
        if (adapter != null) {
            this.mTabAdapter = adapter;
            for (int i = 0; i < adapter.getCount(); ++i) {
                this.addTab(new XTabView(this.getContext()).setIcon(adapter.getIcon(this.getContext(), i)).setTitle(adapter.getTitle(i)).setBadge(adapter.getBadge(i)).setBackground(adapter.getBackground(i)));
            }
        }
    }

    public TabAdapter getTabAdapter() {
        return this.mTabAdapter;
    }

    public void setupWithFragment(FragmentManager manager, List<Fragment> fragments) {
        this.setupWithFragment(manager, 0, fragments);
    }

    public void setupWithFragment(FragmentManager manager, List<Fragment> fragments, TabAdapter adapter) {
        this.setupWithFragment(manager, 0, fragments, adapter);
    }

    public void setupWithFragment(FragmentManager manager, int containerResid, List<Fragment> fragments) {
        if (this.mTabFragmentManager != null) {
            this.mTabFragmentManager.detach();
        }
        this.mTabFragmentManager = containerResid != 0 ? new TabFragmentManager(manager, containerResid, fragments, this) : new TabFragmentManager(manager, fragments, this);
    }

    public void setupWithFragment(FragmentManager manager, int containerResId, List<Fragment> fragments, TabAdapter adapter) {
        this.setTabAdapter(adapter);
        this.setupWithFragment(manager, containerResId, fragments);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        if (this.mViewPager != null && this.mTabPageChangeListener != null) {
            this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.mTabPageChangeListener);
        }
        if (viewPager != null) {
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter == null) {
                throw new IllegalArgumentException("ViewPager does not have a PagerAdapter set");
            }
            this.mViewPager = viewPager;
            if (this.mTabPageChangeListener == null) {
                this.mTabPageChangeListener = new OnTabPageChangeListener();
            }
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mTabPageChangeListener);
            this.addOnTabSelectedListener(new OnTabSelectedListener(){

                @Override
                public void onTabSelected(TabView tab, int position) {
                    if (VerticalTabLayout.this.mViewPager != null && VerticalTabLayout.this.mViewPager.getAdapter() != null && position >= 0 && position < VerticalTabLayout.this.mViewPager.getAdapter().getCount()) {
                        VerticalTabLayout.this.mViewPager.setCurrentItem(position);
                    }
                }

                @Override
                public void onTabUnselected(TabView tab, int position) {
                }

                @Override
                public void onTabReselected(TabView tab, int position) {
                }
            });
            this.setPagerAdapter(adapter, true);
        } else {
            this.mViewPager = null;
            this.setPagerAdapter(null, true);
        }
    }

    private void setPagerAdapter(@Nullable PagerAdapter adapter, boolean addObserver) {
        if (this.mPagerAdapter != null && this.mPagerAdapterObserver != null) {
            this.mPagerAdapter.unregisterDataSetObserver(this.mPagerAdapterObserver);
        }
        this.mPagerAdapter = adapter;
        if (addObserver && adapter != null) {
            if (this.mPagerAdapterObserver == null) {
                this.mPagerAdapterObserver = new PagerAdapterObserver();
            }
            adapter.registerDataSetObserver(this.mPagerAdapterObserver);
        }
        this.populateFromPagerAdapter();
    }

    private void populateFromPagerAdapter() {
        this.removeAllTabs();
        if (this.mPagerAdapter != null) {
            int curItem;
            int adapterCount = this.mPagerAdapter.getCount();
            if (this.mPagerAdapter instanceof TabAdapter) {
                this.setTabAdapter((TabAdapter)this.mPagerAdapter);
            } else {
                for (int i = 0; i < adapterCount; ++i) {
                    CharSequence pageTitle = this.mPagerAdapter.getPageTitle(i);
                    String title = pageTitle != null ? pageTitle.toString() : "tab" + i;
                    this.addTab(new XTabView(this.getContext()).setTitle(new ITabView.TabTitle.Builder().setContent(title).build()));
                }
            }
            if (this.mViewPager != null && adapterCount > 0 && (curItem = this.mViewPager.getCurrentItem()) != this.getSelectedTabPosition() && curItem < this.getTabCount()) {
                this.setTabSelected(curItem);
            }
        } else {
            this.removeAllTabs();
        }
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(TabView var1, int var2);

        public void onTabUnselected(TabView var1, int var2);

        public void onTabReselected(TabView var1, int var2);
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        private PagerAdapterObserver() {
        }

        public void onChanged() {
            VerticalTabLayout.this.populateFromPagerAdapter();
        }

        public void onInvalidated() {
            VerticalTabLayout.this.populateFromPagerAdapter();
        }
    }

    private class OnTabPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private int mScrollState;
        boolean mUpdateIndicator;

        public void onPageScrollStateChanged(int state) {
            int mPreviousScrollState = this.mScrollState;
            this.mScrollState = state;
            this.mUpdateIndicator = this.mScrollState != 2 || mPreviousScrollState != 0;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (this.mUpdateIndicator) {
                VerticalTabLayout.this.mTabStrip.moveIndicator(positionOffset + (float)position);
            }
        }

        public void onPageSelected(int position) {
            if (position != VerticalTabLayout.this.getSelectedTabPosition()) {
                VerticalTabLayout.this.setTabSelected(position, !this.mUpdateIndicator, true);
            }
        }
    }

    private class TabStrip
    extends LinearLayout {
        private float mIndicatorTopY;
        private float mIndicatorX;
        private float mIndicatorBottomY;
        private int mLastWidth;
        private Paint mIndicatorPaint;
        private RectF mIndicatorRect;
        private AnimatorSet mIndicatorAnimatorSet;

        public TabStrip(Context context) {
            super(context);
            this.setWillNotDraw(false);
            this.setOrientation(1);
            this.mIndicatorPaint = new Paint();
            this.mIndicatorPaint.setAntiAlias(true);
            VerticalTabLayout.this.mIndicatorGravity = VerticalTabLayout.this.mIndicatorGravity == 0 ? 3 : VerticalTabLayout.this.mIndicatorGravity;
            this.mIndicatorRect = new RectF();
            this.setIndicatorGravity();
        }

        protected void setIndicatorGravity() {
            if (VerticalTabLayout.this.mIndicatorGravity == 3) {
                this.mIndicatorX = 0.0f;
                if (this.mLastWidth != 0) {
                    VerticalTabLayout.this.mIndicatorWidth = this.mLastWidth;
                }
                this.setPadding(VerticalTabLayout.this.mIndicatorWidth, 0, 0, 0);
            } else if (VerticalTabLayout.this.mIndicatorGravity == 5) {
                if (this.mLastWidth != 0) {
                    VerticalTabLayout.this.mIndicatorWidth = this.mLastWidth;
                }
                this.setPadding(0, 0, VerticalTabLayout.this.mIndicatorWidth, 0);
            } else if (VerticalTabLayout.this.mIndicatorGravity == 119) {
                this.mIndicatorX = 0.0f;
                this.setPadding(0, 0, 0, 0);
            }
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (VerticalTabLayout.this.mIndicatorGravity == 5) {
                        TabStrip.this.mIndicatorX = TabStrip.this.getWidth() - VerticalTabLayout.this.mIndicatorWidth;
                    } else if (VerticalTabLayout.this.mIndicatorGravity == 119) {
                        TabStrip.this.mLastWidth = VerticalTabLayout.this.mIndicatorWidth;
                        VerticalTabLayout.this.mIndicatorWidth = TabStrip.this.getWidth();
                    }
                    TabStrip.this.invalidate();
                }
            });
        }

        private void calcIndicatorY(float offset) {
            int index = (int)Math.floor(offset);
            View childView = this.getChildAt(index);
            if (Math.floor(offset) != (double)(this.getChildCount() - 1) && Math.ceil(offset) != 0.0) {
                View nextView = this.getChildAt(index + 1);
                this.mIndicatorTopY = (float)childView.getTop() + (float)(nextView.getTop() - childView.getTop()) * (offset - (float)index);
                this.mIndicatorBottomY = (float)childView.getBottom() + (float)(nextView.getBottom() - childView.getBottom()) * (offset - (float)index);
            } else {
                this.mIndicatorTopY = childView.getTop();
                this.mIndicatorBottomY = childView.getBottom();
            }
        }

        protected void updateIndicator() {
            this.moveIndicatorWithAnimator(VerticalTabLayout.this.getSelectedTabPosition());
        }

        protected void moveIndicator(float offset) {
            this.calcIndicatorY(offset);
            this.invalidate();
        }

        protected void moveIndicatorWithAnimator(int index) {
            final int direction = index - VerticalTabLayout.this.getSelectedTabPosition();
            View childView = this.getChildAt(index);
            final float targetTop = childView.getTop();
            final float targetBottom = childView.getBottom();
            if (this.mIndicatorTopY == targetTop && this.mIndicatorBottomY == targetBottom) {
                return;
            }
            if (this.mIndicatorAnimatorSet != null && this.mIndicatorAnimatorSet.isRunning()) {
                this.mIndicatorAnimatorSet.end();
            }
            this.post(new Runnable(){

                @Override
                public void run() {
                    ValueAnimator startAnime = null;
                    ValueAnimator endAnime = null;
                    if (direction > 0) {
                        startAnime = ValueAnimator.ofFloat((float[])new float[]{TabStrip.this.mIndicatorBottomY, targetBottom}).setDuration(100L);
                        startAnime.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                TabStrip.this.mIndicatorBottomY = Float.parseFloat(animation.getAnimatedValue().toString());
                                TabStrip.this.invalidate();
                            }
                        });
                        endAnime = ValueAnimator.ofFloat((float[])new float[]{TabStrip.this.mIndicatorTopY, targetTop}).setDuration(100L);
                        endAnime.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                TabStrip.this.mIndicatorTopY = Float.parseFloat(animation.getAnimatedValue().toString());
                                TabStrip.this.invalidate();
                            }
                        });
                    } else if (direction < 0) {
                        startAnime = ValueAnimator.ofFloat((float[])new float[]{TabStrip.this.mIndicatorTopY, targetTop}).setDuration(100L);
                        startAnime.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                TabStrip.this.mIndicatorTopY = Float.parseFloat(animation.getAnimatedValue().toString());
                                TabStrip.this.invalidate();
                            }
                        });
                        endAnime = ValueAnimator.ofFloat((float[])new float[]{TabStrip.this.mIndicatorBottomY, targetBottom}).setDuration(100L);
                        endAnime.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                TabStrip.this.mIndicatorBottomY = Float.parseFloat(animation.getAnimatedValue().toString());
                                TabStrip.this.invalidate();
                            }
                        });
                    }
                    if (startAnime != null) {
                        TabStrip.this.mIndicatorAnimatorSet = new AnimatorSet();
                        TabStrip.this.mIndicatorAnimatorSet.play(endAnime).after((Animator)startAnime);
                        TabStrip.this.mIndicatorAnimatorSet.start();
                    }
                }
            });
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            this.mIndicatorPaint.setColor(VerticalTabLayout.this.mColorIndicator);
            this.mIndicatorRect.left = this.mIndicatorX;
            this.mIndicatorRect.top = this.mIndicatorTopY;
            this.mIndicatorRect.right = this.mIndicatorX + (float)VerticalTabLayout.this.mIndicatorWidth;
            this.mIndicatorRect.bottom = this.mIndicatorBottomY;
            if (VerticalTabLayout.this.mIndicatorCorners != 0.0f) {
                canvas.drawRoundRect(this.mIndicatorRect, VerticalTabLayout.this.mIndicatorCorners, VerticalTabLayout.this.mIndicatorCorners, this.mIndicatorPaint);
            } else {
                canvas.drawRect(this.mIndicatorRect, this.mIndicatorPaint);
            }
        }
    }
}

