/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.tabbar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import io.github.inflationx.calligraphy3.HasTypeface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TabControlView
extends RadioGroup
implements HasTypeface {
    private Context mContext;
    private OnTabSelectionChangedListener mListener;
    private int mTextSize;
    private int mStrokeWidth;
    private int mItemPadding;
    private int mItemPaddingHorizontal;
    private int mItemPaddingVertical;
    private int mSelectedColor;
    private int mUnselectedColor;
    private int mSelectedTextColor;
    private int mUnselectedTextColor;
    private int mDefaultSelection = -1;
    private boolean mStretch = false;
    private boolean mEqualWidth = false;
    private ColorStateList mTextColorStateList;
    private LinkedHashMap<String, String> mItemMap = new LinkedHashMap();
    private List<RadioButton> mOptions;
    private RadioGroup.OnCheckedChangeListener mSelectionChangedListener = new RadioGroup.OnCheckedChangeListener(){

        public void onCheckedChanged(RadioGroup group, int checkedId) {
            if (TabControlView.this.mListener != null) {
                String identifier = ((RadioButton)group.findViewById(checkedId)).getText().toString();
                String value = (String)TabControlView.this.mItemMap.get(identifier);
                TabControlView.this.mListener.newSelection(identifier, value);
            }
        }
    };

    public TabControlView(Context context) {
        super(context, null);
        this.init(context);
        this.update();
    }

    public TabControlView(Context context, AttributeSet attrs) throws Exception {
        super(context, attrs);
        this.init(context);
        this.initAttrs(context, attrs);
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(Context context, AttributeSet attrs) throws Exception {
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TabControlView, 0, 0);
        try {
            this.mTextSize = attributes.getDimensionPixelSize(R.styleable.TabControlView_tcv_textSize, ResUtils.getDimensionPixelSize(context, R.dimen.default_tcv_text_size));
            this.mSelectedColor = attributes.getColor(R.styleable.TabControlView_tcv_selectedColor, ThemeUtils.getMainThemeColor(context));
            this.mUnselectedColor = attributes.getColor(R.styleable.TabControlView_tcv_unselectedColor, 0);
            this.mSelectedTextColor = attributes.getColor(R.styleable.TabControlView_tcv_selectedTextColor, -1);
            this.mUnselectedTextColor = attributes.getColor(R.styleable.TabControlView_tcv_unselectedTextColor, ThemeUtils.getMainThemeColor(context));
            this.mStrokeWidth = attributes.getDimensionPixelSize(R.styleable.TabControlView_tcv_strokeWidth, ResUtils.getDimensionPixelSize(context, R.dimen.default_tcv_stroke_width));
            this.mItemPadding = attributes.getDimensionPixelSize(R.styleable.TabControlView_tcv_item_padding, -1);
            this.mItemPaddingHorizontal = attributes.getDimensionPixelSize(R.styleable.TabControlView_tcv_item_padding_horizontal, -1);
            this.mItemPaddingVertical = attributes.getDimensionPixelSize(R.styleable.TabControlView_tcv_item_padding_vertical, -1);
            this.mTextColorStateList = new ColorStateList((int[][])new int[][]{{-16842912}, {0x10100A0}}, new int[]{this.mUnselectedTextColor, this.mSelectedTextColor});
            this.mDefaultSelection = attributes.getInt(R.styleable.TabControlView_tcv_defaultSelection, this.mDefaultSelection);
            this.mEqualWidth = attributes.getBoolean(R.styleable.TabControlView_tcv_equalWidth, this.mEqualWidth);
            this.mStretch = attributes.getBoolean(R.styleable.TabControlView_tcv_stretch, this.mStretch);
            CharSequence[] itemArray = attributes.getTextArray(R.styleable.TabControlView_tcv_items);
            CharSequence[] valueArray = attributes.getTextArray(R.styleable.TabControlView_tcv_values);
            this.setItems(itemArray, valueArray);
        }
        finally {
            attributes.recycle();
        }
    }

    private void init(Context context) {
        this.mContext = context;
        this.setPadding(10, 10, 10, 10);
    }

    private void update() {
        RadioButton radioButton;
        this.removeAllViews();
        this.setOrientation(0);
        float textWidth = 0.0f;
        this.mOptions = new ArrayList<RadioButton>();
        Iterator<Map.Entry<String, String>> itemIterator = this.mItemMap.entrySet().iterator();
        int i = 0;
        while (itemIterator.hasNext()) {
            Map.Entry<String, String> item = itemIterator.next();
            RadioButton rb = new RadioButton(this.mContext);
            rb.setTextColor(this.mTextColorStateList);
            RadioGroup.LayoutParams params = new RadioGroup.LayoutParams(-2, -1);
            if (this.mStretch) {
                params.weight = 1.0f;
            }
            if (i > 0) {
                params.setMarginStart(-this.mStrokeWidth);
            }
            rb.setLayoutParams((ViewGroup.LayoutParams)params);
            rb.setButtonDrawable((Drawable)new StateListDrawable());
            if (i == 0) {
                if (this.isRtl()) {
                    this.updateRadioButton(rb, R.drawable.tcv_right_option, R.drawable.tcv_right_option_selected);
                } else {
                    this.updateRadioButton(rb, R.drawable.tcv_left_option, R.drawable.tcv_left_option_selected);
                }
            } else if (i == this.mItemMap.size() - 1) {
                if (this.isRtl()) {
                    this.updateRadioButton(rb, R.drawable.tcv_left_option, R.drawable.tcv_left_option_selected);
                } else {
                    this.updateRadioButton(rb, R.drawable.tcv_right_option, R.drawable.tcv_right_option_selected);
                }
            } else {
                this.updateRadioButton(rb, R.drawable.tcv_middle_option, R.drawable.tcv_middle_option_selected);
            }
            rb.setLayoutParams((ViewGroup.LayoutParams)params);
            if (this.mItemPadding != -1) {
                rb.setPadding(this.mItemPadding, this.mItemPadding, this.mItemPadding, this.mItemPadding);
            }
            if (this.mItemPaddingHorizontal != -1 && this.mItemPaddingVertical != -1) {
                rb.setPadding(this.mItemPaddingHorizontal, this.mItemPaddingVertical, this.mItemPaddingHorizontal, this.mItemPaddingVertical);
            }
            rb.setMinWidth(this.mStrokeWidth * 10);
            rb.setGravity(17);
            rb.setTextSize(0, (float)this.mTextSize);
            rb.setTypeface(XUI.getDefaultTypeface());
            rb.setText((CharSequence)item.getKey());
            textWidth = Math.max(rb.getPaint().measureText((String)item.getKey()), textWidth);
            this.mOptions.add(rb);
            ++i;
        }
        for (RadioButton option : this.mOptions) {
            if (this.mEqualWidth) {
                option.setWidth((int)(textWidth + (float)(this.mStrokeWidth * 20)));
            }
            this.addView((View)option);
        }
        this.setOnCheckedChangeListener(this.mSelectionChangedListener);
        if (this.mDefaultSelection > -1 && (radioButton = (RadioButton)this.getChildAt(this.mDefaultSelection)) != null) {
            this.check(radioButton.getId());
        }
    }

    private boolean isRtl() {
        return Build.VERSION.SDK_INT >= 17 && this.getResources().getConfiguration().getLayoutDirection() == 1;
    }

    private void updateRadioButton(RadioButton rb, int tcv_option_normal, int tcv_option_selected) {
        GradientDrawable unselected = (GradientDrawable)this.mContext.getResources().getDrawable(tcv_option_normal).mutate();
        unselected.setStroke(this.mStrokeWidth, this.mSelectedColor);
        unselected.setDither(true);
        unselected.setColor(this.mUnselectedColor);
        GradientDrawable selected = (GradientDrawable)this.mContext.getResources().getDrawable(tcv_option_selected).mutate();
        selected.setColor(this.mSelectedColor);
        selected.setStroke(this.mStrokeWidth, this.mSelectedColor);
        this.setRadioButtonBackground(rb, unselected, selected);
    }

    private void setRadioButtonBackground(RadioButton rb, GradientDrawable unselected, GradientDrawable selected) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{-16842912}, (Drawable)unselected);
        stateListDrawable.addState(new int[]{0x10100A0}, (Drawable)selected);
        if (Build.VERSION.SDK_INT < 16) {
            rb.setBackgroundDrawable((Drawable)stateListDrawable);
        } else {
            rb.setBackground((Drawable)stateListDrawable);
        }
    }

    public String[] getCheckedWithIdentifier() {
        String identifier = ((RadioButton)this.findViewById(this.getCheckedRadioButtonId())).getText().toString();
        String value = this.mItemMap.get(identifier);
        return new String[]{identifier, value};
    }

    public String getChecked() {
        return this.mItemMap.get(((RadioButton)this.findViewById(this.getCheckedRadioButtonId())).getText().toString());
    }

    public TabControlView setItems(String[] itemArray, String[] valueArray) throws Exception {
        this.mItemMap.clear();
        if (itemArray != null && valueArray != null && itemArray.length != valueArray.length) {
            throw new Exception("Item labels and value arrays must be the same size");
        }
        if (itemArray != null) {
            if (valueArray != null) {
                for (int i = 0; i < itemArray.length; ++i) {
                    this.mItemMap.put(itemArray[i], valueArray[i]);
                }
            } else {
                for (String item : itemArray) {
                    this.mItemMap.put(item.toString(), item.toString());
                }
            }
        }
        this.update();
        return this;
    }

    private void setItems(CharSequence[] itemArray, CharSequence[] valueArray) throws Exception {
        block5: {
            if (itemArray != null && valueArray != null && itemArray.length != valueArray.length) {
                throw new Exception("Item labels and value arrays must be the same size");
            }
            if (itemArray == null) break block5;
            if (valueArray != null) {
                for (int i = 0; i < itemArray.length; ++i) {
                    this.mItemMap.put(itemArray[i].toString(), valueArray[i].toString());
                }
            } else {
                for (CharSequence item : itemArray) {
                    this.mItemMap.put(item.toString(), item.toString());
                }
            }
        }
    }

    public TabControlView setItems(String[] items, String[] values, int defaultSelection) throws Exception {
        if (defaultSelection > items.length - 1) {
            throw new Exception("Default selection cannot be greater than the number of items");
        }
        this.mDefaultSelection = defaultSelection;
        this.setItems(items, values);
        return this;
    }

    public TabControlView setDefaultSelection(int defaultSelection) throws Exception {
        if (defaultSelection > this.mItemMap.size() - 1) {
            throw new Exception("Default selection cannot be greater than the number of items");
        }
        this.mDefaultSelection = defaultSelection;
        this.update();
        return this;
    }

    public TabControlView setSelection(String value) {
        this.setSelection(value, true);
        return this;
    }

    public TabControlView setSelection(String value, boolean isSilent) {
        String title = this.getTitleByValue(value);
        this.setSelectionTitle(title, isSilent);
        return this;
    }

    public TabControlView setSelectionTitle(String title) {
        this.setSelectionTitle(title, true);
        return this;
    }

    public TabControlView setSelectionTitle(String title, boolean isSilent) {
        for (RadioButton option : this.mOptions) {
            if (!option.getText().toString().equalsIgnoreCase(title)) continue;
            if (isSilent) {
                this.setOnCheckedChangeListener(null);
                this.check(option.getId());
                this.setOnCheckedChangeListener(this.mSelectionChangedListener);
                continue;
            }
            this.check(option.getId());
        }
        return this;
    }

    private String getTitleByValue(String value) {
        if (this.mItemMap.containsValue(value)) {
            for (String key : this.mItemMap.keySet()) {
                String title = this.mItemMap.get(key);
                if (title == null || !title.equalsIgnoreCase(value)) continue;
                return key;
            }
        }
        return "";
    }

    public TabControlView setColors(int primaryColor, int secondaryColor) {
        this.mSelectedColor = primaryColor;
        this.mSelectedTextColor = secondaryColor;
        this.mUnselectedColor = secondaryColor;
        this.mUnselectedTextColor = primaryColor;
        this.mTextColorStateList = new ColorStateList((int[][])new int[][]{{-16842912}, {0x10100A0}}, new int[]{this.mUnselectedTextColor, this.mSelectedTextColor});
        this.update();
        return this;
    }

    public TabControlView setColors(int selectedColor, int selectedTextColor, int unselectedColor, int unselectedTextColor) {
        this.mSelectedColor = selectedColor;
        this.mSelectedTextColor = selectedTextColor;
        this.mUnselectedColor = unselectedColor;
        this.mUnselectedTextColor = unselectedTextColor;
        this.mTextColorStateList = new ColorStateList((int[][])new int[][]{{-16842912}, {0x10100A0}}, new int[]{unselectedTextColor, selectedTextColor});
        this.update();
        return this;
    }

    public TabControlView setOnTabSelectionChangedListener(OnTabSelectionChangedListener listener) {
        this.mListener = listener;
        return this;
    }

    public TabControlView setEqualWidth(boolean equalWidth) {
        this.mEqualWidth = equalWidth;
        this.update();
        return this;
    }

    public TabControlView setStretch(boolean stretch) {
        this.mStretch = stretch;
        this.update();
        return this;
    }

    public void setTypeface(Typeface typeface) {
        if (this.mOptions != null) {
            for (int i = 0; i < this.mOptions.size(); ++i) {
                this.mOptions.get(i).setTypeface(typeface);
            }
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.update();
    }

    public static interface OnTabSelectionChangedListener {
        public void newSelection(String var1, String var2);
    }
}

