/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.tabbar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import io.github.inflationx.calligraphy3.HasTypeface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultiTabControlView
extends LinearLayout
implements HasTypeface {
    private Context mContext;
    private OnMultiTabSelectionChangedListener mListener;
    private int mTextSize;
    private int mStrokeWidth;
    private int mItemPadding;
    private int mItemPaddingHorizontal;
    private int mItemPaddingVertical;
    private int mSelectedColor;
    private int mUnselectedColor;
    private int mSelectedTextColor;
    private int mUnselectedTextColor;
    private int[] mDefaultSelectionList;
    private boolean mStretch = false;
    private boolean mEqualWidth = false;
    private ColorStateList mTextColorStateList;
    private LinkedHashMap<String, String> mItemMap = new LinkedHashMap();
    private List<CheckBox> mOptions;
    private CompoundButton.OnCheckedChangeListener mCheckBoxListener = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton checkBox, boolean isChecked) {
            if (MultiTabControlView.this.mListener != null) {
                String identifier = checkBox.getText().toString();
                String value = (String)MultiTabControlView.this.mItemMap.get(identifier);
                MultiTabControlView.this.mListener.newSelection(identifier, value, checkBox.isChecked());
            }
        }
    };

    private void addOnCheckedChangeListener(CheckBox cb) {
        if (cb != null) {
            cb.setOnCheckedChangeListener(this.mCheckBoxListener);
        }
    }

    public MultiTabControlView(Context context) {
        super(context, null);
        this.init(context);
        this.update();
    }

    public MultiTabControlView(Context context, AttributeSet attrs) throws Exception {
        super(context, attrs);
        this.init(context);
        this.initAttrs(context, attrs);
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(Context context, AttributeSet attrs) throws Exception {
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TabControlView, 0, 0);
        try {
            this.mTextSize = attributes.getDimensionPixelSize(R.styleable.TabControlView_tcv_textSize, ResUtils.getDimensionPixelSize(context, R.dimen.default_tcv_text_size));
            this.mSelectedColor = attributes.getColor(R.styleable.TabControlView_tcv_selectedColor, ThemeUtils.getMainThemeColor(context));
            this.mUnselectedColor = attributes.getColor(R.styleable.TabControlView_tcv_unselectedColor, 0);
            this.mSelectedTextColor = attributes.getColor(R.styleable.TabControlView_tcv_selectedTextColor, -1);
            this.mUnselectedTextColor = attributes.getColor(R.styleable.TabControlView_tcv_unselectedTextColor, ThemeUtils.getMainThemeColor(context));
            this.mStrokeWidth = attributes.getDimensionPixelSize(R.styleable.TabControlView_tcv_strokeWidth, ResUtils.getDimensionPixelSize(context, R.dimen.default_tcv_stroke_width));
            this.mItemPadding = attributes.getDimensionPixelSize(R.styleable.TabControlView_tcv_item_padding, -1);
            this.mItemPaddingHorizontal = attributes.getDimensionPixelSize(R.styleable.TabControlView_tcv_item_padding_horizontal, -1);
            this.mItemPaddingVertical = attributes.getDimensionPixelSize(R.styleable.TabControlView_tcv_item_padding_vertical, -1);
            this.mTextColorStateList = new ColorStateList((int[][])new int[][]{{-16842912}, {0x10100A0}}, new int[]{this.mUnselectedTextColor, this.mSelectedTextColor});
            int defaultSelection = attributes.getInt(R.styleable.TabControlView_tcv_defaultSelection, -1);
            if (defaultSelection > -1) {
                this.mDefaultSelectionList = new int[]{defaultSelection};
            }
            this.mEqualWidth = attributes.getBoolean(R.styleable.TabControlView_tcv_equalWidth, this.mEqualWidth);
            this.mStretch = attributes.getBoolean(R.styleable.TabControlView_tcv_stretch, this.mStretch);
            CharSequence[] itemArray = attributes.getTextArray(R.styleable.TabControlView_tcv_items);
            CharSequence[] valueArray = attributes.getTextArray(R.styleable.TabControlView_tcv_values);
            this.setItems(itemArray, valueArray);
        }
        finally {
            attributes.recycle();
        }
    }

    private void init(Context context) {
        this.mContext = context;
        this.setPadding(10, 10, 10, 10);
    }

    private void update() {
        this.removeAllViews();
        this.setOrientation(0);
        float textWidth = 0.0f;
        this.mOptions = new ArrayList<CheckBox>();
        Iterator<Map.Entry<String, String>> itemIterator = this.mItemMap.entrySet().iterator();
        int i = 0;
        while (itemIterator.hasNext()) {
            Map.Entry<String, String> item = itemIterator.next();
            CheckBox cb = new CheckBox(this.mContext);
            cb.setTextColor(this.mTextColorStateList);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
            if (this.mStretch) {
                params.weight = 1.0f;
            }
            if (i > 0) {
                params.setMarginStart(-this.mStrokeWidth);
            }
            cb.setLayoutParams((ViewGroup.LayoutParams)params);
            cb.setButtonDrawable((Drawable)new StateListDrawable());
            if (i == 0) {
                if (this.isRtl()) {
                    this.updateCheckBox(cb, R.drawable.tcv_right_option, R.drawable.tcv_right_option_selected);
                } else {
                    this.updateCheckBox(cb, R.drawable.tcv_left_option, R.drawable.tcv_left_option_selected);
                }
            } else if (i == this.mItemMap.size() - 1) {
                if (this.isRtl()) {
                    this.updateCheckBox(cb, R.drawable.tcv_left_option, R.drawable.tcv_left_option_selected);
                } else {
                    this.updateCheckBox(cb, R.drawable.tcv_right_option, R.drawable.tcv_right_option_selected);
                }
            } else {
                this.updateCheckBox(cb, R.drawable.tcv_middle_option, R.drawable.tcv_middle_option_selected);
            }
            cb.setLayoutParams((ViewGroup.LayoutParams)params);
            if (this.mItemPadding != -1) {
                cb.setPadding(this.mItemPadding, this.mItemPadding, this.mItemPadding, this.mItemPadding);
            }
            if (this.mItemPaddingHorizontal != -1 && this.mItemPaddingVertical != -1) {
                cb.setPadding(this.mItemPaddingHorizontal, this.mItemPaddingVertical, this.mItemPaddingHorizontal, this.mItemPaddingVertical);
            }
            cb.setMinWidth(this.mStrokeWidth * 10);
            cb.setGravity(17);
            cb.setTextSize(0, (float)this.mTextSize);
            cb.setTypeface(XUI.getDefaultTypeface());
            cb.setText((CharSequence)item.getKey());
            this.addOnCheckedChangeListener(cb);
            textWidth = Math.max(cb.getPaint().measureText(item.getKey()), textWidth);
            this.mOptions.add(cb);
            ++i;
        }
        for (CheckBox option : this.mOptions) {
            if (this.mEqualWidth) {
                option.setWidth((int)(textWidth + (float)(this.mStrokeWidth * 20)));
            }
            this.addView((View)option);
        }
        if (this.mDefaultSelectionList != null && this.mDefaultSelectionList.length > 0) {
            for (Object selection : (Object)this.mDefaultSelectionList) {
                this.setIsChecked((int)selection, true);
            }
        }
    }

    private boolean isRtl() {
        return Build.VERSION.SDK_INT >= 17 && this.getResources().getConfiguration().getLayoutDirection() == 1;
    }

    private void updateCheckBox(CheckBox cb, int tcv_option_normal, int tcv_option_selected) {
        GradientDrawable unselected = (GradientDrawable)this.mContext.getResources().getDrawable(tcv_option_normal).mutate();
        unselected.setStroke(this.mStrokeWidth, this.mSelectedColor);
        unselected.setDither(true);
        unselected.setColor(this.mUnselectedColor);
        GradientDrawable selected = (GradientDrawable)this.mContext.getResources().getDrawable(tcv_option_selected).mutate();
        selected.setColor(this.mSelectedColor);
        selected.setStroke(this.mStrokeWidth, this.mSelectedColor);
        this.setCheckBoxBackground(cb, unselected, selected);
    }

    private void setCheckBoxBackground(CheckBox cb, GradientDrawable unselected, GradientDrawable selected) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{-16842912}, (Drawable)unselected);
        stateListDrawable.addState(new int[]{0x10100A0}, (Drawable)selected);
        if (Build.VERSION.SDK_INT < 16) {
            cb.setBackgroundDrawable((Drawable)stateListDrawable);
        } else {
            cb.setBackground((Drawable)stateListDrawable);
        }
    }

    public boolean isChecked(int position) {
        return ((CheckBox)this.getChildAt(position)).isChecked();
    }

    public void setIsChecked(int position, boolean isChecked) {
        CheckBox cb = (CheckBox)this.getChildAt(position);
        if (cb != null) {
            cb.setChecked(isChecked);
        }
    }

    public MultiTabControlView setItems(String[] itemArray, String[] valueArray) throws Exception {
        this.mItemMap.clear();
        if (itemArray != null && valueArray != null && itemArray.length != valueArray.length) {
            throw new Exception("Item labels and value arrays must be the same size");
        }
        if (itemArray != null) {
            if (valueArray != null) {
                for (int i = 0; i < itemArray.length; ++i) {
                    this.mItemMap.put(itemArray[i], valueArray[i]);
                }
            } else {
                for (String item : itemArray) {
                    this.mItemMap.put(item.toString(), item.toString());
                }
            }
        }
        this.update();
        return this;
    }

    private void setItems(CharSequence[] itemArray, CharSequence[] valueArray) throws Exception {
        block5: {
            if (itemArray != null && valueArray != null && itemArray.length != valueArray.length) {
                throw new Exception("Item labels and value arrays must be the same size");
            }
            if (itemArray == null) break block5;
            if (valueArray != null) {
                for (int i = 0; i < itemArray.length; ++i) {
                    this.mItemMap.put(itemArray[i].toString(), valueArray[i].toString());
                }
            } else {
                for (CharSequence item : itemArray) {
                    this.mItemMap.put(item.toString(), item.toString());
                }
            }
        }
    }

    public MultiTabControlView setItems(String[] items, String[] values, int ... defaultSelection) throws Exception {
        if (defaultSelection == null) {
            throw new Exception("defaultSelectionList cannot be null");
        }
        if (defaultSelection.length > items.length) {
            throw new Exception("the length of Default selectionList cannot be greater than the length of items");
        }
        for (int selection : defaultSelection) {
            if (selection <= this.mItemMap.size() - 1) continue;
            throw new Exception("Default selection cannot be greater than the number of items");
        }
        this.mDefaultSelectionList = defaultSelection;
        this.setItems(items, values);
        return this;
    }

    public MultiTabControlView setDefaultSelection(int ... defaultSelections) throws Exception {
        if (defaultSelections == null) {
            throw new Exception("defaultSelectionList cannot be null");
        }
        if (defaultSelections.length > this.mItemMap.size()) {
            throw new Exception("the length of Default selectionList cannot be greater than the length of items");
        }
        for (int selection : defaultSelections) {
            if (selection <= this.mItemMap.size() - 1) continue;
            throw new Exception("Default selection cannot be greater than the number of items");
        }
        this.mDefaultSelectionList = defaultSelections;
        this.update();
        return this;
    }

    public MultiTabControlView setDefaultSelection(@NonNull List<Integer> defaultSelections) throws Exception {
        int[] selections = new int[defaultSelections.size()];
        for (int i = 0; i < selections.length; ++i) {
            selections[i] = defaultSelections.get(i);
        }
        this.setDefaultSelection(selections);
        return this;
    }

    public MultiTabControlView setSelection(String ... values) {
        for (String value : values) {
            this.setSelection(value);
        }
        return this;
    }

    public MultiTabControlView setSelection(String value) {
        this.setSelectionStatus(value, true);
        return this;
    }

    public MultiTabControlView setSelectionStatus(String value, boolean isChecked) {
        String title = this.getTitleByValue(value);
        this.setSelectionStatusByTitle(title, isChecked);
        return this;
    }

    public MultiTabControlView setSelectionStatusByTitle(String title, boolean isChecked) {
        this.setSelectionStatusByTitle(title, isChecked, true);
        return this;
    }

    public MultiTabControlView setSelectionStatusByTitle(String title, boolean isChecked, boolean isSilent) {
        for (CheckBox option : this.mOptions) {
            if (!option.getText().toString().equalsIgnoreCase(title)) continue;
            if (isSilent) {
                option.setOnCheckedChangeListener(null);
                option.setChecked(isChecked);
                this.addOnCheckedChangeListener(option);
                continue;
            }
            option.setChecked(isChecked);
        }
        return this;
    }

    private String getTitleByValue(String value) {
        if (this.mItemMap.containsValue(value)) {
            for (String key : this.mItemMap.keySet()) {
                String title = this.mItemMap.get(key);
                if (title == null || !title.equalsIgnoreCase(value)) continue;
                return key;
            }
        }
        return "";
    }

    public MultiTabControlView setColors(int primaryColor, int secondaryColor) {
        this.mSelectedColor = primaryColor;
        this.mSelectedTextColor = secondaryColor;
        this.mUnselectedColor = secondaryColor;
        this.mUnselectedTextColor = primaryColor;
        this.mTextColorStateList = new ColorStateList((int[][])new int[][]{{-16842912}, {0x10100A0}}, new int[]{this.mUnselectedTextColor, this.mSelectedTextColor});
        this.update();
        return this;
    }

    public MultiTabControlView setColors(int selectedColor, int selectedTextColor, int unselectedColor, int unselectedTextColor) {
        this.mSelectedColor = selectedColor;
        this.mSelectedTextColor = selectedTextColor;
        this.mUnselectedColor = unselectedColor;
        this.mUnselectedTextColor = unselectedTextColor;
        this.mTextColorStateList = new ColorStateList((int[][])new int[][]{{-16842912}, {0x10100A0}}, new int[]{unselectedTextColor, selectedTextColor});
        this.update();
        return this;
    }

    public MultiTabControlView setOnMultiTabSelectionChangedListener(OnMultiTabSelectionChangedListener listener) {
        this.mListener = listener;
        return this;
    }

    public MultiTabControlView setEqualWidth(boolean equalWidth) {
        this.mEqualWidth = equalWidth;
        this.update();
        return this;
    }

    public MultiTabControlView setStretch(boolean stretch) {
        this.mStretch = stretch;
        this.update();
        return this;
    }

    public void setTypeface(Typeface typeface) {
        if (this.mOptions != null) {
            for (int i = 0; i < this.mOptions.size(); ++i) {
                this.mOptions.get(i).setTypeface(typeface);
            }
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.update();
    }

    public static interface OnMultiTabSelectionChangedListener {
        public void newSelection(String var1, String var2, boolean var3);
    }
}

