/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.tabbar;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import io.github.inflationx.calligraphy3.HasTypeface;

public class EasyIndicator
extends LinearLayout
implements View.OnClickListener,
ViewPager.OnPageChangeListener,
HasTypeface {
    private LinearLayout mIndicatorContainer;
    private ViewPager mViewPager;
    public OnTabClickListener mOnTabClickListener;
    private LinearLayout tabContent;
    private TextView[] tvs;
    public int screenWidth;
    public int screenHeight;
    private int mCurrIndex;
    private int indicatorHeight = 45;
    private int indicatorWidth = -1;
    private boolean indicatorLineShow = true;
    private int indicatorLineHeight = 3;
    private int indicatorLineWidth = -1;
    private int indicatorLineColor;
    private Drawable indicatorLineDrawable;
    private int indicatorBottomLineHeight = 0;
    private int indicatorBottomLineColor;
    private int indicatorVerticalLineWidth = 0;
    private int indicatorVerticalLineHeight = 0;
    private int indicatorVerticalLineColor;
    private int indicatorSelectedColor;
    private int indicatorNormalColor;
    private float indicatorTextSize;
    private float indicatorSelectTextSize = this.indicatorTextSize = 14.0f;

    public EasyIndicator(Context context) {
        this(context, null);
    }

    public EasyIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.EasyIndicatorStyle);
    }

    public EasyIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        this.initScreenWidth();
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.EasyIndicator, defStyleAttr, 0);
        this.indicatorWidth = (int)this.getDimensionPixelSize(typedArray, R.styleable.EasyIndicator_indicator_width, this.indicatorWidth);
        this.indicatorHeight = (int)this.getDimensionPixelSize(typedArray, R.styleable.EasyIndicator_indicator_height, this.indicatorHeight);
        Drawable indicatorBgDrawable = ResUtils.getDrawableAttrRes(context, typedArray, R.styleable.EasyIndicator_indicator_background);
        this.indicatorLineShow = typedArray.getBoolean(R.styleable.EasyIndicator_indicator_line_show, this.indicatorLineShow);
        this.indicatorLineWidth = (int)this.getDimensionPixelSize(typedArray, R.styleable.EasyIndicator_indicator_line_width, this.indicatorLineWidth);
        this.indicatorLineHeight = (int)this.getDimensionPixelSize(typedArray, R.styleable.EasyIndicator_indicator_line_height, this.indicatorLineHeight);
        this.indicatorLineColor = typedArray.getColor(R.styleable.EasyIndicator_indicator_line_color, ThemeUtils.getMainThemeColor(context));
        this.indicatorLineDrawable = ResUtils.getDrawableAttrRes(context, typedArray, R.styleable.EasyIndicator_indicator_line_res);
        this.indicatorBottomLineHeight = (int)this.getDimensionPixelSize(typedArray, R.styleable.EasyIndicator_indicator_bottom_line_height, this.indicatorBottomLineHeight);
        this.indicatorBottomLineColor = typedArray.getColor(R.styleable.EasyIndicator_indicator_bottom_line_color, ThemeUtils.resolveColor(context, R.attr.xui_config_color_separator_dark));
        this.indicatorSelectedColor = typedArray.getColor(R.styleable.EasyIndicator_indicator_selected_color, ThemeUtils.getMainThemeColor(context));
        this.indicatorNormalColor = typedArray.getColor(R.styleable.EasyIndicator_indicator_normal_color, ResUtils.getColor(context, R.color.xui_config_color_black));
        this.indicatorTextSize = this.getDimensionPixelSize(typedArray, R.styleable.EasyIndicator_indicator_textSize, (int)this.indicatorTextSize);
        this.indicatorVerticalLineWidth = (int)this.getDimensionPixelSize(typedArray, R.styleable.EasyIndicator_indicator_vertical_line_w, this.indicatorVerticalLineWidth);
        this.indicatorVerticalLineColor = typedArray.getColor(R.styleable.EasyIndicator_indicator_vertical_line_color, ThemeUtils.resolveColor(context, R.attr.xui_config_color_separator_dark));
        this.indicatorVerticalLineHeight = (int)this.getDimensionPixelSize(typedArray, R.styleable.EasyIndicator_indicator_vertical_line_h, this.indicatorVerticalLineHeight);
        this.indicatorSelectTextSize = this.getDimensionPixelSize(typedArray, R.styleable.EasyIndicator_indicator_select_textSize, 14);
        typedArray.recycle();
        this.indicatorWidth = Math.min(this.indicatorWidth, this.screenWidth);
        if (this.indicatorWidth == 0) {
            this.indicatorWidth = -1;
        }
        this.tabContent = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.indicatorWidth, -2);
        if (indicatorBgDrawable != null) {
            this.tabContent.setBackground(indicatorBgDrawable);
        } else {
            this.tabContent.setBackgroundColor(-1);
        }
        params.gravity = 17;
        this.tabContent.setLayoutParams((ViewGroup.LayoutParams)params);
        this.tabContent.setGravity(17);
    }

    public void setTabTitles(String[] tabTitles) {
        this.tvs = new TextView[tabTitles.length];
        this.tabContent.removeAllViews();
        for (int i = 0; i < tabTitles.length; ++i) {
            TextView view = new TextView(this.getContext());
            view.setTag((Object)i);
            view.setText((CharSequence)tabTitles[i]);
            view.setTypeface(XUI.getDefaultTypeface());
            view.setGravity(17);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, this.indicatorHeight, 1.0f);
            view.setLayoutParams((ViewGroup.LayoutParams)lp);
            if (i == 0) {
                view.setTextColor(this.indicatorSelectedColor);
                view.setTextSize(0, this.indicatorSelectTextSize);
            } else {
                view.setTextColor(this.indicatorNormalColor);
                view.setTextSize(0, this.indicatorTextSize);
            }
            view.setOnClickListener((View.OnClickListener)this);
            this.tvs[i] = view;
            this.tabContent.addView((View)view);
            if (i == tabTitles.length - 1) continue;
            View line = new View(this.getContext());
            line.setBackgroundColor(this.indicatorVerticalLineColor);
            LinearLayoutCompat.LayoutParams compat = new LinearLayoutCompat.LayoutParams(this.indicatorVerticalLineWidth, this.indicatorVerticalLineHeight);
            line.setLayoutParams((ViewGroup.LayoutParams)compat);
            this.tabContent.addView(line);
        }
        this.removeAllViews();
        this.addView((View)this.tabContent);
        if (this.indicatorLineShow) {
            this.mIndicatorContainer = new LinearLayout(this.getContext());
            this.mIndicatorContainer.setGravity(17);
            int iw = this.indicatorWidth > 0 ? this.indicatorWidth / this.tvs.length : this.screenWidth / this.tvs.length;
            this.mIndicatorContainer.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(iw, this.indicatorLineHeight));
            View indicator = new View(this.getContext());
            indicator.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(this.indicatorLineWidth > 0 ? this.indicatorLineWidth : -1, -1));
            if (this.indicatorLineDrawable != null) {
                indicator.setBackground(this.indicatorLineDrawable);
            } else {
                indicator.setBackgroundColor(this.indicatorLineColor);
            }
            this.mIndicatorContainer.addView(indicator);
            this.addView((View)this.mIndicatorContainer);
            if (this.indicatorWidth > 0) {
                LinearLayout.LayoutParams ll = (LinearLayout.LayoutParams)this.mIndicatorContainer.getLayoutParams();
                ll.setMarginStart((this.screenWidth - this.indicatorWidth) / 2);
                this.mIndicatorContainer.setLayoutParams((ViewGroup.LayoutParams)ll);
            }
        }
        View line = new View(this.getContext());
        LinearLayoutCompat.LayoutParams params = new LinearLayoutCompat.LayoutParams(-1, this.indicatorBottomLineHeight);
        line.setLayoutParams((ViewGroup.LayoutParams)params);
        line.setBackgroundColor(this.indicatorBottomLineColor);
        this.addView(line);
    }

    public void setViewPager(PagerAdapter adapter) {
        this.mViewPager = new ViewPager(this.getContext());
        this.mViewPager.setId(R.id.view_pager);
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(-1, -1));
        this.mViewPager.setAdapter(adapter);
        this.mViewPager.setCurrentItem(0);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.addView((View)this.mViewPager);
    }

    public void setViewPager(ViewPager viewPage, PagerAdapter adapter) {
        this.mViewPager = viewPage;
        this.mViewPager.setAdapter(adapter);
        this.mViewPager.setCurrentItem(0);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
    }

    private AnimatorSet buildIndicatorAnimatorTowards(TextView tv) {
        float x = this.tabContent.getX();
        ObjectAnimator xAnimator = ObjectAnimator.ofFloat((Object)this.mIndicatorContainer, (String)"X", (float[])new float[]{this.mIndicatorContainer.getX(), tv.getX() + x});
        final ViewGroup.LayoutParams params = this.mIndicatorContainer.getLayoutParams();
        ValueAnimator widthAnimator = ValueAnimator.ofInt((int[])new int[]{params.width, tv.getMeasuredWidth()});
        widthAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                params.width = (Integer)animation.getAnimatedValue();
                EasyIndicator.this.mIndicatorContainer.setLayoutParams(params);
            }
        });
        AnimatorSet set = new AnimatorSet();
        set.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        set.playTogether(new Animator[]{xAnimator, widthAnimator});
        return set;
    }

    public void onClick(View v) {
        TextView tv = (TextView)v;
        int position = (Integer)v.getTag();
        if (this.mViewPager != null) {
            this.mViewPager.setCurrentItem(position);
        } else {
            this.setSelectorColor(tv);
            if (this.indicatorLineShow) {
                this.buildIndicatorAnimatorTowards(tv).start();
            }
        }
        if (this.mOnTabClickListener != null) {
            this.mOnTabClickListener.onTabClick(((TextView)v).getText().toString(), position);
        }
    }

    private void setSelectorColor(TextView tv) {
        for (TextView textView : this.tvs) {
            textView.setTextColor(this.indicatorNormalColor);
            textView.setTextSize(0, this.indicatorTextSize);
        }
        tv.setTextColor(this.indicatorSelectedColor);
        tv.setTextSize(0, this.indicatorSelectTextSize);
    }

    public void setOnTabClickListener(OnTabClickListener onTabClickListener) {
        this.mOnTabClickListener = onTabClickListener;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        LinearLayout.LayoutParams ll = (LinearLayout.LayoutParams)this.mIndicatorContainer.getLayoutParams();
        if (this.mCurrIndex == position) {
            ll.setMarginStart((int)((float)(this.mCurrIndex * this.mIndicatorContainer.getMeasuredWidth()) + positionOffset * (float)this.mIndicatorContainer.getMeasuredWidth()));
        } else if (this.mCurrIndex > position) {
            ll.setMarginStart((int)((float)(this.mCurrIndex * this.mIndicatorContainer.getMeasuredWidth()) - (1.0f - positionOffset) * (float)this.mIndicatorContainer.getMeasuredWidth()));
        }
        this.mIndicatorContainer.setLayoutParams((ViewGroup.LayoutParams)ll);
    }

    public void onPageSelected(int position) {
        this.mCurrIndex = position;
        this.setSelectorColor(this.tvs[position]);
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void setTypeface(Typeface typeface) {
        if (this.tvs != null) {
            for (TextView tv : this.tvs) {
                tv.setTypeface(typeface);
            }
        }
    }

    private float getDimensionPixelSize(TypedArray typeArray, int styleable2, int defaultSize) {
        int sizeStyleable = typeArray.getResourceId(styleable2, 0);
        return sizeStyleable > 0 ? (float)typeArray.getResources().getDimensionPixelSize(sizeStyleable) : (float)typeArray.getDimensionPixelSize(styleable2, (int)this.getPixelSizeBySp(defaultSize));
    }

    private float getPixelSizeBySp(int sp) {
        Resources res = this.getResources();
        float scale = res.getDisplayMetrics().scaledDensity;
        return (float)sp * scale;
    }

    private void initScreenWidth() {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.screenHeight = dm.heightPixels;
        this.screenWidth = dm.widthPixels;
    }

    public LinearLayout getTabContent() {
        return this.tabContent;
    }

    public static interface OnTabClickListener {
        public void onTabClick(String var1, int var2);
    }
}

