/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.statelayout;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.xuexiang.xui.logs.UILog;

public class StatusLoader {
    public static final int STATUS_LOADING = 1;
    public static final int STATUS_LOAD_SUCCESS = 2;
    public static final int STATUS_LOAD_FAILED = 3;
    public static final int STATUS_EMPTY_DATA = 4;
    public static final int STATUS_CUSTOM = 5;
    private static volatile StatusLoader sDefault;
    private Adapter mAdapter;

    private StatusLoader() {
    }

    public static StatusLoader from(Adapter adapter) {
        StatusLoader statusLoader = new StatusLoader();
        statusLoader.mAdapter = adapter;
        return statusLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatusLoader getDefault() {
        if (sDefault != null) return sDefault;
        Class<StatusLoader> clazz = StatusLoader.class;
        synchronized (StatusLoader.class) {
            if (sDefault != null) return sDefault;
            sDefault = new StatusLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefault;
        }
    }

    public static void initDefault(Adapter adapter) {
        StatusLoader.getDefault().mAdapter = adapter;
    }

    public Holder wrap(Activity activity) {
        ViewGroup wrapper = (ViewGroup)activity.findViewById(0x1020002);
        return new Holder(this.mAdapter, (Context)activity, wrapper);
    }

    public Holder wrap(View view) {
        FrameLayout wrapper = new FrameLayout(view.getContext());
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp != null) {
            wrapper.setLayoutParams(lp);
        }
        if (view.getParent() != null) {
            ViewGroup parent = (ViewGroup)view.getParent();
            int index = parent.indexOfChild(view);
            parent.removeView(view);
            parent.addView((View)wrapper, index);
        }
        FrameLayout.LayoutParams newLp = new FrameLayout.LayoutParams(-1, -1);
        wrapper.addView(view, (ViewGroup.LayoutParams)newLp);
        return new Holder(this.mAdapter, view.getContext(), (ViewGroup)wrapper);
    }

    public Holder cover(View view) {
        ViewParent parent = view.getParent();
        if (parent == null) {
            throw new RuntimeException("view has no parent to show StatusLoader as cover!");
        }
        ViewGroup viewGroup = (ViewGroup)parent;
        FrameLayout wrapper = new FrameLayout(view.getContext());
        viewGroup.addView((View)wrapper, view.getLayoutParams());
        return new Holder(this.mAdapter, view.getContext(), (ViewGroup)wrapper);
    }

    public static class Holder {
        private Adapter mAdapter;
        private Context mContext;
        private View.OnClickListener mRetryListener;
        private View mCurStatusView;
        private ViewGroup mWrapper;
        private int curState;
        private SparseArray<View> mStatusViews = new SparseArray(5);
        private Object mData;

        private Holder(Adapter adapter, Context context, ViewGroup wrapper) {
            this.mAdapter = adapter;
            this.mContext = context;
            this.mWrapper = wrapper;
        }

        public Holder withRetry(View.OnClickListener listener) {
            this.mRetryListener = listener;
            return this;
        }

        public Holder withData(Object data) {
            this.mData = data;
            return this;
        }

        public int getCurState() {
            return this.curState;
        }

        public void showLoading() {
            this.showLoadingStatus(1);
        }

        public void showLoadSuccess() {
            this.showLoadingStatus(2);
        }

        public void showLoadFailed() {
            this.showLoadingStatus(3);
        }

        public void showEmpty() {
            this.showLoadingStatus(4);
        }

        public void showCustom() {
            this.showLoadingStatus(5);
        }

        public void showLoadingStatus(int status) {
            if (this.curState == status || !this.validate()) {
                return;
            }
            this.curState = status;
            View convertView = (View)this.mStatusViews.get(status);
            if (convertView == null) {
                convertView = this.mCurStatusView;
            }
            try {
                View view = this.mAdapter.getView(this, convertView, status);
                if (view == null) {
                    UILog.e(this.mAdapter.getClass().getName() + ".getView returns null");
                    return;
                }
                if (view != this.mCurStatusView || this.mWrapper.indexOfChild(view) < 0) {
                    if (this.mCurStatusView != null) {
                        this.mWrapper.removeView(this.mCurStatusView);
                    }
                    if (Build.VERSION.SDK_INT >= 21) {
                        view.setElevation(Float.MAX_VALUE);
                    }
                    this.mWrapper.addView(view);
                    ViewGroup.LayoutParams lp = view.getLayoutParams();
                    if (lp != null) {
                        lp.width = -1;
                        lp.height = -1;
                    }
                } else if (this.mWrapper.indexOfChild(view) != this.mWrapper.getChildCount() - 1) {
                    view.bringToFront();
                }
                this.mCurStatusView = view;
                this.mStatusViews.put(status, (Object)view);
            }
            catch (Exception e) {
                UILog.e(e);
            }
        }

        private boolean validate() {
            if (this.mAdapter == null) {
                UILog.e("StatusLoader.Adapter is not specified\uff01");
            }
            if (this.mContext == null) {
                UILog.e("Context is null\uff01");
            }
            if (this.mWrapper == null) {
                UILog.e("The mWrapper of loading status view is null\uff01");
            }
            return this.mAdapter != null && this.mContext != null && this.mWrapper != null;
        }

        public Context getContext() {
            return this.mContext;
        }

        public ViewGroup getWrapper() {
            return this.mWrapper;
        }

        public View.OnClickListener getRetryListener() {
            return this.mRetryListener;
        }

        public <T> T getData() {
            try {
                return (T)this.mData;
            }
            catch (Exception e) {
                UILog.e(e);
                return null;
            }
        }
    }

    public static interface Adapter {
        public View getView(Holder var1, View var2, int var3);
    }
}

