/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.statelayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.AnimRes;
import androidx.annotation.StringRes;
import com.xuexiang.xui.R;
import com.xuexiang.xui.UIConfig;
import com.xuexiang.xui.widget.progress.materialprogressbar.MaterialProgressBar;
import com.xuexiang.xui.widget.statelayout.CustomStateOptions;
import com.xuexiang.xui.widget.statelayout.SimpleAnimationListener;

public class StatefulLayout
extends LinearLayout {
    private static final String MSG_ONE_CHILD = "StatefulLayout must have one child!";
    private boolean mAnimationEnabled;
    private Animation mInAnimation;
    private Animation mOutAnimation;
    private int mAnimCounter;
    private View mContent;
    private LinearLayout mLlContainer;
    private MaterialProgressBar mProgressBar;
    private ImageView mImage;
    private TextView mMessage;
    private Button mBtnRetry;

    public StatefulLayout(Context context) {
        this(context, null);
    }

    public StatefulLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.StatefulLayoutStyle);
    }

    public StatefulLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.StatefulLayout, defStyleAttr, 0);
        this.mAnimationEnabled = array.getBoolean(R.styleable.StatefulLayout_stf_animationEnabled, UIConfig.getInstance((Context)context).getStateLayoutConfig().animationEnabled);
        int inAnimationResId = array.getResourceId(R.styleable.StatefulLayout_stf_inAnimation, -1);
        this.mInAnimation = inAnimationResId != -1 ? this.loadAnimation(inAnimationResId) : UIConfig.getInstance(context).getStateLayoutConfig().getInAnimation();
        int outAnimationResId = array.getResourceId(R.styleable.StatefulLayout_stf_outAnimation, -1);
        this.mOutAnimation = inAnimationResId != -1 ? this.loadAnimation(outAnimationResId) : UIConfig.getInstance(context).getStateLayoutConfig().getOutAnimation();
        array.recycle();
    }

    public boolean isAnimationEnabled() {
        return this.mAnimationEnabled;
    }

    public StatefulLayout setAnimationEnabled(boolean animationEnabled) {
        this.mAnimationEnabled = animationEnabled;
        return this;
    }

    public Animation getInAnimation() {
        return this.mInAnimation;
    }

    public StatefulLayout setInAnimation(Animation animation) {
        this.mInAnimation = animation;
        return this;
    }

    public StatefulLayout setInAnimation(@AnimRes int anim2) {
        this.mInAnimation = this.loadAnimation(anim2);
        return this;
    }

    public Animation getOutAnimation() {
        return this.mOutAnimation;
    }

    public StatefulLayout setOutAnimation(Animation animation) {
        this.mOutAnimation = animation;
        return this;
    }

    public StatefulLayout setOutAnimation(@AnimRes int anim2) {
        this.mOutAnimation = this.loadAnimation(anim2);
        return this;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() > 1) {
            throw new IllegalStateException(MSG_ONE_CHILD);
        }
        this.attachTemplate();
    }

    public void attachTemplate() {
        this.setOrientation(1);
        this.mContent = this.getChildAt(0);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.xui_layout_stateful_template, (ViewGroup)this, true);
        this.mLlContainer = (LinearLayout)this.findViewById(R.id.stContainer);
        this.mProgressBar = (MaterialProgressBar)this.findViewById(R.id.stProgress);
        this.mImage = (ImageView)this.findViewById(R.id.stImage);
        this.mMessage = (TextView)this.findViewById(R.id.stMessage);
        this.mBtnRetry = (Button)this.findViewById(R.id.stButton);
    }

    public void showContent() {
        if (this.mContent == null) {
            return;
        }
        if (this.isAnimationEnabled()) {
            this.mLlContainer.clearAnimation();
            this.mContent.clearAnimation();
            final int animCounterCopy = ++this.mAnimCounter;
            if (this.mLlContainer.getVisibility() == 0) {
                this.mOutAnimation.setAnimationListener((Animation.AnimationListener)new SimpleAnimationListener(){

                    @Override
                    public void onAnimationEnd(Animation animation) {
                        if (StatefulLayout.this.mAnimCounter != animCounterCopy) {
                            return;
                        }
                        StatefulLayout.this.mLlContainer.setVisibility(8);
                        StatefulLayout.this.mContent.setVisibility(0);
                        StatefulLayout.this.mContent.startAnimation(StatefulLayout.this.mInAnimation);
                    }
                });
                this.mLlContainer.startAnimation(this.mOutAnimation);
            }
        } else {
            this.mLlContainer.setVisibility(8);
            this.mContent.setVisibility(0);
        }
    }

    public void showLoading() {
        this.showLoading(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getLoadingMessageRes());
    }

    public void showLoading(@StringRes int resId) {
        this.showLoading(this.getString(resId));
    }

    public void showLoading(String message) {
        this.showCustom(new CustomStateOptions().message(message).loading());
    }

    public void showEmpty() {
        this.showEmpty(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getEmptyMessageRes());
    }

    public void showEmpty(@StringRes int resId) {
        this.showEmpty(this.getString(resId));
    }

    public void showEmpty(String message) {
        this.showCustom(new CustomStateOptions().message(message).image(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getEmptyImageRes()));
    }

    public void showError(View.OnClickListener clickListener) {
        this.showError(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getErrorMessageRes(), clickListener);
    }

    public void showError(@StringRes int resId, View.OnClickListener clickListener) {
        this.showError(this.getString(resId), clickListener);
    }

    public void showError(String message, View.OnClickListener clickListener) {
        this.showError(message, this.getString(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getRetryMessageRes()), clickListener);
    }

    public void showError(String message, String buttonText, View.OnClickListener clickListener) {
        this.showCustom(new CustomStateOptions().message(message).image(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getErrorImageRes()).buttonText(buttonText).buttonClickListener(clickListener));
    }

    public void showOffline(View.OnClickListener clickListener) {
        this.showOffline(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getOfflineMessageRes(), clickListener);
    }

    public void showOffline(@StringRes int resId, View.OnClickListener clickListener) {
        this.showOffline(this.getString(resId), clickListener);
    }

    public void showOffline(String message, View.OnClickListener clickListener) {
        this.showOffline(message, this.getString(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getRetryMessageRes()), clickListener);
    }

    public void showOffline(String message, String buttonText, View.OnClickListener clickListener) {
        this.showCustom(new CustomStateOptions().message(message).image(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getOfflineImageRes()).buttonText(buttonText).buttonClickListener(clickListener));
    }

    public void showLocationOff(View.OnClickListener clickListener) {
        this.showLocationOff(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getLocationOffMessageRes(), clickListener);
    }

    public void showLocationOff(@StringRes int resId, View.OnClickListener clickListener) {
        this.showLocationOff(this.getString(resId), clickListener);
    }

    public void showLocationOff(String message, View.OnClickListener clickListener) {
        this.showLocationOff(message, this.getString(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getRetryMessageRes()), clickListener);
    }

    public void showLocationOff(String message, String buttonText, View.OnClickListener clickListener) {
        this.showCustom(new CustomStateOptions().message(message).image(UIConfig.getInstance(this.getContext()).getStateLayoutConfig().getLocationOffImageRes()).buttonText(buttonText).buttonClickListener(clickListener));
    }

    public void showCustom(final CustomStateOptions options) {
        if (this.isAnimationEnabled()) {
            this.mLlContainer.clearAnimation();
            if (this.mContent != null) {
                this.mContent.clearAnimation();
            }
            final int animCounterCopy = ++this.mAnimCounter;
            if (this.mLlContainer.getVisibility() == 8) {
                this.mOutAnimation.setAnimationListener((Animation.AnimationListener)new SimpleAnimationListener(){

                    @Override
                    public void onAnimationEnd(Animation animation) {
                        if (animCounterCopy != StatefulLayout.this.mAnimCounter) {
                            return;
                        }
                        if (StatefulLayout.this.mContent != null) {
                            StatefulLayout.this.mContent.setVisibility(8);
                        }
                        StatefulLayout.this.mLlContainer.setVisibility(0);
                        StatefulLayout.this.mLlContainer.startAnimation(StatefulLayout.this.mInAnimation);
                    }
                });
                if (this.mContent != null) {
                    this.mContent.startAnimation(this.mOutAnimation);
                }
                this.state(options);
            } else {
                this.mOutAnimation.setAnimationListener((Animation.AnimationListener)new SimpleAnimationListener(){

                    @Override
                    public void onAnimationEnd(Animation animation) {
                        if (animCounterCopy != StatefulLayout.this.mAnimCounter) {
                            return;
                        }
                        StatefulLayout.this.state(options);
                        StatefulLayout.this.mLlContainer.startAnimation(StatefulLayout.this.mInAnimation);
                    }
                });
                this.mLlContainer.startAnimation(this.mOutAnimation);
            }
        } else {
            if (this.mContent != null) {
                this.mContent.setVisibility(8);
            }
            this.mLlContainer.setVisibility(0);
            this.state(options);
        }
    }

    private void state(CustomStateOptions options) {
        if (!TextUtils.isEmpty((CharSequence)options.getMessage())) {
            this.mMessage.setVisibility(0);
            this.mMessage.setText((CharSequence)options.getMessage());
        } else {
            this.mMessage.setVisibility(8);
        }
        if (options.isLoading()) {
            this.mProgressBar.setVisibility(0);
            this.mImage.setVisibility(8);
            this.mBtnRetry.setVisibility(8);
        } else {
            this.mProgressBar.setVisibility(8);
            if (options.getImageRes() != 0) {
                this.mImage.setVisibility(0);
                this.mImage.setImageResource(options.getImageRes());
            } else {
                this.mImage.setVisibility(8);
            }
            if (options.getClickListener() != null) {
                this.mBtnRetry.setVisibility(0);
                this.mBtnRetry.setOnClickListener(options.getClickListener());
                if (!TextUtils.isEmpty((CharSequence)options.getButtonText())) {
                    this.mBtnRetry.setText((CharSequence)options.getButtonText());
                }
            } else {
                this.mBtnRetry.setVisibility(8);
            }
        }
    }

    private String getString(@StringRes int resId) {
        return this.getContext().getString(resId);
    }

    private Animation loadAnimation(@AnimRes int resId) {
        return AnimationUtils.loadAnimation((Context)this.getContext(), (int)resId);
    }
}

