/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.statelayout;

import android.content.Context;
import android.view.animation.Animation;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;

public class StateLayoutConfig {
    private static final boolean DEFAULT_ANIM_ENABLED = true;
    private static final int DEFAULT_IN_ANIM = 0x10A0000;
    private static final int DEFAULT_OUT_ANIM = 0x10A0001;
    public boolean animationEnabled = true;
    public Animation inAnimation;
    public Animation outAnimation;
    public int emptyImageRes;
    public int emptyMessageRes;
    public int errorImageRes;
    public int errorMessageRes;
    public int offlineImageRes;
    public int offlineMessageRes;
    public int locationOffImageRes;
    public int locationOffMessageRes;
    public int retryMessageRes;
    public int loadingMessageRes;

    public StateLayoutConfig(@NonNull Context context) {
        this.inAnimation = ResUtils.getAnim(context, 0x10A0000);
        this.outAnimation = ResUtils.getAnim(context, 0x10A0001);
        this.emptyImageRes = R.drawable.stf_ic_empty;
        this.emptyMessageRes = R.string.stfEmptyMessage;
        this.errorImageRes = R.drawable.stf_ic_error;
        this.errorMessageRes = R.string.stfErrorMessage;
        this.offlineImageRes = R.drawable.stf_ic_offline;
        this.offlineMessageRes = R.string.stfOfflineMessage;
        this.locationOffImageRes = R.drawable.stf_ic_location_off;
        this.locationOffMessageRes = R.string.stfLocationOffMessage;
        this.retryMessageRes = R.string.stfRetryButtonText;
        this.loadingMessageRes = R.string.stfLoadingMessage;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public StateLayoutConfig setAnimationEnabled(boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
        return this;
    }

    public Animation getInAnimation() {
        return this.inAnimation;
    }

    public StateLayoutConfig setInAnimation(Animation inAnimation) {
        this.inAnimation = inAnimation;
        return this;
    }

    public Animation getOutAnimation() {
        return this.outAnimation;
    }

    public StateLayoutConfig setOutAnimation(Animation outAnimation) {
        this.outAnimation = outAnimation;
        return this;
    }

    public int getEmptyImageRes() {
        return this.emptyImageRes;
    }

    public StateLayoutConfig setEmptyImageRes(@DrawableRes int emptyImageRes) {
        this.emptyImageRes = emptyImageRes;
        return this;
    }

    public int getEmptyMessageRes() {
        return this.emptyMessageRes;
    }

    public StateLayoutConfig setEmptyMessageRes(@StringRes int emptyMessageRes) {
        this.emptyMessageRes = emptyMessageRes;
        return this;
    }

    public int getErrorImageRes() {
        return this.errorImageRes;
    }

    public StateLayoutConfig setErrorImageRes(@DrawableRes int errorImageRes) {
        this.errorImageRes = errorImageRes;
        return this;
    }

    public int getErrorMessageRes() {
        return this.errorMessageRes;
    }

    public StateLayoutConfig setErrorMessageRes(@StringRes int errorMessageRes) {
        this.errorMessageRes = errorMessageRes;
        return this;
    }

    public int getOfflineImageRes() {
        return this.offlineImageRes;
    }

    public StateLayoutConfig setOfflineImageRes(@DrawableRes int offlineImageRes) {
        this.offlineImageRes = offlineImageRes;
        return this;
    }

    public int getOfflineMessageRes() {
        return this.offlineMessageRes;
    }

    public StateLayoutConfig setOfflineMessageRes(@StringRes int offlineMessageRes) {
        this.offlineMessageRes = offlineMessageRes;
        return this;
    }

    public int getLocationOffImageRes() {
        return this.locationOffImageRes;
    }

    public StateLayoutConfig setLocationOffImageRes(@DrawableRes int locationOffImageRes) {
        this.locationOffImageRes = locationOffImageRes;
        return this;
    }

    public int getLocationOffMessageRes() {
        return this.locationOffMessageRes;
    }

    public StateLayoutConfig setLocationOffMessageRes(@StringRes int locationOffMessageRes) {
        this.locationOffMessageRes = locationOffMessageRes;
        return this;
    }

    public int getRetryMessageRes() {
        return this.retryMessageRes;
    }

    public StateLayoutConfig setRetryMessageRes(@StringRes int retryMessageRes) {
        this.retryMessageRes = retryMessageRes;
        return this;
    }

    public int getLoadingMessageRes() {
        return this.loadingMessageRes;
    }

    public StateLayoutConfig setLoadingMessageRes(@StringRes int loadingMessageRes) {
        this.loadingMessageRes = loadingMessageRes;
        return this;
    }
}

