/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.spinner.editspinner;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.spinner.editspinner.BaseEditSpinnerAdapter;
import com.xuexiang.xui.widget.spinner.editspinner.EditSpinnerFilter;
import java.util.List;

public class EditSpinnerAdapter<T>
extends BaseEditSpinnerAdapter<T>
implements EditSpinnerFilter {
    private int mTextColor;
    private float mTextSize;
    private int mBackgroundSelector;
    private String mFilterColor = "#F15C58";
    private boolean mIsFilterKey = false;

    public EditSpinnerAdapter(List<T> data) {
        super(data);
    }

    public EditSpinnerAdapter(T[] data) {
        super(data);
    }

    @Override
    public EditSpinnerFilter getEditSpinnerFilter() {
        return this;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ms_layout_list_item, parent, false);
            holder = new ViewHolder(convertView, this.mTextColor, this.mTextSize, this.mBackgroundSelector);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.mTextView.setText((CharSequence)Html.fromHtml((String)this.getItem(position)));
        return convertView;
    }

    @Override
    public boolean onFilter(String keyword) {
        this.mDisplayData.clear();
        if (TextUtils.isEmpty((CharSequence)keyword)) {
            this.initDisplayData(this.mDataSource);
            for (int i = 0; i < this.mIndexs.length; ++i) {
                this.mIndexs[i] = i;
            }
        } else {
            try {
                StringBuilder builder = new StringBuilder();
                builder.append("[^\\s]*").append(keyword).append("[^\\s]*");
                for (int i = 0; i < this.mDataSource.size(); ++i) {
                    if (!this.getDataSourceString(i).replaceAll("\\s+", "|").matches(builder.toString())) continue;
                    this.mIndexs[this.mDisplayData.size()] = i;
                    if (this.mIsFilterKey) {
                        this.mDisplayData.add(this.getDataSourceString(i).replaceFirst(keyword, "<font color=\"" + this.mFilterColor + "\">" + keyword + "</font>"));
                        continue;
                    }
                    this.mDisplayData.add(this.getDataSourceString(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.notifyDataSetChanged();
        return this.mDisplayData.size() > 0;
    }

    public EditSpinnerAdapter setTextColor(@ColorInt int textColor) {
        this.mTextColor = textColor;
        return this;
    }

    public EditSpinnerAdapter setTextSize(float textSize) {
        this.mTextSize = textSize;
        return this;
    }

    public EditSpinnerAdapter setBackgroundSelector(@DrawableRes int backgroundSelector) {
        this.mBackgroundSelector = backgroundSelector;
        return this;
    }

    public EditSpinnerAdapter setFilterColor(String filterColor) {
        this.mFilterColor = filterColor;
        return this;
    }

    public EditSpinnerAdapter setIsFilterKey(boolean isFilterKey) {
        this.mIsFilterKey = isFilterKey;
        return this;
    }

    private static class ViewHolder {
        private TextView mTextView;

        private ViewHolder(@NonNull View convertView, @ColorInt int textColor, float textSize, @DrawableRes int backgroundSelector) {
            Configuration config;
            this.mTextView = (TextView)convertView.findViewById(R.id.tv_tinted_spinner);
            this.mTextView.setTextColor(textColor);
            this.mTextView.setTextSize(0, textSize);
            if (backgroundSelector != 0) {
                this.mTextView.setBackgroundResource(backgroundSelector);
            }
            if (Build.VERSION.SDK_INT >= 17 && (config = convertView.getResources().getConfiguration()).getLayoutDirection() == 1) {
                this.mTextView.setTextDirection(4);
            }
        }
    }
}

