/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.spinner.editspinner;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.spinner.editspinner.BaseEditSpinnerAdapter;
import com.xuexiang.xui.widget.spinner.editspinner.EditSpinnerAdapter;
import java.lang.ref.WeakReference;
import java.util.List;

public class EditSpinner
extends FrameLayout
implements View.OnClickListener,
AdapterView.OnItemClickListener,
TextWatcher {
    private static final int DEFAULT_MAX_LINE = 1;
    private static final int TOGGLE_POPUP_WINDOW_INTERVAL = 200;
    private EditText mEditText;
    private ImageView mIvArrow;
    private WeakReference<ListPopupWindow> mPopupWindow;
    private BaseEditSpinnerAdapter mAdapter;
    private long mPopupWindowHideTime;
    private Animation mAnimation;
    private Animation mResetAnimation;
    private AdapterView.OnItemClickListener mOnItemClickListener;
    private int mMaxLine = 1;
    private Drawable mDropDownBg;
    private int mPopAnimStyle;
    private boolean mIsShowFilterData = true;
    private boolean mIsFilterKey = false;

    public EditSpinner(Context context) {
        this(context, null);
    }

    public EditSpinner(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.EditSpinnerStyle);
    }

    public EditSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
        this.initAttrs(context, attrs, defStyleAttr);
        this.initAnimation();
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.xui_layout_edit_spinner, (ViewGroup)this);
        this.mEditText = (EditText)this.findViewById(R.id.edit_spinner_edit);
        this.mIvArrow = (ImageView)this.findViewById(R.id.edit_spinner_arrow);
        this.mIvArrow.setOnClickListener((View.OnClickListener)this);
        this.mEditText.addTextChangedListener((TextWatcher)this);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        int arrowMargin;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.EditSpinner, defStyleAttr, 0);
        this.mIsShowFilterData = typedArray.getBoolean(R.styleable.EditSpinner_es_isShowFilterData, true);
        this.mIsFilterKey = typedArray.getBoolean(R.styleable.EditSpinner_es_isFilterKey, false);
        int imageId = typedArray.getResourceId(R.styleable.EditSpinner_es_arrowImage, 0);
        if (imageId != 0) {
            this.mIvArrow.setImageResource(imageId);
        }
        if ((arrowMargin = typedArray.getDimensionPixelSize(R.styleable.EditSpinner_es_arrowMargin, -1)) != -1) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mIvArrow.getLayoutParams();
            params.setMargins(arrowMargin, 0, arrowMargin, 0);
            this.mIvArrow.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mEditText.setHint((CharSequence)typedArray.getString(R.styleable.EditSpinner_es_hint));
        int bg = typedArray.getResourceId(R.styleable.EditSpinner_es_background, 0);
        if (bg != 0) {
            this.mEditText.setBackgroundResource(bg);
        }
        this.mMaxLine = typedArray.getInt(R.styleable.EditSpinner_es_maxLine, 1);
        this.mEditText.setMaxLines(this.mMaxLine);
        int height = typedArray.getDimensionPixelSize(R.styleable.EditSpinner_es_height, ThemeUtils.resolveDimension(this.getContext(), R.attr.ms_item_height_size));
        this.mEditText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, height));
        this.setTextColors(ResUtils.getColorStateListAttrRes(context, typedArray, R.styleable.EditSpinner_es_textColor));
        this.setTextSize(typedArray.getDimensionPixelSize(R.styleable.EditSpinner_es_textSize, ThemeUtils.resolveDimension(this.getContext(), R.attr.xui_config_size_spinner_text)));
        int entriesId = typedArray.getResourceId(R.styleable.EditSpinner_es_entries, 0);
        if (entriesId != 0) {
            this.setItems(ResUtils.getStringArray(context, entriesId));
        }
        this.mDropDownBg = ResUtils.getDrawableAttrRes(context, typedArray, R.styleable.EditSpinner_es_dropdown_bg);
        boolean enable = typedArray.getBoolean(R.styleable.EditSpinner_es_enable, true);
        this.setEnabled(enable);
        int maxLength = typedArray.getInteger(R.styleable.EditSpinner_es_maxLength, -1);
        this.setMaxLength(maxLength);
        int maxEms = typedArray.getInteger(R.styleable.EditSpinner_es_maxEms, -1);
        this.setMaxEms(maxEms);
        this.mPopAnimStyle = typedArray.getResourceId(R.styleable.EditSpinner_es_popAnimStyle, -1);
        typedArray.recycle();
    }

    private void initAnimation() {
        this.mAnimation = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mAnimation.setDuration(300L);
        this.mAnimation.setFillAfter(true);
        this.mResetAnimation = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mResetAnimation.setDuration(300L);
        this.mResetAnimation.setFillAfter(true);
    }

    private void setBaseAdapter(BaseAdapter adapter) {
        ListPopupWindow popupWindow;
        if (this.mPopupWindow == null) {
            this.mPopupWindow = new WeakReference<ListPopupWindow>(this.buildPopupWindow());
        }
        if ((popupWindow = this.getPopupWindow()) != null) {
            popupWindow.setAdapter((ListAdapter)adapter);
        }
    }

    private ListPopupWindow buildPopupWindow() {
        ListPopupWindow popupWindow = new ListPopupWindow(this.getContext()){

            public void show() {
                if (!this.isShowing()) {
                    EditSpinner.this.mIvArrow.startAnimation(EditSpinner.this.mAnimation);
                }
                super.show();
            }
        };
        if (this.mPopAnimStyle != -1) {
            popupWindow.setAnimationStyle(this.mPopAnimStyle);
        }
        popupWindow.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        popupWindow.setInputMethodMode(1);
        popupWindow.setSoftInputMode(48);
        popupWindow.setPromptPosition(1);
        popupWindow.setWidth(-2);
        popupWindow.setHeight(-2);
        popupWindow.setAnchorView((View)this.mEditText);
        popupWindow.setVerticalOffset(ThemeUtils.resolveDimension(this.getContext(), R.attr.ms_dropdown_offset));
        popupWindow.setListSelector(ResUtils.getDrawable(this.getContext(), R.drawable.xui_config_list_item_selector));
        popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                EditSpinner.this.mPopupWindowHideTime = System.currentTimeMillis();
                EditSpinner.this.mIvArrow.startAnimation(EditSpinner.this.mResetAnimation);
            }
        });
        if (this.mDropDownBg != null) {
            popupWindow.setBackgroundDrawable(this.mDropDownBg);
        } else {
            popupWindow.setBackgroundDrawable(ResUtils.getDrawable(this.getContext(), R.drawable.ms_drop_down_bg_radius));
        }
        return popupWindow;
    }

    public final void onClick(View v) {
        this.togglePopupWindow();
    }

    private void togglePopupWindow() {
        if (System.currentTimeMillis() - this.mPopupWindowHideTime > 200L) {
            if (this.mAdapter == null || this.mPopupWindow == null) {
                return;
            }
            this.showFilterData("");
        }
    }

    public final void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        String selectContent = ((BaseEditSpinnerAdapter)parent.getAdapter()).getItemString(position);
        this.setText(selectContent);
        this.dismissDropDown();
        if (this.mOnItemClickListener != null) {
            this.mOnItemClickListener.onItemClick(parent, view, position, id2);
        }
    }

    public final void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public final void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public final void afterTextChanged(Editable s) {
        String key = s.toString();
        this.mEditText.setSelection(key.length());
        if (!TextUtils.isEmpty((CharSequence)key)) {
            if (this.mIsShowFilterData) {
                this.showFilterData(key);
            }
        } else {
            this.dismissDropDown();
        }
    }

    private void showFilterData(String key) {
        if (this.mPopupWindow == null || this.mAdapter == null || this.mAdapter.getEditSpinnerFilter() == null) {
            this.dismissDropDown();
            return;
        }
        if (this.mAdapter.getEditSpinnerFilter().onFilter(key)) {
            this.showDropDown();
        } else {
            this.dismissDropDown();
        }
    }

    protected void onDetachedFromWindow() {
        this.recycle();
        super.onDetachedFromWindow();
    }

    private void showDropDown() {
        ListPopupWindow popupWindow = this.getPopupWindow();
        if (popupWindow != null) {
            popupWindow.show();
        }
    }

    private void dismissDropDown() {
        ListPopupWindow popupWindow = this.getPopupWindow();
        if (popupWindow != null) {
            popupWindow.dismiss();
        }
    }

    private void recycle() {
        if (this.mIvArrow != null) {
            this.mIvArrow.clearAnimation();
        }
        if (this.mAnimation != null) {
            this.mAnimation.cancel();
        }
        if (this.mResetAnimation != null) {
            this.mResetAnimation.cancel();
        }
        this.setAdapter(null);
        this.dismissDropDown();
    }

    private ListPopupWindow getPopupWindow() {
        return this.mPopupWindow != null ? (ListPopupWindow)this.mPopupWindow.get() : null;
    }

    public String getText() {
        return this.mEditText != null ? this.mEditText.getText().toString() : "";
    }

    public EditSpinner setItems(String[] data) {
        this.mAdapter = new EditSpinnerAdapter<String>(data).setTextColor(this.mEditText.getTextColors().getDefaultColor()).setTextSize(this.mEditText.getTextSize()).setIsFilterKey(this.mIsFilterKey);
        this.setAdapter(this.mAdapter);
        return this;
    }

    public EditSpinner setItems(List<String> data) {
        this.mAdapter = new EditSpinnerAdapter<String>(data).setTextColor(this.mEditText.getTextColors().getDefaultColor()).setTextSize(this.mEditText.getTextSize()).setIsFilterKey(this.mIsFilterKey);
        this.setAdapter(this.mAdapter);
        return this;
    }

    public EditSpinner setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
        return this;
    }

    public EditSpinner setText(@NonNull String text) {
        if (this.mEditText != null) {
            this.mEditText.removeTextChangedListener((TextWatcher)this);
            this.mEditText.setText((CharSequence)text);
            this.mEditText.setSelection(text.length());
            this.mEditText.addTextChangedListener((TextWatcher)this);
        }
        return this;
    }

    public EditSpinner setTextColors(ColorStateList colors) {
        if (this.mEditText != null && colors != null) {
            this.mEditText.setTextColor(colors);
            if (this.mAdapter != null && this.mAdapter instanceof EditSpinnerAdapter) {
                ((EditSpinnerAdapter)this.mAdapter).setTextColor(colors.getDefaultColor());
            }
        }
        return this;
    }

    public EditSpinner setTextColor(@ColorInt int color2) {
        if (this.mEditText != null) {
            this.mEditText.setTextColor(color2);
            if (this.mAdapter != null && this.mAdapter instanceof EditSpinnerAdapter) {
                ((EditSpinnerAdapter)this.mAdapter).setTextColor(color2);
            }
        }
        return this;
    }

    public EditSpinner setBackgroundSelector(@DrawableRes int backgroundSelector) {
        if (this.mEditText != null) {
            this.mEditText.setBackgroundResource(backgroundSelector);
        }
        return this;
    }

    public EditSpinner setIsFilterKey(boolean isFilterKey) {
        if (this.mEditText != null && this.mAdapter != null && this.mAdapter instanceof EditSpinnerAdapter) {
            ((EditSpinnerAdapter)this.mAdapter).setIsFilterKey(isFilterKey);
        }
        return this;
    }

    public EditSpinner setFilterColor(String filterColor) {
        if (this.mEditText != null && this.mAdapter != null && this.mAdapter instanceof EditSpinnerAdapter) {
            ((EditSpinnerAdapter)this.mAdapter).setFilterColor(filterColor);
        }
        return this;
    }

    public EditSpinner setTextSize(float textSize) {
        if (this.mEditText != null) {
            this.mEditText.setTextSize(0, textSize);
            if (this.mAdapter != null && this.mAdapter instanceof EditSpinnerAdapter) {
                ((EditSpinnerAdapter)this.mAdapter).setTextSize(textSize);
            }
        }
        return this;
    }

    public EditSpinner setHint(String hint) {
        if (this.mEditText != null) {
            this.mEditText.setHint((CharSequence)hint);
        }
        return this;
    }

    public EditSpinner setArrowImageDrawable(Drawable drawable2) {
        if (this.mIvArrow != null) {
            this.mIvArrow.setImageDrawable(drawable2);
        }
        return this;
    }

    public EditSpinner setArrowImageResource(@DrawableRes int res) {
        if (this.mIvArrow != null) {
            this.mIvArrow.setImageResource(res);
        }
        return this;
    }

    public EditSpinner setAdapter(BaseEditSpinnerAdapter adapter) {
        this.mAdapter = adapter;
        this.setBaseAdapter(this.mAdapter);
        return this;
    }

    public EditSpinner setMaxLine(int maxLine) {
        if (this.mEditText != null) {
            this.mMaxLine = maxLine;
            this.mEditText.setMaxLines(this.mMaxLine);
        }
        return this;
    }

    public EditSpinner setEditTextHeight(int dp) {
        if (this.mEditText != null) {
            this.mEditText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, DensityUtils.dp2px(this.getContext(), dp)));
        }
        return this;
    }

    public EditSpinner setEditTextWidth(int dp) {
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.width = DensityUtils.dp2px(this.getContext(), dp);
        this.setLayoutParams(params);
        return this;
    }

    public void setEnabled(boolean enabled) {
        if (this.mEditText != null) {
            this.mEditText.setFocusable(enabled);
            this.mEditText.setFocusableInTouchMode(enabled);
            this.mEditText.setEnabled(enabled);
            this.mIvArrow.setEnabled(enabled);
        }
    }

    public EditSpinner setMaxLength(int maxLength) {
        if (this.mEditText != null && maxLength > 0) {
            InputFilter[] filters = new InputFilter[]{new InputFilter.LengthFilter(maxLength)};
            this.mEditText.setFilters(filters);
        }
        return this;
    }

    public EditSpinner setMaxEms(int maxEms) {
        if (this.mEditText != null && maxEms > 0) {
            this.mEditText.setMaxEms(maxEms);
        }
        return this;
    }

    public EditSpinner addTextChangedListener(TextWatcher watcher) {
        if (this.mEditText != null) {
            this.mEditText.addTextChangedListener(watcher);
        }
        return this;
    }

    public EditSpinner setInputType(int type) {
        if (this.mEditText != null) {
            this.mEditText.setInputType(type);
        }
        return this;
    }

    public EditText getEditText() {
        return this.mEditText;
    }
}

