/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.spinner.editspinner;

import android.widget.BaseAdapter;
import com.xuexiang.xui.utils.CollectionUtils;
import com.xuexiang.xui.widget.spinner.editspinner.EditSpinnerFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class BaseEditSpinnerAdapter<T>
extends BaseAdapter {
    protected final List<T> mDataSource;
    protected List<String> mDisplayData;
    protected final int[] mIndexs;

    public BaseEditSpinnerAdapter(List<T> data) {
        this.mDataSource = data;
        this.mDisplayData = new ArrayList<String>();
        this.initDisplayData(data);
        this.mIndexs = new int[this.mDataSource.size()];
    }

    public BaseEditSpinnerAdapter(T[] data) {
        this.mDataSource = new ArrayList<T>();
        this.mDataSource.addAll(Arrays.asList(data));
        this.mDisplayData = new ArrayList<String>();
        this.initDisplayData(this.mDataSource);
        this.mIndexs = new int[this.mDataSource.size()];
    }

    protected void initDisplayData(List<T> data) {
        if (!CollectionUtils.isEmpty(data)) {
            for (int i = 0; i < data.size(); ++i) {
                this.mDisplayData.add(data.get(i).toString());
            }
        }
    }

    public int getCount() {
        return CollectionUtils.getSize(this.mDisplayData);
    }

    public String getItem(int position) {
        return CollectionUtils.getListItem(this.mDisplayData, position);
    }

    public long getItemId(int position) {
        return position;
    }

    public abstract EditSpinnerFilter getEditSpinnerFilter();

    protected String getItemString(int position) {
        return this.mDataSource.get(this.mIndexs[position]).toString();
    }

    protected String getDataSourceString(int i) {
        T data = CollectionUtils.getListItem(this.mDataSource, i);
        return data != null ? data.toString() : "";
    }

    public void recycle() {
        CollectionUtils.clear(this.mDataSource);
        CollectionUtils.clear(this.mDisplayData);
        this.notifyDataSetChanged();
    }
}

