/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.spinner;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import java.util.Arrays;
import java.util.List;

public class DropDownMenu
extends LinearLayout {
    private LinearLayout mTabMenuView;
    private FrameLayout mContainerView;
    private FrameLayout mPopupMenuViews;
    private View mMaskView;
    private int mCurrentTabPosition = -1;
    private int mContentLayoutId;
    private View mContentView;
    private int mDividerColor;
    private int mDividerWidth;
    private int mDividerMargin;
    private int mMenuTextSelectedColor;
    private int mMenuTextUnselectedColor;
    private int mMenuTextPaddingHorizontal;
    private int mMenuTextPaddingVertical;
    private int mMaskColor;
    private int mMenuTextSize;
    private Drawable mMenuSelectedIcon;
    private Drawable mMenuUnselectedIcon;
    private float mMenuHeightPercent = 0.5f;

    public DropDownMenu(Context context) {
        super(context, null);
    }

    public DropDownMenu(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.DropDownMenuStyle);
    }

    public DropDownMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.DropDownMenu, defStyleAttr, 0);
        this.mContentLayoutId = array.getResourceId(R.styleable.DropDownMenu_ddm_contentLayoutId, -1);
        this.mDividerColor = array.getColor(R.styleable.DropDownMenu_ddm_dividerColor, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_separator_dark));
        this.mDividerWidth = array.getDimensionPixelSize(R.styleable.DropDownMenu_ddm_dividerWidth, ResUtils.getDimensionPixelSize(context, R.dimen.default_ddm_divider_width));
        this.mDividerMargin = array.getDimensionPixelSize(R.styleable.DropDownMenu_ddm_dividerMargin, ResUtils.getDimensionPixelSize(context, R.dimen.default_ddm_divider_margin));
        int underlineColor = array.getColor(R.styleable.DropDownMenu_ddm_underlineColor, ThemeUtils.resolveColor(context, R.attr.xui_config_color_separator_light));
        int underlineHeight = array.getDimensionPixelSize(R.styleable.DropDownMenu_ddm_underlineHeight, ResUtils.getDimensionPixelSize(context, R.dimen.default_ddm_underline_height));
        int menuBackgroundColor = array.getColor(R.styleable.DropDownMenu_ddm_menuBackgroundColor, -1);
        this.mMaskColor = array.getColor(R.styleable.DropDownMenu_ddm_maskColor, ResUtils.getColor(context, R.color.default_ddm_mask_color));
        this.mMenuTextSelectedColor = array.getColor(R.styleable.DropDownMenu_ddm_menuTextSelectedColor, ThemeUtils.getMainThemeColor(context));
        this.mMenuTextUnselectedColor = array.getColor(R.styleable.DropDownMenu_ddm_menuTextUnselectedColor, ThemeUtils.resolveColor(context, R.attr.xui_config_color_content_text));
        this.mMenuTextPaddingHorizontal = array.getDimensionPixelSize(R.styleable.DropDownMenu_ddm_menuTextPaddingHorizontal, ResUtils.getDimensionPixelSize(context, R.dimen.default_ddm_menu_text_padding_horizontal));
        this.mMenuTextPaddingVertical = array.getDimensionPixelSize(R.styleable.DropDownMenu_ddm_menuTextPaddingVertical, ResUtils.getDimensionPixelSize(context, R.dimen.default_ddm_menu_text_padding_vertical));
        this.mMenuTextSize = array.getDimensionPixelSize(R.styleable.DropDownMenu_ddm_menuTextSize, ResUtils.getDimensionPixelSize(context, R.dimen.default_ddm_menu_text_size));
        this.mMenuUnselectedIcon = ResUtils.getDrawableAttrRes(this.getContext(), array, R.styleable.DropDownMenu_ddm_menuUnselectedIcon);
        if (this.mMenuUnselectedIcon == null) {
            this.mMenuUnselectedIcon = ResUtils.getVectorDrawable(this.getContext(), R.drawable.ddm_ic_arrow_down);
        }
        this.mMenuSelectedIcon = ResUtils.getDrawableAttrRes(this.getContext(), array, R.styleable.DropDownMenu_ddm_menuSelectedIcon);
        if (this.mMenuSelectedIcon == null) {
            this.mMenuSelectedIcon = ResUtils.getVectorDrawable(this.getContext(), R.drawable.ddm_ic_arrow_up);
        }
        this.mMenuHeightPercent = array.getFloat(R.styleable.DropDownMenu_ddm_menuHeightPercent, this.mMenuHeightPercent);
        array.recycle();
        this.mTabMenuView = new LinearLayout(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        this.mTabMenuView.setOrientation(0);
        this.mTabMenuView.setBackgroundColor(menuBackgroundColor);
        this.mTabMenuView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)this.mTabMenuView, 0);
        View underLine = new View(this.getContext());
        underLine.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, underlineHeight));
        underLine.setBackgroundColor(underlineColor);
        this.addView(underLine, 1);
        this.mContainerView = new FrameLayout(context);
        this.mContainerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.mContainerView, 2);
    }

    public void setDropDownMenu(@NonNull String[] tabTexts, @NonNull List<View> popupViews) {
        this.setDropDownMenu(Arrays.asList(tabTexts), popupViews);
    }

    public void setDropDownMenu(@NonNull List<String> tabTexts, @NonNull List<View> popupViews) {
        if (this.mContentLayoutId == -1) {
            throw new IllegalArgumentException("mContentLayoutId == -1, You need to set properties app:ddm_contentLayoutId");
        }
        this.setDropDownMenu(tabTexts, popupViews, View.inflate((Context)this.getContext(), (int)this.mContentLayoutId, null));
    }

    public void setDropDownMenu(@NonNull String[] tabTexts, @NonNull List<View> popupViews, @NonNull View contentView) {
        this.setDropDownMenu(Arrays.asList(tabTexts), popupViews, contentView);
    }

    public void setDropDownMenu(@NonNull List<String> tabTexts, @NonNull List<View> popupViews, @NonNull View contentView) {
        int i;
        if (tabTexts.size() != popupViews.size()) {
            throw new IllegalArgumentException("params not match, tabTexts.size() should be equal popupViews.size()");
        }
        for (i = 0; i < tabTexts.size(); ++i) {
            this.addTab(tabTexts, i);
        }
        this.mContentView = contentView;
        this.mContainerView.addView(contentView, 0);
        this.mMaskView = new View(this.getContext());
        this.mMaskView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mMaskView.setBackgroundColor(this.mMaskColor);
        this.mMaskView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DropDownMenu.this.closeMenu();
            }
        });
        this.mContainerView.addView(this.mMaskView, 1);
        this.mMaskView.setVisibility(8);
        if (this.mContainerView.getChildAt(2) != null) {
            this.mContainerView.removeViewAt(2);
        }
        this.mPopupMenuViews = new FrameLayout(this.getContext());
        this.mPopupMenuViews.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, (int)((float)DensityUtils.getDisplayHeight(this.getContext(), true) * this.mMenuHeightPercent)));
        this.mPopupMenuViews.setVisibility(8);
        this.mContainerView.addView((View)this.mPopupMenuViews, 2);
        for (i = 0; i < popupViews.size(); ++i) {
            popupViews.get(i).setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            this.mPopupMenuViews.addView(popupViews.get(i), i);
        }
    }

    private void addTab(@NonNull List<String> tabTexts, int index) {
        final TextView tab = new TextView(this.getContext());
        tab.setSingleLine();
        tab.setEllipsize(TextUtils.TruncateAt.END);
        tab.setGravity(17);
        tab.setTextSize(0, (float)this.mMenuTextSize);
        tab.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        tab.setTextColor(this.mMenuTextUnselectedColor);
        this.setArrowIconEnd(tab, this.mMenuUnselectedIcon);
        tab.setText((CharSequence)tabTexts.get(index));
        tab.setPadding(this.mMenuTextPaddingHorizontal, this.mMenuTextPaddingVertical, this.mMenuTextPaddingHorizontal, this.mMenuTextPaddingVertical);
        tab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DropDownMenu.this.switchMenu((View)tab);
            }
        });
        this.mTabMenuView.addView((View)tab);
        if (index < tabTexts.size() - 1) {
            View view = new View(this.getContext());
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.mDividerWidth, -1);
            params.topMargin = this.mDividerMargin;
            params.bottomMargin = this.mDividerMargin;
            view.setLayoutParams((ViewGroup.LayoutParams)params);
            view.setBackgroundColor(this.mDividerColor);
            this.mTabMenuView.addView(view);
        }
    }

    public void setTabMenuText(String text) {
        if (this.mCurrentTabPosition != -1) {
            ((TextView)this.mTabMenuView.getChildAt(this.mCurrentTabPosition)).setText((CharSequence)text);
        }
    }

    public void setTabMenuClickable(boolean clickable) {
        for (int i = 0; i < this.mTabMenuView.getChildCount(); i += 2) {
            this.mTabMenuView.getChildAt(i).setClickable(clickable);
        }
    }

    public void closeMenu() {
        if (this.mCurrentTabPosition != -1) {
            ((TextView)this.mTabMenuView.getChildAt(this.mCurrentTabPosition)).setTextColor(this.mMenuTextUnselectedColor);
            this.setArrowIconEnd((TextView)this.mTabMenuView.getChildAt(this.mCurrentTabPosition), this.mMenuUnselectedIcon);
            this.mPopupMenuViews.setVisibility(8);
            this.mPopupMenuViews.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ddm_menu_out));
            this.mMaskView.setVisibility(8);
            this.mMaskView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ddm_mask_out));
            this.mCurrentTabPosition = -1;
        }
    }

    public boolean isShowing() {
        return this.mCurrentTabPosition != -1;
    }

    public View getContentView() {
        return this.mContentView;
    }

    private void switchMenu(View target) {
        for (int i = 0; i < this.mTabMenuView.getChildCount(); i += 2) {
            if (target == this.mTabMenuView.getChildAt(i)) {
                if (this.mCurrentTabPosition == i) {
                    this.closeMenu();
                    continue;
                }
                if (this.mCurrentTabPosition == -1) {
                    this.mPopupMenuViews.setVisibility(0);
                    this.mPopupMenuViews.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ddm_menu_in));
                    this.mMaskView.setVisibility(0);
                    this.mMaskView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ddm_mask_in));
                    this.mPopupMenuViews.getChildAt(i / 2).setVisibility(0);
                } else {
                    this.mPopupMenuViews.getChildAt(i / 2).setVisibility(0);
                }
                this.mCurrentTabPosition = i;
                ((TextView)this.mTabMenuView.getChildAt(i)).setTextColor(this.mMenuTextSelectedColor);
                this.setArrowIconEnd((TextView)this.mTabMenuView.getChildAt(i), this.mMenuSelectedIcon);
                continue;
            }
            ((TextView)this.mTabMenuView.getChildAt(i)).setTextColor(this.mMenuTextUnselectedColor);
            this.setArrowIconEnd((TextView)this.mTabMenuView.getChildAt(i), this.mMenuUnselectedIcon);
            this.mPopupMenuViews.getChildAt(i / 2).setVisibility(8);
        }
    }

    private void setArrowIconEnd(TextView view, Drawable arrowIcon) {
        if (view == null) {
            return;
        }
        view.setCompoundDrawablesRelativeWithIntrinsicBounds(null, null, arrowIcon, null);
    }
}

