/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.slideback.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;

public class SlideBackIconView
extends View {
    private Path bgPath;
    private Path arrowPath;
    private Paint bgPaint;
    private Paint arrowPaint;
    @ColorInt
    private int backViewColor = -16777216;
    private float backViewHeight = 0.0f;
    private float arrowSize = 10.0f;
    private float maxSlideLength = 0.0f;
    private float slideLength = 0.0f;

    public SlideBackIconView(Context context) {
        this(context, null);
    }

    public SlideBackIconView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlideBackIconView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.bgPath = new Path();
        this.arrowPath = new Path();
        this.bgPaint = new Paint();
        this.bgPaint.setAntiAlias(true);
        this.bgPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.bgPaint.setColor(this.backViewColor);
        this.bgPaint.setStrokeWidth(1.0f);
        this.arrowPaint = new Paint();
        this.arrowPaint.setAntiAlias(true);
        this.arrowPaint.setStyle(Paint.Style.STROKE);
        this.arrowPaint.setColor(-1);
        this.arrowPaint.setStrokeWidth(8.0f);
        this.arrowPaint.setStrokeJoin(Paint.Join.ROUND);
        this.setAlpha(0.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.bgPath.reset();
        this.bgPath.moveTo(0.0f, 0.0f);
        this.bgPath.cubicTo(0.0f, this.backViewHeight * 2.0f / 9.0f, this.slideLength, this.backViewHeight / 3.0f, this.slideLength, this.backViewHeight / 2.0f);
        this.bgPath.cubicTo(this.slideLength, this.backViewHeight * 2.0f / 3.0f, 0.0f, this.backViewHeight * 7.0f / 9.0f, 0.0f, this.backViewHeight);
        canvas.drawPath(this.bgPath, this.bgPaint);
        float arrowZoom = this.slideLength / this.maxSlideLength;
        float arrowAngle = arrowZoom < 0.75f ? 0.0f : (arrowZoom - 0.75f) * 2.0f;
        this.arrowPath.reset();
        this.arrowPath.moveTo(this.slideLength / 2.0f + this.arrowSize * arrowAngle, this.backViewHeight / 2.0f - arrowZoom * this.arrowSize);
        this.arrowPath.lineTo(this.slideLength / 2.0f - this.arrowSize * arrowAngle, this.backViewHeight / 2.0f);
        this.arrowPath.lineTo(this.slideLength / 2.0f + this.arrowSize * arrowAngle, this.backViewHeight / 2.0f + arrowZoom * this.arrowSize);
        canvas.drawPath(this.arrowPath, this.arrowPaint);
        this.setAlpha(this.slideLength / this.maxSlideLength - 0.2f);
    }

    public void updateSlideLength(float slideLength) {
        this.slideLength = slideLength;
        this.invalidate();
    }

    public void setMaxSlideLength(float maxSlideLength) {
        this.maxSlideLength = maxSlideLength;
    }

    public void setArrowSize(float arrowSize) {
        this.arrowSize = arrowSize;
    }

    public void setBackViewColor(@ColorInt int backViewColor) {
        this.backViewColor = backViewColor;
    }

    public void setBackViewHeight(float backViewHeight) {
        this.backViewHeight = backViewHeight;
    }

    public float getBackViewHeight() {
        return this.backViewHeight;
    }
}

