/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.shadow;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;

public class ShadowDrawable
extends Drawable {
    private Paint mShadowPaint;
    private Paint mBgPaint;
    private int mShadowRadius;
    private int mShape;
    private int mShapeRadius;
    private int mOffsetX;
    private int mOffsetY;
    private int[] mBgColor;
    private RectF mRect;
    public static final int SHAPE_RECTANGLE = 0;
    public static final int SHAPE_ROUND = 1;

    private ShadowDrawable(int shape, int[] bgColor, int shapeRadius, int shadowColor, int shadowRadius, int offsetX, int offsetY) {
        this.mShape = shape;
        this.mBgColor = bgColor;
        this.mShapeRadius = shapeRadius;
        this.mShadowRadius = shadowRadius;
        this.mOffsetX = offsetX;
        this.mOffsetY = offsetY;
        this.mShadowPaint = new Paint();
        this.mShadowPaint.setColor(0);
        this.mShadowPaint.setAntiAlias(true);
        this.mShadowPaint.setShadowLayer((float)shadowRadius, (float)offsetX, (float)offsetY, shadowColor);
        this.mShadowPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
        this.mBgPaint = new Paint();
        this.mBgPaint.setAntiAlias(true);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.mRect = new RectF((float)(left + this.mShadowRadius - this.mOffsetX), (float)(top + this.mShadowRadius - this.mOffsetY), (float)(right - this.mShadowRadius - this.mOffsetX), (float)(bottom - this.mShadowRadius - this.mOffsetY));
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.mBgColor != null) {
            if (this.mBgColor.length == 1) {
                this.mBgPaint.setColor(this.mBgColor[0]);
            } else {
                this.mBgPaint.setShader((Shader)new LinearGradient(this.mRect.left, this.mRect.height() / 2.0f, this.mRect.right, this.mRect.height() / 2.0f, this.mBgColor, null, Shader.TileMode.CLAMP));
            }
        }
        if (this.mShape == 0) {
            canvas.drawRoundRect(this.mRect, (float)this.mShapeRadius, (float)this.mShapeRadius, this.mShadowPaint);
            canvas.drawRoundRect(this.mRect, (float)this.mShapeRadius, (float)this.mShapeRadius, this.mBgPaint);
        } else {
            canvas.drawCircle(this.mRect.centerX(), this.mRect.centerY(), Math.min(this.mRect.width(), this.mRect.height()) / 2.0f, this.mShadowPaint);
            canvas.drawCircle(this.mRect.centerX(), this.mRect.centerY(), Math.min(this.mRect.width(), this.mRect.height()) / 2.0f, this.mBgPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.mShadowPaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mShadowPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public static void setShadowDrawable(View view, Drawable drawable2) {
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)drawable2);
    }

    public static void setShadowDrawable(View view, int shapeRadius, int shadowColor, int shadowRadius, int offsetX, int offsetY) {
        ShadowDrawable drawable2 = new Builder().setShapeRadius(shapeRadius).setShadowColor(shadowColor).setShadowRadius(shadowRadius).setOffsetX(offsetX).setOffsetY(offsetY).build();
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)drawable2);
    }

    public static void setShadowDrawable(View view, int bgColor, int shapeRadius, int shadowColor, int shadowRadius, int offsetX, int offsetY) {
        ShadowDrawable drawable2 = new Builder().setBgColor(bgColor).setShapeRadius(shapeRadius).setShadowColor(shadowColor).setShadowRadius(shadowRadius).setOffsetX(offsetX).setOffsetY(offsetY).build();
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)drawable2);
    }

    public static void setShadowDrawable(View view, int shape, int bgColor, int shapeRadius, int shadowColor, int shadowRadius, int offsetX, int offsetY) {
        ShadowDrawable drawable2 = new Builder().setShape(shape).setBgColor(bgColor).setShapeRadius(shapeRadius).setShadowColor(shadowColor).setShadowRadius(shadowRadius).setOffsetX(offsetX).setOffsetY(offsetY).build();
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)drawable2);
    }

    public static void setShadowDrawable(View view, int[] bgColor, int shapeRadius, int shadowColor, int shadowRadius, int offsetX, int offsetY) {
        ShadowDrawable drawable2 = new Builder().setBgColor(bgColor).setShapeRadius(shapeRadius).setShadowColor(shadowColor).setShadowRadius(shadowRadius).setOffsetX(offsetX).setOffsetY(offsetY).build();
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)drawable2);
    }

    public static ShadowDrawable fromAttributeSet(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShadowDrawable);
        int shadowRadius = typedArray.getDimensionPixelSize(R.styleable.ShadowDrawable_sd_shadowRadius, ResUtils.getDimensionPixelSize(context, R.dimen.default_sd_shadow_radius));
        int shadowColor = typedArray.getColor(R.styleable.ShadowDrawable_sd_shadowColor, Builder.DEFAULT_SHADOW_COLOR);
        int shape = typedArray.getInt(R.styleable.ShadowDrawable_sd_shapeType, 0);
        int shapeRadius = typedArray.getDimensionPixelSize(R.styleable.ShadowDrawable_sd_shapeRadius, ResUtils.getDimensionPixelSize(context, R.dimen.default_sd_shape_radius));
        int offsetX = typedArray.getDimensionPixelSize(R.styleable.ShadowDrawable_sd_offsetX, 0);
        int offsetY = typedArray.getDimensionPixelSize(R.styleable.ShadowDrawable_sd_offsetY, 0);
        int bgColor = typedArray.getColor(R.styleable.ShadowDrawable_sd_bgColor, ResUtils.getColor(context, R.color.xui_config_color_white));
        int secondBgColor = typedArray.getColor(R.styleable.ShadowDrawable_sd_secondBgColor, -1);
        typedArray.recycle();
        Builder builder = new Builder().setShape(shape).setShapeRadius(shapeRadius).setShadowColor(shadowColor).setShadowRadius(shadowRadius).setOffsetX(offsetX).setOffsetY(offsetY);
        if (secondBgColor != -1) {
            builder.setBgColor(new int[]{bgColor, secondBgColor});
        } else {
            builder.setBgColor(bgColor);
        }
        return builder.build();
    }

    public static class Builder {
        public static final int DEFAULT_SHADOW_COLOR = Color.parseColor((String)"#4d000000");
        private int mShape = 0;
        private int mShapeRadius = 10;
        private int mShadowColor = DEFAULT_SHADOW_COLOR;
        private int mShadowRadius = 16;
        private int mOffsetX = 0;
        private int mOffsetY = 0;
        private int[] mBgColor = new int[1];

        public Builder() {
            this.mBgColor[0] = 0;
        }

        public Builder setShape(int mShape) {
            this.mShape = mShape;
            return this;
        }

        public Builder setShapeRadius(int ShapeRadius) {
            this.mShapeRadius = ShapeRadius;
            return this;
        }

        public Builder setShadowColor(int shadowColor) {
            this.mShadowColor = shadowColor;
            return this;
        }

        public Builder setShadowRadius(int shadowRadius) {
            this.mShadowRadius = shadowRadius;
            return this;
        }

        public Builder setOffsetX(int OffsetX) {
            this.mOffsetX = OffsetX;
            return this;
        }

        public Builder setOffsetY(int OffsetY) {
            this.mOffsetY = OffsetY;
            return this;
        }

        public Builder setBgColor(int BgColor) {
            this.mBgColor[0] = BgColor;
            return this;
        }

        public Builder setBgColor(int[] BgColor) {
            this.mBgColor = BgColor;
            return this;
        }

        public ShadowDrawable build() {
            return new ShadowDrawable(this.mShape, this.mBgColor, this.mShapeRadius, this.mShadowColor, this.mShadowRadius, this.mOffsetX, this.mOffsetY);
        }
    }
}

