/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.searchview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.searchview.AbstractSearchFilter;
import com.xuexiang.xui.widget.searchview.DefaultSearchFilter;
import java.util.ArrayList;
import java.util.List;

public class SearchAdapter
extends BaseAdapter
implements Filterable,
AbstractSearchFilter.OnFilterResultListener {
    private List<String> mData;
    private String[] mSuggestions;
    private Drawable mSuggestionIcon;
    private LayoutInflater mInflater;
    private boolean mEllipsize;
    private AbstractSearchFilter mSearchFilter;

    public SearchAdapter(Context context, String[] suggestions) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mData = new ArrayList<String>();
        this.mSuggestions = suggestions;
        this.setSearchFilter(new DefaultSearchFilter());
    }

    public SearchAdapter(Context context, String[] suggestions, Drawable suggestionIcon, boolean ellipsize) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mData = new ArrayList<String>();
        this.mSuggestions = suggestions;
        this.mSuggestionIcon = suggestionIcon;
        this.mEllipsize = ellipsize;
        this.setSearchFilter(new DefaultSearchFilter());
    }

    public Filter getFilter() {
        return this.mSearchFilter;
    }

    public SearchAdapter setSearchFilter(AbstractSearchFilter searchFilter) {
        this.mSearchFilter = searchFilter;
        this.mSearchFilter.setSuggestions(this.mSuggestions);
        this.mSearchFilter.setOnFilterResultListener(this);
        return this;
    }

    @Override
    public void publishResults(List<String> results) {
        this.mData = results;
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mData.size();
    }

    public Object getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        SuggestionsViewHolder viewHolder;
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.xui_layout_search_view_suggest_item, parent, false);
            viewHolder = new SuggestionsViewHolder(convertView);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (SuggestionsViewHolder)convertView.getTag();
        }
        String currentListData = (String)this.getItem(position);
        viewHolder.textView.setText((CharSequence)currentListData);
        if (this.mEllipsize) {
            viewHolder.textView.setSingleLine();
            viewHolder.textView.setEllipsize(TextUtils.TruncateAt.END);
        }
        return convertView;
    }

    private class SuggestionsViewHolder {
        TextView textView;
        ImageView imageView;

        public SuggestionsViewHolder(View convertView) {
            this.textView = (TextView)convertView.findViewById(R.id.suggestion_text);
            if (SearchAdapter.this.mSuggestionIcon != null) {
                this.imageView = (ImageView)convertView.findViewById(R.id.suggestion_icon);
                this.imageView.setImageDrawable(SearchAdapter.this.mSuggestionIcon);
            }
        }
    }
}

