/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.searchview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewAnimationUtils;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorListener;

class AnimationUtils {
    public static int ANIMATION_DURATION_SHORT = 150;
    public static int ANIMATION_DURATION_MEDIUM = 400;
    public static int ANIMATION_DURATION_LONG = 800;

    private AnimationUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    static void crossFadeViews(View showView, View hideView) {
        AnimationUtils.crossFadeViews(showView, hideView, ANIMATION_DURATION_SHORT);
    }

    static void crossFadeViews(View showView, View hideView, int duration) {
        AnimationUtils.fadeInView(showView, duration);
        AnimationUtils.fadeOutView(hideView, duration);
    }

    static void fadeInView(View view) {
        AnimationUtils.fadeInView(view, ANIMATION_DURATION_SHORT);
    }

    static void fadeInView(View view, int duration) {
        AnimationUtils.fadeInView(view, duration, null);
    }

    static void fadeInView(View view, int duration, final AnimationListener listener) {
        view.setVisibility(0);
        view.setAlpha(0.0f);
        ViewPropertyAnimatorListener vpListener = null;
        if (listener != null) {
            vpListener = new ViewPropertyAnimatorListener(){

                public void onAnimationStart(View view) {
                    if (!listener.onAnimationStart(view)) {
                        view.setDrawingCacheEnabled(true);
                    }
                }

                public void onAnimationEnd(View view) {
                    if (!listener.onAnimationEnd(view)) {
                        view.setDrawingCacheEnabled(false);
                    }
                }

                public void onAnimationCancel(View view) {
                }
            };
        }
        ViewCompat.animate((View)view).alpha(1.0f).setDuration((long)duration).setListener(vpListener);
    }

    @TargetApi(value=21)
    static void reveal(final View view, final AnimationListener listener) {
        int cx = view.getWidth() - (int)TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)view.getResources().getDisplayMetrics());
        int cy = view.getHeight() / 2;
        int finalRadius = Math.max(view.getWidth(), view.getHeight());
        Animator anim2 = ViewAnimationUtils.createCircularReveal((View)view, (int)cx, (int)cy, (float)0.0f, (float)finalRadius);
        view.setVisibility(0);
        anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                listener.onAnimationStart(view);
            }

            public void onAnimationEnd(Animator animation) {
                listener.onAnimationEnd(view);
            }

            public void onAnimationCancel(Animator animation) {
                listener.onAnimationCancel(view);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        anim2.start();
    }

    static void fadeOutView(View view) {
        AnimationUtils.fadeOutView(view, ANIMATION_DURATION_SHORT);
    }

    static void fadeOutView(View view, int duration) {
        AnimationUtils.fadeOutView(view, duration, null);
    }

    static void fadeOutView(View view, int duration, final AnimationListener listener) {
        ViewCompat.animate((View)view).alpha(0.0f).setDuration((long)duration).setListener(new ViewPropertyAnimatorListener(){

            public void onAnimationStart(View view) {
                if (listener == null || !listener.onAnimationStart(view)) {
                    view.setDrawingCacheEnabled(true);
                }
            }

            public void onAnimationEnd(View view) {
                if (listener == null || !listener.onAnimationEnd(view)) {
                    view.setVisibility(8);
                    view.setDrawingCacheEnabled(false);
                }
            }

            public void onAnimationCancel(View view) {
            }
        });
    }

    public static interface AnimationListener {
        public boolean onAnimationStart(View var1);

        public boolean onAnimationEnd(View var1);

        public boolean onAnimationCancel(View var1);
    }
}

