/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.progress.ratingbar;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.xuexiang.xui.widget.progress.ratingbar.RatingBar;
import java.util.UUID;

public class AnimationRatingBar
extends RatingBar {
    protected Handler mHandler;
    protected Runnable mRunnable;
    protected String mRunnableToken = UUID.randomUUID().toString();

    protected AnimationRatingBar(Context context) {
        super(context);
        this.init();
    }

    protected AnimationRatingBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    protected AnimationRatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    protected void postRunnable(Runnable runnable, long animationDelay) {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        long timeMillis = SystemClock.uptimeMillis() + animationDelay;
        this.mHandler.postAtTime(runnable, (Object)this.mRunnableToken, timeMillis);
    }
}

