/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.progress.loading;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import com.xuexiang.xui.R;
import com.xuexiang.xui.UIConfig;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.utils.Utils;

public class RotateLoadingView
extends View {
    private static final int DEFAULT_ARC_WIDTH = 6;
    private static final int DEFAULT_SPEED_OF_DEGREE = 5;
    private boolean mIsDraw;
    private boolean mIsAutoMode = true;
    private Paint mArcPaint;
    private int mArcWidth;
    private int mArcColor;
    private boolean mIsSingleArc;
    private RectF mLoadingRectF;
    private int mTopDegree = 10;
    private int mBottomDegree = 190;
    private float mArcDegree;
    private int mMaxArcDegree;
    private int mSpeedOfDegree;
    private float mSpeedOfArc;
    private boolean mChangeBigger = true;
    private Bitmap mIconBitmap;
    private float mIconScale;
    private Paint mIconPaint;

    public RotateLoadingView(Context context) {
        super(context);
        this.initAttrs(context, null);
    }

    public RotateLoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public RotateLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LoadingView);
        this.mArcColor = typedArray.getColor(R.styleable.LoadingView_lv_color, ThemeUtils.getMainThemeColor(context));
        this.mArcWidth = typedArray.getDimensionPixelSize(R.styleable.LoadingView_lv_width, DensityUtils.dp2px(this.getContext(), 6.0f));
        this.mSpeedOfDegree = typedArray.getInt(R.styleable.LoadingView_lv_speed, 5);
        this.mSpeedOfArc = this.mSpeedOfDegree >> 2;
        this.mIsDraw = this.mIsAutoMode = typedArray.getBoolean(R.styleable.LoadingView_lv_auto, true);
        this.mIsSingleArc = typedArray.getBoolean(R.styleable.LoadingView_lv_arc_single, false);
        this.mMaxArcDegree = this.mIsSingleArc ? 280 : 160;
        boolean hasIcon = typedArray.getBoolean(R.styleable.LoadingView_lv_has_icon, true);
        if (hasIcon) {
            Drawable icon = ResUtils.getDrawableAttrRes(context, typedArray, R.styleable.LoadingView_lv_icon);
            if (icon != null) {
                this.mIconBitmap = Utils.getBitmapFromDrawable(icon);
            } else {
                Drawable appIcon = UIConfig.getInstance(context).getAppIcon();
                if (appIcon != null) {
                    this.mIconBitmap = Utils.getBitmapFromDrawable(appIcon);
                }
            }
            this.mIconScale = typedArray.getFloat(R.styleable.LoadingView_lv_icon_scale, 0.5f);
        }
        typedArray.recycle();
        this.initPaint();
    }

    private void initPaint() {
        this.mArcPaint = new Paint();
        this.mArcPaint.setColor(this.mArcColor);
        this.mArcPaint.setAntiAlias(true);
        this.mArcPaint.setStyle(Paint.Style.STROKE);
        this.mArcPaint.setStrokeWidth((float)this.mArcWidth);
        this.mArcPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mIconPaint = new Paint();
        this.mIconPaint.setColor(this.mArcColor);
        this.mIconPaint.setAntiAlias(true);
        this.mIconPaint.setStyle(Paint.Style.STROKE);
        this.mIconPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.mArcDegree = 10.0f;
        this.mLoadingRectF = new RectF((float)(2 * this.mArcWidth), (float)(2 * this.mArcWidth), (float)(width - 2 * this.mArcWidth), (float)(height - 2 * this.mArcWidth));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mIsDraw) {
            return;
        }
        this.drawArc(canvas);
        this.changeArcDegree();
        this.invalidate();
    }

    private void drawArc(Canvas canvas) {
        if (this.mIconBitmap != null) {
            canvas.drawBitmap(this.mIconBitmap, null, this.getIconBitmapRectF(this.mIconBitmap), this.mIconPaint);
        }
        this.drawTopArc(canvas);
        if (!this.mIsSingleArc) {
            this.drawBottomArc(canvas);
        }
    }

    private void drawTopArc(Canvas canvas) {
        canvas.drawArc(this.mLoadingRectF, (float)this.mTopDegree, this.mArcDegree, false, this.mArcPaint);
        this.mTopDegree += this.mSpeedOfDegree;
        if (this.mTopDegree > 360) {
            this.mTopDegree -= 360;
        }
    }

    private void drawBottomArc(Canvas canvas) {
        canvas.drawArc(this.mLoadingRectF, (float)this.mBottomDegree, this.mArcDegree, false, this.mArcPaint);
        this.mBottomDegree += this.mSpeedOfDegree;
        if (this.mBottomDegree > 360) {
            this.mBottomDegree -= 360;
        }
    }

    private void changeArcDegree() {
        if (this.mChangeBigger) {
            if (this.mArcDegree < (float)this.mMaxArcDegree) {
                this.mArcDegree += this.mSpeedOfArc;
            }
        } else if (this.mArcDegree > (float)this.mSpeedOfDegree) {
            this.mArcDegree -= 2.0f * this.mSpeedOfArc;
        }
        if (this.mArcDegree >= (float)this.mMaxArcDegree || this.mArcDegree <= (float)this.mSpeedOfDegree) {
            this.mChangeBigger = !this.mChangeBigger;
        }
    }

    public RectF getIconBitmapRectF(Bitmap bitmap) {
        float height;
        float width = bitmap.getWidth();
        if (width >= (height = (float)bitmap.getHeight())) {
            height = (float)this.getWidth() / width * height;
            width = this.getWidth();
        } else {
            width = (float)this.getHeight() / height * width;
            height = this.getHeight();
        }
        float left = ((float)this.getWidth() - width * this.mIconScale) / 2.0f;
        float top = ((float)this.getHeight() - height * this.mIconScale) / 2.0f;
        float right = (float)this.getWidth() - left;
        float bottom = (float)this.getHeight() - top;
        return new RectF(left, top, right, bottom);
    }

    public RotateLoadingView setLoadingIcon(Drawable icon) {
        if (icon != null) {
            this.mIconBitmap = Utils.getBitmapFromDrawable(icon);
        }
        return this;
    }

    public RotateLoadingView setLoadingIcon(Bitmap iconBitmap) {
        this.mIconBitmap = iconBitmap;
        return this;
    }

    public RotateLoadingView setLoadingColor(int color2) {
        this.mArcColor = color2;
        return this;
    }

    public int getLoadingColor() {
        return this.mArcColor;
    }

    public void start() {
        if (!this.mIsAutoMode) {
            this.mIsDraw = true;
            this.invalidate();
        }
    }

    public void stop() {
        if (!this.mIsAutoMode) {
            this.pause();
        }
    }

    private void pause() {
        this.mIsDraw = false;
        this.invalidate();
    }

    public boolean isStart() {
        return this.mIsDraw;
    }

    public void recycle() {
        this.pause();
        if (this.mIconBitmap != null) {
            this.mIconBitmap.recycle();
            this.mIconBitmap = null;
        }
        this.mArcPaint = null;
        this.mIconPaint = null;
        this.mLoadingRectF = null;
    }
}

