/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.progress.loading;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import androidx.annotation.NonNull;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;

public class MiniLoadingView
extends View {
    private int mSize;
    private int mPaintColor;
    private int mAnimateValue = 0;
    private ValueAnimator mAnimator;
    private Paint mPaint;
    private static final int LINE_COUNT = 12;
    private static final int DEGREE_PER_LINE = 30;
    private ValueAnimator.AnimatorUpdateListener mUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            MiniLoadingView.this.mAnimateValue = (Integer)animation.getAnimatedValue();
            MiniLoadingView.this.invalidate();
        }
    };

    public MiniLoadingView(Context context) {
        this(context, null);
    }

    public MiniLoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.MiniLoadingStyle);
    }

    public MiniLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
        this.initPaint();
    }

    public MiniLoadingView(Context context, int size, int color2) {
        super(context);
        this.mSize = size;
        this.mPaintColor = color2;
        this.initPaint();
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.MiniLoadingView, defStyleAttr, 0);
        this.mSize = array.getDimensionPixelSize(R.styleable.MiniLoadingView_mlv_loading_view_size, DensityUtils.dp2px(context, 32.0f));
        this.mPaintColor = array.getColor(R.styleable.MiniLoadingView_mlv_loading_view_color, -1);
        array.recycle();
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mPaintColor);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    public void setColor(int color2) {
        this.mPaintColor = color2;
        this.mPaint.setColor(color2);
        this.invalidate();
    }

    public void setSize(int size) {
        this.mSize = size;
        this.requestLayout();
    }

    public void start() {
        if (this.mAnimator == null) {
            this.mAnimator = ValueAnimator.ofInt((int[])new int[]{0, 11});
            this.mAnimator.addUpdateListener(this.mUpdateListener);
            this.mAnimator.setDuration(600L);
            this.mAnimator.setRepeatMode(1);
            this.mAnimator.setRepeatCount(-1);
            this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mAnimator.start();
        } else if (!this.mAnimator.isStarted()) {
            this.mAnimator.start();
        }
    }

    public void stop() {
        if (this.mAnimator != null) {
            this.mAnimator.removeUpdateListener(this.mUpdateListener);
            this.mAnimator.removeAllUpdateListeners();
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
    }

    private void drawLoading(Canvas canvas, int rotateDegrees) {
        int width = this.mSize / 12;
        int height = this.mSize / 6;
        this.mPaint.setStrokeWidth((float)width);
        canvas.rotate((float)rotateDegrees, (float)this.mSize / 2.0f, (float)this.mSize / 2.0f);
        canvas.translate((float)this.mSize / 2.0f, (float)this.mSize / 2.0f);
        for (int i = 0; i < 12; ++i) {
            canvas.rotate(30.0f);
            this.mPaint.setAlpha((int)(255.0f * (float)(i + 1) / 12.0f));
            canvas.translate(0.0f, (float)(-this.mSize) / 2.0f + (float)width / 2.0f);
            canvas.drawLine(0.0f, 0.0f, 0.0f, (float)height, this.mPaint);
            canvas.translate(0.0f, (float)this.mSize / 2.0f - (float)width / 2.0f);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mSize, this.mSize);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int saveCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
        this.drawLoading(canvas, this.mAnimateValue * 30);
        canvas.restoreToCount(saveCount);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.start();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stop();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.start();
        } else {
            this.stop();
        }
    }
}

