/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.progress;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathDashPathEffect;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ThemeUtils;

public class CircleProgressView
extends View {
    public static final int ACCELERATE_DECELERATE_INTERPOLATOR = 0;
    public static final int LINEAR_INTERPOLATOR = 1;
    public static final int ACCELERATE_INTERPOLATOR = 2;
    public static final int DECELERATE_INTERPOLATOR = 3;
    public static final int OVERSHOOT_INTERPOLATOR = 4;
    private int mAnimateType = 0;
    private float mStartProgress = 0.0f;
    private float mEndProgress = 60.0f;
    private int mStartColor = this.getResources().getColor(R.color.xui_config_color_light_orange);
    private int mEndColor = this.getResources().getColor(R.color.xui_config_color_dark_orange);
    private boolean trackEnabled;
    private boolean fillEnabled;
    private int mTrackWidth;
    private int mProgressWidth;
    private int mProgressTextSize;
    private int mProgressTextColor;
    private boolean circleBroken;
    private int mTrackColor = this.getResources().getColor(R.color.default_pv_track_color);
    private int mProgressDuration = 1200;
    private boolean textVisibility;
    private ObjectAnimator progressAnimator;
    private float moveProgress = 0.0f;
    private Paint progressPaint;
    private Paint trackPaint;
    private LinearGradient mShader;
    private RectF mOval;
    private Interpolator mInterpolator;
    private CircleProgressUpdateListener mUpdateListener;
    private Path mScaleZonePath;
    private float mScaleZoneWidth;
    private float mScaleZoneLength;
    private int mScaleZonePadding;
    private boolean isGraduated = false;
    private int mScaleZoneCornerRadius = 0;
    PathEffect pathEffect;

    public CircleProgressView(Context context) {
        this(context, null);
    }

    public CircleProgressView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.CircleProgressViewStyle);
    }

    public CircleProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.obtainAttrs(context, attrs, defStyleAttr);
        this.init();
    }

    private void obtainAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleProgressView, defStyleAttr, 0);
        this.mStartProgress = typedArray.getInt(R.styleable.CircleProgressView_cpv_start_progress, 0);
        this.mEndProgress = typedArray.getInt(R.styleable.CircleProgressView_cpv_end_progress, 60);
        this.mStartColor = typedArray.getColor(R.styleable.CircleProgressView_cpv_start_color, this.getResources().getColor(R.color.xui_config_color_light_orange));
        this.mEndColor = typedArray.getColor(R.styleable.CircleProgressView_cpv_end_color, this.getResources().getColor(R.color.xui_config_color_dark_orange));
        this.fillEnabled = typedArray.getBoolean(R.styleable.CircleProgressView_cpv_isFilled, false);
        this.trackEnabled = typedArray.getBoolean(R.styleable.CircleProgressView_cpv_isTracked, false);
        this.circleBroken = typedArray.getBoolean(R.styleable.CircleProgressView_cpv_circle_broken, false);
        this.mProgressTextColor = typedArray.getColor(R.styleable.CircleProgressView_cpv_progress_textColor, ThemeUtils.getMainThemeColor(this.getContext()));
        this.mProgressTextSize = typedArray.getDimensionPixelSize(R.styleable.CircleProgressView_cpv_progress_textSize, this.getResources().getDimensionPixelSize(R.dimen.default_pv_progress_text_size));
        this.mTrackWidth = typedArray.getDimensionPixelSize(R.styleable.CircleProgressView_cpv_track_width, this.getResources().getDimensionPixelSize(R.dimen.default_pv_trace_width));
        this.mProgressWidth = typedArray.getDimensionPixelSize(R.styleable.CircleProgressView_cpv_progress_width, this.getResources().getDimensionPixelSize(R.dimen.default_pv_trace_width));
        this.mAnimateType = typedArray.getInt(R.styleable.CircleProgressView_cpv_animate_type, 0);
        this.mTrackColor = typedArray.getColor(R.styleable.CircleProgressView_cpv_track_color, this.getResources().getColor(R.color.default_pv_track_color));
        this.textVisibility = typedArray.getBoolean(R.styleable.CircleProgressView_cpv_progress_textVisibility, true);
        this.mProgressDuration = typedArray.getInt(R.styleable.CircleProgressView_cpv_progress_duration, 1200);
        this.mScaleZoneLength = typedArray.getDimensionPixelSize(R.styleable.CircleProgressView_cpv_scaleZone_length, this.getResources().getDimensionPixelSize(R.dimen.default_pv_zone_length));
        this.mScaleZoneWidth = typedArray.getDimensionPixelSize(R.styleable.CircleProgressView_cpv_scaleZone_width, this.getResources().getDimensionPixelSize(R.dimen.default_pv_zone_width));
        this.mScaleZonePadding = typedArray.getDimensionPixelSize(R.styleable.CircleProgressView_cpv_scaleZone_padding, this.getResources().getDimensionPixelSize(R.dimen.default_pv_zone_padding));
        this.mScaleZoneCornerRadius = typedArray.getDimensionPixelSize(R.styleable.CircleProgressView_cpv_scaleZone_corner_radius, this.getResources().getDimensionPixelSize(R.dimen.default_pv_zone_corner_radius));
        this.isGraduated = typedArray.getBoolean(R.styleable.CircleProgressView_cpv_isGraduated, false);
        this.moveProgress = this.mStartProgress;
        typedArray.recycle();
    }

    private void init() {
        this.progressPaint = new Paint(1);
        this.progressPaint.setStyle(Paint.Style.STROKE);
        this.progressPaint.setStrokeCap(Paint.Cap.ROUND);
        this.progressPaint.setStrokeWidth((float)this.mProgressWidth);
        this.trackPaint = new Paint(1);
        this.trackPaint.setStyle(Paint.Style.STROKE);
        this.trackPaint.setStrokeCap(Paint.Cap.ROUND);
        this.trackPaint.setStrokeWidth((float)this.mTrackWidth);
        this.mScaleZonePath = new Path();
        this.drawScaleZones(this.isGraduated);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawTrack(canvas);
        this.drawProgress(canvas);
        this.drawProgressText(canvas);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateTheTrack();
        this.mShader = new LinearGradient(this.mOval.left - 200.0f, this.mOval.top - 200.0f, this.mOval.right + 20.0f, this.mOval.bottom + 20.0f, this.mStartColor, this.mEndColor, Shader.TileMode.CLAMP);
        RectF mScaleZoneRect = new RectF(0.0f, 0.0f, this.mScaleZoneWidth, this.mScaleZoneLength);
        this.mScaleZonePath.addRoundRect(mScaleZoneRect, (float)this.mScaleZoneCornerRadius, (float)this.mScaleZoneCornerRadius, Path.Direction.CW);
    }

    private void drawTrack(Canvas canvas) {
        if (this.trackEnabled) {
            this.trackPaint.setShader(null);
            this.trackPaint.setColor(this.mTrackColor);
            this.initTrack(canvas, this.fillEnabled);
        }
    }

    private void drawProgress(Canvas canvas) {
        this.progressPaint.setShader((Shader)this.mShader);
        this.updateTheTrack();
        this.initProgressDrawing(canvas, this.fillEnabled);
    }

    private void drawScaleZones(boolean isGraduated) {
        if (isGraduated) {
            if (this.pathEffect == null) {
                this.pathEffect = new PathDashPathEffect(this.mScaleZonePath, (float)this.mScaleZonePadding, 0.0f, PathDashPathEffect.Style.ROTATE);
            }
            this.progressPaint.setPathEffect(this.pathEffect);
        } else {
            this.pathEffect = null;
            this.progressPaint.setPathEffect(null);
        }
    }

    private void initTrack(Canvas canvas, boolean isFilled) {
        if (isFilled) {
            this.trackPaint.setStyle(Paint.Style.FILL);
        } else {
            this.trackPaint.setStyle(Paint.Style.STROKE);
        }
        if (this.circleBroken) {
            canvas.drawArc(this.mOval, 135.0f, 270.0f, isFilled, this.trackPaint);
        } else {
            canvas.drawArc(this.mOval, 90.0f, 360.0f, isFilled, this.trackPaint);
        }
    }

    private void drawProgressText(Canvas canvas) {
        if (this.textVisibility) {
            Paint mTextPaint = new Paint(1);
            mTextPaint.setStyle(Paint.Style.FILL);
            mTextPaint.setTextSize((float)this.mProgressTextSize);
            mTextPaint.setColor(this.mProgressTextColor);
            mTextPaint.setTextAlign(Paint.Align.CENTER);
            mTextPaint.setTypeface(XUI.getDefaultTypeface());
            String progressText = (int)this.moveProgress + "%";
            float x = this.getWidth() + this.getPaddingLeft() - this.getPaddingRight() >> 1;
            float y = ((float)(this.getHeight() + this.getPaddingTop() - this.getPaddingBottom()) - (mTextPaint.descent() + mTextPaint.ascent())) / 2.0f;
            canvas.drawText(progressText, x, y, mTextPaint);
        }
    }

    public void setAnimateType(int type) {
        this.mAnimateType = type;
        this.setObjectAnimatorType(type);
    }

    private void setObjectAnimatorType(int animatorType) {
        switch (animatorType) {
            case 0: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new AccelerateDecelerateInterpolator();
                break;
            }
            case 1: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new LinearInterpolator();
                break;
            }
            case 2: {
                if (this.mInterpolator == null) break;
                this.mInterpolator = null;
                this.mInterpolator = new AccelerateInterpolator();
                break;
            }
            case 3: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new DecelerateInterpolator();
                break;
            }
            case 4: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new OvershootInterpolator();
                break;
            }
        }
    }

    public void setProgress(float progress) {
        this.moveProgress = progress;
        this.refreshTheView();
    }

    public float getProgress() {
        return this.moveProgress;
    }

    public void setStartProgress(float startProgress) {
        if (startProgress < 0.0f || startProgress > 100.0f) {
            throw new IllegalArgumentException("Illegal progress value, please change it!");
        }
        this.moveProgress = this.mStartProgress = startProgress;
        this.refreshTheView();
    }

    public void setEndProgress(float endProgress) {
        if (endProgress < 0.0f || endProgress > 100.0f) {
            throw new IllegalArgumentException("Illegal progress value, please change it!");
        }
        this.mEndProgress = endProgress;
        this.refreshTheView();
    }

    public void setStartColor(@ColorInt int startColor) {
        this.mStartColor = startColor;
        this.updateTheTrack();
        this.mShader = new LinearGradient(this.mOval.left - 200.0f, this.mOval.top - 200.0f, this.mOval.right + 20.0f, this.mOval.bottom + 20.0f, this.mStartColor, this.mEndColor, Shader.TileMode.CLAMP);
        this.refreshTheView();
    }

    public void setEndColor(@ColorInt int endColor) {
        this.mEndColor = endColor;
        this.updateTheTrack();
        this.mShader = new LinearGradient(this.mOval.left - 200.0f, this.mOval.top - 200.0f, this.mOval.right + 20.0f, this.mOval.bottom + 20.0f, this.mStartColor, this.mEndColor, Shader.TileMode.CLAMP);
        this.refreshTheView();
    }

    public void setTrackWidth(int width) {
        this.mTrackWidth = DensityUtils.dp2px(this.getContext(), width);
        this.trackPaint.setStrokeWidth((float)width);
        this.updateTheTrack();
        this.refreshTheView();
    }

    public void setProgressWidth(int width) {
        this.mProgressWidth = DensityUtils.dp2px(this.getContext(), width);
        this.progressPaint.setStrokeWidth((float)width);
        this.refreshTheView();
    }

    public void setProgressTextSize(int size) {
        this.mProgressTextSize = DensityUtils.sp2px(this.getContext(), size);
        this.refreshTheView();
    }

    public void setProgressTextColor(@ColorInt int textColor) {
        this.mProgressTextColor = textColor;
    }

    public void setProgressDuration(int duration) {
        this.mProgressDuration = duration;
    }

    public void setTrackEnabled(boolean trackAble) {
        this.trackEnabled = trackAble;
        this.refreshTheView();
    }

    public void setTrackColor(@ColorInt int color2) {
        this.mTrackColor = color2;
        this.refreshTheView();
    }

    public void setFillEnabled(boolean fillEnabled) {
        this.fillEnabled = fillEnabled;
        this.refreshTheView();
    }

    public void setCircleBroken(boolean isBroken) {
        this.circleBroken = isBroken;
        this.refreshTheView();
    }

    public void setGraduatedEnabled(final boolean isGraduated) {
        this.isGraduated = isGraduated;
        this.post(new Runnable(){

            @Override
            public void run() {
                CircleProgressView.this.drawScaleZones(isGraduated);
            }
        });
    }

    public void setScaleZoneWidth(float zoneWidth) {
        this.mScaleZoneWidth = DensityUtils.dp2px(this.getContext(), zoneWidth);
    }

    public void setScaleZoneLength(float zoneLength) {
        this.mScaleZoneLength = DensityUtils.dp2px(this.getContext(), zoneLength);
    }

    public void setScaleZonePadding(int zonePadding) {
        this.mScaleZonePadding = DensityUtils.dp2px(this.getContext(), zonePadding);
    }

    public void setScaleZoneCornerRadius(int cornerRadius) {
        this.mScaleZoneCornerRadius = DensityUtils.dp2px(this.getContext(), cornerRadius);
    }

    public void setProgressTextVisibility(boolean visibility) {
        this.textVisibility = visibility;
    }

    public void startProgressAnimation() {
        this.progressAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"progress", (float[])new float[]{this.mStartProgress, this.mEndProgress});
        this.progressAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
        this.progressAnimator.setDuration((long)this.mProgressDuration);
        this.progressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue("progress")).floatValue();
                if (CircleProgressView.this.mUpdateListener != null) {
                    CircleProgressView.this.mUpdateListener.onCircleProgressUpdate(CircleProgressView.this, progress);
                }
            }
        });
        this.progressAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                if (CircleProgressView.this.mUpdateListener != null) {
                    CircleProgressView.this.mUpdateListener.onCircleProgressStart(CircleProgressView.this);
                }
            }

            public void onAnimationEnd(Animator animator) {
                if (CircleProgressView.this.mUpdateListener != null) {
                    CircleProgressView.this.mUpdateListener.onCircleProgressFinished(CircleProgressView.this);
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        this.progressAnimator.start();
    }

    public void stopProgressAnimation() {
        if (this.progressAnimator != null) {
            this.progressAnimator.cancel();
            this.progressAnimator = null;
        }
    }

    private void refreshTheView() {
        this.invalidate();
        this.requestLayout();
    }

    private void updateTheTrack() {
        if (this.mOval != null) {
            this.mOval = null;
        }
        this.mOval = new RectF((float)(this.getPaddingLeft() + this.mTrackWidth), (float)(this.getPaddingTop() + this.mTrackWidth), (float)(this.getWidth() - this.getPaddingRight() - this.mTrackWidth), (float)(this.getHeight() - this.getPaddingBottom() - this.mTrackWidth));
    }

    private void initProgressDrawing(Canvas canvas, boolean isFilled) {
        if (isFilled) {
            this.progressPaint.setStyle(Paint.Style.FILL);
        } else {
            this.progressPaint.setStyle(Paint.Style.STROKE);
        }
        if (this.circleBroken) {
            canvas.drawArc(this.mOval, 135.0f + this.mStartProgress * 2.7f, (this.moveProgress - this.mStartProgress) * 2.7f, isFilled, this.progressPaint);
        } else {
            canvas.drawArc(this.mOval, 270.0f + this.mStartProgress * 3.6f, (this.moveProgress - this.mStartProgress) * 3.6f, isFilled, this.progressPaint);
        }
    }

    public void setProgressViewUpdateListener(CircleProgressUpdateListener listener) {
        this.mUpdateListener = listener;
    }

    public static interface CircleProgressUpdateListener {
        public void onCircleProgressStart(View var1);

        public void onCircleProgressUpdate(View var1, float var2);

        public void onCircleProgressFinished(View var1);
    }
}

