/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.popupwindow.popup;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.XUIWrapContentListView;
import com.xuexiang.xui.widget.popupwindow.popup.XUIPopup;

public class XUIListPopup<T extends XUIListPopup>
extends XUIPopup {
    protected ListView mListView;
    protected ListAdapter mAdapter;
    private boolean mHasDivider;

    public XUIListPopup(Context context, int direction, ListAdapter adapter) {
        super(context, direction);
        this.mAdapter = adapter;
    }

    public XUIListPopup(Context context, ListAdapter adapter) {
        super(context);
        this.mAdapter = adapter;
    }

    public T create(int width, int maxHeight, AdapterView.OnItemClickListener onItemClickListener) {
        this.create(width, maxHeight);
        this.mListView.setOnItemClickListener(onItemClickListener);
        return (T)this;
    }

    protected T create(int width, int maxHeight) {
        int margin = DensityUtils.dp2px(this.getContext(), 5.0f);
        if (maxHeight != 0) {
            this.mListView = new XUIWrapContentListView(this.getContext(), maxHeight);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(width, maxHeight);
            lp.setMargins(0, margin, 0, margin);
            this.mListView.setLayoutParams((ViewGroup.LayoutParams)lp);
        } else {
            this.mListView = new XUIWrapContentListView(this.getContext());
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(width, -2);
            lp.setMargins(0, margin, 0, margin);
            this.mListView.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        this.mListView.setPadding(margin, 0, margin, 0);
        this.mListView.setAdapter(this.mAdapter);
        this.mListView.setVerticalScrollBarEnabled(false);
        this.mListView.setOverScrollMode(2);
        this.updateListViewDivider(this.mListView);
        this.setContentView((View)this.mListView);
        return (T)this;
    }

    protected T create(int width) {
        return this.create(width, 0);
    }

    public T setHasDivider(boolean hasDivider) {
        this.mHasDivider = hasDivider;
        if (this.mListView != null) {
            this.updateListViewDivider(this.mListView);
        }
        return (T)this;
    }

    private void updateListViewDivider(ListView listView) {
        if (this.mHasDivider) {
            listView.setDivider((Drawable)new ColorDrawable(ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_separator_light)));
            if (XUI.isTablet()) {
                listView.setDividerHeight(DensityUtils.dp2px(this.getContext(), 1.0f));
            } else {
                listView.setDividerHeight(DensityUtils.dp2px(this.getContext(), 0.5f));
            }
        } else {
            listView.setDivider(null);
        }
    }

    public T setDivider(Drawable divider) {
        if (this.mListView != null) {
            this.mListView.setDivider(divider);
        }
        return (T)this;
    }

    public T setDividerHeight(int dividerHeight) {
        if (this.mListView != null) {
            this.mListView.setDividerHeight(dividerHeight);
        }
        return (T)this;
    }

    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public ListView getListView() {
        return this.mListView;
    }
}

