/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.popupwindow.popup;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.FrameLayout;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.XUIWrapContentExpandableListView;
import com.xuexiang.xui.widget.popupwindow.popup.XUIPopup;

public class XUIExpandableListPopup<T extends XUIExpandableListPopup>
extends XUIPopup {
    protected ExpandableListView mExpandableListView;
    protected ExpandableListAdapter mAdapter;
    private boolean mHasDivider;

    public XUIExpandableListPopup(Context context) {
        super(context);
    }

    public XUIExpandableListPopup(Context context, int direction, ExpandableListAdapter adapter) {
        super(context, direction);
        this.mAdapter = adapter;
    }

    public XUIExpandableListPopup(Context context, ExpandableListAdapter adapter) {
        super(context);
        this.mAdapter = adapter;
    }

    public T create(int width, int maxHeight, ExpandableListView.OnChildClickListener onChildClickListener) {
        this.create(width, maxHeight);
        this.mExpandableListView.setOnChildClickListener(onChildClickListener);
        return (T)this;
    }

    public T create(int width) {
        return this.create(width, 0);
    }

    protected T create(int width, int maxHeight) {
        int margin = DensityUtils.dp2px(this.getContext(), 5.0f);
        if (maxHeight != 0) {
            this.mExpandableListView = new XUIWrapContentExpandableListView(this.getContext(), maxHeight);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(width, maxHeight);
            lp.setMargins(0, margin, 0, margin);
            this.mExpandableListView.setLayoutParams((ViewGroup.LayoutParams)lp);
        } else {
            this.mExpandableListView = new XUIWrapContentExpandableListView(this.getContext());
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(width, -2);
            lp.setMargins(0, margin, 0, margin);
            this.mExpandableListView.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        this.mExpandableListView.setPadding(margin, 0, margin, 0);
        this.mExpandableListView.setAdapter(this.mAdapter);
        this.mExpandableListView.setGroupIndicator(null);
        this.mExpandableListView.setVerticalScrollBarEnabled(false);
        this.mExpandableListView.setOverScrollMode(2);
        this.updateDivider(this.mExpandableListView);
        this.setContentView((View)this.mExpandableListView);
        return (T)this;
    }

    public T setHasDivider(boolean hasDivider) {
        this.mHasDivider = hasDivider;
        if (this.mExpandableListView != null) {
            this.updateDivider(this.mExpandableListView);
        }
        return (T)this;
    }

    private void updateDivider(ExpandableListView listView) {
        if (this.mHasDivider) {
            listView.setDivider((Drawable)new ColorDrawable(ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_separator_light)));
            listView.setChildDivider((Drawable)new ColorDrawable(ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_separator_light)));
            listView.setDividerHeight(DensityUtils.dp2px(this.getContext(), XUI.isTablet() ? 1.0f : 0.5f));
        } else {
            listView.setDivider(null);
            listView.setChildDivider(null);
        }
    }

    public T setGroupDivider(Drawable divider) {
        if (this.mExpandableListView != null) {
            this.mExpandableListView.setDivider(divider);
        }
        return (T)this;
    }

    public T setChildDivider(Drawable divider) {
        if (this.mExpandableListView != null) {
            this.mExpandableListView.setChildDivider(divider);
        }
        return (T)this;
    }

    public T setDividerHeight(int dividerHeight) {
        if (this.mExpandableListView != null) {
            this.mExpandableListView.setDividerHeight(dividerHeight);
        }
        return (T)this;
    }

    public T setOnChildClickListener(ExpandableListView.OnChildClickListener onChildClickListener) {
        if (this.mExpandableListView != null) {
            this.mExpandableListView.setOnChildClickListener(onChildClickListener);
        }
        return (T)this;
    }

    public T setOnGroupClickListener(ExpandableListView.OnGroupClickListener onGroupClickListener) {
        if (this.mExpandableListView != null) {
            this.mExpandableListView.setOnGroupClickListener(onGroupClickListener);
        }
        return (T)this;
    }

    public T setEnableOnlyExpandOne(boolean enable) {
        if (this.mExpandableListView != null) {
            if (enable) {
                this.mExpandableListView.setOnGroupExpandListener(new ExpandableListView.OnGroupExpandListener(){

                    public void onGroupExpand(int groupPosition) {
                        XUIExpandableListPopup.this.expandOnlyOne(groupPosition);
                    }
                });
            } else {
                this.mExpandableListView.setOnGroupExpandListener(null);
            }
        }
        return (T)this;
    }

    public boolean expandOnlyOne(int expandedPosition) {
        if (this.mExpandableListView == null) {
            return false;
        }
        boolean result = true;
        int groupLength = this.mExpandableListView.getExpandableListAdapter().getGroupCount();
        for (int i = 0; i < groupLength; ++i) {
            if (i == expandedPosition || !this.mExpandableListView.isGroupExpanded(i)) continue;
            result &= this.mExpandableListView.collapseGroup(i);
        }
        return result;
    }

    public void expandAllGroup() {
        if (this.mExpandableListView != null) {
            int groupLength = this.mExpandableListView.getExpandableListAdapter().getGroupCount();
            for (int i = 0; i < groupLength; ++i) {
                if (this.mExpandableListView.isGroupExpanded(i)) continue;
                this.mExpandableListView.expandGroup(i);
            }
        }
    }

    public void collapseAllGroup() {
        if (this.mExpandableListView != null) {
            int groupLength = this.mExpandableListView.getExpandableListAdapter().getGroupCount();
            for (int i = 0; i < groupLength; ++i) {
                if (!this.mExpandableListView.isGroupExpanded(i)) continue;
                this.mExpandableListView.collapseGroup(i);
            }
        }
    }

    public void clearExpandStatus() {
        this.collapseAllGroup();
    }

    public ExpandableListAdapter getAdapter() {
        return this.mAdapter;
    }

    public ExpandableListView getExpandableListView() {
        return this.mExpandableListView;
    }
}

