/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.popupwindow.good;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.popupwindow.good.IGoodView;

public class GoodView
extends PopupWindow
implements IGoodView {
    private TextView mContent = null;
    private String mText = "";
    private int mTextColor = -16777216;
    private int mTextSize = 16;
    private AnimationSet mAnimationSet;
    private int mFromY = 0;
    private int mToY = 60;
    private float mFromAlpha = 1.0f;
    private float mToAlpha = 0.0f;
    private int mDuration = 800;
    private int mDistance = 60;
    private boolean mChanged = false;

    public GoodView(Context context) {
        super(context);
        this.initView(context);
    }

    private void initView(Context context) {
        RelativeLayout layout2 = new RelativeLayout(context);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(14);
        params.addRule(12);
        this.mContent = new TextView(context);
        this.mContent.setIncludeFontPadding(false);
        this.mContent.setTextSize(1, (float)this.mTextSize);
        this.mContent.setTextColor(this.mTextColor);
        this.mContent.setText((CharSequence)this.mText);
        this.mContent.setLayoutParams((ViewGroup.LayoutParams)params);
        layout2.addView((View)this.mContent);
        this.setContentView((View)layout2);
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.mContent.measure(w, h);
        this.setWidth(this.mContent.getMeasuredWidth());
        this.setHeight(this.mDistance + this.mContent.getMeasuredHeight());
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setFocusable(false);
        this.setTouchable(false);
        this.setOutsideTouchable(false);
        this.mAnimationSet = this.createAnimation();
    }

    private static int getTextViewHeight(TextView textView, int width) {
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        textView.measure(widthMeasureSpec, heightMeasureSpec);
        return textView.getMeasuredHeight();
    }

    @Override
    public IGoodView setText(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("text cannot be null.");
        }
        this.mText = text;
        this.mContent.setText((CharSequence)text);
        this.mContent.setBackground((Drawable)new ColorDrawable(0));
        int w = (int)this.mContent.getPaint().measureText(text);
        this.setWidth(w);
        this.setHeight(this.mDistance + GoodView.getTextViewHeight(this.mContent, w));
        return this;
    }

    @Override
    public IGoodView setTextColor(int color2) {
        this.mTextColor = color2;
        this.mContent.setTextColor(color2);
        return this;
    }

    @Override
    public IGoodView setTextSize(int textSize) {
        this.mTextSize = textSize;
        this.mContent.setTextSize(2, (float)textSize);
        return this;
    }

    @Override
    public IGoodView setTextInfo(String text, int textColor, int textSize) {
        this.setTextColor(textColor);
        this.setTextSize(textSize);
        this.setText(text);
        return this;
    }

    @Override
    public IGoodView setImageResource(int resId) {
        return this.setImageDrawable(ResUtils.getDrawable(this.mContent.getContext(), resId));
    }

    @Override
    public IGoodView setImageDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("drawable cannot be null.");
        }
        this.mContent.setBackground(drawable2);
        this.mContent.setText((CharSequence)"");
        this.setWidth(drawable2.getIntrinsicWidth());
        this.setHeight(this.mDistance + drawable2.getIntrinsicHeight());
        return this;
    }

    @Override
    public IGoodView setDistance(int dis) {
        this.mDistance = dis;
        this.mToY = dis;
        this.mChanged = true;
        this.setHeight(this.mDistance + this.mContent.getMeasuredHeight());
        return this;
    }

    @Override
    public IGoodView setTranslateY(int fromY, int toY) {
        this.mFromY = fromY;
        this.mToY = toY;
        this.mChanged = true;
        return this;
    }

    @Override
    public IGoodView setAlpha(float fromAlpha, float toAlpha) {
        this.mFromAlpha = fromAlpha;
        this.mToAlpha = toAlpha;
        this.mChanged = true;
        return this;
    }

    @Override
    public IGoodView setDuration(int duration) {
        this.mDuration = duration;
        this.mChanged = true;
        return this;
    }

    @Override
    public void reset() {
        this.mText = "";
        this.mTextColor = -16777216;
        this.mTextSize = 16;
        this.mFromY = 0;
        this.mToY = 60;
        this.mFromAlpha = 1.0f;
        this.mToAlpha = 0.0f;
        this.mDuration = 800;
        this.mDistance = 60;
        this.mChanged = false;
        this.mAnimationSet = this.createAnimation();
    }

    @Override
    public void show(View v) {
        if (!this.isShowing()) {
            int offsetY = -v.getHeight() - this.getHeight();
            this.showAsDropDown(v, v.getWidth() / 2 - this.getWidth() / 2, offsetY);
            if (this.mAnimationSet == null || this.mChanged) {
                this.mAnimationSet = this.createAnimation();
                this.mChanged = false;
            }
            this.mContent.startAnimation((Animation)this.mAnimationSet);
        }
    }

    private AnimationSet createAnimation() {
        AnimationSet anim2 = new AnimationSet(true);
        TranslateAnimation translateAnim = new TranslateAnimation(0.0f, 0.0f, (float)this.mFromY, (float)(-this.mToY));
        AlphaAnimation alphaAnim = new AlphaAnimation(this.mFromAlpha, this.mToAlpha);
        anim2.addAnimation((Animation)translateAnim);
        anim2.addAnimation((Animation)alphaAnim);
        anim2.setDuration((long)this.mDuration);
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (GoodView.this.isShowing()) {
                    GoodView.this.dismiss();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        return anim2;
    }
}

