/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.popupwindow;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.Html;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.ThemeUtils;

public class ViewTooltip {
    private final View mView;
    private final TooltipView mTooltipView;

    private ViewTooltip(View view) {
        this.mView = view;
        this.mTooltipView = new TooltipView((Context)this.getActivityContext(view.getContext()));
    }

    public static ViewTooltip on(View view) {
        return new ViewTooltip(view);
    }

    public Activity getActivityContext(Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public ViewTooltip position(Position position) {
        this.mTooltipView.setPosition(position);
        return this;
    }

    public ViewTooltip customView(View customView) {
        this.mTooltipView.setCustomView(customView);
        return this;
    }

    public ViewTooltip customView(int viewId) {
        this.mTooltipView.setCustomView(((Activity)this.mView.getContext()).findViewById(viewId));
        return this;
    }

    public ViewTooltip align(ALIGN align) {
        this.mTooltipView.setAlign(align);
        return this;
    }

    public TooltipView show() {
        Context activityContext = this.mTooltipView.getContext();
        if (activityContext != null && activityContext instanceof Activity) {
            final ViewGroup decorView = (ViewGroup)((Activity)activityContext).getWindow().getDecorView();
            this.mView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    final Rect rect = new Rect();
                    ViewTooltip.this.mView.getGlobalVisibleRect(rect);
                    int[] location = new int[2];
                    ViewTooltip.this.mView.getLocationOnScreen(location);
                    rect.left = location[0];
                    decorView.addView((View)ViewTooltip.this.mTooltipView, -2, -2);
                    ViewTooltip.this.mTooltipView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                        public boolean onPreDraw() {
                            ViewTooltip.this.mTooltipView.setup(rect, decorView.getWidth());
                            ViewTooltip.this.mTooltipView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                            return false;
                        }
                    });
                }
            }, 100L);
        }
        return this.mTooltipView;
    }

    public void close() {
        this.mTooltipView.close();
    }

    public ViewTooltip duration(long duration) {
        this.mTooltipView.setDuration(duration);
        return this;
    }

    public ViewTooltip color(int color2) {
        this.mTooltipView.setColor(color2);
        return this;
    }

    public ViewTooltip onDisplay(ListenerDisplay listener) {
        this.mTooltipView.setListenerDisplay(listener);
        return this;
    }

    public ViewTooltip onHide(ListenerHide listener) {
        this.mTooltipView.setListenerHide(listener);
        return this;
    }

    public ViewTooltip padding(int left, int top, int right, int bottom) {
        this.mTooltipView.mPaddingTop = top;
        this.mTooltipView.mPaddingBottom = bottom;
        this.mTooltipView.mPaddingLeft = left;
        this.mTooltipView.mPaddingRight = right;
        return this;
    }

    public ViewTooltip animation(TooltipAnimation tooltipAnimation) {
        this.mTooltipView.setTooltipAnimation(tooltipAnimation);
        return this;
    }

    public ViewTooltip text(String text) {
        this.mTooltipView.setText(text);
        return this;
    }

    public ViewTooltip corner(int corner) {
        this.mTooltipView.setCorner(corner);
        return this;
    }

    public ViewTooltip textColor(int textColor) {
        this.mTooltipView.setTextColor(textColor);
        return this;
    }

    public ViewTooltip textTypeFace(Typeface typeface) {
        this.mTooltipView.setTextTypeFace(typeface);
        return this;
    }

    public ViewTooltip textSize(int unit, float textSize) {
        this.mTooltipView.setTextSize(unit, textSize);
        return this;
    }

    public ViewTooltip setTextGravity(int textGravity) {
        this.mTooltipView.setTextGravity(textGravity);
        return this;
    }

    public ViewTooltip clickToHide(boolean clickToHide) {
        this.mTooltipView.setClickToHide(clickToHide);
        return this;
    }

    public ViewTooltip autoHide(boolean autoHide, long duration) {
        this.mTooltipView.setAutoHide(autoHide);
        this.mTooltipView.setDuration(duration);
        return this;
    }

    public static class TooltipView
    extends FrameLayout {
        private static final int MARGIN_SCREEN_BORDER_TOOLTIP = 30;
        private final int ARROW_HEIGHT = 15;
        protected View mChildView;
        private int mBubbleColor = Color.parseColor((String)"#B2299EE3");
        private Path mBubblePath;
        private Paint mBubblePaint;
        private Position mPosition = Position.BOTTOM;
        private ALIGN mAlign = ALIGN.CENTER;
        private boolean mClickToHide;
        private boolean mAutoHide = true;
        private long mDuration = 4000L;
        private ListenerDisplay mListenerDisplay;
        private ListenerHide mListenerHide;
        private TooltipAnimation mTooltipAnimation = new FadeTooltipAnimation();
        private int mCorner = 30;
        private int mPaddingTop;
        private int mPaddingBottom;
        private int mPaddingRight;
        private int mPaddingLeft;
        private Rect mViewRect;

        public TooltipView(Context context) {
            super(context);
            this.setWillNotDraw(false);
            this.mChildView = new TextView(context);
            ((TextView)this.mChildView).setTextColor(-1);
            this.addView(this.mChildView, -2, -2);
            this.mChildView.setPadding(0, 0, 0, 0);
            this.mBubblePaint = new Paint(1);
            this.mBubblePaint.setColor(this.mBubbleColor);
            this.mBubblePaint.setStyle(Paint.Style.FILL);
            this.mPaddingTop = this.mPaddingBottom = ThemeUtils.resolveDimension(this.getContext(), R.attr.xui_tip_popup_padding_top);
            this.mPaddingRight = this.mPaddingLeft = ThemeUtils.resolveDimension(this.getContext(), R.attr.xui_tip_popup_padding_left);
            this.setTextTypeFace(XUI.getDefaultTypeface());
        }

        public void setCustomView(View customView) {
            this.removeView(this.mChildView);
            this.mChildView = customView;
            this.addView(this.mChildView, -2, -2);
        }

        public void setColor(int color2) {
            this.mBubbleColor = color2;
            this.mBubblePaint.setColor(color2);
            this.postInvalidate();
        }

        public void setPosition(Position position) {
            this.mPosition = position;
            switch (position) {
                case TOP: {
                    this.setPaddingRelative(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom + 15);
                    break;
                }
                case BOTTOM: {
                    this.setPaddingRelative(this.mPaddingLeft, this.mPaddingTop + 15, this.mPaddingRight, this.mPaddingBottom);
                    break;
                }
                case LEFT: {
                    this.setPaddingRelative(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight + 15, this.mPaddingBottom);
                    break;
                }
                case RIGHT: {
                    this.setPaddingRelative(this.mPaddingLeft + 15, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom);
                    break;
                }
            }
            this.postInvalidate();
        }

        public void setAlign(ALIGN align) {
            this.mAlign = align;
            this.postInvalidate();
        }

        public void setText(String text) {
            if (this.mChildView instanceof TextView) {
                ((TextView)this.mChildView).setText((CharSequence)Html.fromHtml((String)text));
            }
            this.postInvalidate();
        }

        public void setTextColor(int textColor) {
            if (this.mChildView instanceof TextView) {
                ((TextView)this.mChildView).setTextColor(textColor);
            }
            this.postInvalidate();
        }

        public void setTextTypeFace(Typeface textTypeFace) {
            if (this.mChildView instanceof TextView) {
                ((TextView)this.mChildView).setTypeface(textTypeFace);
            }
            this.postInvalidate();
        }

        public void setTextSize(int unit, float size) {
            if (this.mChildView instanceof TextView) {
                ((TextView)this.mChildView).setTextSize(unit, size);
            }
            this.postInvalidate();
        }

        public void setTextGravity(int textGravity) {
            if (this.mChildView instanceof TextView) {
                ((TextView)this.mChildView).setGravity(textGravity);
            }
            this.postInvalidate();
        }

        public void setClickToHide(boolean clickToHide) {
            this.mClickToHide = clickToHide;
        }

        public void setCorner(int corner) {
            this.mCorner = corner;
        }

        protected void onSizeChanged(int width, int height, int oldw, int oldh) {
            super.onSizeChanged(width, height, oldw, oldh);
            this.mBubblePath = this.drawBubble(new RectF(0.0f, 0.0f, (float)width, (float)height), this.mCorner, this.mCorner, this.mCorner, this.mCorner);
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            if (this.mBubblePath != null) {
                canvas.drawPath(this.mBubblePath, this.mBubblePaint);
            }
        }

        public void setListenerDisplay(ListenerDisplay listener) {
            this.mListenerDisplay = listener;
        }

        public void setListenerHide(ListenerHide listener) {
            this.mListenerHide = listener;
        }

        public void setTooltipAnimation(TooltipAnimation tooltipAnimation) {
            this.mTooltipAnimation = tooltipAnimation;
        }

        protected void startEnterAnimation() {
            this.mTooltipAnimation.animateEnter((View)this, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (TooltipView.this.mListenerDisplay != null) {
                        TooltipView.this.mListenerDisplay.onDisplay((View)TooltipView.this);
                    }
                }
            });
        }

        protected void startExitAnimation(final Animator.AnimatorListener animatorListener) {
            this.mTooltipAnimation.animateExit((View)this, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    animatorListener.onAnimationEnd(animation);
                    if (TooltipView.this.mListenerHide != null) {
                        TooltipView.this.mListenerHide.onHide((View)TooltipView.this);
                    }
                }
            });
        }

        protected void handleAutoRemove() {
            if (this.mClickToHide) {
                this.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (TooltipView.this.mClickToHide) {
                            TooltipView.this.remove();
                        }
                    }
                });
            }
            if (this.mAutoHide) {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TooltipView.this.remove();
                    }
                }, this.mDuration);
            }
        }

        public void remove() {
            this.startExitAnimation((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (TooltipView.this.getParent() != null) {
                        ViewGroup parent = (ViewGroup)TooltipView.this.getParent();
                        parent.removeView((View)TooltipView.this);
                    }
                }
            });
        }

        public void setDuration(long duration) {
            this.mDuration = duration;
        }

        public void setAutoHide(boolean autoHide) {
            this.mAutoHide = autoHide;
        }

        public void setupPosition(Rect rect) {
            if (this.mPosition == Position.LEFT || this.mPosition == Position.RIGHT) {
                int myHeight = this.getHeight();
                int hisHeight = rect.height();
                int maxHeight = Math.max(hisHeight, myHeight);
                int minHeight = Math.min(hisHeight, myHeight);
                int spacingY = 0;
                switch (this.mAlign) {
                    case START: {
                        spacingY = 0;
                        break;
                    }
                    case CENTER: {
                        spacingY = (int)(-1.0f * (float)maxHeight / 2.0f + (float)minHeight / 2.0f);
                        break;
                    }
                }
                if (this.mPosition == Position.LEFT) {
                    this.setTranslationY(rect.top + spacingY);
                    this.setTranslationX(rect.left - this.getWidth());
                } else {
                    this.setTranslationY(rect.top + spacingY);
                    this.setTranslationX(rect.right);
                }
            } else {
                int spacingX = 0;
                int myWidth = this.getWidth();
                int hisWidth = rect.width();
                if (this.mAlign == ALIGN.CENTER) {
                    spacingX = (int)((float)hisWidth / 2.0f - 1.0f * (float)myWidth / 2.0f);
                }
                if (this.mPosition == Position.BOTTOM) {
                    this.setTranslationY(rect.bottom);
                    this.setTranslationX(rect.left + spacingX);
                } else {
                    this.setTranslationY(rect.top - this.getHeight());
                    this.setTranslationX(rect.left + spacingX);
                }
            }
        }

        private Path drawBubble(RectF myRect, float topLeftDiameter, float topRightDiameter, float bottomRightDiameter, float bottomLeftDiameter) {
            Path path = new Path();
            if (this.mViewRect == null) {
                return path;
            }
            topLeftDiameter = topLeftDiameter < 0.0f ? 0.0f : topLeftDiameter;
            topRightDiameter = topRightDiameter < 0.0f ? 0.0f : topRightDiameter;
            bottomLeftDiameter = bottomLeftDiameter < 0.0f ? 0.0f : bottomLeftDiameter;
            bottomRightDiameter = bottomRightDiameter < 0.0f ? 0.0f : bottomRightDiameter;
            float spacingLeft = this.mPosition == Position.RIGHT ? 15.0f : 0.0f;
            float spacingTop = this.mPosition == Position.BOTTOM ? 15.0f : 0.0f;
            float spacingRight = this.mPosition == Position.LEFT ? 15.0f : 0.0f;
            float spacingBottom = this.mPosition == Position.TOP ? 15.0f : 0.0f;
            float left = spacingLeft + myRect.left;
            float top = spacingTop + myRect.top;
            float right = myRect.right - spacingRight;
            float bottom = myRect.bottom - spacingBottom;
            float centerX = (float)this.mViewRect.centerX() - this.getX();
            path.moveTo(left + topLeftDiameter / 2.0f, top);
            int ARROW_WIDTH = 15;
            if (this.mPosition == Position.BOTTOM) {
                path.lineTo(centerX - (float)ARROW_WIDTH, top);
                path.lineTo(centerX, myRect.top);
                path.lineTo(centerX + (float)ARROW_WIDTH, top);
            }
            path.lineTo(right - topRightDiameter / 2.0f, top);
            path.quadTo(right, top, right, top + topRightDiameter / 2.0f);
            if (this.mPosition == Position.LEFT) {
                path.lineTo(right, bottom / 2.0f - (float)ARROW_WIDTH);
                path.lineTo(myRect.right, bottom / 2.0f);
                path.lineTo(right, bottom / 2.0f + (float)ARROW_WIDTH);
            }
            path.lineTo(right, bottom - bottomRightDiameter / 2.0f);
            path.quadTo(right, bottom, right - bottomRightDiameter / 2.0f, bottom);
            if (this.mPosition == Position.TOP) {
                path.lineTo(centerX + (float)ARROW_WIDTH, bottom);
                path.lineTo(centerX, myRect.bottom);
                path.lineTo(centerX - (float)ARROW_WIDTH, bottom);
            }
            path.lineTo(left + bottomLeftDiameter / 2.0f, bottom);
            path.quadTo(left, bottom, left, bottom - bottomLeftDiameter / 2.0f);
            if (this.mPosition == Position.RIGHT) {
                path.lineTo(left, bottom / 2.0f + (float)ARROW_WIDTH);
                path.lineTo(myRect.left, bottom / 2.0f);
                path.lineTo(left, bottom / 2.0f - (float)ARROW_WIDTH);
            }
            path.lineTo(left, top + topLeftDiameter / 2.0f);
            path.quadTo(left, top, left + topLeftDiameter / 2.0f, top);
            path.close();
            return path;
        }

        public boolean adjustSize(Rect rect, int screenWidth) {
            boolean changed = false;
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            if (this.mPosition == Position.LEFT && this.getWidth() > rect.left) {
                layoutParams.width = rect.left - 30;
                changed = true;
            } else if (this.mPosition == Position.RIGHT && rect.right + this.getWidth() > screenWidth) {
                layoutParams.width = screenWidth - rect.right - 30;
                changed = true;
            } else if (this.mPosition == Position.TOP || this.mPosition == Position.BOTTOM) {
                float widthRight = (float)(this.getWidth() - rect.width()) / 2.0f;
                if ((float)rect.right + widthRight > (float)screenWidth) {
                    float movinX = (float)rect.right + widthRight - (float)screenWidth + 30.0f;
                    rect.left = (int)((float)rect.left - movinX);
                    rect.right = (int)((float)rect.right - movinX);
                    changed = true;
                } else if ((float)rect.left - widthRight < 0.0f) {
                    float movinX = 0.0f - ((float)rect.left - widthRight) + 30.0f;
                    rect.left = (int)((float)rect.left + movinX);
                    rect.right = (int)((float)rect.right + movinX);
                    changed = true;
                }
            }
            this.setLayoutParams(layoutParams);
            this.postInvalidate();
            return changed;
        }

        private void onSetup(Rect myRect) {
            this.setupPosition(myRect);
            this.mBubblePath = this.drawBubble(new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight()), this.mCorner, this.mCorner, this.mCorner, this.mCorner);
            this.startEnterAnimation();
            this.handleAutoRemove();
        }

        public void setup(Rect viewRect, int screenWidth) {
            this.mViewRect = new Rect(viewRect);
            final Rect myRect = new Rect(viewRect);
            boolean changed = this.adjustSize(myRect, screenWidth);
            if (!changed) {
                this.onSetup(myRect);
            } else {
                this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        TooltipView.this.onSetup(myRect);
                        TooltipView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        return false;
                    }
                });
            }
        }

        public void close() {
            this.remove();
        }
    }

    public static class FadeTooltipAnimation
    implements TooltipAnimation {
        private long mFadeDuration = 400L;

        public FadeTooltipAnimation() {
        }

        public FadeTooltipAnimation(long fadeDuration) {
            this.mFadeDuration = fadeDuration;
        }

        @Override
        public void animateEnter(View view, Animator.AnimatorListener animatorListener) {
            view.setAlpha(0.0f);
            view.animate().alpha(1.0f).setDuration(this.mFadeDuration).setListener(animatorListener);
        }

        @Override
        public void animateExit(View view, Animator.AnimatorListener animatorListener) {
            view.animate().alpha(0.0f).setDuration(this.mFadeDuration).setListener(animatorListener);
        }
    }

    public static interface ListenerHide {
        public void onHide(View var1);
    }

    public static interface ListenerDisplay {
        public void onDisplay(View var1);
    }

    public static interface TooltipAnimation {
        public void animateEnter(View var1, Animator.AnimatorListener var2);

        public void animateExit(View var1, Animator.AnimatorListener var2);
    }

    public static enum ALIGN {
        START,
        CENTER;

    }

    public static enum Position {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

