/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.popupwindow;

import android.content.Context;
import android.view.View;
import android.widget.ListView;
import android.widget.PopupWindow;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.Utils;

public class PopWindow
extends PopupWindow {
    private int mPopupWidth;
    private int mPopupHeight;

    public PopWindow(View contentView) {
        this(contentView, -2, -2);
    }

    public PopWindow(Context context, int layoutId) {
        this(context, layoutId, -2, -2);
    }

    public PopWindow(View contentView, int width, int height) {
        super(contentView, width, height, false);
        this.init(contentView.getContext());
    }

    public PopWindow(Context context, int layoutId, int width, int height) {
        this.initContentView(context, layoutId, width, height);
        this.init(context);
    }

    private void initContentView(Context context, int layoutId, int width, int height) {
        View contentView = View.inflate((Context)context, (int)layoutId, null);
        this.setContentView(contentView);
        this.setWidth(width);
        this.setHeight(height);
    }

    private void init(Context context) {
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setBackgroundDrawable(context.getResources().getDrawable(R.drawable.xui_bg_center_popwindow));
        this.measurePopWindowSize();
    }

    public void measurePopWindowSize() {
        this.getContentView().measure(0, 0);
        this.mPopupHeight = this.getContentView().getMeasuredHeight();
        this.mPopupWidth = this.getContentView().getMeasuredWidth();
    }

    public void onClick(View v) {
        if (this.isShowing()) {
            this.dismiss();
        } else {
            this.showAsDropDown(v);
        }
    }

    public void onClickUp2(View v) {
        if (this.isShowing()) {
            this.dismiss();
        } else {
            this.showUp2(v);
        }
    }

    public void onClickUp(View v) {
        if (this.isShowing()) {
            this.dismiss();
        } else {
            this.showUp(v);
        }
    }

    public void onClick(View v, int xoff, int yoff) {
        if (this.isShowing()) {
            this.dismiss();
        } else {
            this.showAsDropDown(v, xoff, yoff);
        }
    }

    public View findViewById(int resId) {
        return this.getContentView().findViewById(resId);
    }

    protected <T extends View> T findView(int resId) {
        return (T)this.getContentView().findViewById(resId);
    }

    public Context getContext() {
        return this.getContentView().getContext();
    }

    public static void dismissPopWindow(PopWindow popWindow) {
        if (popWindow != null) {
            popWindow.dismiss();
        }
    }

    public void updatePopWindowHeight(ListView listView) {
        this.mPopupHeight = Utils.getListViewHeightBasedOnChildren(listView);
    }

    public void showUp(View v) {
        int[] location = new int[2];
        v.getLocationOnScreen(location);
        this.showAtLocation(v, 0, location[0] + v.getWidth() / 2 - this.mPopupWidth / 2, location[1] - v.getHeight() / 2 - this.mPopupHeight);
    }

    public void showUp2(View v) {
        int[] location = new int[2];
        v.getLocationOnScreen(location);
        this.showAtLocation(v, 0, location[0] - this.mPopupWidth / 2, location[1] - this.mPopupHeight);
    }
}

