/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.picker.widget.builder;

import android.content.Context;
import android.view.ViewGroup;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.picker.wheelview.WheelView;
import com.xuexiang.xui.widget.picker.widget.TimePickerView;
import com.xuexiang.xui.widget.picker.widget.configure.PickerOptions;
import com.xuexiang.xui.widget.picker.widget.configure.TimePickerType;
import com.xuexiang.xui.widget.picker.widget.listener.CustomListener;
import com.xuexiang.xui.widget.picker.widget.listener.OnTimeSelectChangeListener;
import com.xuexiang.xui.widget.picker.widget.listener.OnTimeSelectListener;
import java.util.Calendar;

public class TimePickerBuilder {
    private PickerOptions mPickerOptions = new PickerOptions(2);

    public TimePickerBuilder(Context context, OnTimeSelectListener listener) {
        this.mPickerOptions.context = context;
        this.mPickerOptions.timeSelectListener = listener;
        this.mPickerOptions.textColorConfirm = ThemeUtils.getMainThemeColor(context);
        this.mPickerOptions.textColorCancel = ThemeUtils.getMainThemeColor(context);
    }

    public TimePickerBuilder setGravity(int gravity) {
        this.mPickerOptions.textGravity = gravity;
        return this;
    }

    public TimePickerBuilder setType(boolean ... types) {
        if (types.length != 6) {
            throw new IllegalArgumentException("\u63a7\u5236\u201c\u5e74\u201d\u201c\u6708\u201d\u201c\u65e5\u201d\u201c\u65f6\u201d\u201c\u5206\u201d\u201c\u79d2\u201d\u7684\u663e\u793a\u6216\u9690\u85cf, \u957f\u5ea6\u5fc5\u987b\u4e3a6\uff01");
        }
        this.mPickerOptions.type = types;
        return this;
    }

    public TimePickerBuilder setType(TimePickerType type) {
        this.mPickerOptions.type = type.getType();
        return this;
    }

    public TimePickerBuilder setSubmitText(String textContentConfirm) {
        this.mPickerOptions.textContentConfirm = textContentConfirm;
        return this;
    }

    public TimePickerBuilder isDialog(boolean isDialog) {
        this.mPickerOptions.isDialog = isDialog;
        return this;
    }

    public TimePickerBuilder setCancelText(String textContentCancel) {
        this.mPickerOptions.textContentCancel = textContentCancel;
        return this;
    }

    public TimePickerBuilder setTitleText(String textContentTitle) {
        this.mPickerOptions.textContentTitle = textContentTitle;
        return this;
    }

    public TimePickerBuilder setSubmitColor(int textColorConfirm) {
        this.mPickerOptions.textColorConfirm = textColorConfirm;
        return this;
    }

    public TimePickerBuilder setCancelColor(int textColorCancel) {
        this.mPickerOptions.textColorCancel = textColorCancel;
        return this;
    }

    public TimePickerBuilder setDecorView(ViewGroup decorView) {
        this.mPickerOptions.decorView = decorView;
        return this;
    }

    public TimePickerBuilder setBgColor(int bgColorWheel) {
        this.mPickerOptions.bgColorWheel = bgColorWheel;
        return this;
    }

    public TimePickerBuilder setTitleBgColor(int bgColorTitle) {
        this.mPickerOptions.bgColorTitle = bgColorTitle;
        return this;
    }

    public TimePickerBuilder setTitleColor(int textColorTitle) {
        this.mPickerOptions.textColorTitle = textColorTitle;
        return this;
    }

    public TimePickerBuilder setSubCalSize(int textSizeSubmitCancel) {
        this.mPickerOptions.textSizeSubmitCancel = textSizeSubmitCancel;
        return this;
    }

    public TimePickerBuilder setTitleSize(int textSizeTitle) {
        this.mPickerOptions.textSizeTitle = textSizeTitle;
        return this;
    }

    public TimePickerBuilder setContentTextSize(int textSizeContent) {
        this.mPickerOptions.textSizeContent = textSizeContent;
        return this;
    }

    public TimePickerBuilder setDate(Calendar date) {
        this.mPickerOptions.date = date;
        return this;
    }

    public TimePickerBuilder setLayoutRes(int res, CustomListener customListener) {
        this.mPickerOptions.layoutRes = res;
        this.mPickerOptions.customListener = customListener;
        return this;
    }

    public TimePickerBuilder setRangDate(Calendar startDate, Calendar endDate) {
        this.mPickerOptions.startDate = startDate;
        this.mPickerOptions.endDate = endDate;
        return this;
    }

    public TimePickerBuilder setLineSpacingMultiplier(float lineSpacingMultiplier) {
        this.mPickerOptions.lineSpacingMultiplier = lineSpacingMultiplier;
        return this;
    }

    public TimePickerBuilder setDividerColor(int dividerColor) {
        this.mPickerOptions.dividerColor = dividerColor;
        return this;
    }

    public TimePickerBuilder setDividerType(WheelView.DividerType dividerType) {
        this.mPickerOptions.dividerType = dividerType;
        return this;
    }

    public TimePickerBuilder setBackgroundId(int backgroundId) {
        this.mPickerOptions.backgroundId = backgroundId;
        return this;
    }

    public TimePickerBuilder setTextColorCenter(int textColorCenter) {
        this.mPickerOptions.textColorCenter = textColorCenter;
        return this;
    }

    public TimePickerBuilder setTextColorOut(int textColorOut) {
        this.mPickerOptions.textColorOut = textColorOut;
        return this;
    }

    public TimePickerBuilder isCyclic(boolean cyclic) {
        this.mPickerOptions.cyclic = cyclic;
        return this;
    }

    public TimePickerBuilder setOutSideCancelable(boolean cancelable) {
        this.mPickerOptions.cancelable = cancelable;
        return this;
    }

    public TimePickerBuilder setLunarCalendar(boolean lunarCalendar) {
        this.mPickerOptions.isLunarCalendar = lunarCalendar;
        return this;
    }

    public TimePickerBuilder setLabel(String labelYear, String labelMonth, String labelDay, String labelHours, String labelMins, String labelSeconds) {
        this.mPickerOptions.labelYear = labelYear;
        this.mPickerOptions.labelMonth = labelMonth;
        this.mPickerOptions.labelDay = labelDay;
        this.mPickerOptions.labelHours = labelHours;
        this.mPickerOptions.labelMinutes = labelMins;
        this.mPickerOptions.labelSeconds = labelSeconds;
        return this;
    }

    public TimePickerBuilder setTextXOffset(int xOffsetYear, int xOffsetMonth, int xOffsetDay, int xOffsetHours, int xOffsetMinutes, int xOffsetSeconds) {
        this.mPickerOptions.xOffsetYear = xOffsetYear;
        this.mPickerOptions.xOffsetMonth = xOffsetMonth;
        this.mPickerOptions.xOffsetDay = xOffsetDay;
        this.mPickerOptions.xOffsetHours = xOffsetHours;
        this.mPickerOptions.xOffsetMinutes = xOffsetMinutes;
        this.mPickerOptions.xOffsetSeconds = xOffsetSeconds;
        return this;
    }

    public TimePickerBuilder isCenterLabel(boolean isCenterLabel) {
        this.mPickerOptions.isCenterLabel = isCenterLabel;
        return this;
    }

    public TimePickerBuilder setTimeSelectChangeListener(OnTimeSelectChangeListener listener) {
        this.mPickerOptions.timeSelectChangeListener = listener;
        return this;
    }

    public TimePickerView build() {
        return new TimePickerView(this.mPickerOptions);
    }
}

