/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.picker.wheelview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Handler;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.xuexiang.xui.R;
import com.xuexiang.xui.logs.UILog;
import com.xuexiang.xui.widget.picker.wheelview.adapter.WheelAdapter;
import com.xuexiang.xui.widget.picker.wheelview.interfaces.IPickerViewItem;
import com.xuexiang.xui.widget.picker.wheelview.listener.LoopViewGestureListener;
import com.xuexiang.xui.widget.picker.wheelview.listener.OnItemSelectedListener;
import com.xuexiang.xui.widget.picker.wheelview.timer.InertiaTimerTask;
import com.xuexiang.xui.widget.picker.wheelview.timer.MessageHandler;
import com.xuexiang.xui.widget.picker.wheelview.timer.SmoothScrollTimerTask;
import io.github.inflationx.calligraphy3.HasTypeface;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class WheelView
extends View
implements HasTypeface {
    private DividerType dividerType;
    private Context context;
    private Handler handler;
    private GestureDetector gestureDetector;
    private OnItemSelectedListener onItemSelectedListener;
    private boolean isOptions = false;
    private boolean isCenterLabel = true;
    private ScheduledExecutorService mExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> mFuture;
    private TextPaint paintOuterText;
    private TextPaint paintCenterText;
    private Paint paintIndicator;
    private WheelAdapter adapter;
    private String label;
    private int textSize;
    private int maxTextWidth;
    private int maxTextHeight;
    private int textXOffset;
    private float itemHeight;
    private Typeface typeface = Typeface.MONOSPACE;
    private int textColorOut;
    private int textColorCenter;
    private int dividerColor;
    private float lineSpacingMultiplier = 1.6f;
    private boolean isLoop;
    private float firstLineY;
    private float secondLineY;
    private float centerY;
    private float totalScrollY;
    private int initPosition;
    private int selectedItem;
    private int preCurrentIndex;
    private int itemsVisible = 11;
    private int measuredHeight;
    private int measuredWidth;
    private int radius;
    private int mOffset = 0;
    private float previousY = 0.0f;
    private long startTime = 0L;
    private static final int VELOCITY_FLING = 5;
    private int widthMeasureSpec;
    private int mGravity = 17;
    private int drawCenterContentStart = 0;
    private int drawOutContentStart = 0;
    private static final float SCALE_CONTENT = 0.8f;
    private float CENTER_CONTENT_OFFSET;
    private static final float DEFAULT_TEXT_TARGET_SKEWX = 0.5f;

    public WheelView(Context context) {
        this(context, null);
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.textSize = this.getResources().getDimensionPixelSize(R.dimen.default_wheel_view_text_size);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        float density = dm.density;
        if (density < 1.0f) {
            this.CENTER_CONTENT_OFFSET = 2.4f;
        } else if (1.0f <= density && density < 1.5f) {
            this.CENTER_CONTENT_OFFSET = 3.6f;
        } else if (1.5f <= density && density < 2.0f) {
            this.CENTER_CONTENT_OFFSET = 4.5f;
        } else if (2.0f <= density && density < 3.0f) {
            this.CENTER_CONTENT_OFFSET = 6.0f;
        } else if (density >= 3.0f) {
            this.CENTER_CONTENT_OFFSET = density * 2.5f;
        }
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WheelView, 0, 0);
            this.mGravity = a.getInt(R.styleable.WheelView_wv_gravity, 17);
            this.textColorOut = a.getColor(R.styleable.WheelView_wv_textColorOut, -5723992);
            this.textColorCenter = a.getColor(R.styleable.WheelView_wv_textColorCenter, -14013910);
            this.dividerColor = a.getColor(R.styleable.WheelView_wv_dividerColor, -2763307);
            this.textSize = a.getDimensionPixelSize(R.styleable.WheelView_wv_textSize, this.textSize);
            this.lineSpacingMultiplier = a.getFloat(R.styleable.WheelView_wv_lineSpacingMultiplier, this.lineSpacingMultiplier);
            a.recycle();
        }
        this.judgeLineSpace();
        this.initLoopView(context);
    }

    private void judgeLineSpace() {
        if (this.lineSpacingMultiplier < 1.0f) {
            this.lineSpacingMultiplier = 1.0f;
        } else if (this.lineSpacingMultiplier > 4.0f) {
            this.lineSpacingMultiplier = 4.0f;
        }
    }

    private void initLoopView(Context context) {
        this.context = context;
        this.handler = new MessageHandler(this);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new LoopViewGestureListener(this));
        this.gestureDetector.setIsLongpressEnabled(false);
        this.isLoop = true;
        this.totalScrollY = 0.0f;
        this.initPosition = -1;
        this.initPaints();
    }

    private void initPaints() {
        this.paintOuterText = new TextPaint();
        this.paintOuterText.setColor(this.textColorOut);
        this.paintOuterText.setAntiAlias(true);
        this.paintOuterText.setTypeface(this.typeface);
        this.paintOuterText.setTextSize((float)this.textSize);
        this.paintCenterText = new TextPaint();
        this.paintCenterText.setColor(this.textColorCenter);
        this.paintCenterText.setAntiAlias(true);
        this.paintCenterText.setTextScaleX(1.1f);
        this.paintCenterText.setTypeface(this.typeface);
        this.paintCenterText.setTextSize((float)this.textSize);
        this.paintIndicator = new Paint();
        this.paintIndicator.setColor(this.dividerColor);
        this.paintIndicator.setAntiAlias(true);
        this.setLayerType(1, null);
    }

    private void remeasure() {
        if (this.adapter == null) {
            return;
        }
        this.measureTextWidthHeight();
        int halfCircumference = (int)(this.itemHeight * (float)(this.itemsVisible - 1));
        this.measuredHeight = (int)((double)(halfCircumference * 2) / Math.PI);
        this.radius = (int)((double)halfCircumference / Math.PI);
        this.measuredWidth = View.MeasureSpec.getSize((int)this.widthMeasureSpec);
        this.firstLineY = ((float)this.measuredHeight - this.itemHeight) / 2.0f;
        this.secondLineY = ((float)this.measuredHeight + this.itemHeight) / 2.0f;
        this.centerY = this.secondLineY - (this.itemHeight - (float)this.maxTextHeight) / 2.0f - this.CENTER_CONTENT_OFFSET;
        if (this.initPosition == -1) {
            this.initPosition = this.isLoop ? (this.adapter.getItemsCount() + 1) / 2 : 0;
        }
        this.preCurrentIndex = this.initPosition;
    }

    private void measureTextWidthHeight() {
        Rect rect = new Rect();
        for (int i = 0; i < this.adapter.getItemsCount(); ++i) {
            String s1 = this.getContentText(this.adapter.getItem(i));
            this.paintCenterText.getTextBounds(s1, 0, s1.length(), rect);
            int textWidth = rect.width();
            if (textWidth > this.maxTextWidth) {
                this.maxTextWidth = textWidth;
            }
            this.paintCenterText.getTextBounds("\u661f\u671f", 0, 2, rect);
            this.maxTextHeight = rect.height() + 2;
        }
        this.itemHeight = this.lineSpacingMultiplier * (float)this.maxTextHeight;
    }

    public void smoothScroll(ACTION action) {
        this.cancelFuture();
        if (action == ACTION.FLING || action == ACTION.DAGGLE) {
            this.mOffset = (int)((this.totalScrollY % this.itemHeight + this.itemHeight) % this.itemHeight);
            this.mOffset = (float)this.mOffset > this.itemHeight / 2.0f ? (int)(this.itemHeight - (float)this.mOffset) : -this.mOffset;
        }
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new SmoothScrollTimerTask(this, this.mOffset), 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public final void scrollBy(float velocityY) {
        this.cancelFuture();
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new InertiaTimerTask(this, velocityY), 0L, 5L, TimeUnit.MILLISECONDS);
    }

    public void cancelFuture() {
        if (this.mFuture != null && !this.mFuture.isCancelled()) {
            this.mFuture.cancel(true);
            this.mFuture = null;
        }
    }

    public final void setCyclic(boolean cyclic) {
        this.isLoop = cyclic;
    }

    public final void setTypeface(Typeface font) {
        this.typeface = font;
        this.paintOuterText.setTypeface(this.typeface);
        this.paintCenterText.setTypeface(this.typeface);
    }

    public final void setTextSize(float size) {
        if (size > 0.0f) {
            this.textSize = (int)(this.context.getResources().getDisplayMetrics().density * size);
            this.paintOuterText.setTextSize((float)this.textSize);
            this.paintCenterText.setTextSize((float)this.textSize);
        }
    }

    public final void setCurrentItem(int currentItem) {
        this.selectedItem = currentItem;
        this.initPosition = currentItem;
        this.totalScrollY = 0.0f;
        this.invalidate();
    }

    public final void setOnItemSelectedListener(OnItemSelectedListener OnItemSelectedListener2) {
        this.onItemSelectedListener = OnItemSelectedListener2;
    }

    public final void setAdapter(WheelAdapter adapter) {
        this.adapter = adapter;
        boolean isNeedRelayout = this.measuredHeight <= 0;
        this.remeasure();
        if (isNeedRelayout) {
            this.requestLayout();
        } else {
            this.invalidate();
        }
    }

    public final WheelAdapter getAdapter() {
        return this.adapter;
    }

    public final int getCurrentItem() {
        if (this.adapter == null) {
            return 0;
        }
        if (this.isLoop && (this.selectedItem < 0 || this.selectedItem >= this.adapter.getItemsCount())) {
            return Math.max(0, Math.min(Math.abs(Math.abs(this.selectedItem) - this.adapter.getItemsCount()), this.adapter.getItemsCount() - 1));
        }
        return Math.max(0, Math.min(this.selectedItem, this.adapter.getItemsCount() - 1));
    }

    public final void onItemSelected() {
        if (this.onItemSelectedListener != null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    WheelView.this.onItemSelectedListener.onItemSelected(WheelView.this.getCurrentItem());
                }
            }, 200L);
        }
    }

    protected void onDraw(Canvas canvas) {
        int counter;
        if (this.adapter == null) {
            return;
        }
        this.initPosition = Math.min(Math.max(0, this.initPosition), this.adapter.getItemsCount() - 1);
        Object[] visibles = new Object[this.itemsVisible];
        int change = (int)(this.totalScrollY / this.itemHeight);
        try {
            this.preCurrentIndex = this.initPosition + change % this.adapter.getItemsCount();
        }
        catch (ArithmeticException e) {
            UILog.eTag("WheelView", "\u51fa\u9519\u4e86\uff01adapter.getItemsCount() == 0\uff0c\u8054\u52a8\u6570\u636e\u4e0d\u5339\u914d");
        }
        if (!this.isLoop) {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = 0;
            }
            if (this.preCurrentIndex > this.adapter.getItemsCount() - 1) {
                this.preCurrentIndex = this.adapter.getItemsCount() - 1;
            }
        } else {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = this.adapter.getItemsCount() + this.preCurrentIndex;
            }
            if (this.preCurrentIndex > this.adapter.getItemsCount() - 1) {
                this.preCurrentIndex -= this.adapter.getItemsCount();
            }
        }
        float itemHeightOffset = this.totalScrollY % this.itemHeight;
        for (counter = 0; counter < this.itemsVisible; ++counter) {
            int index = this.preCurrentIndex - (this.itemsVisible / 2 - counter);
            if (this.isLoop) {
                index = this.getLoopMappingIndex(index);
                visibles[counter] = this.adapter.getItem(index);
                continue;
            }
            visibles[counter] = index < 0 ? "" : (index > this.adapter.getItemsCount() - 1 ? "" : this.adapter.getItem(index));
        }
        if (this.dividerType == DividerType.WRAP) {
            float startX = TextUtils.isEmpty((CharSequence)this.label) ? (float)(this.measuredWidth - this.maxTextWidth) / 2.0f - 12.0f : (float)(this.measuredWidth - this.maxTextWidth) / 4.0f - 12.0f;
            if (startX <= 0.0f) {
                startX = 10.0f;
            }
            float endX = (float)this.measuredWidth - startX;
            canvas.drawLine(startX, this.firstLineY, endX, this.firstLineY, this.paintIndicator);
            canvas.drawLine(startX, this.secondLineY, endX, this.secondLineY, this.paintIndicator);
        } else {
            canvas.drawLine(0.0f, this.firstLineY, (float)this.measuredWidth, this.firstLineY, this.paintIndicator);
            canvas.drawLine(0.0f, this.secondLineY, (float)this.measuredWidth, this.secondLineY, this.paintIndicator);
        }
        if (!TextUtils.isEmpty((CharSequence)this.label) && this.isCenterLabel) {
            int drawRightContentStart = this.measuredWidth - this.getTextWidth((Paint)this.paintCenterText, this.label);
            canvas.drawText(this.label, (float)drawRightContentStart - this.CENTER_CONTENT_OFFSET, this.centerY, (Paint)this.paintCenterText);
        }
        for (counter = 0; counter < this.itemsVisible; ++counter) {
            canvas.save();
            double radian = (this.itemHeight * (float)counter - itemHeightOffset) / (float)this.radius;
            float angle = (float)(90.0 - radian / Math.PI * 180.0);
            if (angle >= 90.0f || angle <= -90.0f) {
                canvas.restore();
                continue;
            }
            float offsetCoefficient = (float)Math.pow(Math.abs(angle) / 90.0f, 2.2);
            String contentText = !this.isCenterLabel && !TextUtils.isEmpty((CharSequence)this.label) && !TextUtils.isEmpty((CharSequence)this.getContentText(visibles[counter])) ? this.getContentText(visibles[counter]) + this.label : this.getContentText(visibles[counter]);
            this.reMeasureTextSize(contentText);
            this.measuredCenterContentStart(contentText);
            this.measuredOutContentStart(contentText);
            float translateY = (float)((double)this.radius - Math.cos(radian) * (double)this.radius - Math.sin(radian) * (double)this.maxTextHeight / 2.0);
            canvas.translate(0.0f, translateY);
            if (translateY <= this.firstLineY && (float)this.maxTextHeight + translateY >= this.firstLineY) {
                canvas.save();
                canvas.clipRect(0.0f, 0.0f, (float)this.measuredWidth, this.firstLineY - translateY);
                canvas.scale(1.0f, (float)Math.sin(radian) * 0.8f);
                canvas.drawText(contentText, (float)this.drawOutContentStart, (float)this.maxTextHeight, (Paint)this.paintOuterText);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0.0f, this.firstLineY - translateY, (float)this.measuredWidth, (float)((int)this.itemHeight));
                canvas.scale(1.0f, (float)Math.sin(radian) * 1.0f);
                canvas.drawText(contentText, (float)this.drawCenterContentStart, (float)this.maxTextHeight - this.CENTER_CONTENT_OFFSET, (Paint)this.paintCenterText);
                canvas.restore();
            } else if (translateY <= this.secondLineY && (float)this.maxTextHeight + translateY >= this.secondLineY) {
                canvas.save();
                canvas.clipRect(0.0f, 0.0f, (float)this.measuredWidth, this.secondLineY - translateY);
                canvas.scale(1.0f, (float)Math.sin(radian) * 1.0f);
                canvas.drawText(contentText, (float)this.drawCenterContentStart, (float)this.maxTextHeight - this.CENTER_CONTENT_OFFSET, (Paint)this.paintCenterText);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0.0f, this.secondLineY - translateY, (float)this.measuredWidth, (float)((int)this.itemHeight));
                canvas.scale(1.0f, (float)Math.sin(radian) * 0.8f);
                canvas.drawText(contentText, (float)this.drawOutContentStart, (float)this.maxTextHeight, (Paint)this.paintOuterText);
                canvas.restore();
            } else if (translateY >= this.firstLineY && (float)this.maxTextHeight + translateY <= this.secondLineY) {
                float Y = (float)this.maxTextHeight - this.CENTER_CONTENT_OFFSET;
                canvas.drawText(contentText, (float)this.drawCenterContentStart, Y, (Paint)this.paintCenterText);
                this.selectedItem = this.preCurrentIndex - (this.itemsVisible / 2 - counter);
            } else {
                canvas.save();
                canvas.clipRect(0, 0, this.measuredWidth, (int)this.itemHeight);
                canvas.scale(1.0f, (float)Math.sin(radian) * 0.8f);
                this.paintOuterText.setTextSkewX((float)((this.textXOffset == 0 ? 0 : (this.textXOffset > 0 ? 1 : -1)) * (angle > 0.0f ? -1 : 1)) * 0.5f * offsetCoefficient);
                this.paintOuterText.setAlpha((int)((1.0f - offsetCoefficient) * 255.0f));
                canvas.drawText(contentText, (float)this.drawOutContentStart + (float)this.textXOffset * offsetCoefficient, (float)this.maxTextHeight, (Paint)this.paintOuterText);
                canvas.restore();
            }
            canvas.restore();
            this.paintCenterText.setTextSize((float)this.textSize);
        }
    }

    private void reMeasureTextSize(String contentText) {
        Rect rect = new Rect();
        this.paintCenterText.getTextBounds(contentText, 0, contentText.length(), rect);
        int width = rect.width();
        int size = this.textSize;
        while (width > this.measuredWidth) {
            this.paintCenterText.setTextSize((float)(--size));
            this.paintCenterText.getTextBounds(contentText, 0, contentText.length(), rect);
            width = rect.width();
        }
        this.paintOuterText.setTextSize((float)size);
    }

    private int getLoopMappingIndex(int index) {
        if (index < 0) {
            index += this.adapter.getItemsCount();
            index = this.getLoopMappingIndex(index);
        } else if (index > this.adapter.getItemsCount() - 1) {
            index -= this.adapter.getItemsCount();
            index = this.getLoopMappingIndex(index);
        }
        return index;
    }

    private String getContentText(Object item) {
        if (item == null) {
            return "";
        }
        if (item instanceof IPickerViewItem) {
            return ((IPickerViewItem)item).getPickerViewText();
        }
        if (item instanceof Integer) {
            return String.format(Locale.getDefault(), "%02d", item);
        }
        return item.toString();
    }

    private void measuredCenterContentStart(String content) {
        Rect rect = new Rect();
        this.paintCenterText.getTextBounds(content, 0, content.length(), rect);
        switch (this.mGravity) {
            case 17: {
                if (this.isOptions || this.label == null || "".equals(this.label) || !this.isCenterLabel) {
                    this.drawCenterContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.5);
                    break;
                }
                this.drawCenterContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.25);
                break;
            }
            case 3: {
                this.drawCenterContentStart = 0;
                break;
            }
            case 5: {
                this.drawCenterContentStart = this.measuredWidth - rect.width() - (int)this.CENTER_CONTENT_OFFSET;
                break;
            }
        }
    }

    private void measuredOutContentStart(String content) {
        Rect rect = new Rect();
        this.paintOuterText.getTextBounds(content, 0, content.length(), rect);
        switch (this.mGravity) {
            case 17: {
                if (this.isOptions || this.label == null || "".equals(this.label) || !this.isCenterLabel) {
                    this.drawOutContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.5);
                    break;
                }
                this.drawOutContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.25);
                break;
            }
            case 3: {
                this.drawOutContentStart = 0;
                break;
            }
            case 5: {
                this.drawOutContentStart = this.measuredWidth - rect.width() - (int)this.CENTER_CONTENT_OFFSET;
                break;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.widthMeasureSpec = widthMeasureSpec;
        this.remeasure();
        this.setMeasuredDimension(this.measuredWidth, this.measuredHeight);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean eventConsumed = this.gestureDetector.onTouchEvent(event);
        boolean isIgnore = false;
        float top = (float)(-this.initPosition) * this.itemHeight;
        float bottom = (float)(this.adapter.getItemsCount() - 1 - this.initPosition) * this.itemHeight;
        float ratio = 0.25f;
        switch (event.getAction()) {
            case 0: {
                this.startTime = System.currentTimeMillis();
                this.cancelFuture();
                this.previousY = event.getRawY();
                break;
            }
            case 2: {
                float dy = this.previousY - event.getRawY();
                this.previousY = event.getRawY();
                this.totalScrollY += dy;
                if (this.isLoop) break;
                if (this.totalScrollY - this.itemHeight * ratio < top && dy < 0.0f || this.totalScrollY + this.itemHeight * ratio > bottom && dy > 0.0f) {
                    this.totalScrollY -= dy;
                    isIgnore = true;
                    break;
                }
                isIgnore = false;
                break;
            }
            default: {
                if (eventConsumed) break;
                float y = event.getY();
                double L = Math.acos(((float)this.radius - y) / (float)this.radius) * (double)this.radius;
                int circlePosition = (int)((L + (double)(this.itemHeight / 2.0f)) / (double)this.itemHeight);
                float extraOffset = (this.totalScrollY % this.itemHeight + this.itemHeight) % this.itemHeight;
                this.mOffset = (int)((float)(circlePosition - this.itemsVisible / 2) * this.itemHeight - extraOffset);
                if (System.currentTimeMillis() - this.startTime > 120L) {
                    this.smoothScroll(ACTION.DAGGLE);
                    break;
                }
                this.smoothScroll(ACTION.CLICK);
            }
        }
        if (!isIgnore && event.getAction() != 0) {
            this.invalidate();
        }
        return true;
    }

    public int getItemsCount() {
        return this.adapter != null ? this.adapter.getItemsCount() : 0;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void isCenterLabel(boolean isCenterLabel) {
        this.isCenterLabel = isCenterLabel;
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    public int getTextWidth(Paint paint, String str) {
        int iRet = 0;
        if (str != null && str.length() > 0) {
            int len = str.length();
            float[] widths = new float[len];
            paint.getTextWidths(str, widths);
            for (int j = 0; j < len; ++j) {
                iRet += (int)Math.ceil(widths[j]);
            }
        }
        return iRet;
    }

    public void setIsOptions(boolean options) {
        this.isOptions = options;
    }

    public void setTextColorOut(int textColorOut) {
        this.textColorOut = textColorOut;
        this.paintOuterText.setColor(this.textColorOut);
    }

    public void setTextColorCenter(int textColorCenter) {
        this.textColorCenter = textColorCenter;
        this.paintCenterText.setColor(this.textColorCenter);
    }

    public void setTextXOffset(int textXOffset) {
        this.textXOffset = textXOffset;
        if (textXOffset != 0) {
            this.paintCenterText.setTextScaleX(1.0f);
        }
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        this.paintIndicator.setColor(dividerColor);
    }

    public void setDividerType(DividerType dividerType) {
        this.dividerType = dividerType;
    }

    public void setLineSpacingMultiplier(float lineSpacingMultiplier) {
        if (lineSpacingMultiplier != 0.0f) {
            this.lineSpacingMultiplier = lineSpacingMultiplier;
            this.judgeLineSpace();
        }
    }

    public boolean isLoop() {
        return this.isLoop;
    }

    public float getTotalScrollY() {
        return this.totalScrollY;
    }

    public void setTotalScrollY(float totalScrollY) {
        this.totalScrollY = totalScrollY;
    }

    public float getItemHeight() {
        return this.itemHeight;
    }

    public int getInitPosition() {
        return this.initPosition;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public static enum DividerType {
        FILL,
        WRAP;

    }

    public static enum ACTION {
        CLICK,
        FLING,
        DAGGLE;

    }
}

