/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.picker;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import java.util.HashSet;
import java.util.Set;

public class XSeekBar
extends View {
    private static int DEFAULT_TOUCH_TARGET_SIZE;
    private static int DEFAULT_TEXT_MIN_SPACE;
    private static final int DEFAULT_MAX = 100;
    private static final float DEFAULT_BIG_SCALE_WITH = 1.7f;
    private static final float DEFAULT_MIDDLE_SCALE_WITH = 1.2f;
    private static final float DEFAULT_SMALL_SCALE_WITH = 1.0f;
    private final Paint mPaint = new Paint(1);
    private int mLineStartX;
    private int mLineEndX;
    private int mLineLength;
    private int mMaxPosition = 0;
    private int mRange;
    private int mMiddleY = 0;
    private Rect mMaxTextRect = new Rect();
    private Rect mRulerTextRect = new Rect();
    private Set<Integer> mTouchingMinTarget = new HashSet<Integer>();
    private Set<Integer> mTouchingMaxTarget = new HashSet<Integer>();
    private boolean mIsTouching = false;
    private boolean mLastTouchedMin;
    private int mSelectedNumber = -1;
    private boolean mIsFirstInit = true;
    private float mConvertFactor;
    private OnSeekBarListener mOnSeekBarListener;
    private int mVerticalPadding;
    private int mInsideRangeColor;
    private int mOutsideRangeColor;
    private float mInsideRangeLineStrokeWidth;
    private float mOutsideRangeLineStrokeWidth;
    private int mMax = 100;
    private int mMin = 0;
    private Bitmap mSliderIcon;
    private Bitmap mSliderIconFocus;
    private boolean mIsLineRound;
    private boolean mIsShowBubble;
    private Bitmap mBubbleBitmap;
    private boolean mIsShowNumber;
    private int mNumberTextColor;
    private float mNumberTextSize;
    private float mNumberMarginBottom;
    private boolean mIsShowRuler;
    private int mRulerColor;
    private int mRulerTextColor;
    private float mRulerTextSize;
    private float mRulerMarginTop;
    private float mRulerDividerHeight;
    private float mRulerTextMarginTop;
    private int mRulerInterval;

    public XSeekBar(Context context) {
        this(context, null);
    }

    public XSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.XSeekBarStyle);
    }

    public XSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
    }

    public void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        DEFAULT_TOUCH_TARGET_SIZE = DensityUtils.dp2px(context, 20.0f);
        DEFAULT_TEXT_MIN_SPACE = DensityUtils.dp2px(context, 2.0f);
        int colorAccent = ThemeUtils.resolveColor(context, R.attr.colorAccent);
        int colorControlNormal = ThemeUtils.resolveColor(context, R.attr.colorControlNormal);
        if (attrs != null) {
            TypedArray array2 = context.obtainStyledAttributes(attrs, R.styleable.XSeekBar, defStyleAttr, 0);
            this.mVerticalPadding = array2.getDimensionPixelSize(R.styleable.XSeekBar_xsb_verticalPadding, DensityUtils.dp2px(context, 10.0f));
            this.mInsideRangeColor = array2.getColor(R.styleable.XSeekBar_xsb_insideRangeLineColor, colorAccent);
            this.mOutsideRangeColor = array2.getColor(R.styleable.XSeekBar_xsb_outsideRangeLineColor, ResUtils.getColor(context, R.color.default_xrs_outside_line_color));
            this.mInsideRangeLineStrokeWidth = array2.getDimensionPixelSize(R.styleable.XSeekBar_xsb_insideRangeLineStrokeWidth, DensityUtils.dp2px(context, 5.0f));
            this.mOutsideRangeLineStrokeWidth = array2.getDimensionPixelSize(R.styleable.XSeekBar_xsb_outsideRangeLineStrokeWidth, DensityUtils.dp2px(context, 5.0f));
            this.mMin = array2.getInt(R.styleable.XSeekBar_xsb_min, this.mMin);
            this.mMax = array2.getInt(R.styleable.XSeekBar_xsb_max, this.mMax);
            this.mSliderIcon = BitmapFactory.decodeResource((Resources)this.getResources(), (int)array2.getResourceId(R.styleable.XSeekBar_xsb_sliderIcon, R.drawable.xui_ic_slider_icon));
            this.mSliderIconFocus = BitmapFactory.decodeResource((Resources)this.getResources(), (int)array2.getResourceId(R.styleable.XSeekBar_xsb_sliderIconFocus, R.drawable.xui_ic_slider_icon));
            this.mIsLineRound = array2.getBoolean(R.styleable.XSeekBar_xsb_isLineRound, true);
            this.mIsShowBubble = array2.getBoolean(R.styleable.XSeekBar_xsb_isShowBubble, false);
            boolean isFitColor = array2.getBoolean(R.styleable.XSeekBar_xsb_isFitColor, true);
            this.mIsShowNumber = array2.getBoolean(R.styleable.XSeekBar_xsb_isShowNumber, true);
            this.mNumberTextColor = array2.getColor(R.styleable.XSeekBar_xsb_numberTextColor, colorAccent);
            this.mNumberTextSize = array2.getDimensionPixelSize(R.styleable.XSeekBar_xsb_numberTextSize, DensityUtils.sp2px(context, 12.0f));
            this.mNumberMarginBottom = array2.getDimensionPixelSize(R.styleable.XSeekBar_xsb_numberMarginBottom, DensityUtils.dp2px(context, 2.0f));
            if (isFitColor) {
                Bitmap bitmap;
                if (this.mIsShowBubble) {
                    this.mNumberTextColor = -1;
                }
                if ((bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)array2.getResourceId(R.styleable.XSeekBar_xsb_bubbleResource, R.drawable.xui_bg_bubble_blue))) != null) {
                    this.mBubbleBitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
                    Canvas canvas = new Canvas(this.mBubbleBitmap);
                    canvas.drawColor(this.mInsideRangeColor, PorterDuff.Mode.SRC_IN);
                }
            } else {
                this.mBubbleBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)array2.getResourceId(R.styleable.XSeekBar_xsb_bubbleResource, R.drawable.xui_bg_bubble_blue));
            }
            this.mIsShowRuler = array2.getBoolean(R.styleable.XSeekBar_xsb_isShowRuler, false);
            this.mRulerColor = array2.getColor(R.styleable.XSeekBar_xsb_rulerColor, colorControlNormal);
            this.mRulerTextColor = array2.getColor(R.styleable.XSeekBar_xsb_rulerTextColor, colorControlNormal);
            this.mRulerTextSize = array2.getDimensionPixelSize(R.styleable.XSeekBar_xsb_rulerTextSize, DensityUtils.sp2px(context, 12.0f));
            this.mRulerMarginTop = array2.getDimensionPixelSize(R.styleable.XSeekBar_xsb_rulerMarginTop, DensityUtils.dp2px(context, 4.0f));
            this.mRulerDividerHeight = array2.getDimensionPixelSize(R.styleable.XSeekBar_xsb_rulerDividerHeight, DensityUtils.dp2px(context, 4.0f));
            this.mRulerTextMarginTop = array2.getDimensionPixelSize(R.styleable.XSeekBar_xsb_rulerTextMarginTop, DensityUtils.dp2px(context, 4.0f));
            this.mRulerInterval = array2.getInt(R.styleable.XSeekBar_xsb_rulerInterval, 20);
            array2.recycle();
        }
        this.mRange = this.mMax - this.mMin;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int desiredWidth = widthSize;
        this.getTextBounds(String.valueOf(this.mMax), this.mMaxTextRect);
        int desiredHeight = this.mIsShowNumber && this.mIsShowBubble ? (int)((float)this.mSliderIcon.getHeight() + this.mNumberMarginBottom) + this.mBubbleBitmap.getHeight() : (this.mIsShowNumber ? (int)((float)this.mSliderIcon.getHeight() + this.mNumberMarginBottom) : this.mSliderIcon.getHeight());
        int rulerHeight = (int)(this.mRulerMarginTop + this.mRulerDividerHeight * 3.0f + this.mRulerTextMarginTop + (float)this.mRulerTextRect.height());
        if (this.mIsShowRuler) {
            this.getRulerTextBounds(String.valueOf(this.mMin), this.mRulerTextRect);
            desiredHeight += rulerHeight;
        }
        int height = desiredHeight;
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else if (heightMode == Integer.MIN_VALUE) {
            height = desiredHeight;
        }
        int marginStartEnd = this.mIsShowBubble ? this.mBubbleBitmap.getWidth() : Math.max(this.mSliderIcon.getWidth(), this.mMaxTextRect.width());
        this.mLineLength = width - marginStartEnd;
        this.mMiddleY = this.mIsShowRuler ? height - rulerHeight - this.mSliderIcon.getHeight() / 2 : (height += this.mVerticalPadding) - this.mSliderIcon.getHeight() / 2;
        this.mLineStartX = marginStartEnd / 2;
        this.mLineEndX = this.mLineLength + marginStartEnd / 2;
        this.calculateConvertFactor();
        if (this.mIsFirstInit) {
            this.setSelectedValue(this.mSelectedNumber != -1 ? this.mSelectedNumber : this.mMax);
        }
        this.setMeasuredDimension(width, height += this.mVerticalPadding);
    }

    protected void onDraw(Canvas canvas) {
        this.drawEntireRangeLine(canvas);
        this.drawSelectedRangeLine(canvas);
        if (this.mIsShowNumber) {
            this.drawSelectedNumber(canvas);
        }
        this.drawRuler(canvas);
        this.drawSelectedTargets(canvas);
    }

    private void drawEntireRangeLine(Canvas canvas) {
        this.mPaint.setColor(this.mOutsideRangeColor);
        this.mPaint.setStrokeWidth(this.mOutsideRangeLineStrokeWidth);
        canvas.drawLine((float)this.mLineStartX, (float)this.mMiddleY, (float)this.mLineEndX, (float)this.mMiddleY, this.mPaint);
        if (this.mIsLineRound) {
            this.mPaint.setColor(this.mInsideRangeColor);
            canvas.drawCircle((float)this.mLineStartX, (float)this.mMiddleY, this.mOutsideRangeLineStrokeWidth / 2.0f, this.mPaint);
            this.mPaint.setColor(this.mOutsideRangeColor);
            canvas.drawCircle((float)this.mLineEndX, (float)this.mMiddleY, this.mOutsideRangeLineStrokeWidth / 2.0f, this.mPaint);
        }
    }

    private void drawSelectedRangeLine(Canvas canvas) {
        this.mPaint.setStrokeWidth(this.mInsideRangeLineStrokeWidth);
        this.mPaint.setColor(this.mInsideRangeColor);
        canvas.drawLine((float)this.mLineStartX, (float)this.mMiddleY, (float)this.mMaxPosition, (float)this.mMiddleY, this.mPaint);
    }

    private void drawSelectedNumber(Canvas canvas) {
        float yText;
        String max = String.valueOf(this.getSelectedNumber());
        this.getTextBounds(max, this.mMaxTextRect);
        if (this.mIsShowBubble) {
            float top = (float)this.mMiddleY - (float)this.mSliderIcon.getHeight() / 2.0f - (float)this.mBubbleBitmap.getHeight() - this.mNumberMarginBottom;
            yText = top + (float)this.mBubbleBitmap.getHeight() / 2.0f + (float)this.mMaxTextRect.height() / 2.0f - 6.0f;
            canvas.drawBitmap(this.mBubbleBitmap, (float)this.mMaxPosition - (float)this.mBubbleBitmap.getWidth() / 2.0f, top, this.mPaint);
        } else {
            yText = (float)this.mMiddleY - (float)this.mSliderIcon.getHeight() / 2.0f - this.mNumberMarginBottom;
        }
        float maxX = (float)this.mMaxPosition - (float)this.mMaxTextRect.width() / 2.0f;
        this.mPaint.setTextSize(this.mNumberTextSize);
        this.mPaint.setColor(this.mNumberTextColor);
        canvas.drawText(max, maxX, yText, this.mPaint);
    }

    private void drawRuler(Canvas canvas) {
        if (this.mIsShowRuler) {
            float startX = this.mLineStartX;
            float stopY = 0.0f;
            float startY = 0.0f;
            float divider = (float)this.mRulerInterval / 10.0f;
            float scaleLength = (float)this.mLineLength / ((float)(this.mMax - this.mMin) / divider) / divider;
            boolean isMinHasText = false;
            boolean isMaxHasText = false;
            for (int i = this.mMin; i <= this.mMax; ++i) {
                if (i % this.mRulerInterval == 0) {
                    startY = (float)this.mMiddleY + (float)this.mSliderIcon.getHeight() / 2.0f + this.mRulerMarginTop;
                    stopY = startY + this.mRulerDividerHeight * 3.0f;
                    this.mPaint.setColor(this.mRulerTextColor);
                    this.mPaint.setTextSize(this.mRulerTextSize);
                    this.getRulerTextBounds(String.valueOf(i), this.mRulerTextRect);
                    canvas.drawText(String.valueOf(i), startX - (float)this.mRulerTextRect.width() / 2.0f, stopY + (float)this.mRulerTextRect.height() + this.mRulerTextMarginTop, this.mPaint);
                    if (i == this.mMin) {
                        isMinHasText = true;
                    }
                    if (i == this.mMax) {
                        isMaxHasText = true;
                    }
                    this.mPaint.setStrokeWidth(1.7f);
                    this.mPaint.setColor(this.mRulerColor);
                    canvas.drawLine(startX, startY, startX, stopY, this.mPaint);
                } else if (i % (this.mRulerInterval / 2) == 0 && this.mRulerInterval % 10 == 0) {
                    startY = (float)this.mMiddleY + (float)this.mSliderIcon.getHeight() / 2.0f + this.mRulerMarginTop;
                    stopY = startY + this.mRulerDividerHeight * 2.0f;
                    this.mPaint.setStrokeWidth(1.2f);
                    this.mPaint.setColor(this.mRulerColor);
                    canvas.drawLine(startX, startY, startX, stopY, this.mPaint);
                } else {
                    startY = (float)this.mMiddleY + (float)this.mSliderIcon.getHeight() / 2.0f + this.mRulerMarginTop;
                    stopY = startY + this.mRulerDividerHeight;
                    this.mPaint.setStrokeWidth(1.0f);
                    if (i % (this.mRulerInterval / 10) == 0) {
                        this.mPaint.setColor(this.mRulerColor);
                        canvas.drawLine(startX, startY, startX, stopY, this.mPaint);
                    }
                }
                if (i == this.mMax && !isMaxHasText || i == this.mMin && !isMinHasText) {
                    this.mPaint.setColor(this.mRulerTextColor);
                    this.mPaint.setTextSize(this.mRulerTextSize);
                    this.getRulerTextBounds(String.valueOf(i), this.mRulerTextRect);
                    float x = startX - (float)this.mRulerTextRect.width() / 2.0f;
                    if (i == this.mMax && i % this.mRulerInterval == 1) {
                        x = startX + (float)DEFAULT_TEXT_MIN_SPACE;
                    }
                    if (i == this.mMin && i % this.mRulerInterval == this.mRulerInterval - 1) {
                        x = startX - (float)this.mRulerTextRect.width() / 2.0f - (float)DEFAULT_TEXT_MIN_SPACE;
                    }
                    canvas.drawText(String.valueOf(i), x, startY + this.mRulerDividerHeight * 3.0f + (float)this.mRulerTextRect.height() + this.mRulerTextMarginTop, this.mPaint);
                }
                startX += scaleLength;
            }
        }
    }

    private void drawSelectedTargets(Canvas canvas) {
        this.mPaint.setColor(this.mInsideRangeColor);
        canvas.drawCircle((float)this.mMaxPosition, (float)this.mMiddleY, (float)DensityUtils.dp2px(this.getContext(), 3.0f), this.mPaint);
        if (!this.mIsTouching) {
            canvas.drawBitmap(this.mSliderIcon, (float)this.mMaxPosition - (float)this.mSliderIcon.getWidth() / 2.0f, (float)this.mMiddleY - (float)this.mSliderIcon.getWidth() / 2.0f, this.mPaint);
        } else {
            canvas.drawBitmap(this.mSliderIconFocus, (float)this.mMaxPosition - (float)this.mSliderIcon.getWidth() / 2.0f, (float)this.mMiddleY - (float)this.mSliderIcon.getWidth() / 2.0f, this.mPaint);
        }
    }

    private void getTextBounds(String text, Rect rect) {
        this.mPaint.setTextSize(this.mNumberTextSize);
        this.mPaint.getTextBounds(text, 0, text.length(), rect);
    }

    private void getRulerTextBounds(String text, Rect rect) {
        this.mPaint.setTextSize(this.mRulerTextSize);
        this.mPaint.getTextBounds(text, 0, text.length(), rect);
    }

    private void jumpToPosition(int index, MotionEvent event) {
        if (event.getX(index) > (float)this.mMaxPosition && event.getX(index) <= (float)this.mLineEndX) {
            this.mMaxPosition = (int)event.getX(index);
            this.invalidate();
            this.callMaxChangedCallbacks();
        } else if (event.getX(index) < (float)this.mMaxPosition && event.getX(index) >= (float)this.mLineStartX) {
            this.mMaxPosition = (int)event.getX(index);
            this.invalidate();
            this.callMaxChangedCallbacks();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        this.mIsFirstInit = false;
        int actionIndex = event.getActionIndex();
        switch (event.getActionMasked()) {
            case 0: {
                this.updateTouchStatus(true);
                if (this.mLastTouchedMin) {
                    if (!this.checkTouchingMinTarget(actionIndex, event) && !this.checkTouchingMaxTarget(actionIndex, event)) {
                        this.jumpToPosition(actionIndex, event);
                    }
                } else if (!this.checkTouchingMaxTarget(actionIndex, event) && !this.checkTouchingMinTarget(actionIndex, event)) {
                    this.jumpToPosition(actionIndex, event);
                }
                this.invalidate();
                break;
            }
            case 1: 
            case 6: {
                this.updateTouchStatus(false);
                this.mTouchingMinTarget.remove(event.getPointerId(actionIndex));
                this.mTouchingMaxTarget.remove(event.getPointerId(actionIndex));
                this.invalidate();
                break;
            }
            case 2: {
                this.updateTouchStatus(true);
                for (int i = 0; i < event.getPointerCount(); ++i) {
                    int touchX;
                    if (this.mTouchingMinTarget.contains(event.getPointerId(i))) {
                        touchX = (int)event.getX(i);
                        if ((touchX = this.clamp(touchX, this.mLineStartX, this.mLineEndX).intValue()) >= this.mMaxPosition) {
                            this.mMaxPosition = touchX;
                            this.callMaxChangedCallbacks();
                        }
                    }
                    if (!this.mTouchingMaxTarget.contains(event.getPointerId(i))) continue;
                    touchX = (int)event.getX(i);
                    this.mMaxPosition = touchX = this.clamp(touchX, this.mLineStartX, this.mLineEndX).intValue();
                    this.callMaxChangedCallbacks();
                }
                this.invalidate();
                break;
            }
            case 5: {
                this.updateTouchStatus(true);
                for (int i = 0; i < event.getPointerCount(); ++i) {
                    if (this.mLastTouchedMin) {
                        if (this.checkTouchingMinTarget(i, event) || this.checkTouchingMaxTarget(i, event)) continue;
                        this.jumpToPosition(i, event);
                        continue;
                    }
                    if (this.checkTouchingMaxTarget(i, event) || this.checkTouchingMinTarget(i, event)) continue;
                    this.jumpToPosition(i, event);
                }
                break;
            }
            case 3: {
                this.updateTouchStatus(false);
                this.mTouchingMinTarget.clear();
                this.mTouchingMaxTarget.clear();
                this.invalidate();
                break;
            }
        }
        return true;
    }

    private void updateTouchStatus(boolean isTouching) {
        this.mIsTouching = isTouching;
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(isTouching);
        }
    }

    private boolean checkTouchingMinTarget(int index, MotionEvent event) {
        if (this.isTouchingMinTarget(index, event)) {
            this.mLastTouchedMin = true;
            this.mTouchingMinTarget.add(event.getPointerId(index));
            return true;
        }
        return false;
    }

    private boolean checkTouchingMaxTarget(int index, MotionEvent event) {
        if (this.isTouchingMaxTarget(index, event)) {
            this.mLastTouchedMin = false;
            this.mTouchingMaxTarget.add(event.getPointerId(index));
            return true;
        }
        return false;
    }

    private void callMaxChangedCallbacks() {
        if (this.mOnSeekBarListener != null) {
            this.mOnSeekBarListener.onValueChanged(this, this.getSelectedNumber());
        }
    }

    private boolean isTouchingMinTarget(int pointerIndex, MotionEvent event) {
        return false;
    }

    private boolean isTouchingMaxTarget(int pointerIndex, MotionEvent event) {
        return event.getX(pointerIndex) > (float)(this.mMaxPosition - DEFAULT_TOUCH_TARGET_SIZE) && event.getX(pointerIndex) < (float)(this.mMaxPosition + DEFAULT_TOUCH_TARGET_SIZE) && event.getY(pointerIndex) > (float)(this.mMiddleY - DEFAULT_TOUCH_TARGET_SIZE) && event.getY(pointerIndex) < (float)(this.mMiddleY + DEFAULT_TOUCH_TARGET_SIZE);
    }

    private void calculateConvertFactor() {
        this.mConvertFactor = (float)this.mRange / (float)this.mLineLength;
    }

    public int getSelectedNumber() {
        return Math.round((float)(this.mMaxPosition - this.mLineStartX) * this.mConvertFactor + (float)this.mMin);
    }

    public void setDefaultValue(int value) {
        this.mSelectedNumber = value;
        this.setSelectedValue(value);
        this.invalidate();
    }

    private void setSelectedValue(int selectedMax) {
        this.mMaxPosition = Math.round((float)(selectedMax - this.mMin) / this.mConvertFactor + (float)this.mLineStartX);
        this.callMaxChangedCallbacks();
    }

    public void setOnSeekBarListener(OnSeekBarListener listener) {
        this.mOnSeekBarListener = listener;
    }

    public int getMin() {
        return this.mMin;
    }

    public void setMin(int min) {
        this.mMin = min;
        this.mRange = this.mMax - min;
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int max) {
        this.mMax = max;
        this.mRange = max - this.mMin;
    }

    public void setInterval(int rulerInterval) {
        this.mRulerInterval = rulerInterval;
        this.invalidate();
    }

    public void reset() {
        this.mMaxPosition = this.mLineEndX;
        if (this.mOnSeekBarListener != null) {
            this.mOnSeekBarListener.onValueChanged(this, this.getSelectedNumber());
        }
        this.invalidate();
    }

    private <T extends Number> T clamp(@NonNull T value, @NonNull T min, @NonNull T max) {
        if (value.doubleValue() > max.doubleValue()) {
            return max;
        }
        if (value.doubleValue() < min.doubleValue()) {
            return min;
        }
        return value;
    }

    public static interface OnSeekBarListener {
        public void onValueChanged(XSeekBar var1, int var2);
    }
}

