/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.picker;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.Nullable;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import io.github.inflationx.calligraphy3.HasTypeface;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;

public class RulerView
extends View
implements HasTypeface {
    private int mScaleLimit = 1;
    private int mRulerHeight = 50;
    private int mRulerToResultGap = this.mRulerHeight / 4;
    private int mScaleCount = 10;
    private int mScaleGap = 10;
    private int mMinScale = 0;
    private float mFirstScale = 50.0f;
    private int mMaxScale = 100;
    private int mBgColor;
    private int mSmallScaleColor;
    private int mMidScaleColor;
    private int mLargeScaleColor;
    private int mScaleNumColor;
    private int mResultNumColor;
    private String mUnit = "kg";
    private int mUnitColor;
    private int mSmallScaleStroke = 2;
    private int mMidScaleStroke = 3;
    private int mLargeScaleStroke = 5;
    private int mResultNumTextSize = 20;
    private int mScaleNumTextSize = 16;
    private int mUnitTextSize = 13;
    private boolean mShowScaleResult = true;
    private boolean mIsBgRoundRect = true;
    private int mRoundRadius = 10;
    private OnChooseResultListener mOnChooseResultListener;
    private float mComputeScale = -1.0f;
    public float mCurrentScale = this.mFirstScale;
    private ValueAnimator mValueAnimator;
    private VelocityTracker mVelocityTracker = VelocityTracker.obtain();
    private String mResultText = String.valueOf(this.mFirstScale);
    private Paint mBgPaint;
    private Paint mSmallScalePaint;
    private Paint mMidScalePaint;
    private Paint mLagScalePaint;
    private TextPaint mScaleNumPaint;
    private TextPaint mResultNumPaint;
    private TextPaint mUnitPaint;
    private Rect mScaleNumRect;
    private Rect mResultNumRect;
    private Rect mKgRect;
    private RectF mBgRect;
    private int mHeight;
    private int mWidth;
    private int mSmallScaleHeight;
    private int mMidScaleHeight;
    private int mLagScaleHeight;
    private float mDownX;
    private float mMoveX = 0.0f;
    private float mLastMoveX = 0.0f;
    private boolean mIsUp = false;

    public RulerView(Context context) {
        this(context, null);
    }

    public RulerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.RulerViewStyle);
    }

    public RulerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
        this.init();
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RulerView, defStyleAttr, 0);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mScaleLimit = a.getInt(R.styleable.RulerView_rv_scaleLimit, this.mScaleLimit);
        this.mRulerHeight = a.getDimensionPixelSize(R.styleable.RulerView_rv_rulerHeight, (int)TypedValue.applyDimension((int)1, (float)this.mRulerHeight, (DisplayMetrics)displayMetrics));
        this.mRulerToResultGap = a.getDimensionPixelSize(R.styleable.RulerView_rv_rulerToResultGap, (int)TypedValue.applyDimension((int)1, (float)this.mRulerToResultGap, (DisplayMetrics)displayMetrics));
        this.mScaleCount = a.getInt(R.styleable.RulerView_rv_scaleCount, this.mScaleCount);
        this.mScaleGap = a.getDimensionPixelSize(R.styleable.RulerView_rv_scaleGap, (int)TypedValue.applyDimension((int)1, (float)this.mScaleGap, (DisplayMetrics)displayMetrics));
        this.mMinScale = a.getInt(R.styleable.RulerView_rv_minScale, this.mMinScale) / this.mScaleLimit;
        this.mFirstScale = a.getFloat(R.styleable.RulerView_rv_firstScale, this.mFirstScale) / (float)this.mScaleLimit;
        this.mMaxScale = a.getInt(R.styleable.RulerView_rv_maxScale, this.mMaxScale) / this.mScaleLimit;
        this.mBgColor = a.getColor(R.styleable.RulerView_rv_bgColor, ResUtils.getColor(context, R.color.default_ruler_view_bg_color));
        this.mSmallScaleColor = a.getColor(R.styleable.RulerView_rv_smallScaleColor, ResUtils.getColor(context, R.color.default_ruler_view_small_scale_color));
        this.mMidScaleColor = a.getColor(R.styleable.RulerView_rv_midScaleColor, ResUtils.getColor(context, R.color.default_ruler_view_mid_scale_color));
        this.mLargeScaleColor = a.getColor(R.styleable.RulerView_rv_largeScaleColor, ResUtils.getColor(context, R.color.default_ruler_view_large_scale_color));
        this.mScaleNumColor = a.getColor(R.styleable.RulerView_rv_scaleNumColor, ResUtils.getColor(context, R.color.default_ruler_view_scale_num_color));
        this.mResultNumColor = a.getColor(R.styleable.RulerView_rv_resultNumColor, ResUtils.getColor(context, R.color.default_ruler_view_result_num_color));
        this.mUnitColor = a.getColor(R.styleable.RulerView_rv_unitColor, ResUtils.getColor(context, R.color.default_ruler_view_unit_color));
        String tempUnit = this.mUnit;
        this.mUnit = a.getString(R.styleable.RulerView_rv_unit);
        if (TextUtils.isEmpty((CharSequence)this.mUnit)) {
            this.mUnit = tempUnit;
        }
        this.mSmallScaleStroke = a.getDimensionPixelSize(R.styleable.RulerView_rv_smallScaleStroke, (int)TypedValue.applyDimension((int)1, (float)this.mSmallScaleStroke, (DisplayMetrics)displayMetrics));
        this.mMidScaleStroke = a.getDimensionPixelSize(R.styleable.RulerView_rv_midScaleStroke, (int)TypedValue.applyDimension((int)1, (float)this.mMidScaleStroke, (DisplayMetrics)displayMetrics));
        this.mLargeScaleStroke = a.getDimensionPixelSize(R.styleable.RulerView_rv_largeScaleStroke, (int)TypedValue.applyDimension((int)1, (float)this.mLargeScaleStroke, (DisplayMetrics)displayMetrics));
        this.mResultNumTextSize = a.getDimensionPixelSize(R.styleable.RulerView_rv_resultNumTextSize, (int)TypedValue.applyDimension((int)2, (float)this.mResultNumTextSize, (DisplayMetrics)displayMetrics));
        this.mScaleNumTextSize = a.getDimensionPixelSize(R.styleable.RulerView_rv_scaleNumTextSize, (int)TypedValue.applyDimension((int)2, (float)this.mScaleNumTextSize, (DisplayMetrics)displayMetrics));
        this.mUnitTextSize = a.getDimensionPixelSize(R.styleable.RulerView_rv_unitTextSize, (int)TypedValue.applyDimension((int)2, (float)this.mUnitTextSize, (DisplayMetrics)displayMetrics));
        this.mShowScaleResult = a.getBoolean(R.styleable.RulerView_rv_showScaleResult, this.mShowScaleResult);
        this.mIsBgRoundRect = a.getBoolean(R.styleable.RulerView_rv_isBgRoundRect, this.mIsBgRoundRect);
        this.mRoundRadius = a.getDimensionPixelSize(R.styleable.RulerView_rv_roundRadius, (int)TypedValue.applyDimension((int)1, (float)this.mRoundRadius, (DisplayMetrics)displayMetrics));
        a.recycle();
    }

    private void init() {
        this.mBgPaint = new Paint(1);
        this.mSmallScalePaint = new Paint(1);
        this.mMidScalePaint = new Paint(1);
        this.mLagScalePaint = new Paint(1);
        this.mScaleNumPaint = new TextPaint(1);
        this.mResultNumPaint = new TextPaint(1);
        this.mUnitPaint = new TextPaint(1);
        this.mBgPaint.setColor(this.mBgColor);
        this.mSmallScalePaint.setColor(this.mSmallScaleColor);
        this.mMidScalePaint.setColor(this.mMidScaleColor);
        this.mLagScalePaint.setColor(this.mLargeScaleColor);
        this.mScaleNumPaint.setColor(this.mScaleNumColor);
        this.mResultNumPaint.setColor(this.mResultNumColor);
        this.mUnitPaint.setColor(this.mUnitColor);
        this.mResultNumPaint.setStyle(Paint.Style.FILL);
        this.mUnitPaint.setStyle(Paint.Style.FILL);
        this.mBgPaint.setStyle(Paint.Style.FILL);
        this.mSmallScalePaint.setStyle(Paint.Style.FILL);
        this.mMidScalePaint.setStyle(Paint.Style.FILL);
        this.mLagScalePaint.setStyle(Paint.Style.FILL);
        this.mLagScalePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mMidScalePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mSmallScalePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mSmallScalePaint.setStrokeWidth((float)this.mSmallScaleStroke);
        this.mMidScalePaint.setStrokeWidth((float)this.mMidScaleStroke);
        this.mLagScalePaint.setStrokeWidth((float)this.mLargeScaleStroke);
        this.mResultNumPaint.setTextSize((float)this.mResultNumTextSize);
        this.mUnitPaint.setTextSize((float)this.mUnitTextSize);
        this.mScaleNumPaint.setTextSize((float)this.mScaleNumTextSize);
        this.mBgRect = new RectF();
        this.mResultNumRect = new Rect();
        this.mScaleNumRect = new Rect();
        this.mKgRect = new Rect();
        this.mResultNumPaint.getTextBounds(this.mResultText, 0, this.mResultText.length(), this.mResultNumRect);
        this.mUnitPaint.getTextBounds(this.mResultText, 0, 1, this.mKgRect);
        this.mSmallScaleHeight = this.mRulerHeight / 4;
        this.mMidScaleHeight = this.mRulerHeight / 2;
        this.mLagScaleHeight = this.mRulerHeight / 2 + 5;
        this.mValueAnimator = new ValueAnimator();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int heightModule = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        switch (heightModule) {
            case -2147483648: {
                this.mHeight = this.mRulerHeight + (this.mShowScaleResult ? this.mResultNumRect.height() : 0) + this.mRulerToResultGap * 2 + this.getPaddingTop() + this.getPaddingBottom();
                break;
            }
            case 0: 
            case 0x40000000: {
                this.mHeight = heightSize + this.getPaddingTop() + this.getPaddingBottom();
                break;
            }
        }
        this.mWidth = widthSize + this.getPaddingLeft() + this.getPaddingRight();
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onDraw(Canvas canvas) {
        this.drawBg(canvas);
        this.drawScaleAndNum(canvas);
        this.drawResultText(canvas, this.mResultText);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
        float currentX = event.getX();
        this.mIsUp = false;
        this.mVelocityTracker.computeCurrentVelocity(500);
        this.mVelocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                if (this.mValueAnimator != null && this.mValueAnimator.isRunning()) {
                    this.mValueAnimator.end();
                    this.mValueAnimator.cancel();
                }
                this.mDownX = event.getX();
                break;
            }
            case 2: {
                this.mMoveX = currentX - this.mDownX + this.mLastMoveX;
                if (this.mMoveX >= (float)this.mWidth / 2.0f) {
                    this.mMoveX = (float)this.mWidth / 2.0f;
                    break;
                }
                if (!(this.mMoveX <= this.getWhichScaleMoveX(this.mMaxScale))) break;
                this.mMoveX = this.getWhichScaleMoveX(this.mMaxScale);
                break;
            }
            case 1: {
                this.mLastMoveX = this.mMoveX;
                int xVelocity = (int)this.mVelocityTracker.getXVelocity();
                this.autoVelocityScroll(xVelocity);
                this.mVelocityTracker.clear();
                break;
            }
        }
        this.invalidate();
        return true;
    }

    private void autoVelocityScroll(int xVelocity) {
        if (Math.abs(xVelocity) < 50) {
            this.mIsUp = true;
            return;
        }
        if (this.mValueAnimator.isRunning()) {
            return;
        }
        this.mValueAnimator = ValueAnimator.ofInt((int[])new int[]{0, xVelocity / 20}).setDuration((long)Math.abs(xVelocity / 10));
        this.mValueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                RulerView.this.mMoveX = RulerView.this.mMoveX + (float)((Integer)animation.getAnimatedValue()).intValue();
                if (RulerView.this.mMoveX >= (float)RulerView.this.mWidth / 2.0f) {
                    RulerView.this.mMoveX = (float)RulerView.this.mWidth / 2.0f;
                } else if (RulerView.this.mMoveX <= RulerView.this.getWhichScaleMoveX(RulerView.this.mMaxScale)) {
                    RulerView.this.mMoveX = RulerView.this.getWhichScaleMoveX(RulerView.this.mMaxScale);
                }
                RulerView.this.mLastMoveX = RulerView.this.mMoveX;
                RulerView.this.invalidate();
            }
        });
        this.mValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                RulerView.this.mIsUp = true;
                RulerView.this.invalidate();
            }
        });
        this.mValueAnimator.start();
    }

    private float getWhichScaleMoveX(float scale) {
        return (float)this.mWidth / 2.0f - (float)(this.mScaleGap * this.mScaleCount) * (scale - (float)this.mMinScale);
    }

    private void drawScaleAndNum(Canvas canvas) {
        canvas.translate(0.0f, (float)((this.mShowScaleResult ? this.mResultNumRect.height() : 0) + this.mRulerToResultGap));
        if (this.mFirstScale != -1.0f) {
            this.mLastMoveX = this.mMoveX = this.getWhichScaleMoveX(this.mFirstScale);
            this.mFirstScale = -1.0f;
        }
        if (this.mComputeScale != -1.0f) {
            this.mLastMoveX = this.mMoveX;
            if (this.mValueAnimator != null && !this.mValueAnimator.isRunning()) {
                this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.getWhichScaleMoveX(this.mCurrentScale), this.getWhichScaleMoveX(this.mComputeScale)});
                this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        RulerView.this.mMoveX = ((Float)animation.getAnimatedValue()).floatValue();
                        RulerView.this.mLastMoveX = RulerView.this.mMoveX;
                        RulerView.this.invalidate();
                    }
                });
                this.mValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        RulerView.this.mComputeScale = -1.0f;
                    }
                });
                this.mValueAnimator.setDuration(Math.abs((long)((this.getWhichScaleMoveX(this.mComputeScale) - this.getWhichScaleMoveX(this.mCurrentScale)) / 100.0f)));
                this.mValueAnimator.start();
            }
        }
        int num1 = -((int)(this.mMoveX / (float)this.mScaleGap));
        float num2 = this.mMoveX % (float)this.mScaleGap;
        canvas.save();
        int rulerRight = 0;
        if (this.mIsUp) {
            float moveX2;
            num2 = (this.mMoveX - (float)this.mWidth / 2.0f % (float)this.mScaleGap) % (float)this.mScaleGap;
            if (num2 <= 0.0f) {
                num2 = (float)this.mScaleGap - Math.abs(num2);
            }
            int leftScroll = (int)Math.abs(num2);
            int rightScroll = (int)((float)this.mScaleGap - Math.abs(num2));
            float f = moveX2 = num2 <= (float)this.mScaleGap / 2.0f ? this.mMoveX - (float)leftScroll : this.mMoveX + (float)rightScroll;
            if (this.mValueAnimator != null && !this.mValueAnimator.isRunning()) {
                this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mMoveX, moveX2});
                this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        RulerView.this.mMoveX = ((Float)animation.getAnimatedValue()).floatValue();
                        RulerView.this.mLastMoveX = RulerView.this.mMoveX;
                        RulerView.this.invalidate();
                    }
                });
                this.mValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        if (RulerView.this.mOnChooseResultListener != null) {
                            RulerView.this.mOnChooseResultListener.onEndResult(RulerView.this.mResultText);
                        }
                    }
                });
                this.mValueAnimator.setDuration(300L);
                this.mValueAnimator.start();
                this.mIsUp = false;
            }
            num1 = (int)(-(this.mMoveX / (float)this.mScaleGap));
            num2 = this.mMoveX % (float)this.mScaleGap;
        }
        canvas.translate(num2, 0.0f);
        this.mCurrentScale = ((BigDecimal)new WeakReference<BigDecimal>(new BigDecimal((((float)this.mWidth / 2.0f - this.mMoveX) / (float)(this.mScaleGap * this.mScaleCount) + (float)this.mMinScale) * (float)this.mScaleLimit)).get()).setScale(1, 4).floatValue();
        this.mResultText = String.valueOf(this.mCurrentScale);
        if (this.mOnChooseResultListener != null) {
            this.mOnChooseResultListener.onScrollResult(this.mResultText);
        }
        while (rulerRight < this.mWidth) {
            if (num1 % this.mScaleCount == 0) {
                if (!(this.mMoveX >= 0.0f && (float)rulerRight < this.mMoveX - (float)this.mScaleGap || (float)this.mWidth / 2.0f - (float)rulerRight <= this.getWhichScaleMoveX(this.mMaxScale + 1) - this.mMoveX)) {
                    canvas.drawLine(0.0f, 0.0f, 0.0f, (float)this.mMidScaleHeight, this.mMidScalePaint);
                    this.mScaleNumPaint.getTextBounds(num1 / this.mScaleGap + this.mMinScale + "", 0, (num1 / this.mScaleGap + this.mMinScale + "").length(), this.mScaleNumRect);
                    canvas.drawText((num1 / this.mScaleCount + this.mMinScale) * this.mScaleLimit + "", (float)(-this.mScaleNumRect.width()) / 2.0f, (float)this.mLagScaleHeight + (float)(this.mRulerHeight - this.mLagScaleHeight) / 2.0f + (float)this.mScaleNumRect.height(), (Paint)this.mScaleNumPaint);
                }
            } else if (!(this.mMoveX >= 0.0f && (float)rulerRight < this.mMoveX || (float)this.mWidth / 2.0f - (float)rulerRight < this.getWhichScaleMoveX(this.mMaxScale) - this.mMoveX)) {
                canvas.drawLine(0.0f, 0.0f, 0.0f, (float)this.mSmallScaleHeight, this.mSmallScalePaint);
            }
            ++num1;
            rulerRight += this.mScaleGap;
            canvas.translate((float)this.mScaleGap, 0.0f);
        }
        canvas.restore();
        canvas.drawLine((float)this.mWidth / 2.0f, 0.0f, (float)this.mWidth / 2.0f, (float)this.mLagScaleHeight, this.mLagScalePaint);
    }

    private void drawResultText(Canvas canvas, String resultText) {
        if (!this.mShowScaleResult) {
            return;
        }
        canvas.translate(0.0f, (float)(-this.mResultNumRect.height()) - (float)this.mRulerToResultGap / 2.0f);
        this.mResultNumPaint.getTextBounds(resultText, 0, resultText.length(), this.mResultNumRect);
        canvas.drawText(resultText, (float)this.mWidth / 2.0f - (float)this.mResultNumRect.width() / 2.0f, (float)this.mResultNumRect.height(), (Paint)this.mResultNumPaint);
        int resultNumRight = this.mWidth / 2 + this.mResultNumRect.width() / 2 + 10;
        canvas.drawText(this.mUnit, (float)resultNumRight, (float)(this.mKgRect.height() + 2), (Paint)this.mUnitPaint);
    }

    private void drawBg(Canvas canvas) {
        this.mBgRect.set(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
        if (this.mIsBgRoundRect) {
            canvas.drawRoundRect(this.mBgRect, (float)this.mRoundRadius, (float)this.mRoundRadius, this.mBgPaint);
        } else {
            canvas.drawRect(this.mBgRect, this.mBgPaint);
        }
    }

    private void computeScrollTo(float scale) {
        if ((scale /= (float)this.mScaleLimit) < (float)this.mMinScale || scale > (float)this.mMaxScale) {
            return;
        }
        this.mComputeScale = scale;
        this.invalidate();
    }

    public void setTypeface(Typeface typeface) {
        if (this.mResultNumPaint != null) {
            this.mResultNumPaint.setTypeface(typeface);
        }
        if (this.mUnitPaint != null) {
            this.mUnitPaint.setTypeface(typeface);
        }
        if (this.mScaleNumPaint != null) {
            this.mScaleNumPaint.setTypeface(typeface);
        }
    }

    public void setRulerHeight(int rulerHeight) {
        this.mRulerHeight = rulerHeight;
        this.invalidate();
    }

    public void setRulerToResultGap(int rulerToResultGap) {
        this.mRulerToResultGap = rulerToResultGap;
        this.invalidate();
    }

    public void setScaleCount(int scaleCount) {
        this.mScaleCount = scaleCount;
        this.invalidate();
    }

    public void setScaleGap(int scaleGap) {
        this.mScaleGap = scaleGap;
        this.invalidate();
    }

    public void setMinScale(int minScale) {
        this.mMinScale = minScale;
        this.invalidate();
    }

    public void setFirstScale(float firstScale) {
        this.mFirstScale = firstScale;
        this.invalidate();
    }

    public void setMaxScale(int maxScale) {
        this.mMaxScale = maxScale;
        this.invalidate();
    }

    public void setBgColor(int bgColor) {
        this.mBgColor = bgColor;
        this.invalidate();
    }

    public void setSmallScaleColor(int smallScaleColor) {
        this.mSmallScaleColor = smallScaleColor;
        this.invalidate();
    }

    public void setMidScaleColor(int midScaleColor) {
        this.mMidScaleColor = midScaleColor;
        this.invalidate();
    }

    public void setLargeScaleColor(int largeScaleColor) {
        this.mLargeScaleColor = largeScaleColor;
    }

    public void setScaleNumColor(int scaleNumColor) {
        this.mScaleNumColor = scaleNumColor;
        this.invalidate();
    }

    public void setResultNumColor(int resultNumColor) {
        this.mResultNumColor = resultNumColor;
        this.invalidate();
    }

    public void setUnit(String unit) {
        this.mUnit = unit;
        this.invalidate();
    }

    public void setUnitColor(int unitColor) {
        this.mUnitColor = unitColor;
        this.invalidate();
    }

    public void setSmallScaleStroke(int smallScaleStroke) {
        this.mSmallScaleStroke = smallScaleStroke;
        this.invalidate();
    }

    public void setMidScaleStroke(int midScaleStroke) {
        this.mMidScaleStroke = midScaleStroke;
        this.invalidate();
    }

    public void setLargeScaleStroke(int largeScaleStroke) {
        this.mLargeScaleStroke = largeScaleStroke;
        this.invalidate();
    }

    public void setResultNumTextSize(int resultNumTextSize) {
        this.mResultNumTextSize = resultNumTextSize;
        this.invalidate();
    }

    public void setScaleNumTextSize(int scaleNumTextSize) {
        this.mScaleNumTextSize = scaleNumTextSize;
        this.invalidate();
    }

    public void setUnitTextSize(int unitTextSize) {
        this.mUnitTextSize = unitTextSize;
        this.invalidate();
    }

    public void setShowScaleResult(boolean showScaleResult) {
        this.mShowScaleResult = showScaleResult;
        this.invalidate();
    }

    public void setIsBgRoundRect(boolean bgRoundRect) {
        this.mIsBgRoundRect = bgRoundRect;
        this.invalidate();
    }

    public void setScaleLimit(int scaleLimit) {
        this.mScaleLimit = scaleLimit;
        this.invalidate();
    }

    public void setCurrentValue(float value) {
        this.computeScrollTo(value);
    }

    public float getCurrentValue() {
        return this.mCurrentScale;
    }

    public String getSelectValue() {
        return this.mResultText;
    }

    public RulerView setOnChooseResultListener(OnChooseResultListener onChooseResultListener) {
        this.mOnChooseResultListener = onChooseResultListener;
        return this;
    }

    public static interface OnChooseResultListener {
        public void onEndResult(String var1);

        public void onScrollResult(String var1);
    }
}

