/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.layout.linkage.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.webkit.WebView;
import android.widget.Scroller;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingChildHelper;
import com.xuexiang.xui.widget.layout.linkage.ChildLinkageEvent;
import com.xuexiang.xui.widget.layout.linkage.ILinkageScroll;
import com.xuexiang.xui.widget.layout.linkage.LinkageScrollHandler;
import com.xuexiang.xui.widget.layout.linkage.PosIndicator;

public class LinkageWebView
extends WebView
implements ILinkageScroll,
NestedScrollingChild {
    private NestedScrollingChildHelper mChildHelper;
    private PosIndicator mPosIndicator;
    private final float DENSITY;
    private VelocityTracker mVelocityTracker;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private Scroller mScroller;
    private ChildLinkageEvent mLinkageEvent;
    private final int[] mScrollConsumed = new int[2];

    public LinkageWebView(Context context) {
        this(context, null);
    }

    public LinkageWebView(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public LinkageWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mScroller = new Scroller(this.getContext());
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        this.mPosIndicator = new PosIndicator();
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mPosIndicator.setTouchSlop(viewConfiguration.getScaledTouchSlop());
        this.DENSITY = context.getResources().getDisplayMetrics().density;
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.setNestedScrollingEnabled(true);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if ((!this.canScrollVertically(1) || this.isScrollToBottom()) && this.mLinkageEvent != null) {
            this.mLinkageEvent.onContentScrollToBottom((View)this);
        }
        if (!this.canScrollVertically(-1) && this.mLinkageEvent != null) {
            this.mLinkageEvent.onContentScrollToTop((View)this);
        }
        if (this.mLinkageEvent != null) {
            this.mLinkageEvent.onContentScroll((View)this);
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int currY = this.mScroller.getCurrY();
            this.scrollTo(0, currY);
            this.invalidate();
        }
    }

    private boolean canScrollVertical(int direction) {
        int scrollY = this.getScrollY();
        if (direction < 0) {
            return scrollY > 0;
        }
        return !this.isScrollToBottom();
    }

    private boolean isScrollToBottom() {
        int scrollRange;
        int scrollY = this.getScrollY();
        return scrollY >= (scrollRange = this.getScrollRange());
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getRawX();
        float y = event.getRawY();
        switch (event.getAction()) {
            case 0: {
                this.mPosIndicator.onDown(x, y);
                this.startNestedScroll(2);
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(event);
                this.mScroller.abortAnimation();
                break;
            }
            case 2: {
                this.mPosIndicator.onMove(x, y);
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(event);
                if (!this.mPosIndicator.isDragging()) break;
                int dy = (int)(-this.mPosIndicator.getOffsetY());
                if (!this.dispatchNestedPreScroll(0, dy, this.mScrollConsumed, null)) {
                    this.scrollBy(0, dy);
                }
                event.setAction(3);
                break;
            }
            case 1: 
            case 3: {
                this.mPosIndicator.onRelease(x, y);
                this.mVelocityTracker.addMovement(event);
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int yVelocity = (int)this.mVelocityTracker.getYVelocity();
                this.recycleVelocityTracker();
                if (Math.abs(yVelocity) <= this.mMinimumVelocity) break;
                this.flingWithNestedDispatch(-yVelocity);
                break;
            }
        }
        super.onTouchEvent(event);
        return true;
    }

    private void flingWithNestedDispatch(int velocityY) {
        boolean canFling;
        int scrollY = this.getScrollY();
        boolean bl = canFling = !(scrollY <= 0 && velocityY <= 0 || scrollY >= this.getScrollRange() && velocityY >= 0);
        if (!this.dispatchNestedPreFling(0.0f, velocityY)) {
            this.dispatchNestedFling(0.0f, velocityY, canFling);
            this.flingScroll(0, velocityY);
        }
    }

    public void flingScroll(int vx, int vy) {
        this.mScroller.fling(0, this.getScrollY(), 0, vy, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.invalidate();
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public int getWebViewContentHeight() {
        return (int)((float)this.getContentHeight() * this.DENSITY);
    }

    public int getScrollRange() {
        return this.getWebViewContentHeight() - this.getHeight();
    }

    public void scrollToBottom() {
        int contentHeight = this.getWebViewContentHeight();
        super.scrollTo(0, contentHeight - this.getHeight());
    }

    public void smoothScrollToBottom() {
        this.mScroller.startScroll(0, this.getScrollY(), 0, this.getScrollRange() - this.getScrollY(), 200);
        this.invalidate();
    }

    public void scrollTo(int x, int y) {
        int scrollRange = this.getScrollRange();
        y = Math.max(y, 0);
        y = Math.min(y, scrollRange);
        super.scrollTo(x, y);
    }

    @Override
    public void setChildLinkageEvent(ChildLinkageEvent event) {
        this.mLinkageEvent = event;
    }

    @Override
    public LinkageScrollHandler provideScrollHandler() {
        return new LinkageScrollHandler(){

            @Override
            public void flingContent(View target, int velocityY) {
                LinkageWebView.this.flingScroll(0, velocityY);
            }

            @Override
            public void scrollContentToTop() {
                LinkageWebView.this.scrollTo(0, 0);
            }

            @Override
            public void scrollContentToBottom() {
                LinkageWebView.this.scrollToBottom();
            }

            @Override
            public void stopContentScroll(View target) {
                LinkageWebView.this.flingScroll(0, 0);
            }

            @Override
            public boolean canScrollVertically(int direction) {
                return LinkageWebView.this.canScrollVertical(direction);
            }

            @Override
            public boolean isScrollable() {
                return true;
            }

            @Override
            public int getVerticalScrollExtent() {
                return LinkageWebView.this.computeVerticalScrollExtent();
            }

            @Override
            public int getVerticalScrollOffset() {
                return LinkageWebView.this.computeVerticalScrollOffset();
            }

            @Override
            public int getVerticalScrollRange() {
                return LinkageWebView.this.computeVerticalScrollRange();
            }
        };
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }
}

